/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveThermostat;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import com.tridium.zwave.point.BZWaveThermostatSetPointProxyExt;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcThermostatSetpoint
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String ADD_NAME;
    int setpointsSupported;
    int setpointType;
    int precScaleSize;
    int precision;
    int scale;
    int command;
    long value;
    int modeSupported;
    BFacets facets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcThermostatSetpoint;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 67;
    }

    public Type getControlPointType() {
        return BNumericWritable.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        ((BZWaveThermostat)bZWaveDevice).readSetpointSupported();
    }

    public byte[] getWriteFrame(BStatusValue bStatusValue, BZWaveProxyExt bZWaveProxyExt) {
        long l = 0L;
        int n = ((BZWaveThermostatSetPointProxyExt)bZWaveProxyExt).getPrecisionScaleSize();
        int n2 = n & 7;
        int n3 = n >> 5 & 7;
        byte[] byArray = new byte[4 + n2];
        byArray[0] = (byte)bZWaveProxyExt.getCommandClass();
        byArray[1] = (byte)bZWaveProxyExt.getWriteCommand();
        byArray[2] = (byte)bZWaveProxyExt.getAuxSelector();
        byArray[3] = (byte)n;
        double d = ((BStatusNumeric)bStatusValue).getValue();
        l = (long)(d * Math.pow(10.0, n3));
        if (n2 == 1) {
            byArray[4] = (byte)l;
        } else if (n2 == 2) {
            byArray[4] = (byte)(l >> 8);
            byArray[5] = (byte)l;
        } else if (n2 == 4) {
            byArray[4] = (byte)(l >> 24);
            byArray[5] = (byte)(l >> 16);
            byArray[4] = (byte)(l >> 8);
            byArray[5] = (byte)l;
        }
        return byArray;
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 3 && this.command != 5) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ":  Unsupported command for CommandClassThermostatSetpoint: 0x" + Integer.toHexString(this.command));
            return;
        }
        if (this.command == 3) {
            this.setpointType = zWaveInputStream.read() & 0xF;
            this.precScaleSize = zWaveInputStream.readByte();
            this.precision = this.precScaleSize >> 5 & 7;
            this.scale = this.precScaleSize >> 3 & 3;
            int n = this.precScaleSize & 7;
            this.value = 0L;
            if (n == 1) {
                this.value = zWaveInputStream.read();
            } else if (n == 2) {
                this.value = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
            } else if (n == 4) {
                this.value = (long)zWaveInputStream.read() << 32 | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte();
            }
            this.updatePoint(bZWaveDevice);
        } else {
            this.setpointsSupported = zWaveInputStream.readByte();
            if (zWaveInputStream.available() > 0) {
                this.setpointsSupported += zWaveInputStream.readByte() << 8;
            }
            this.addPoints(bZWaveDevice.getPoints());
        }
    }

    public void updatePoint(BZWaveDevice bZWaveDevice) {
        BZWaveThermostatSetPointProxyExt bZWaveThermostatSetPointProxyExt = (BZWaveThermostatSetPointProxyExt)bZWaveDevice.getProxyExt(this.getCommandClass(), this.getCommandType(), this.getAuxSelector());
        if (bZWaveThermostatSetPointProxyExt == null) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + ".ThermostatSetpoint");
            return;
        }
        bZWaveThermostatSetPointProxyExt.setPrecisionScaleSize(this.getPrecScaleSize());
        BFacets bFacets = this.getReportFacets();
        if (bFacets != null) {
            bZWaveThermostatSetPointProxyExt.setDeviceFacets(this.getReportFacets());
            bZWaveThermostatSetPointProxyExt.getParentPoint().setFacets(bZWaveThermostatSetPointProxyExt.getDeviceFacets());
        }
        bZWaveThermostatSetPointProxyExt.readOk(this.getValue());
    }

    public boolean isSetpointSupportedReport() {
        boolean bl = false;
        if (this.command == 5) {
            bl = true;
        }
        return bl;
    }

    public int getPrecScaleSize() {
        return this.precScaleSize;
    }

    public void addPoints(BZWavePointDeviceExt bZWavePointDeviceExt) {
        if (this.command != 5) {
            return;
        }
        int n = 0;
        while (n < 16) {
            if ((this.setpointsSupported & 1 << n) != 0 && bZWavePointDeviceExt.get(ZWaveMessageConst.SETPONT_NAMES[n]) == null) {
                BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, ZWaveMessageConst.SETPONT_NAMES[n], BNumericWritable.TYPE, 67, 2, 1, 3, n, 1, BPollFrequency.normal, BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_F, (int)0));
            }
            ++n;
        }
    }

    public int getCommandType() {
        return 3;
    }

    public int getAuxSelector() {
        return this.setpointType;
    }

    public BFacets getReportFacets() {
        if (this.scale == 0) {
            return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_C, (int)this.precision);
        }
        return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_F, (int)this.precision);
    }

    public BStatusValue getValue() {
        return new BStatusNumeric((double)this.value / Math.pow(10.0, this.precision));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcThermostatSetpoint;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcThermostatSetpoint = BCcThermostatSetpoint.class("[Lcom.tridium.zwave.cmdclass.BCcThermostatSetpoint;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "";
    }
}

