/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveThermostat;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.enums.BZWaveThermostatMode;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcThermostatMode
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String ADD_NAME;
    int command;
    int value;
    int modeSupported;
    BFacets facets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcThermostatMode;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 64;
    }

    public Type getControlPointType() {
        return BEnumWritable.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BValue bValue;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        String string = ADD_NAME;
        if (n > 1) {
            string = string + n;
        }
        if ((bValue = bZWavePointDeviceExt.get(string)) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, ADD_NAME, BEnumWritable.TYPE, 64, 2, 1, 3, -1, n, BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BZWaveThermostatMode.TYPE)));
        } else {
            BControlPoint bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
        ((BZWaveThermostat)bZWaveDevice).readModeSupported();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 3 && this.command != 5) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassThermostatMode: 0x" + Integer.toHexString(this.command));
            return;
        }
        if (this.command == 3) {
            this.value = zWaveInputStream.readByte();
        } else {
            this.modeSupported = zWaveInputStream.readByte();
            if (zWaveInputStream.available() > 0) {
                this.modeSupported += zWaveInputStream.readByte() << 8;
            }
            ArrayList<BZWaveThermostatMode> arrayList = new ArrayList<BZWaveThermostatMode>();
            int n = 1;
            int n2 = 0;
            while (n2 < 16) {
                if ((this.modeSupported & n) != 0) {
                    try {
                        arrayList.add(BZWaveThermostatMode.make(n2));
                    }
                    catch (Exception exception) {
                        System.out.println(" invalid mode ordinal: " + n2);
                    }
                }
                n <<= 1;
                ++n2;
            }
            int[] nArray = new int[arrayList.size()];
            String[] stringArray = new String[nArray.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                nArray[n3] = ((BZWaveThermostatMode)((Object)arrayList.get(n3))).getOrdinal();
                stringArray[n3] = TextUtil.capitalize((String)((BZWaveThermostatMode)((Object)arrayList.get(n3))).getTag());
                ++n3;
            }
            BEnumRange bEnumRange = BEnumRange.make((int[])nArray, (String[])stringArray);
            this.facets = BFacets.makeEnum((BEnumRange)bEnumRange);
        }
        this.updatePoint(bZWaveDevice);
    }

    public int getCommandType() {
        return 3;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return this.facets;
    }

    public BStatusValue getValue() {
        return new BStatusEnum((BEnum)BZWaveThermostatMode.make(this.value));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcThermostatMode;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcThermostatMode = BCcThermostatMode.class("[Lcom.tridium.zwave.cmdclass.BCcThermostatMode;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "mode";
    }
}

