/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcSensorAlarm
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String ADD_NAME;
    int sourceNode;
    int sensorType;
    int sensorState;
    int seconds;
    int command;
    int sensorSupported;
    BStatusBoolean pointValue;
    BFacets facets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcSensorAlarm;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 156;
    }

    public Type getControlPointType() {
        return BBooleanPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        byte[] byArray = new byte[]{-100, 3};
        bZWaveDevice.sendMsg(byArray);
    }

    public byte[] getReadFrame(BZWaveProxyExt bZWaveProxyExt) {
        if (bZWaveProxyExt.getInstance() > 1) {
            return this.getMultiInstanceReadFrame(bZWaveProxyExt);
        }
        byte[] byArray = new byte[]{(byte)bZWaveProxyExt.getCommandClass(), (byte)bZWaveProxyExt.getReadCommand(), (byte)bZWaveProxyExt.getAuxSelector()};
        return byArray;
    }

    public byte[] getWriteFrame(BStatusValue bStatusValue, BZWaveProxyExt bZWaveProxyExt) {
        return null;
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 2 && this.command != 4) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassSensorAlarm: 0x" + Integer.toHexString(this.command));
            return;
        }
        if (this.command == 2) {
            this.sourceNode = zWaveInputStream.readByte();
            this.sensorType = zWaveInputStream.readByte();
            this.sensorState = zWaveInputStream.readByte();
            this.seconds = zWaveInputStream.readWord();
            boolean bl = false;
            if (this.sensorState != 0) {
                bl = true;
            }
            this.pointValue.setValue(bl);
            boolean bl2 = false;
            if (this.sensorState != 0) {
                bl2 = true;
            }
            this.pointValue.setStatusInAlarm(bl2);
            this.updatePoint(bZWaveDevice);
        } else {
            int n = zWaveInputStream.readByte();
            if (n > 4) {
                n = 4;
            }
            int n2 = 0;
            while (n2 < n) {
                this.sensorSupported |= zWaveInputStream.readByte() << 8 * n2;
                ++n2;
            }
            this.addPoints(bZWaveDevice.getPoints());
        }
    }

    public void addPoints(BZWavePointDeviceExt bZWavePointDeviceExt) {
        if (this.command != 4) {
            return;
        }
        int n = 0;
        while (n < 6) {
            if ((this.sensorSupported & 1 << n) != 0 && bZWavePointDeviceExt.get(ZWaveMessageConst.SENSOR_ALARM_NAMES[n]) == null) {
                BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, ZWaveMessageConst.SENSOR_ALARM_NAMES[n], BBooleanPoint.TYPE, 156, 1, 0, 2, n, BFacets.makeBoolean((String)"active", (String)"inactive"));
            }
            ++n;
        }
    }

    public int getCommandType() {
        return 2;
    }

    public int getAuxSelector() {
        return this.sensorType;
    }

    public BFacets getReportFacets() {
        return BFacets.makeBoolean((String)"active", (String)"inactive");
    }

    public BStatusValue getValue() {
        return this.pointValue;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pointValue = new BStatusBoolean();
    }

    public BCcSensorAlarm() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcSensorAlarm;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcSensorAlarm = BCcSensorAlarm.class("[Lcom.tridium.zwave.cmdclass.BCcSensorAlarm;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "";
    }
}

