/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcMeter
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String ADD_NAME;
    int meterype;
    int scale;
    int precision;
    double value;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcMeter;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 50;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BValue bValue;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        String string = ADD_NAME;
        if (n > 1) {
            string = string + n;
        }
        if ((bValue = bZWavePointDeviceExt.get(string)) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BNumericPoint.TYPE, 50, 1, -1, 2, -1, n, BPollFrequency.normal, BFacets.makeNumeric());
        } else {
            BControlPoint bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 2) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for processMeter: 0x" + Integer.toHexString(n));
            return;
        }
        this.meterype = zWaveInputStream.readByte() & 0x1F;
        int n2 = zWaveInputStream.readByte();
        int n3 = n2 & 7;
        this.scale = n2 >> 3 & 3;
        this.precision = n2 >> 5 & 7;
        long l = 0L;
        if (n3 == 1) {
            l = zWaveInputStream.read();
        } else if (n3 == 2) {
            l = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
        } else if (n3 == 4) {
            l = (long)zWaveInputStream.read() << 24 | (long)(zWaveInputStream.readByte() << 16) | (long)(zWaveInputStream.readByte() << 8) | (long)zWaveInputStream.readByte();
        }
        this.value = (double)l / Math.pow(10.0, this.precision);
        this.updatePoint(bZWaveDevice);
    }

    public int getCommandType() {
        return 2;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        switch (this.meterype) {
            case 1: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.KWH, (int)this.precision);
            }
            case 2: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CUBIC_METERS, (int)this.precision);
            }
            case 3: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CUBIC_METERS, (int)this.precision);
                }
                if (this.scale == 1) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CUBIC_FEET, (int)this.precision);
                }
                if (this.scale != 2) break;
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.GALLON, (int)this.precision);
            }
        }
        return BFacets.makeNumeric((int)this.precision);
    }

    public int getMeasureType() {
        return this.meterype;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public BStatusValue getValue() {
        return new BStatusNumeric(this.value);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcMeter;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcMeter = BCcMeter.class("[Lcom.tridium.zwave.cmdclass.BCcMeter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "meterValue";
    }
}

