/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcIndicator
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property indicator = BCcIndicator.newProperty((int)1, (boolean)false, null);
    public static final Action read = BCcIndicator.newAction((int)16, null);
    public static final Action indicatorOn = BCcIndicator.newAction((int)16, null);
    public static final Action indicatorOff = BCcIndicator.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    int value;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcIndicator;

    public boolean getIndicator() {
        return this.getBoolean(indicator);
    }

    public void setIndicator(boolean bl) {
        this.setBoolean(indicator, bl, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void indicatorOn() {
        this.invoke(indicatorOn, null, null);
    }

    public void indicatorOff() {
        this.invoke(indicatorOff, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 135;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        this.read();
    }

    public void doRead() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-121, 2};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doIndicatorOn() {
        this.doSetIndicator(true);
    }

    public void doIndicatorOff() {
        this.doSetIndicator(false);
    }

    public void doSetIndicator(boolean bl) {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-121, 1, bl ? (byte)-1 : 0};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
        this.doRead();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 3) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassIndicator: 0x" + Integer.toHexString(n));
            return;
        }
        this.value = zWaveInputStream.readByte();
        try {
            BCcIndicator bCcIndicator = (BCcIndicator)bZWaveDevice.get(ADD_NAME);
            boolean bl = false;
            if (this.value != 0) {
                bl = true;
            }
            bCcIndicator.setIndicator(bl);
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! Indicator object does not exist !!!!!!!!!");
        }
    }

    public int getCommandType() {
        return 3;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return null;
    }

    public BStatusValue getValue() {
        boolean bl = false;
        if (this.value != 0) {
            bl = true;
        }
        return new BStatusBoolean(bl);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcIndicator;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcIndicator = BCcIndicator.class("[Lcom.tridium.zwave.cmdclass.BCcIndicator;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "indicator";
    }
}

