/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcEnergyProduction
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String INSTANT_ADD_NAME;
    public static String TOTAL_ADD_NAME;
    public static String TODAYS_ADD_NAME;
    public static String TOTAL_TIME_ADD_NAME;
    int parameterType;
    int scale;
    int precision;
    double value;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcEnergyProduction;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return INSTANT_ADD_NAME;
    }

    public int getCommandClass() {
        return 144;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        if (bZWavePointDeviceExt.get(INSTANT_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, INSTANT_ADD_NAME, BNumericPoint.TYPE, 144, 2, -1, 3, 1, n, BPollFrequency.normal, BFacets.makeNumeric());
        }
        if (bZWavePointDeviceExt.get(TOTAL_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, TOTAL_ADD_NAME, BNumericPoint.TYPE, 144, 2, -1, 3, 2, n, BPollFrequency.normal, BFacets.makeNumeric());
        }
        if (bZWavePointDeviceExt.get(TODAYS_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, TODAYS_ADD_NAME, BNumericPoint.TYPE, 144, 2, -1, 3, 3, n, BPollFrequency.normal, BFacets.makeNumeric());
        }
        if (bZWavePointDeviceExt.get(TOTAL_TIME_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, TOTAL_TIME_ADD_NAME, BNumericPoint.TYPE, 144, 2, -1, 3, 4, n, BPollFrequency.normal, BFacets.makeNumeric());
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 3) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for processEnergyProduction: 0x" + Integer.toHexString(n));
            return;
        }
        this.parameterType = zWaveInputStream.readByte();
        int n2 = zWaveInputStream.readByte();
        int n3 = n2 & 7;
        this.scale = n2 >> 3 & 3;
        this.precision = n2 >> 5 & 7;
        long l = 0L;
        if (n3 == 1) {
            l = zWaveInputStream.read();
        } else if (n3 == 2) {
            l = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
        } else if (n3 == 4) {
            l = (long)zWaveInputStream.read() << 32 | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte();
        }
        this.value = (double)l / Math.pow(10.0, this.precision);
        this.updatePoint(bZWaveDevice);
    }

    public int getCommandType() {
        return 5;
    }

    public int getAuxSelector() {
        return this.parameterType + 1;
    }

    public BFacets getReportFacets() {
        switch (this.parameterType) {
            case 0: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT, (int)this.precision);
            }
            case 1: 
            case 2: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT_HOUR, (int)this.precision);
            }
            case 3: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.SEC, (int)this.precision);
                }
                if (this.scale != 1) break;
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.HOUR, (int)this.precision);
            }
        }
        return BFacets.makeNumeric((int)this.precision);
    }

    public int getMeasureType() {
        return this.parameterType;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public BStatusValue getValue() {
        return new BStatusNumeric(this.value);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcEnergyProduction;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcEnergyProduction = BCcEnergyProduction.class("[Lcom.tridium.zwave.cmdclass.BCcEnergyProduction;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        INSTANT_ADD_NAME = "instantEnergy";
        TOTAL_ADD_NAME = "totalEnergy";
        TODAYS_ADD_NAME = "todaysEnergy";
        TOTAL_TIME_ADD_NAME = "totalTime";
    }
}

