/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.enums.BZWaveDoorLockModeEnum;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcDoorLock
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static int DOOR_MASK;
    public static int BOLT_MASK;
    public static int LATCH_MASK;
    public static String DOOR_ADD_NAME;
    public static String BOLT_ADD_NAME;
    public static String LATCH_ADD_NAME;
    public static String MODE_ADD_NAME;
    int command;
    int lockMode;
    int outHandlesMode;
    int inHandlesMode;
    int doorCondition;
    int lockTimeoutMinutes;
    int lockTimeoutSeconds;
    int operationType;
    int outHandlesState;
    int inHandlesState;
    BFacets facets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcDoorLock;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return MODE_ADD_NAME;
    }

    public int getCommandClass() {
        return 98;
    }

    public Type getControlPointType() {
        return BEnumWritable.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        if (bZWavePointDeviceExt.get(MODE_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, MODE_ADD_NAME, BEnumWritable.TYPE, 98, 2, 1, 3, BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BZWaveDoorLockModeEnum.TYPE)));
        }
        if (bZWavePointDeviceExt.get(DOOR_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, DOOR_ADD_NAME, BBooleanPoint.TYPE, 98, 2, -1, 3, BFacets.makeBoolean((String)"closed", (String)"open"));
        }
        if (bZWavePointDeviceExt.get(BOLT_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, BOLT_ADD_NAME, BBooleanPoint.TYPE, 98, 2, -1, 3, BFacets.makeBoolean((String)"unlocked", (String)"locked"));
        }
        if (bZWavePointDeviceExt.get(LATCH_ADD_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, LATCH_ADD_NAME, BBooleanPoint.TYPE, 98, 2, -1, 3, BFacets.makeBoolean((String)"closed", (String)"open"));
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 3 && this.command != 6) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassDoorLock: 0x" + Integer.toHexString(this.command));
            return;
        }
        if (this.command == 3) {
            this.lockMode = zWaveInputStream.readByte();
            int n = zWaveInputStream.readByte();
            this.outHandlesMode = n >> 4 & 0xF;
            this.inHandlesMode = n & 0xF;
            this.lockTimeoutMinutes = zWaveInputStream.readByte();
            this.lockTimeoutSeconds = zWaveInputStream.readByte();
            this.updatePoint(bZWaveDevice);
        } else {
            this.operationType = zWaveInputStream.readByte() & 0xF;
            int n = zWaveInputStream.readByte();
            this.outHandlesState = n >> 4 & 0xF;
            this.inHandlesState = n & 0xF;
            this.doorCondition = zWaveInputStream.readByte();
            this.lockTimeoutMinutes = zWaveInputStream.readByte();
            this.lockTimeoutSeconds = zWaveInputStream.readByte();
        }
    }

    public void updatePoint(BZWaveDevice bZWaveDevice) {
        BZWaveProxyExt[] bZWaveProxyExtArray = bZWaveDevice.getProxyExts(this.getCommandClass(), this.getCommandType());
        if (bZWaveProxyExtArray == null || bZWaveProxyExtArray.length == 0) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + ".doorLock");
            return;
        }
        int n = 0;
        while (n < bZWaveProxyExtArray.length) {
            if (bZWaveProxyExtArray[n].getParentPoint().getName().equals(DOOR_ADD_NAME)) {
                BZWaveProxyExt bZWaveProxyExt = bZWaveProxyExtArray[n];
                boolean bl = false;
                if ((this.doorCondition & DOOR_MASK) != 0) {
                    bl = true;
                }
                bZWaveProxyExt.readOk((BStatusValue)new BStatusBoolean(bl));
            } else if (bZWaveProxyExtArray[n].getParentPoint().getName().equals(BOLT_ADD_NAME)) {
                BZWaveProxyExt bZWaveProxyExt = bZWaveProxyExtArray[n];
                boolean bl = false;
                if ((this.doorCondition & BOLT_MASK) != 0) {
                    bl = true;
                }
                bZWaveProxyExt.readOk((BStatusValue)new BStatusBoolean(bl));
            } else if (bZWaveProxyExtArray[n].getParentPoint().getName().equals(LATCH_ADD_NAME)) {
                BZWaveProxyExt bZWaveProxyExt = bZWaveProxyExtArray[n];
                boolean bl = false;
                if ((this.doorCondition & LATCH_MASK) != 0) {
                    bl = true;
                }
                bZWaveProxyExt.readOk((BStatusValue)new BStatusBoolean(bl));
            } else if (bZWaveProxyExtArray[n].getParentPoint().getName().equals(MODE_ADD_NAME)) {
                bZWaveProxyExtArray[n].readOk((BStatusValue)new BStatusEnum((BEnum)BZWaveDoorLockModeEnum.make(this.lockMode)));
            }
            ++n;
        }
    }

    public int getCommandType() {
        return 3;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return this.facets;
    }

    public BStatusValue getValue() {
        return new BStatusEnum((BEnum)BZWaveDoorLockModeEnum.make(this.lockMode));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.command = 0;
        this.lockMode = 0;
        this.outHandlesMode = 0;
        this.inHandlesMode = 0;
        this.doorCondition = 0;
        this.lockTimeoutMinutes = 0;
        this.lockTimeoutSeconds = 0;
        this.operationType = 0;
        this.outHandlesState = 0;
        this.inHandlesState = 0;
    }

    public BCcDoorLock() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcDoorLock;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcDoorLock = BCcDoorLock.class("[Lcom.tridium.zwave.cmdclass.BCcDoorLock;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DOOR_MASK = 1;
        BOLT_MASK = 2;
        LATCH_MASK = 4;
        DOOR_ADD_NAME = "door";
        BOLT_ADD_NAME = "bolt";
        LATCH_ADD_NAME = "latch";
        MODE_ADD_NAME = "mode";
    }
}

