/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcClock
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property unused = BCcClock.newProperty((int)1, (boolean)true, null);
    public static final Property time = BCcClock.newProperty((int)1, (BValue)BTime.DEFAULT, null);
    public static final Property weekDay = BCcClock.newProperty((int)1, (BValue)BWeekday.sunday, null);
    public static final Action readTime = BCcClock.newAction((int)16, null);
    public static final Action syncTime = BCcClock.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    int minute;
    int hour;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcClock;

    public boolean getUnused() {
        return this.getBoolean(unused);
    }

    public void setUnused(boolean bl) {
        this.setBoolean(unused, bl, null);
    }

    public BTime getTime() {
        return (BTime)this.get(time);
    }

    public void setTime(BTime bTime) {
        this.set(time, (BValue)bTime, null);
    }

    public BWeekday getWeekDay() {
        return (BWeekday)this.get(weekDay);
    }

    public void setWeekDay(BWeekday bWeekday) {
        this.set(weekDay, (BValue)bWeekday, null);
    }

    public void readTime() {
        this.invoke(readTime, null, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 129;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        this.readTime();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 6) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassClock: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BCcClock bCcClock = (BCcClock)bZWaveDevice.get(ADD_NAME);
            bCcClock.readData(bCcClock, zWaveInputStream);
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! manufacturerSpecific object does not exist !!!!!!!!!");
        }
    }

    public void doReadTime() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-127, 5};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doSyncTime() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[4];
            byArray[0] = -127;
            byArray[1] = 4;
            BAbsTime bAbsTime = BAbsTime.make();
            int n = bAbsTime.getWeekday().getOrdinal();
            if (n == 0) {
                n = 7;
            }
            int n2 = bAbsTime.getHour();
            int n3 = bAbsTime.getMinute();
            byArray[2] = (byte)((n << 5) + n2);
            byArray[3] = (byte)n3;
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void readData(BCcClock bCcClock, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        this.minute = zWaveInputStream.readByte();
        this.hour = n & 0x1F;
        int n2 = n >> 5 & 7;
        if (n2 == 0) {
            bCcClock.setUnused(true);
            bCcClock.setWeekDay(BWeekday.sunday);
        } else {
            bCcClock.setUnused(false);
            if (n2 == 7) {
                bCcClock.setWeekDay(BWeekday.sunday);
            } else {
                bCcClock.setWeekDay(BWeekday.make((int)n2));
            }
            bCcClock.setTime(BTime.make((int)this.hour, (int)this.minute, (int)0));
        }
    }

    public String toString(Context context) {
        return this.getWeekDay().toString(context) + ' ' + this.getTime().toString(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcClock;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcClock = BCcClock.class("[Lcom.tridium.zwave.cmdclass.BCcClock;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "clock";
    }
}

