/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcBattery
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    static int BATTERY_LEVEL_SELECT;
    static int BATTERY_LOW_SELECT;
    public static String BATTERY_LEVEL_NAME;
    public static String BATTERY_LOW_NAME;
    int value;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcBattery;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return BATTERY_LEVEL_NAME;
    }

    public int getCommandClass() {
        return 128;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        if (bZWavePointDeviceExt.get(BATTERY_LEVEL_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, BATTERY_LEVEL_NAME, BNumericPoint.TYPE, 128, 2, -1, 3, BATTERY_LEVEL_SELECT, 0, BPollFrequency.normal, BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)0));
        }
        if (bZWavePointDeviceExt.get(BATTERY_LOW_NAME) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, BATTERY_LOW_NAME, BBooleanPoint.TYPE, 128, 2, -1, 3, BATTERY_LOW_SELECT, 0, BPollFrequency.normal, BFacets.makeBoolean((String)"low", (String)"normal"));
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 3) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassIndicator: 0x" + Integer.toHexString(n));
            return;
        }
        this.value = zWaveInputStream.readByte();
        this.updatePoint(bZWaveDevice);
    }

    public void updatePoint(BZWaveDevice bZWaveDevice) {
        BZWaveProxyExt bZWaveProxyExt = bZWaveDevice.getProxyExt(this.getCommandClass(), this.getCommandType(), BATTERY_LEVEL_SELECT);
        if (bZWaveProxyExt == null) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + ".batteryLevel");
            return;
        }
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)this.value);
        if (this.value < 0 || this.value > 100) {
            bStatusNumeric.setStatusFault(true);
        }
        bZWaveProxyExt.readOk((BStatusValue)bStatusNumeric);
        bZWaveProxyExt = bZWaveDevice.getProxyExt(this.getCommandClass(), this.getCommandType(), BATTERY_LOW_SELECT);
        if (bZWaveProxyExt == null) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + ".BatteryLow");
            return;
        }
        boolean bl = false;
        if (this.value == 255) {
            bl = true;
        }
        BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
        bZWaveProxyExt.readOk((BStatusValue)bStatusBoolean);
    }

    public int getCommandType() {
        return 3;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)0);
    }

    public BStatusValue getValue() {
        boolean bl = false;
        if (this.value != 0) {
            bl = true;
        }
        return new BStatusBoolean(bl);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcBattery;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcBattery = BCcBattery.class("[Lcom.tridium.zwave.cmdclass.BCcBattery;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        BATTERY_LEVEL_SELECT = 0;
        BATTERY_LOW_SELECT = 1;
        BATTERY_LEVEL_NAME = "batteryLevel";
        BATTERY_LOW_NAME = "batteryLow";
    }
}

