/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcBasicTariffInfo
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Property isDual = BCcBasicTariffInfo.newProperty((int)1, (boolean)false, null);
    public static final Property totalNumberImportRates = BCcBasicTariffInfo.newProperty((int)1, (int)0, null);
    public static final Property element1CurrentRateInUse = BCcBasicTariffInfo.newProperty((int)1, (int)0, null);
    public static final Property element1RateConsumption = BCcBasicTariffInfo.newProperty((int)1, (int)0, (BFacets)BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT_HOUR, (int)0));
    public static final Property timeNextRate = BCcBasicTariffInfo.newProperty((int)1, (String)"", null);
    public static final Property element2CurrentRateInUse = BCcBasicTariffInfo.newProperty((int)1, (int)0, null);
    public static final Property element2RateConsumption = BCcBasicTariffInfo.newProperty((int)1, (int)0, (BFacets)BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT_HOUR, (int)0));
    public static final Action read = BCcBasicTariffInfo.newAction((int)16, null);
    public static final Type TYPE;
    static BFacets facets;
    public static String ADD_NAME;
    public static String ADD_RATE_CONSUMPTION_NAME;
    public static String ADD_E2_RATE_CONSUMPTION_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcBasicTariffInfo;

    public boolean getIsDual() {
        return this.getBoolean(isDual);
    }

    public void setIsDual(boolean bl) {
        this.setBoolean(isDual, bl, null);
    }

    public int getTotalNumberImportRates() {
        return this.getInt(totalNumberImportRates);
    }

    public void setTotalNumberImportRates(int n) {
        this.setInt(totalNumberImportRates, n, null);
    }

    public int getElement1CurrentRateInUse() {
        return this.getInt(element1CurrentRateInUse);
    }

    public void setElement1CurrentRateInUse(int n) {
        this.setInt(element1CurrentRateInUse, n, null);
    }

    public long getElement1RateConsumption() {
        return this.getLong(element1RateConsumption);
    }

    public void setElement1RateConsumption(long l) {
        this.setLong(element1RateConsumption, l, null);
    }

    public String getTimeNextRate() {
        return this.getString(timeNextRate);
    }

    public void setTimeNextRate(String string) {
        this.setString(timeNextRate, string, null);
    }

    public int getElement2CurrentRateInUse() {
        return this.getInt(element2CurrentRateInUse);
    }

    public void setElement2CurrentRateInUse(int n) {
        this.setInt(element2CurrentRateInUse, n, null);
    }

    public long getElement2RateConsumption() {
        return this.getLong(element2RateConsumption);
    }

    public void setElement2RateConsumption(long l) {
        this.setLong(element2RateConsumption, l, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 54;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        this.setMultiInstance(n);
        String string = ADD_NAME;
        if (n > 1) {
            string = string + n;
        }
        if (bZWaveDevice.get(string) == null) {
            bZWaveDevice.add(string, (BValue)this);
        }
        this.addRateConsumptionPoint(bZWaveDevice, n, ADD_RATE_CONSUMPTION_NAME);
        if (this.getIsDual()) {
            this.addRateConsumptionPoint(bZWaveDevice, n, ADD_E2_RATE_CONSUMPTION_NAME);
        }
    }

    private final void addRateConsumptionPoint(BZWaveDevice bZWaveDevice, int n, String string) {
        BValue bValue;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        if (n > 1) {
            string = string + n;
        }
        if ((bValue = bZWavePointDeviceExt.get(string)) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BNumericPoint.TYPE, this.getCommandClass(), 1, -1, 2, -1, n, BPollFrequency.normal, BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT_HOUR, (int)0));
        } else {
            BControlPoint bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 2) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for Basic Tariff Info: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BCcBasicTariffInfo bCcBasicTariffInfo = (BCcBasicTariffInfo)bZWaveDevice.get(ADD_NAME);
            int n2 = zWaveInputStream.readByte();
            boolean bl = false;
            if ((n2 & 0x80) != 0) {
                bl = true;
            }
            bCcBasicTariffInfo.setIsDual(bl);
            bCcBasicTariffInfo.setTotalNumberImportRates(n2 & 0xF);
            bCcBasicTariffInfo.setElement1CurrentRateInUse(zWaveInputStream.readByte() & 0xF);
            bCcBasicTariffInfo.setElement1RateConsumption(zWaveInputStream.readU32());
            int n3 = zWaveInputStream.readByte();
            int n4 = zWaveInputStream.readByte();
            int n5 = zWaveInputStream.readByte();
            if (n3 == 255 && n4 == 255 && n5 == 255) {
                bCcBasicTariffInfo.setTimeNextRate("not used");
            } else {
                bCcBasicTariffInfo.setTimeNextRate("" + n3 + ':' + n4 + ':' + n5);
            }
            if (this.getIsDual() && zWaveInputStream.available() >= 5) {
                bCcBasicTariffInfo.setElement2CurrentRateInUse(zWaveInputStream.readByte() & 0xF);
                bCcBasicTariffInfo.setElement2RateConsumption(zWaveInputStream.readU32());
            }
            this.updatePoint(bZWaveDevice, this.getInstanceName(ADD_RATE_CONSUMPTION_NAME, this.getMultiInstance()), bCcBasicTariffInfo.getElement1RateConsumption());
            if (this.getIsDual()) {
                this.updatePoint(bZWaveDevice, this.getInstanceName(ADD_E2_RATE_CONSUMPTION_NAME, this.getMultiInstance()), bCcBasicTariffInfo.getElement2RateConsumption());
            }
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! BasicTariffInfo object does not exist !!!!!!!!!");
        }
    }

    private final void updatePoint(BZWaveDevice bZWaveDevice, String string, long l) {
        BZWaveProxyExt bZWaveProxyExt = this.getProxy(bZWaveDevice, string);
        if (bZWaveProxyExt == null) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + '.' + string);
            return;
        }
        ptLog.trace(bZWaveProxyExt.getDevice().getDisplayName(null) + '.' + bZWaveProxyExt.getParentPoint().getDisplayName(null) + " update = " + l);
        bZWaveProxyExt.readOk((BStatusValue)new BStatusNumeric((double)l));
    }

    public void doRead() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{(byte)this.getCommandClass(), 1};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public int getCommandType() {
        return 2;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BStatusValue getValue() {
        return new BStatusNumeric(Double.NaN);
    }

    public BFacets getReportFacets() {
        return facets;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcBasicTariffInfo;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcBasicTariffInfo = BCcBasicTariffInfo.class("[Lcom.tridium.zwave.cmdclass.BCcBasicTariffInfo;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        facets = BFacets.makeNumeric((int)0);
        ADD_NAME = "basicTariffInfo";
        ADD_RATE_CONSUMPTION_NAME = "rateConsumption";
        ADD_E2_RATE_CONSUMPTION_NAME = "e2RateConsumption";
    }
}

