/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.zwave.BLonLink;
import com.tridium.zwave.BZWaveDeviceFolder;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.association.BZWaveAssociationDeviceExt;
import com.tridium.zwave.association.BZWaveAssociationGroup;
import com.tridium.zwave.cmdclass.BCcConfiguration;
import com.tridium.zwave.cmdclass.BCcWakeUp;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.cmdclass.BZWaveManufacturerSpecific;
import com.tridium.zwave.cmdclass.BZWaveNames;
import com.tridium.zwave.cmdclass.BZWaveVersion;
import com.tridium.zwave.comm.BZWaveUnsolicitedReceive;
import com.tridium.zwave.config.BZWaveConfigDeviceExt;
import com.tridium.zwave.enums.BGenericDeviceEnum;
import com.tridium.zwave.enums.BZWaveCommandClass;
import com.tridium.zwave.learn.BZWaveLearnPointsJob;
import com.tridium.zwave.learn.CreatCmdClassComponents;
import com.tridium.zwave.messages.SerialApiRequest;
import com.tridium.zwave.messages.SerialGetNodeProtocolInfo;
import com.tridium.zwave.messages.SerialRequestNodeInfo;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveSerialFrame;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveDevice
extends BBasicDevice
implements ZWaveMessageConst {
    public static final Action upload = BZWaveDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BZWaveDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property maxFailsUntilDeviceDown = BZWaveDevice.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property currentFailCount = BZWaveDevice.newProperty((int)5, (int)0, null);
    public static final Property deviceProfile = BZWaveDevice.newProperty((int)0, (String)"", null);
    public static final Property nodeId = BZWaveDevice.newProperty((int)9, (int)0, null);
    public static final Property readDeviceOnEventUpdate = BZWaveDevice.newProperty((int)4, (boolean)false, null);
    public static final Property neighborInfo = BZWaveDevice.newProperty((int)7, (BValue)BBlob.DEFAULT, null);
    public static final Property nodeInfo = BZWaveDevice.newProperty((int)1, (BValue)new BNodeInformation(), null);
    public static final Property points = BZWaveDevice.newProperty((int)0, (BValue)new BZWavePointDeviceExt(), null);
    public static final Property version = BZWaveDevice.newProperty((int)1, (BValue)new BZWaveVersion(), null);
    public static final Property nameLocation = BZWaveDevice.newProperty((int)5, (String)"", null);
    public static final Property naming = BZWaveDevice.newProperty((int)5, (BValue)new BZWaveNames(), null);
    public static final Property learnedPoints = BZWaveDevice.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Property assocIn = BZWaveDevice.newProperty((int)1032, (int)1, null);
    public static final Property usingMultiChannelSwitchAssoication = BZWaveDevice.newProperty((int)4, (boolean)false, null);
    public static final Property remapBasicsToSwitches = BZWaveDevice.newProperty((int)4, (boolean)false, null);
    public static final Property noReadAfterBasicSet = BZWaveDevice.newProperty((int)4, (boolean)false, null);
    public static final Action requestNodeInfo = BZWaveDevice.newAction((int)16, null);
    public static final Action requestProtocolInfo = BZWaveDevice.newAction((int)16, null);
    public static final Action submitPointsDiscoveryJob = BZWaveDevice.newAction((int)4, null);
    public static final Action assignNodeName = BZWaveDevice.newAction((int)20, (BValue)BString.make((String)""), null);
    public static final Action assignNodeLocation = BZWaveDevice.newAction((int)20, (BValue)BString.make((String)""), null);
    public static final Action readVersion = BZWaveDevice.newAction((int)20, null);
    public static final Action readNodeName = BZWaveDevice.newAction((int)20, null);
    public static final Action readNodeLocation = BZWaveDevice.newAction((int)20, null);
    public static final Action pingTimeout = BZWaveDevice.newAction((int)4, null);
    public static final Action readManufacturerSpecific = BZWaveDevice.newAction((int)20, null);
    public static final Action saveDeviceProfile = BZWaveDevice.newAction((int)16, null);
    public static final Action forceSaveDeviceProfile = BZWaveDevice.newAction((int)16, null);
    public static final Action loadDeviceProfile = BZWaveDevice.newAction((int)16, null);
    public static final Action readNeighborInfo = BZWaveDevice.newAction((int)20, null);
    public static final Action readDeviceData = BZWaveDevice.newAction((int)20, null);
    public static final Action readNonBasicPointData = BZWaveDevice.newAction((int)20, null);
    public static final Action removeAssociationsToJace = BZWaveDevice.newAction((int)20, null);
    public static final Topic hail = BZWaveDevice.newTopic((int)0, null);
    public static final Type TYPE;
    public static Log usLog;
    public static Log pingLog;
    public static Object createCmdClassComponentsLock;
    static Object nodeInfoSync;
    static byte[] EOL;
    static String DEVICE_PROFILE_KEY;
    static String POINTS_NAME_MAP_KEY;
    static String CONFIG_NAME_MAP_KEY;
    public static Log profileLog;
    int nodeInfoUpdateStatus;
    Clock.Ticket pingTimer;
    public int consecutiveCount;
    private long lastReadPointDataTicks;
    private CreatCmdClassComponents readVersionInfoJob;
    private CreatCmdClassComponents readInstanceInfoJob;
    private int lastCmdClass;
    boolean wakeUpReadBasicPointPosted;
    private long nodeInfoTicksReqForPoll;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;

    public int getMaxFailsUntilDeviceDown() {
        return this.getInt(maxFailsUntilDeviceDown);
    }

    public void setMaxFailsUntilDeviceDown(int n) {
        this.setInt(maxFailsUntilDeviceDown, n, null);
    }

    public int getCurrentFailCount() {
        return this.getInt(currentFailCount);
    }

    public void setCurrentFailCount(int n) {
        this.setInt(currentFailCount, n, null);
    }

    public String getDeviceProfile() {
        return this.getString(deviceProfile);
    }

    public void setDeviceProfile(String string) {
        this.setString(deviceProfile, string, null);
    }

    public int getNodeId() {
        return this.getInt(nodeId);
    }

    public void setNodeId(int n) {
        this.setInt(nodeId, n, null);
    }

    public boolean getReadDeviceOnEventUpdate() {
        return this.getBoolean(readDeviceOnEventUpdate);
    }

    public void setReadDeviceOnEventUpdate(boolean bl) {
        this.setBoolean(readDeviceOnEventUpdate, bl, null);
    }

    public BBlob getNeighborInfo() {
        return (BBlob)this.get(neighborInfo);
    }

    public void setNeighborInfo(BBlob bBlob) {
        this.set(neighborInfo, (BValue)bBlob, null);
    }

    public BNodeInformation getNodeInfo() {
        return (BNodeInformation)this.get(nodeInfo);
    }

    public void setNodeInfo(BNodeInformation bNodeInformation) {
        this.set(nodeInfo, (BValue)bNodeInformation, null);
    }

    public BZWavePointDeviceExt getPoints() {
        return (BZWavePointDeviceExt)this.get(points);
    }

    public void setPoints(BZWavePointDeviceExt bZWavePointDeviceExt) {
        this.set(points, (BValue)bZWavePointDeviceExt, null);
    }

    public BZWaveVersion getVersion() {
        return (BZWaveVersion)this.get(version);
    }

    public void setVersion(BZWaveVersion bZWaveVersion) {
        this.set(version, (BValue)bZWaveVersion, null);
    }

    public String getNameLocation() {
        return this.getString(nameLocation);
    }

    public void setNameLocation(String string) {
        this.setString(nameLocation, string, null);
    }

    public BZWaveNames getNaming() {
        return (BZWaveNames)this.get(naming);
    }

    public void setNaming(BZWaveNames bZWaveNames) {
        this.set(naming, (BValue)bZWaveNames, null);
    }

    public BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    public void setLearnedPoints(BFolder bFolder) {
        this.set(learnedPoints, (BValue)bFolder, null);
    }

    public int getAssocIn() {
        return this.getInt(assocIn);
    }

    public void setAssocIn(int n) {
        this.setInt(assocIn, n, null);
    }

    public boolean getUsingMultiChannelSwitchAssoication() {
        return this.getBoolean(usingMultiChannelSwitchAssoication);
    }

    public void setUsingMultiChannelSwitchAssoication(boolean bl) {
        this.setBoolean(usingMultiChannelSwitchAssoication, bl, null);
    }

    public boolean getRemapBasicsToSwitches() {
        return this.getBoolean(remapBasicsToSwitches);
    }

    public void setRemapBasicsToSwitches(boolean bl) {
        this.setBoolean(remapBasicsToSwitches, bl, null);
    }

    public boolean getNoReadAfterBasicSet() {
        return this.getBoolean(noReadAfterBasicSet);
    }

    public void setNoReadAfterBasicSet(boolean bl) {
        this.setBoolean(noReadAfterBasicSet, bl, null);
    }

    public void requestNodeInfo() {
        this.invoke(requestNodeInfo, null, null);
    }

    public void requestProtocolInfo() {
        this.invoke(requestProtocolInfo, null, null);
    }

    public BOrd submitPointsDiscoveryJob() {
        return (BOrd)this.invoke(submitPointsDiscoveryJob, null, null);
    }

    public void assignNodeName(BString bString) {
        this.invoke(assignNodeName, (BValue)bString, null);
    }

    public void assignNodeLocation(BString bString) {
        this.invoke(assignNodeLocation, (BValue)bString, null);
    }

    public void readVersion() {
        this.invoke(readVersion, null, null);
    }

    public void readNodeName() {
        this.invoke(readNodeName, null, null);
    }

    public void readNodeLocation() {
        this.invoke(readNodeLocation, null, null);
    }

    public void pingTimeout() {
        this.invoke(pingTimeout, null, null);
    }

    public void readManufacturerSpecific() {
        this.invoke(readManufacturerSpecific, null, null);
    }

    public void saveDeviceProfile() {
        this.invoke(saveDeviceProfile, null, null);
    }

    public void forceSaveDeviceProfile() {
        this.invoke(forceSaveDeviceProfile, null, null);
    }

    public void loadDeviceProfile() {
        this.invoke(loadDeviceProfile, null, null);
    }

    public void readNeighborInfo() {
        this.invoke(readNeighborInfo, null, null);
    }

    public void readDeviceData() {
        this.invoke(readDeviceData, null, null);
    }

    public void readNonBasicPointData() {
        this.invoke(readNonBasicPointData, null, null);
    }

    public void removeAssociationsToJace() {
        this.invoke(removeAssociationsToJace, null, null);
    }

    public void fireHail(BAbsTime bAbsTime) {
        this.fire(hail, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BZWaveNetwork getZWaveNetwork() {
        return (BZWaveNetwork)this.getNetwork();
    }

    public BOrd doSubmitPointsDiscoveryJob() {
        BZWaveLearnPointsJob bZWaveLearnPointsJob = new BZWaveLearnPointsJob(this);
        return bZWaveLearnPointsJob.submit(null);
    }

    /*
     * Exception decompiling
     */
    public void doGetConfigurationData(BInteger var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 125->129)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if ((action.equals((Object)requestNodeInfo) || action.equals((Object)requestProtocolInfo) || action.equals((Object)assignNodeName) || action.equals((Object)assignNodeLocation) || action.equals((Object)readVersion) || action.equals((Object)readNodeLocation) || action.equals((Object)readManufacturerSpecific) || action.equals((Object)readDeviceData) || action.equals((Object)readNonBasicPointData) || action.equals((Object)saveDeviceProfile) || action.equals((Object)removeAssociationsToJace)) && (bZWaveNetwork = this.getZWaveNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doReadNeighborInfo() {
        byte[] byArray = new byte[]{(byte)this.getNodeId(), 1, 1};
        SerialApiRequest serialApiRequest = null;
        try {
            serialApiRequest = new SerialApiRequest(128, byArray);
            this.getZWaveNetwork().sendZWaveSync(new ZWaveSerialFrame(serialApiRequest));
        }
        catch (Exception exception) {}
    }

    public void doForceSaveDeviceProfile() {
        this.doSaveDeviceProfile(true);
    }

    public void doSaveDeviceProfile() {
        this.doSaveDeviceProfile(false);
    }

    public void doSaveDeviceProfile(boolean bl) {
        BZWaveManufacturerSpecific bZWaveManufacturerSpecific = BZWaveManufacturerSpecific.getCmdClassComponent(this);
        if (bZWaveManufacturerSpecific == null) {
            profileLog.trace(this.getNodeId() + ": does not support ManufacturerSpecific Command Class");
            return;
        }
        String string = bZWaveManufacturerSpecific.getInfoFileName();
        try {
            BZWaveConfigDeviceExt bZWaveConfigDeviceExt;
            BNameMap bNameMap;
            BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath("^zwaveDevTemplates/" + string));
            if (bIFile == null) {
                bIFile = BFileSystem.INSTANCE.makeFile(new FilePath("^zwaveDevTemplates/" + string));
            } else {
                if (!bl) {
                    profileLog.message(string + " already exist, will not overwrite!");
                    return;
                }
                bIFile.delete();
                bIFile = BFileSystem.INSTANCE.makeFile(new FilePath("^zwaveDevTemplates/" + string));
            }
            OutputStream outputStream = bIFile.getOutputStream();
            String string2 = this.getDeviceProfile();
            if (string2.length() != 0) {
                outputStream.write(DEVICE_PROFILE_KEY.getBytes());
                outputStream.write(string2.getBytes());
                outputStream.write(EOL);
            }
            if ((bNameMap = this.getNameMap((BComponent)this.getPoints())) != null) {
                outputStream.write(POINTS_NAME_MAP_KEY.getBytes());
                outputStream.write(bNameMap.encodeToString().getBytes());
                outputStream.write(EOL);
            }
            if ((bZWaveConfigDeviceExt = BCcConfiguration.getCmdClassComponent(this)) != null && (bNameMap = this.getNameMap((BComponent)bZWaveConfigDeviceExt)) != null) {
                outputStream.write(CONFIG_NAME_MAP_KEY.getBytes());
                outputStream.write(bNameMap.encodeToString().getBytes());
                outputStream.write(EOL);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doLoadDeviceProfile() {
        BZWaveManufacturerSpecific bZWaveManufacturerSpecific = BZWaveManufacturerSpecific.getCmdClassComponent(this);
        if (bZWaveManufacturerSpecific == null) {
            profileLog.trace(this.getNodeId() + ": does not support ManufacturerSpecific Command Class");
            return;
        }
        String string = bZWaveManufacturerSpecific.getInfoFileName();
        try {
            Object object;
            String string2;
            InputStream inputStream;
            BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath("^zwaveDevTemplates/" + string));
            if (bIFile == null) {
                profileLog.trace(string + " does not exist in station/zwaveDevTemplates dir, looking in jar file");
                inputStream = BZWaveNetwork.TYPE.getModule();
                string2 = inputStream.findFile(new FilePath("/com/tridium/zwave/zwaveDevTemplates"));
                object = inputStream.getChildren((BIFile)string2);
                int n = 0;
                while (n < ((BIFile[])object).length) {
                    if (object[n].getFileName().equals(string)) {
                        bIFile = object[n];
                        break;
                    }
                    ++n;
                }
                if (bIFile == null) {
                    profileLog.trace(string + " does not exist in station/zwaveDevTemplates dir, or jar file");
                    return;
                }
            }
            inputStream = bIFile.getInputStream();
            string2 = ZWaveInputStream.readLine(inputStream);
            profileLog.trace("      line = " + string2);
            if (string2.startsWith(DEVICE_PROFILE_KEY)) {
                object = string2.substring(DEVICE_PROFILE_KEY.length());
                this.setDeviceProfile((String)object);
            }
            if ((string2 = ZWaveInputStream.readLine(inputStream)).startsWith(POINTS_NAME_MAP_KEY)) {
                object = string2.substring(POINTS_NAME_MAP_KEY.length());
                this.setNameMap((BComponent)this.getPoints(), (String)object);
            }
            if ((string2 = ZWaveInputStream.readLine(inputStream)).startsWith(CONFIG_NAME_MAP_KEY)) {
                object = string2.substring(CONFIG_NAME_MAP_KEY.length());
                BZWaveConfigDeviceExt bZWaveConfigDeviceExt = BCcConfiguration.getCmdClassComponent(this);
                this.setNameMap((BComponent)bZWaveConfigDeviceExt, (String)object);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BNameMap getNameMap(BComponent bComponent) {
        BValue bValue = bComponent.get("displayNames");
        if (bValue != null && bValue.getType().is(BNameMap.TYPE)) {
            return (BNameMap)bValue;
        }
        return null;
    }

    public void setNameMap(BComponent bComponent, String string) {
        try {
            BValue bValue = bComponent.get("displayNames");
            if (bValue != null && bValue.getType().is(BNameMap.TYPE)) {
                BNameMap bNameMap = (BNameMap)bValue;
                BNameMap bNameMap2 = (BNameMap)BNameMap.NULL.decodeFromString(string);
                BNameMap bNameMap3 = BNameMap.make((BNameMap)bNameMap, (BNameMap)bNameMap2);
                try {
                    bComponent.set("displayNames", (BValue)bNameMap3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    bComponent.add("displayNames", (BValue)((BNameMap)BNameMap.NULL.decodeFromString(string)), 261);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doBasicGet() {
        byte[] byArray = new byte[]{32, 2};
        this.sendMsg(byArray);
    }

    public void doReadManufacturerSpecific() {
        byte[] byArray = new byte[]{114, 4};
        this.sendMsg(byArray);
    }

    public void doReadVersion() {
        byte[] byArray = new byte[]{-122, 17};
        this.sendMsg(byArray);
    }

    public boolean isNamingSupported() {
        return this.getNodeInfo().isSupported(119);
    }

    public void doReadNodeName() {
        byte[] byArray = new byte[]{119, 2};
        this.sendMsg(byArray);
    }

    public void doReadNodeLocation() {
        byte[] byArray = new byte[]{119, 5};
        this.sendMsg(byArray);
    }

    public void sendMsg(byte[] byArray) {
        SerialSendData serialSendData = null;
        try {
            serialSendData = new SerialSendData(this.getNodeId(), byArray, 5);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doAssignNodeName(BString bString) {
        this.getNaming().doAssignNodeName(bString);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)assignNodeLocation)) {
            return BString.make((String)this.getNaming().getNodeLocation());
        }
        if (action.equals((Object)assignNodeName)) {
            return BString.make((String)this.getNaming().getNodeName());
        }
        return super.getActionParameterDefault(action);
    }

    public void doAssignNodeLocation(BString bString) {
        this.getNaming().doAssignNodeLocation(bString);
    }

    public void doRequestNodeInfo() {
        this.doRequestNodeInfo(null);
    }

    public void doRequestProtocolInfo() {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        SerialGetNodeProtocolInfo serialGetNodeProtocolInfo = new SerialGetNodeProtocolInfo(this.getNodeId());
        try {
            ZWaveSerialFrame zWaveSerialFrame = (ZWaveSerialFrame)bZWaveNetwork.sendZWaveSync(new ZWaveSerialFrame(serialGetNodeProtocolInfo, true));
            ZWaveInputStream zWaveInputStream = new ZWaveInputStream(zWaveSerialFrame.getData(), 0, zWaveSerialFrame.getLength());
            zWaveInputStream.read();
            zWaveInputStream.read();
            int n = zWaveInputStream.read() & 0xFF;
            int n2 = zWaveInputStream.read() & 0xFF;
            int n3 = zWaveInputStream.read() & 0xFF;
            boolean bl = false;
            if ((n2 & 0x80) != 0) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = false;
            if ((n3 & 0x80) != 0) {
                bl3 = true;
            }
            boolean bl4 = bl3;
            boolean bl5 = false;
            if ((n3 & 0x20) != 0) {
                bl5 = true;
            }
            boolean bl6 = bl5;
            boolean bl7 = false;
            if ((n3 & 0x40) != 0) {
                bl7 = true;
            }
            boolean bl8 = bl7;
            zWaveInputStream.read();
            BNodeInformation bNodeInformation = this.getNodeInfo();
            bNodeInformation.setIsListening(bl2);
            bNodeInformation.setOptionalFunctionality(bl4);
            bNodeInformation.setSensor1000ms(bl8);
            bNodeInformation.setSensor250ms(bl6);
            bNodeInformation.readData(zWaveInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doRequestNodeInfo(BJob var1_1) {
        block12: {
            var2_2 = (BZWaveNetwork)this.getNetwork();
            var3_3 = var2_2.commLock;
            // MONITORENTER : var3_3
            var5_4 = BZWaveDevice.nodeInfoSync;
            // MONITORENTER : var5_4
            ** try [egrp 1[TRYBLOCK] [5 : 35->183)] { 
lbl8:
            // 1 sources

            break block12;
lbl12:
            // 1 sources

            catch (Throwable v1) {
                // MONITOREXIT : var5_4
                throw v1;
            }
        }
        var7_5 = null;
        try {
            try {
                var2_2.getUnsolicitedReceiveHandler().setNodeInfoUpdate(this);
                this.nodeInfoUpdateStatus = -1;
                var7_5 = new SerialRequestNodeInfo(this.getNodeId());
                var10_6 = new ZWaveSerialFrame(var7_5, true);
                var10_6.setTag(new Integer(24576));
                var2_2.sendZWaveSync(var10_6);
                BZWaveDevice.nodeInfoSync.wait(10000L);
                if (this.nodeInfoUpdateStatus == -1 && this.getNodeInfo().getCmdClassesRaw().length() == 0) {
                    this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                    this.setFaultCause("NodeInfo not updated");
                }
            }
            catch (Exception var10_7) {
                var10_7.printStackTrace();
            }
            var9_10 = null;
            var2_2 = null;
            // MONITOREXIT : var5_4
            // MONITOREXIT : var3_3
            return;
        }
        catch (Throwable var8_8) {
            var9_9 = null;
            var2_2 = null;
            throw var8_8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyNodeInfoUpdate(int n) {
        this.nodeInfoUpdateStatus = n;
        if (n != 132) return;
        Object object = nodeInfoSync;
        synchronized (object) {
            nodeInfoSync.notify();
            return;
        }
    }

    public Type getNetworkType() {
        return BZWaveNetwork.TYPE;
    }

    public BZWaveConfigDeviceExt getConfigDeviceExt() {
        BDeviceExt[] bDeviceExtArray = this.getDeviceExts();
        int n = 0;
        while (n < bDeviceExtArray.length) {
            if (bDeviceExtArray[n].getType().is(BZWaveConfigDeviceExt.TYPE)) {
                return (BZWaveConfigDeviceExt)bDeviceExtArray[n];
            }
            ++n;
        }
        return null;
    }

    public BZWaveAssociationDeviceExt getAssociationDeviceExt() {
        BDeviceExt[] bDeviceExtArray = this.getDeviceExts();
        int n = 0;
        while (n < bDeviceExtArray.length) {
            if (bDeviceExtArray[n].getType().is(BZWaveAssociationDeviceExt.TYPE)) {
                return (BZWaveAssociationDeviceExt)bDeviceExtArray[n];
            }
            ++n;
        }
        return null;
    }

    public boolean isParentLegal(BComponent bComponent) {
        Type type = bComponent.getType();
        boolean bl = false;
        if (type.is(BZWaveNetwork.TYPE) || type.is(BZWaveDeviceFolder.TYPE)) {
            bl = true;
        }
        return bl;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public IFuture postPing() {
        BZWaveNetwork bZWaveNetwork = this.getZWaveNetwork();
        if (bZWaveNetwork != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
        }
        return null;
    }

    public void doPing() {
        pingLog.trace(this.getNodeId() + ": ping()");
        this.doRequestProtocolInfo();
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        if (this.pingTimer != null) {
            if (this.isDown()) {
                this.pingFail("still down");
            } else {
                super.pingOk();
            }
        }
        if (!this.isNodeListening()) {
            if (this.isDown()) {
                this.pingFail("still down");
            } else {
                super.pingOk();
            }
            return;
        }
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
        }
        BRelTime bRelTime = bZWaveNetwork.getResponseTimeout();
        long l = bRelTime.getMillis() * (long)(1 + bZWaveNetwork.getRetryCount()) * (long)3;
        this.pingTimer = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)l), (Action)pingTimeout, null);
        BNodeInformation bNodeInformation = this.getNodeInfo();
        if (bNodeInformation.isSupported(114)) {
            this.doReadManufacturerSpecific();
        } else if (bNodeInformation.isSupported(134)) {
            this.doReadVersion();
        } else {
            this.doRequestNodeInfo();
        }
    }

    public void pingOk() {
        pingLog.trace(this.getNodeId() + ": pingOk()");
        this.getNetwork().pingOk();
        this.consecutiveCount = 0;
        this.setCurrentFailCount(this.consecutiveCount);
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
        }
        super.pingOk();
        BValue bValue = this.get("wakeUp");
        if (bValue != null && bValue.getType().is(BCcWakeUp.TYPE)) {
            BCcWakeUp bCcWakeUp = (BCcWakeUp)bValue;
            if (bCcWakeUp.getInterval() > 0) {
                this.pingTimer = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)(bCcWakeUp.getInterval() + 30)), (Action)pingTimeout, null);
            } else if (this.pingTimer != null) {
                this.pingTimer.cancel();
                this.pingTimer = null;
            }
        }
    }

    public void doPingTimeout() {
        pingLog.trace(this.getNodeId() + ": pingTimeout - count = " + (this.consecutiveCount + 1));
        if (++this.consecutiveCount >= this.getMaxFailsUntilDeviceDown()) {
            this.pingFail("timeout");
            pingLog.trace(this.getNodeId() + ": invoking pingFail() - count = " + this.consecutiveCount);
        } else {
            BValue bValue = this.get("wakeUp");
            if (bValue != null && bValue.getType().is(BCcWakeUp.TYPE)) {
                BCcWakeUp bCcWakeUp = (BCcWakeUp)bValue;
                if (bCcWakeUp.getInterval() > 0) {
                    this.pingTimer = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)(bCcWakeUp.getInterval() + 30)), (Action)pingTimeout, null);
                } else if (this.pingTimer != null) {
                    this.pingTimer.cancel();
                    this.pingTimer = null;
                }
            }
        }
        this.setCurrentFailCount(this.consecutiveCount);
    }

    public void addCmdClassSupport(int n) {
        this.addCmdClassSupport(n, 1);
    }

    public void addCmdClassSupport(int n, int n2) {
        BCmdClassObject bCmdClassObject = this.getZWaveNetwork().getCommandClassInstance(n);
        if (bCmdClassObject != null) {
            bCmdClassObject.initVersionInstance(this, n2);
            bCmdClassObject.addCmdClass(this, n2);
        }
    }

    public void processApplicationCommand(ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        int n2 = zWaveInputStream.readByte();
        BZWaveUnsolicitedReceive.usLog.trace((Object)((Object)BZWaveCommandClass.getTag(n2)) + "(0x" + Integer.toHexString(n2) + ')');
        BCmdClassObject bCmdClassObject = this.getZWaveNetwork().getCommandClassInstance(n2);
        if (bCmdClassObject != null) {
            bCmdClassObject.processUpdate(this, zWaveInputStream);
        } else {
            usLog.trace("UNSUPPORTED COMMAND CLASS: 0x" + Integer.toHexString(n2));
            usLog.trace("     " + (Object)((Object)BZWaveCommandClass.make(n2)));
        }
    }

    public boolean isNodeListening() {
        BNodeInformation bNodeInformation = this.getNodeInfo();
        if (bNodeInformation.isSupported(132)) {
            return false;
        }
        boolean bl = false;
        if (bNodeInformation.getIsListening() || bNodeInformation.getSensor1000ms() || bNodeInformation.getSensor250ms()) {
            bl = true;
        }
        return bl;
    }

    public BCcWakeUp getWakeUpClass() {
        try {
            return (BCcWakeUp)this.get(BCcWakeUp.ADD_NAME);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getCommandClassVersion(int n) {
        return this.getNodeInfo().getCommandClassVersion(n);
    }

    public void setReadVersionInfoJob(CreatCmdClassComponents creatCmdClassComponents, int n) {
        this.readVersionInfoJob = creatCmdClassComponents;
        this.lastCmdClass = n;
    }

    public CreatCmdClassComponents getReadVersionInfoJob() {
        return this.readVersionInfoJob;
    }

    public int getVersionInfoUpdateLastCmdClass() {
        return this.lastCmdClass;
    }

    public void setReadInstanceInfoJob(CreatCmdClassComponents creatCmdClassComponents, int n) {
        this.readInstanceInfoJob = creatCmdClassComponents;
        this.lastCmdClass = n;
    }

    public CreatCmdClassComponents getReadInstanceInfoJob() {
        return this.readInstanceInfoJob;
    }

    public int getInstanceInfoUpdateLastCmdClass() {
        return this.lastCmdClass;
    }

    public BZWaveProxyExt getProxyExt(int n, int n2) {
        return this.getProxyExt(n, n2, -1);
    }

    public BZWaveProxyExt getProxyExt(int n, int n2, int n3, int n4) {
        return BZWavePointDeviceExt.getProxyExt(this.getPoints(), n, n2, n3, n4);
    }

    public BZWaveProxyExt getProxyExt(int n, int n2, int n3) {
        return BZWavePointDeviceExt.getProxyExt(this.getPoints(), n, n2, n3, -1);
    }

    public BZWaveProxyExt[] getProxyExts(int n, int n2) {
        return BZWavePointDeviceExt.getProxyExts(this.getPoints(), n, n2);
    }

    public void added(Property property, Context context) {
        BLink bLink;
        BValue bValue = this.get(property);
        if (bValue instanceof BLink && context != null && (bLink = (BLink)bValue).getSourceSlotName().startsWith("group")) {
            String string = bLink.getTargetSlotName();
            if (string.equals("assocIn")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceComponent();
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlot().asProperty())).getInt();
                bZWaveDevice.associateDevice(1, this.getNodeId(), n, 0);
            } else if (string.startsWith("assocIn_")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceComponent();
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlot().asProperty())).getInt();
                int n2 = Integer.parseInt(string.substring(string.indexOf(95) + 1));
                bZWaveDevice.associateDevice(2, this.getNodeId(), n, n2);
            } else if (string.startsWith("assocInEp")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceComponent();
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlot().asProperty())).getInt();
                int n3 = Integer.parseInt(string.substring("assocInEp".length()));
                bZWaveDevice.associateDevice(2, this.getNodeId(), n, n3);
            }
        }
        super.added(property, context);
    }

    public void removed(Property property, BValue bValue, Context context) {
        BLink bLink;
        if (bValue instanceof BLink && (bLink = (BLink)bValue).getSourceSlotName().startsWith("group")) {
            String string = bLink.getTargetSlotName();
            if (string.equals("assocIn")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceOrd().get((BObject)this);
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlotName())).getInt();
                bZWaveDevice.unAssociateDevice(1, this.getNodeId(), n, 0);
            } else if (string.startsWith("assocIn_")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceOrd().get((BObject)this);
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlotName())).getInt();
                int n2 = Integer.parseInt(string.substring(string.indexOf(95) + 1));
                bZWaveDevice.unAssociateDevice(2, this.getNodeId(), n, n2);
            } else if (string.startsWith("assocInEp")) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bLink.getSourceOrd().get((BObject)this);
                int n = ((BInteger)bZWaveDevice.get(bLink.getSourceSlotName())).getInt();
                int n3 = Integer.parseInt(string.substring("assocInEp".length()));
                bZWaveDevice.unAssociateDevice(2, this.getNodeId(), n, n3);
            }
        }
        super.removed(property, bValue, context);
    }

    public void associateDevice(int n, int n2, int n3, int n4) {
        try {
            BZWaveAssociationDeviceExt bZWaveAssociationDeviceExt = null;
            bZWaveAssociationDeviceExt = (BZWaveAssociationDeviceExt)this.get("associations");
            if (bZWaveAssociationDeviceExt == null) {
                return;
            }
            String string = "group" + n3;
            BZWaveAssociationGroup bZWaveAssociationGroup = (BZWaveAssociationGroup)bZWaveAssociationDeviceExt.get(string);
            if (bZWaveAssociationGroup == null) {
                return;
            }
            String string2 = BZWaveAssociationGroup.getAddRemoveArgument(n, n2, n4);
            bZWaveAssociationGroup.addNode(BString.make((String)string2));
            if (n4 == 0) {
                bZWaveAssociationGroup.setLinkAdded(true);
            } else {
                bZWaveAssociationGroup.setMultiInstanceLinkAdded(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void unAssociateDevice(int n, int n2, int n3, int n4) {
        try {
            BZWaveAssociationDeviceExt bZWaveAssociationDeviceExt = null;
            bZWaveAssociationDeviceExt = (BZWaveAssociationDeviceExt)this.get("associations");
            if (bZWaveAssociationDeviceExt == null) {
                return;
            }
            BZWaveAssociationGroup bZWaveAssociationGroup = (BZWaveAssociationGroup)bZWaveAssociationDeviceExt.get("group" + n3);
            if (bZWaveAssociationGroup == null) {
                return;
            }
            String string = BZWaveAssociationGroup.getAddRemoveArgument(n, n2, n4);
            bZWaveAssociationGroup.removeNode(BString.make((String)string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final BLink makeLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        BOrd bOrd = bComponent.getHandleOrd();
        String string = slot.getName();
        String string2 = slot2.getName();
        if (string.startsWith("group")) {
            return new BLonLink(bOrd, string, string2, true);
        }
        return new BLink(bOrd, string, string2, true);
    }

    public boolean isBooleanDevice() {
        return this.getNodeInfo().getGenericDeviceClass().equals((Object)BGenericDeviceEnum.genericSwitchBinary);
    }

    public BControlPoint getBasicPoint() {
        return this.getNodeInfo().getDefaultCmdClassPoint();
    }

    public void doRemoveAssociationsToJace() {
        BZWaveAssociationDeviceExt bZWaveAssociationDeviceExt = this.getAssociationDeviceExt();
        bZWaveAssociationDeviceExt.doRemoveAssociationsTo(BString.make((String)String.valueOf(((BZWaveNetwork)this.getNetwork()).getInterfaceNodeId())));
    }

    public void doReadDeviceData() {
        BCcWakeUp bCcWakeUp = this.getWakeUpClass();
        if (bCcWakeUp != null) {
            bCcWakeUp.doReadDeviceData();
            return;
        }
        if (this.getNodeInfo().getCmdClassesRaw().length() == 0) {
            this.getNodeInfo().set(BNodeInformation.cmdClassesRaw, (BValue)BBlob.DEFAULT, Context.decoding);
            this.doRequestNodeInfo();
        }
        try {
            this.getConfigDeviceExt().checkPostedAction();
        }
        catch (Exception exception) {}
        try {
            this.getAssociationDeviceExt().checkPostedAssociations();
        }
        catch (Exception exception) {}
        this.doReadManufacturerSpecific();
        this.doReadPointData();
        try {
            this.getConfigDeviceExt().checkPostedAction();
        }
        catch (Exception exception) {}
        try {
            this.getAssociationDeviceExt().checkPostedAssociations();
        }
        catch (Exception exception) {}
    }

    public void doReadPointData() {
        this.doReadPointData(true);
    }

    public void doReadPointData(boolean bl) {
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            block4: {
                BZWaveProxyExt bZWaveProxyExt;
                block3: {
                    bZWaveProxyExt = (BZWaveProxyExt)bControlPointArray[n].getProxyExt();
                    if (bZWaveProxyExt.getCommandClass() != 32) break block3;
                    if (!bl) break block4;
                    this.wakeUpReadBasicPointPosted = true;
                }
                BPointCmdClassObject.ptLog.trace(this.getNodeId() + ": " + bControlPointArray[n].getDisplayName(null) + " associationEvent poll ");
                bZWaveProxyExt.pollForData();
            }
            ++n;
        }
    }

    public void doReadNonBasicPointData() {
        if (this.wakeUpReadBasicPointPosted) {
            this.wakeUpReadBasicPointPosted = false;
            return;
        }
        if (this.getNodeInfo().getIsListening() || this.getNodeInfo().isFlirsDevice() || this.getReadDeviceOnEventUpdate()) {
            long l = Clock.ticks();
            if (l - this.lastReadPointDataTicks > 1000L) {
                this.doReadPointData(false);
                this.lastReadPointDataTicks = Clock.ticks();
            } else {
                BPointCmdClassObject.ptLog.trace("skipping read points");
            }
        }
    }

    public void hideReadDeviceOnEventUpdate(boolean bl) {
        if (bl) {
            this.setFlags((Slot)readDeviceOnEventUpdate, this.getFlags((Slot)readDeviceOnEventUpdate) | 4);
        } else {
            this.setFlags((Slot)readDeviceOnEventUpdate, this.getFlags((Slot)readDeviceOnEventUpdate) & 0xFFFFFFFB);
        }
    }

    public long getMinTicksForNodeInfoPoll() {
        return this.nodeInfoTicksReqForPoll;
    }

    public void setDelayNodeInfoPoll() {
        this.nodeInfoTicksReqForPoll = Clock.ticks() + 1000L;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nodeInfoUpdateStatus = -1;
        this.consecutiveCount = 0;
        this.lastReadPointDataTicks = 0L;
        this.readVersionInfoJob = null;
        this.readInstanceInfoJob = null;
        this.lastCmdClass = 0;
        this.wakeUpReadBasicPointPosted = false;
        this.nodeInfoTicksReqForPoll = 0L;
    }

    public BZWaveDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$BZWaveDevice;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveDevice.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        usLog = Log.getLog((String)"zwave.unsupported");
        pingLog = Log.getLog((String)"zwave.ping");
        createCmdClassComponentsLock = new Object();
        nodeInfoSync = new Object();
        EOL = new byte[]{13};
        DEVICE_PROFILE_KEY = "deviceProfile=";
        POINTS_NAME_MAP_KEY = "pointsNameMap";
        CONFIG_NAME_MAP_KEY = "configNameMap";
        profileLog = Log.getLog((String)"zwave.profile");
    }
}

