/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.ui;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.datatypes.BAndoverBackupRecord;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.job.BAndoverBackupControllerJob;
import com.tridium.andoverAC256.job.BAndoverRestoreControllerJob;
import com.tridium.andoverAC256.job.BAndoverSetOptionsJob;
import com.tridium.ui.theme.Theme;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.job.BJobBar;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverBackupManager
extends BWbComponentView {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    static final BImage icon;
    BJobBar jobBar;
    BTable table;
    Command cmdBackup;
    Command cmdRestore;
    Command cmdSetOptions;
    RestoreAbort cmdRestoreAbort;
    Delete cmdDelete;
    BAndoverDevice device;
    BAndoverBackupRecord[] recs;
    boolean restoreJobComplete;
    static /* synthetic */ Class class$com$tridium$andoverAC256$ui$BAndoverBackupManager;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.device = (BAndoverDevice)bObject;
        this.registerForComponentEvents((BComponent)this.device.getBackupList());
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        Restore restore = (Restore)this.cmdRestore;
        BJob bJob = restore.getJob();
        if (bComponentEvent.getSourceComponent() == bJob) {
            if (bJob.getJobState().isComplete() && !this.restoreJobComplete) {
                this.restoreJobComplete = true;
                this.table.setSelection((TableSelection)new Selection());
                this.reload();
            }
            return;
        }
        if (bComponentEvent.getSourceComponent() == this.device.getBackupList()) {
            if (bComponentEvent.getId() == 5) {
                this.reload();
            }
            return;
        }
    }

    public void reload() {
        this.recs = BAndoverBackupRecord.list(this.device);
        this.table.getModel().updateTable();
        this.updateCommands();
    }

    private final void updateCommands() {
        int n = this.table.getSelection().getRowCount();
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        this.cmdRestore.setEnabled(bl);
        boolean bl2 = false;
        if (n == 1) {
            bl2 = true;
        }
        this.cmdDelete.setEnabled(bl2);
        this.cmdRestoreAbort.setEnabled(false);
        this.cmdBackup.setEnabled(true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cmdBackup = new Backup((BWidget)this);
        this.cmdRestore = new Restore((BWidget)this);
        this.cmdSetOptions = new SetOptions((BWidget)this);
        this.cmdRestoreAbort = new RestoreAbort((BWidget)this);
        this.cmdDelete = new Delete((BWidget)this);
        this.restoreJobComplete = false;
    }

    public BAndoverBackupManager() {
        this.this();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        this.table.setMultipleSelection(false);
        this.table.setSelection((TableSelection)new Selection());
        BTitlePane bTitlePane = BTitlePane.makePane((String)lexicon.getText("backup.backups"), (BTable)this.table);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(5);
        bGridPane.add(null, (BValue)new BButton(this.cmdBackup));
        bGridPane.add(null, (BValue)new BButton(this.cmdRestore));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdRestoreAbort));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdDelete));
        bGridPane.add(null, (BValue)new BButton(this.cmdSetOptions));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5, (double)0.0)));
        bEdgePane.setCenter((BWidget)bTitlePane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
        this.registerForComponentEvents((BComponent)this.table);
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$ui$BAndoverBackupManager;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$ui$BAndoverBackupManager = BAndoverBackupManager.class("[Lcom.tridium.andoverAC256.ui.BAndoverBackupManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$andoverAC256$ui$BAndoverBackupManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$andoverAC256$ui$BAndoverBackupManager = BAndoverBackupManager.class("[Lcom.tridium.andoverAC256.ui.BAndoverBackupManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
        icon = BImage.make((String)"module://icons/x16/backup.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Restore
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            int n;
            int[] nArray = BAndoverBackupManager.this.table.getSelection().getRows();
            if (nArray.length != 1) {
                return null;
            }
            BAbsTime bAbsTime = (BAbsTime)BAndoverBackupManager.this.table.getModel().getValueAt(nArray[0], 0);
            String string = (String)BAndoverBackupManager.this.table.getModel().getValueAt(nArray[0], 1);
            BOrd bOrd = (BOrd)BAndoverBackupManager.this.table.getModel().getValueAt(nArray[0], 2);
            int n2 = string.indexOf("_dom");
            int n3 = string.indexOf("_", n2 + 1);
            String string2 = string.substring(n2 + 4, n3);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            String string3 = "LCU";
            if (n == 0) {
                string3 = "main controller";
            }
            BAndoverRestoreConfig bAndoverRestoreConfig = new BAndoverRestoreConfig();
            bAndoverRestoreConfig.setRestoreDialog("Restoring Domain " + string2 + " (" + string3 + ')');
            bAndoverRestoreConfig.setFileName(string);
            bAndoverRestoreConfig.setTimestamp(bAbsTime);
            bAndoverRestoreConfig.setDomain(n);
            bAndoverRestoreConfig.setOrd(bOrd);
            BAndoverRestoreConfig bAndoverRestoreConfig2 = (BAndoverRestoreConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.restore.configDialog"), (BObject)bAndoverRestoreConfig);
            if (bAndoverRestoreConfig2 == null) {
                return null;
            }
            BAndoverBackupManager.this.restoreJobComplete = false;
            BOrd bOrd2 = BAndoverBackupManager.this.device.submitRestoreControllerJob(bAndoverRestoreConfig2);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverRestoreControllerJob)bOrd2.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestoreAbort.setJob(this.job);
            BAndoverBackupManager.this.cmdRestoreAbort.setEnabled(true);
            BAndoverBackupManager.this.cmdBackup.setEnabled(false);
            BAndoverBackupManager.this.cmdDelete.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }

        Restore(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "restore");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void updateTable() {
            super.updateTable();
            BAndoverBackupManager.this.updateCommands();
        }

        Selection() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Delete
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            int[] nArray = BAndoverBackupManager.this.table.getSelection().getRows();
            if (nArray.length != 1) {
                return null;
            }
            BOrd bOrd = (BOrd)BAndoverBackupManager.this.table.getModel().getValueAt(nArray[0], 2);
            String string = (String)BAndoverBackupManager.this.table.getModel().getValueAt(nArray[0], 1);
            String string2 = lexicon.getText("backup.confirmDelete") + ' ' + string;
            if (BDialog.confirm((BWidget)this.getOwner(), (Object)string2) == 4) {
                BAndoverBackupManager.this.device.deleteBackupFile(bOrd);
            }
            return null;
        }

        Delete(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "delete");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RestoreAbort
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            if (this.job != null && this.job instanceof BAndoverRestoreControllerJob) {
                this.job.doCancel(null);
            }
            return null;
        }

        public void setJob(BJob bJob) {
            this.job = bJob;
        }

        RestoreAbort(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "abort");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Backup
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            String string = BAndoverBackupManager.this.device.getDevicePassword().substring(2);
            String string2 = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
            BAndoverBackupConfig bAndoverBackupConfig = new BAndoverBackupConfig();
            BAndoverBackupConfig bAndoverBackupConfig2 = (BAndoverBackupConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.backup.configDialog"), (BObject)bAndoverBackupConfig);
            if (bAndoverBackupConfig2 == null) {
                return null;
            }
            String string3 = string + "_dom" + bAndoverBackupConfig2.getDomain() + '_' + string2 + ".txt";
            bAndoverBackupConfig2.setFileName(string3);
            BOrd bOrd = BAndoverBackupManager.this.device.submitBackupControllerJob(bAndoverBackupConfig2);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverBackupControllerJob)bOrd.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestore.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }

        Backup(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "backup");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SetOptions
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            BAndoverSetOptionsConfig bAndoverSetOptionsConfig = (BAndoverSetOptionsConfig)BAndoverBackupManager.this.device.getOptionCommandSettings().newCopy();
            BAndoverSetOptionsConfig bAndoverSetOptionsConfig2 = (BAndoverSetOptionsConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.setOptions.configDialog"), (BObject)bAndoverSetOptionsConfig);
            if (bAndoverSetOptionsConfig2 == null) {
                return null;
            }
            BOrd bOrd = BAndoverBackupManager.this.device.submitSetOptionsJob(bAndoverSetOptionsConfig2);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverSetOptionsJob)bOrd.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestore.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }

        SetOptions(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "setOptions");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        public int getRowCount() {
            return BAndoverBackupManager.this.recs.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BAndoverBackupRecord.timestamp.getDefaultDisplayName(null);
                }
                case 1: {
                    return BAndoverBackupRecord.path.getDefaultDisplayName(null);
                }
                case 2: {
                    return BAndoverBackupRecord.ord.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getValueAt(int n, int n2) {
            BAndoverBackupRecord bAndoverBackupRecord = BAndoverBackupManager.this.recs[n];
            switch (n2) {
                case 0: {
                    return bAndoverBackupRecord.getTimestamp();
                }
                case 1: {
                    return bAndoverBackupRecord.getPath();
                }
                case 2: {
                    return bAndoverBackupRecord.getOrd();
                }
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return icon;
        }

        public void updateTable() {
            super.updateTable();
        }

        Model() {
        }
    }
}

