/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IntHashMap;
import javax.baja.util.Lexicon;
import org.apache.oro.text.awk.AwkCompiler;
import org.apache.oro.text.awk.AwkPattern;
import org.apache.oro.text.regex.MalformedPatternException;

public class AndoverReceivedMessage
extends ReceivedMessage
implements AndoverMessageConst {
    private static final IntHashMap errMap = new IntHashMap();
    private static Lexicon lex = Lexicon.make((String)"andoverAC256");
    public String message;
    public BAndoverPromptEnum prompt;
    public int exceptionCode;
    public int domain;
    public String errorMsg;
    private byte[] byteData;

    public String getMessage() {
        return this.message;
    }

    public BAndoverPromptEnum getPrompt() {
        if (this.prompt == null) {
            this.checkPrompt();
        }
        return this.prompt;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.byteData));
        return stringBuffer.toString();
    }

    private final void checkPrompt() {
        if (this.message.indexOf("Bad Reload Block") != -1) {
            this.prompt = BAndoverPromptEnum.Reloading;
            return;
        }
        if (this.message.indexOf("R>") != -1) {
            this.domain = 0;
            this.prompt = BAndoverPromptEnum.RPrompt;
            return;
        }
        if (this.message.indexOf("P>") != -1) {
            this.domain = 0;
            this.prompt = BAndoverPromptEnum.PPrompt;
            return;
        }
        if (this.message.endsWith("?")) {
            this.prompt = BAndoverPromptEnum.QueryMode;
            return;
        }
        AwkCompiler awkCompiler = new AwkCompiler();
        try {
            AwkPattern awkPattern = (AwkPattern)awkCompiler.compile("R-[0-9]{1,2}>");
        }
        catch (MalformedPatternException malformedPatternException) {
            this.prompt = BAndoverPromptEnum.UnknownPrompt;
            return;
        }
        int n = this.message.lastIndexOf("\n") + 1;
        try {
            if (this.message.charAt(n) == '\n') {
                ++n;
            }
            if (this.message.charAt(n) == 'R') {
                if (this.message.charAt(n + 1) == '>') {
                    this.domain = 0;
                } else {
                    String string = this.message.substring(n + 2, this.message.indexOf(">"));
                    this.domain = Integer.parseInt(string, 10);
                }
                this.prompt = BAndoverPromptEnum.RPrompt;
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("WARNING: unknown message:" + ByteArrayUtil.toHexString((byte[])this.message.getBytes()));
        }
        this.prompt = BAndoverPromptEnum.UnknownPrompt;
    }

    public boolean isError() {
        if (this.message.length() == 0) {
            return true;
        }
        String string = new String(this.message);
        int n = string.indexOf("\u0007");
        if (n != -1) {
            String string2;
            if (string.indexOf("P>") != -1) {
                return false;
            }
            this.errorMsg = string.substring(0, n);
            int n2 = this.errorMsg.indexOf("?");
            int n3 = this.errorMsg.indexOf("?", n2 + 1);
            try {
                string2 = this.errorMsg.substring(n2 + 1, n3).trim();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.exceptionCode = 24;
                return true;
            }
            this.exceptionCode = string2.equalsIgnoreCase("Access Denied") ? 2 : (string2.equalsIgnoreCase("Ambiguous Keyword") ? 3 : (string2.equalsIgnoreCase("Bad Number") ? 4 : (string2.equalsIgnoreCase("Bad Reload Block") ? 5 : (string2.equalsIgnoreCase("Binary Operator Expected") ? 6 : (string2.equalsIgnoreCase("Duplicate Symbol Assignment") ? 7 : (string2.equalsIgnoreCase("Entry Out of Range") ? 8 : (string2.equalsIgnoreCase("Expression too Complex") ? 9 : (string2.equalsIgnoreCase("Invalid Drum Number") ? 10 : (string2.equalsIgnoreCase("Invalid Keyword") ? 11 : (string2.equalsIgnoreCase("Invalid Line Number") ? 12 : (string2.equalsIgnoreCase("Invalid Symbol") ? 13 : (string2.equalsIgnoreCase("Invalid Variable") ? 14 : (string2.equalsIgnoreCase("Line Lost") ? 15 : (string2.equalsIgnoreCase("Program Area Full") ? 16 : (string2.equalsIgnoreCase("Required Entry Missing") ? 17 : (string2.equalsIgnoreCase("Syntax Error") ? 18 : (string2.equalsIgnoreCase("Variable Out of Range") ? 19 : (string2.equalsIgnoreCase("Variable or Unary Operator Expected") ? 20 : (string2.equalsIgnoreCase("System Error") ? 21 : (string2.equalsIgnoreCase("THERE IS NO LCU ATTACHED") ? 22 : (string2.startsWith("Non-existent L") ? 22 : 24)))))))))))))))))))));
            return true;
        }
        if (string.indexOf("P>") != -1) {
            this.errorMsg = "";
            return false;
        }
        if (string.indexOf("R>") != -1) {
            this.errorMsg = "";
            return false;
        }
        int n4 = string.lastIndexOf("\nR");
        if (n4 == -1) {
            this.errorMsg = "missing or invalid prompt";
            return true;
        }
        if (string.indexOf(">", n4) == -1) {
            this.errorMsg = "missing or invalid prompt";
            return true;
        }
        boolean bl = false;
        if (this.exceptionCode != 0) {
            bl = true;
        }
        return bl;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String string) {
        this.errorMsg = string;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int n) {
        this.exceptionCode = n;
    }

    public int getDomain() {
        return this.domain;
    }

    public void setDomain(int n) {
        this.domain = n;
    }

    public String getError() {
        String string = (String)errMap.get(this.exceptionCode);
        if (string != null) {
            return string;
        }
        return "Unknown AC256 error:" + this.exceptionCode;
    }

    public AndoverReceivedMessage() {
        this.byteData = null;
    }

    public AndoverReceivedMessage(byte[] byArray) {
        this.message = new String(byArray);
        this.byteData = byArray;
        this.checkPrompt();
        this.isError();
    }

    public AndoverReceivedMessage(String string) {
        this.message = string;
        this.byteData = string.getBytes();
        this.checkPrompt();
        this.isError();
    }

    public AndoverReceivedMessage(byte[] byArray, boolean bl) {
        this.message = new String(byArray);
        this.byteData = byArray;
    }

    static {
        errMap.put(24, (Object)lex.getText("errAc256.unknownError"));
        errMap.put(2, (Object)lex.getText("errAc256.accessDenied"));
        errMap.put(3, (Object)lex.getText("errAc256.ambiguousKeyword"));
        errMap.put(4, (Object)lex.getText("errAc256.badNumber"));
        errMap.put(5, (Object)lex.getText("errAc256.badReloadBlock"));
        errMap.put(6, (Object)lex.getText("errAc256.binaryOperatorExpected"));
        errMap.put(7, (Object)lex.getText("errAc256.duplicateSymbolAssignment"));
        errMap.put(8, (Object)lex.getText("errAc256.entryOutOfRange"));
        errMap.put(9, (Object)lex.getText("errAc256.expressionTooComplex"));
        errMap.put(10, (Object)lex.getText("errAc256.invalidDrumNumber"));
        errMap.put(11, (Object)lex.getText("errAc256.invalidKeyword"));
        errMap.put(12, (Object)lex.getText("errAc256.invalidLineNumber"));
        errMap.put(13, (Object)lex.getText("errAc256.invalidSymbol"));
        errMap.put(14, (Object)lex.getText("errAc256.invalidVariable"));
        errMap.put(15, (Object)lex.getText("errAc256.lineLost"));
        errMap.put(16, (Object)lex.getText("errAc256.programAreaFull"));
        errMap.put(17, (Object)lex.getText("errAc256.requiredEntryMissing"));
        errMap.put(18, (Object)lex.getText("errAc256.syntaxError"));
        errMap.put(19, (Object)lex.getText("errAc256.variableOutOfRange"));
        errMap.put(20, (Object)lex.getText("errAc256.variableOrUnaryOperatorExpected"));
        errMap.put(21, (Object)lex.getText("errAc256.systemError"));
        errMap.put(22, (Object)lex.getText("errAc256.missingLcu"));
    }
}

