/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGetFlagPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetIOPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetSystemTablePointsResponse;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverReceivedMessage;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;

public class AndoverMessage
extends Message
implements AndoverMessageConst {
    public int domain;
    public int messageType = 12;
    public String commandString;
    public boolean isGetUserFlagPoints;
    public boolean isGetSystemFlagPoints;

    public void write(OutputStream outputStream) {
        try {
            byte[] byArray = this.getByteArray();
            int n = 0;
            while (n < byArray.length) {
                outputStream.write(byArray[n]);
                Thread.sleep(20L);
                ++n;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public byte[] getByteArray() {
        String string = "\n";
        return string.getBytes();
    }

    public int getCurrentDomain() {
        return this.domain;
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        AndoverReceivedMessage andoverReceivedMessage = (AndoverReceivedMessage)receivedMessage;
        if (andoverReceivedMessage.getPrompt() == BAndoverPromptEnum.RPrompt) {
            if (this.messageType == 13) {
                return new AndoverStringResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 4) {
                return new AndoverDataResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 1) {
                return new AndoverStatusResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 5 || this.messageType == 8 || this.messageType == 6) {
                return new AndoverStringResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 9) {
                return new AndoverGetIOPointsResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 10) {
                return new AndoverGetSystemTablePointsResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 11) {
                return new AndoverGetFlagPointsResponse(andoverReceivedMessage.getMessage());
            }
            if (this.messageType == 12) {
                return new AndoverStringResponse(andoverReceivedMessage.getMessage());
            }
        }
        if (andoverReceivedMessage.getPrompt() == BAndoverPromptEnum.Reloading) {
            return new AndoverStringResponse(andoverReceivedMessage.getMessage());
        }
        if (andoverReceivedMessage.getPrompt() == BAndoverPromptEnum.QueryMode) {
            if (this.messageType == 1) {
                return new AndoverStatusResponse(andoverReceivedMessage.getMessage());
            }
            return new AndoverStringResponse(andoverReceivedMessage.getMessage());
        }
        if (andoverReceivedMessage.getPrompt() == BAndoverPromptEnum.PPrompt) {
            return new AndoverStringResponse(andoverReceivedMessage.getMessage());
        }
        return andoverReceivedMessage;
    }

    public void dataToString(StringBuffer stringBuffer) {
    }
}

