/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.comm.AndoverCommTransmitter;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverRestoreControllerJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Action abortReload = BAndoverRestoreControllerJob.newAction((int)16, null);
    public static final Topic jobComplete = BAndoverRestoreControllerJob.newTopic((int)0, null);
    public static final Type TYPE;
    private static final int RELOAD_RUN = 3;
    private static final int RELOAD_PAUSE = 4;
    private static final int RELOAD_FAILED = 5;
    private static final int RELOAD_ABORT = 7;
    private BAndoverDevice device;
    private BAndoverNetwork network;
    private boolean stationPingState;
    private boolean stationPollState;
    AndoverCommTransmitter commTransmitter;
    private BOrd fileOrd;
    private String fileName;
    private int domain;
    private boolean clearLcu;
    private int restoreState;
    private Clock.Ticket pauseTicket;
    ByteArrayOutputStream sb;
    static /* synthetic */ Class class$com$tridium$andoverAC256$job$BAndoverRestoreControllerJob;

    public void abortReload() {
        this.invoke(abortReload, null, null);
    }

    public void fireJobComplete(BValue bValue) {
        this.fire(jobComplete, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void run() {
        try {
            String string;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            boolean bl = true;
            int n = 1;
            this.network.getMonitor().setPingEnabled(false);
            this.network.getPollScheduler().setPollEnabled(false);
            this.log().message("Restore -> Start dedicated process...");
            BIFile bIFile = (BIFile)this.fileOrd.get();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
            this.log().message("Consistancy checking " + this.fileName + "...");
            while (bl && (string = bufferedReader.readLine()) != null) {
                bl = this.checkDumpIntegrity(string);
                if (!bl) {
                    this.failed(new Throwable("ERROR: file " + this.fileName + " has a checksum error at line " + n + ", aborting"));
                    return;
                }
                ++n;
            }
            bufferedReader.close();
            int n2 = n;
            int n3 = this.setDomain(this.domain);
            if (n3 != this.domain) {
                this.cleanUp();
                this.failed(new Throwable("ERROR: LCU NOT FOUND, ABORTING..."));
                return;
            }
            this.log().message("Successfully set domain to " + this.domain);
            if (this.clearLcu && !this.clearMemory()) {
                this.log().message("WARNING: clear memory may not have succeeded, please verify LCU contents after reload");
            }
            this.setDomain(0);
            this.sendEsc();
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                this.failed(exception);
                this.cleanUp();
                return;
            }
            try {
                this.sendDC1(2);
            }
            catch (Exception exception) {
                this.failed(exception);
                this.cleanUp();
                return;
            }
            try {
                Thread.sleep(640L);
            }
            catch (Exception exception) {
                this.failed(exception);
                this.cleanUp();
                return;
            }
            this.sendCR();
            this.sendCR();
            try {
                Thread.sleep(680L);
            }
            catch (Exception exception) {
                this.failed(exception);
                this.cleanUp();
                return;
            }
            this.sendEsc();
            this.sendEsc();
            try {
                Thread.sleep(680L);
            }
            catch (Exception exception) {
                this.failed(exception);
                this.cleanUp();
                return;
            }
            n = 0;
            InputStream inputStream = bIFile.getInputStream();
            this.device.setDriverState(4);
            this.restoreState = 4;
            this.device.andoverNetwork().getUnsolicitedReceiveHandler().setJob(this);
            this.log().message("Sending RELOAD command...");
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("RELOAD\r", 13);
            this.device.andoverNetwork().getComm().transmitNoResponse((Message)andoverGenericRequest);
            if (this.domain == 0) {
                this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getDom0ReloadInterCharacterDelay().getMillis());
            } else {
                this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getLcuReloadInterCharacterDelay().getMillis());
            }
            boolean bl2 = false;
            int n4 = -1;
            int n5 = -1;
            block19: while (!bl2) {
                if (this.getJobState() == BJobState.canceling) {
                    this.restoreState = 7;
                }
                switch (this.restoreState) {
                    case 3: {
                        n4 = inputStream.read();
                        if (n4 == -1) {
                            bl2 = true;
                            inputStream.close();
                            break;
                        }
                        n5 = n4;
                        if (n4 == 10) {
                            String string2 = new String(this.sb.toByteArray());
                            string2 = string2.replace('%', ' ');
                            this.log().message("sent line " + n + " of " + n2 + ':' + string2);
                            ++n;
                            this.sb.write(n4);
                            string2 = new String(this.sb.toByteArray());
                            this.device.andoverNetwork().fireTerminalUpdated((BValue)BString.make((String)string2));
                            this.sb.reset();
                        }
                        if (n4 == 13) {
                            this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(n4);
                        } else if (n4 == 10) {
                            Thread.sleep(this.device.andoverNetwork().getReloadInterLineDelay().getMillis());
                        } else {
                            this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(n4);
                            this.sb.write(n4);
                        }
                        this.progress(n * 100 / n2);
                        if (this.pauseTicket == null) continue block19;
                        this.pauseTicket.cancel();
                        this.pauseTicket = null;
                        break;
                    }
                    case 4: {
                        this.log().message("RELOAD_PAUSE at line " + n);
                        if (this.pauseTicket == null) {
                            this.pauseTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)abortReload, null);
                        }
                        Thread.sleep(1000L);
                        break;
                    }
                    case 7: {
                        inputStream.close();
                        this.cleanUp();
                        this.log().message("RELOAD ABORT at line " + n);
                        this.canceled();
                        return;
                    }
                    case 5: {
                        inputStream.close();
                        this.cleanUp();
                        this.failed(new Throwable("reload failed at line " + n));
                        return;
                    }
                    default: {
                        inputStream.close();
                        this.cleanUp();
                        this.failed(new Throwable("undefined job state, line " + n));
                        return;
                    }
                }
            }
            bufferedReader.close();
            if (n5 == 38) {
                this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(13);
            }
            Thread.sleep(1000L);
            if (this.domain == 0) {
                this.device.setReloadRequired(false);
            }
            this.cleanUp();
            this.log().message("Setting to domain 0...");
            this.setDomain(0);
            this.success();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.failed(exception);
            this.cleanUp();
        }
    }

    private final void cleanUp() {
        this.log().message("cleanup");
        if (this.pauseTicket != null) {
            this.pauseTicket.cancel();
            this.pauseTicket = null;
        }
        this.device.setDriverState(1);
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("&\u001b", 12);
        this.device.andoverNetwork().getComm().transmitNoResponse((Message)andoverGenericRequest);
        this.setDomain(0);
        this.network.getMonitor().setPingEnabled(this.stationPingState);
        this.network.getPollScheduler().setPollEnabled(this.stationPollState);
        this.device.andoverNetwork().getUnsolicitedReceiveHandler().setJob(null);
        this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getInterCharacterDelay().getMillis());
    }

    private final int setDomain(int n) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DOM " + n + '\n', 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
            if (andoverStringResponse == null) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            if (andoverStringResponse.isError()) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            this.device.setCurrentDomain(andoverStringResponse.getDomain());
            this.log().message("Set to domain " + n);
            return andoverStringResponse.getDomain();
        }
        catch (Exception exception) {
            this.log().message("ERROR setting domain to " + n + ": " + exception);
            return -1;
        }
    }

    private final void sendEsc() {
        byte[] byArray = new byte[]{27};
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest(new String(byArray), 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)1), 0);
    }

    private final void sendCR() {
        byte[] byArray = new byte[]{13};
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest(new String(byArray), 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)1), 0);
    }

    private final void sendDC1(int n) throws Exception {
        byte[] byArray = n == 2 ? new byte[]{17, 17} : new byte[]{17};
        this.device.andoverNetwork().getComm().getCommTransmitter().writeBytes(byArray);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean clearMemory() {
        this.device.setDriverState(2);
        var1_1 = new AndoverGenericRequest("CLEAR MEMORY ALL\n", 12);
        var2_3 = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)var1_1, BRelTime.makeSeconds((int)10), 0);
        this.device.setDriverState(1);
        if (var2_3 == null) {
            this.log().message("ERROR: could not clear LCU memory ");
            return false;
        }
        if (!var2_3.getMessage().endsWith("?")) ** GOTO lbl27
        var1_1 = new AndoverGenericRequest("Y", 12);
        var2_3 = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)var1_1, BRelTime.makeSeconds((int)10), 0);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException var3_4) {
            return false;
        }
        var1_1 = new AndoverGenericRequest("\r", 12);
        var2_3 = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)var1_1, BRelTime.makeSeconds((int)10), 0);
        if (var2_3 != null) {
            if (!var2_3.isError() || var2_3.exceptionCode == 22) {
                this.log().message("SUCCESFULLY CLEARED LCU MEMORY");
            } else {
                this.log().message(var2_3.getMessage());
                return false;
            }
        }
        try {
            block9: {
                break block9;
lbl27:
                // 1 sources

                this.log().message("ERROR: did not receive \"Are You Sure?\" querry in response to CLEAR MEMORY");
                return false;
            }
            Thread.sleep(10000L);
            return true;
        }
        catch (Exception var1_2) {
            this.log().message("ERROR clearing LCU memory:" + var1_2);
            return false;
        }
    }

    private final boolean checkDumpIntegrity(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("$");
        if (n3 == -1) {
            return string.startsWith("&");
        }
        char[] cArray = new char[2];
        try {
            StringReader stringReader = new StringReader(string.substring(1, n3));
            string2 = string.substring(n3 + 1, n3 + 3);
            while (stringReader.read(cArray, 0, 2) != -1) {
                n = n + Integer.parseInt(new String(cArray), 16) & 0xFF;
            }
        }
        catch (IOException iOException) {
            this.log().message("ERROR, " + iOException);
            return false;
        }
        n2 = Integer.parseInt(string2, 16);
        if (n2 != n) {
            this.log().message("bad checksum:" + string);
            return false;
        }
        return true;
    }

    public void setRestoreState(int n) {
        this.restoreState = n;
    }

    public void doAbortReload() {
        this.restoreState = 7;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.restoreState = 4;
        this.pauseTicket = null;
        this.sb = new ByteArrayOutputStream();
    }

    public BAndoverRestoreControllerJob() {
        this.this();
    }

    public BAndoverRestoreControllerJob(BAndoverDevice bAndoverDevice, BAndoverRestoreConfig bAndoverRestoreConfig) {
        this.this();
        this.device = bAndoverDevice;
        this.network = (BAndoverNetwork)bAndoverDevice.getNetwork();
        this.stationPingState = this.network.getMonitor().getPingEnabled();
        this.stationPollState = this.network.getPollScheduler().getPollEnabled();
        this.fileOrd = bAndoverRestoreConfig.getOrd();
        this.domain = bAndoverRestoreConfig.getDomain();
        this.fileName = bAndoverRestoreConfig.getFileName();
        this.clearLcu = bAndoverRestoreConfig.getClearMemory();
        if (this.domain == 0) {
            this.clearLcu = false;
        }
        this.commTransmitter = (AndoverCommTransmitter)bAndoverDevice.andoverNetwork().getComm().getCommTransmitter();
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$job$BAndoverRestoreControllerJob;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$job$BAndoverRestoreControllerJob = BAndoverRestoreControllerJob.class("[Lcom.tridium.andoverAC256.job.BAndoverRestoreControllerJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

