/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverPointDiscoveryConfig;
import com.tridium.andoverAC256.job.BAndoverDiscoveryPoint;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverGetFlagPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetIOPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetSystemTablePointsResponse;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverDiscoverPointsJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Type TYPE;
    private BAndoverDevice device;
    private BAndoverPointDiscoveryConfig config;
    private int domain;
    private int numberIOUs;
    private int numberLCUs;
    static /* synthetic */ Class class$com$tridium$andoverAC256$job$BAndoverDiscoverPointsJob;

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void run() {
        try {
            int n;
            int n2;
            int n3;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            if (!this.config.learnAnything()) {
                this.log().message("not configured to learn anything");
                this.progress(100);
                this.success();
                return;
            }
            int n4 = this.config.progressWeight();
            int n5 = 0;
            this.domain = 0;
            if (this.device.getSupportsDomainKeyword()) {
                this.domain = this.setDomain(0);
            }
            if (this.domain != 0) {
                return;
            }
            this.learnSize();
            if (this.config.getSvPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SV Points, domain 0");
                this.getSystemTablePoints("SV");
                this.progress(n5++ / n4 * 100);
            }
            if (this.config.getSaPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SA Points, domain 0");
                this.getSystemTablePoints("SA");
                this.progress(n5++ / n4 * 100);
            }
            if (this.config.getSxPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SX Points, domain 0");
                this.getSystemTablePoints("SX");
                this.progress(n5++ / n4 * 100);
            }
            if (this.config.learnFlags()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SF Points, domain 0");
                this.getFlagPoints(this.config.getUserFlagPoints(), this.config.getSystemFlagPoints());
                this.progress(n5++ / n4 * 100);
            }
            if (this.config.getIou().learnAnything()) {
                n3 = this.config.getIou().getStartAddress();
                n2 = this.config.getIou().getStopAddress();
                n = n3;
                while (n < n2 + 1) {
                    if (this.config.getIou().getIouPoints()) {
                        if (!this.isAlive()) {
                            return;
                        }
                        this.log().message("Learning IOU " + n + " Points, domain 0");
                        this.getIoTablePoints(Integer.toString(n));
                        this.progress(n5++ / n4 * 100);
                    }
                    ++n;
                }
            }
            if (this.config.getLcu().learnAnything()) {
                n3 = this.config.getLcu().getStartAddress();
                n2 = this.config.getLcu().getStopAddress();
                n = n3;
                while (n < n2 + 1) {
                    this.domain = this.setDomain(n);
                    if (this.domain != n) {
                        this.log().message("Could not set to domain " + n + ", no points learned");
                        this.progress(n5++ / n4 * 100);
                    } else {
                        if (this.config.getLcu().getSvPoints()) {
                            if (!this.isAlive()) {
                                return;
                            }
                            this.log().message("Learning SV Points, domain " + n);
                            this.getSystemTablePoints("SV");
                            this.progress(n5++ / n4 * 100);
                        }
                        if (this.config.getLcu().getFlagPoints()) {
                            if (!this.isAlive()) {
                                return;
                            }
                            this.log().message("Learning SF Points, domain " + n);
                            this.getFlagPoints(true, false);
                            this.progress(n5++ / n4 * 100);
                        }
                        if (this.config.getLcu().getIoPoints()) {
                            if (!this.isAlive()) {
                                return;
                            }
                            this.log().message("Learning IO Points, domain " + n);
                            this.getIoTablePoints("1");
                            this.progress(n5++ / n4 * 100);
                        }
                    }
                    ++n;
                }
                this.domain = this.setDomain(0);
            }
            this.progress(100);
            this.success();
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    private final void getSystemTablePoints(String string) {
        this.log().message("Learning " + string + ", domain " + this.domain + "...");
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P " + string + '\n', 10);
        AndoverGetSystemTablePointsResponse andoverGetSystemTablePointsResponse = (AndoverGetSystemTablePointsResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
        if (andoverGetSystemTablePointsResponse != null && !andoverGetSystemTablePointsResponse.isError()) {
            andoverGetSystemTablePointsResponse.decodeMessage();
            this.log().message("found " + andoverGetSystemTablePointsResponse.getNumberPointsReturned() + " points in " + string);
            int n = 0;
            while (n < andoverGetSystemTablePointsResponse.getNumberPointsReturned()) {
                BAndoverDiscoveryPoint bAndoverDiscoveryPoint = new BAndoverDiscoveryPoint(andoverGetSystemTablePointsResponse.getName(n), andoverGetSystemTablePointsResponse.getValue(n), string + " DOM " + Integer.toString(this.domain));
                this.add(null, (BValue)bAndoverDiscoveryPoint);
                ++n;
            }
        }
    }

    private final void getIoTablePoints(String string) {
        String string2 = "";
        string2 = this.domain == 0 ? "IOU " + string : "LCU IO";
        this.log().message("Learning " + string2 + ", domain " + this.domain + "...");
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P " + string + '\n', 9);
        AndoverGetIOPointsResponse andoverGetIOPointsResponse = (AndoverGetIOPointsResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
        if (andoverGetIOPointsResponse != null && !andoverGetIOPointsResponse.isError()) {
            andoverGetIOPointsResponse.decodeMessage();
            this.log().message("found " + andoverGetIOPointsResponse.getNumberPointsReturned() + " points in " + string);
            int n = 0;
            while (n < andoverGetIOPointsResponse.getNumberPointsReturned()) {
                BAndoverDiscoveryPoint bAndoverDiscoveryPoint = new BAndoverDiscoveryPoint(andoverGetIOPointsResponse.getName(n), andoverGetIOPointsResponse.getValue(n), string2 + " DOM " + Integer.toString(this.domain), andoverGetIOPointsResponse.getPointNotes(n));
                this.add(null, (BValue)bAndoverDiscoveryPoint);
                ++n;
            }
        }
    }

    private final void getFlagPoints(boolean bl, boolean bl2) {
        if (bl & bl2) {
            this.log().message("Learning System AND User Defined Flags, domain " + this.domain + "...");
        } else if (bl) {
            this.log().message("Learning User Defined Flags, domain " + this.domain + "...");
        } else if (bl2) {
            this.log().message("Learning System Flags, domain " + this.domain + "...");
        } else {
            return;
        }
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P SF\n", 11);
        AndoverGetFlagPointsResponse andoverGetFlagPointsResponse = (AndoverGetFlagPointsResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
        if (andoverGetFlagPointsResponse != null && !andoverGetFlagPointsResponse.isError()) {
            andoverGetFlagPointsResponse.decodeMessage(bl, bl2);
            this.log().message("found " + andoverGetFlagPointsResponse.getNumberPointsReturned() + " points in SF table");
            int n = 0;
            while (n < andoverGetFlagPointsResponse.getNumberPointsReturned()) {
                BAndoverDiscoveryPoint bAndoverDiscoveryPoint = new BAndoverDiscoveryPoint(andoverGetFlagPointsResponse.getName(n), andoverGetFlagPointsResponse.getValue(n), "SF DOM " + Integer.toString(this.domain));
                this.add(null, (BValue)bAndoverDiscoveryPoint);
                ++n;
            }
        }
    }

    private final int setDomain(int n) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DOM " + n + '\n', 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
            if (andoverStringResponse == null) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            if (andoverStringResponse.isError()) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            this.device.setCurrentDomain(andoverStringResponse.getDomain());
            return andoverStringResponse.getDomain();
        }
        catch (Exception exception) {
            this.log().message("ERROR setting domain to " + n + ": " + exception);
            return -1;
        }
    }

    private final void learnSize() {
        this.log().message("Learning about number of IOUs and LCUs configured in Andover panel");
        AndoverStatusResponse andoverStatusResponse = null;
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P STATUS\n", 1);
        andoverStatusResponse = (AndoverStatusResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
        if (andoverStatusResponse == null || andoverStatusResponse.exceptionCode != 0) {
            this.log().failed("Job Failed, could not get STATUS message from Andover panel");
            this.doCancel(null);
            this.complete(BJobState.failed);
            return;
        }
        this.numberIOUs = andoverStatusResponse.getNumberIOUs();
        this.numberLCUs = andoverStatusResponse.getNumberLCUs();
        this.config.getIou().setStopAddress(this.numberIOUs);
        this.config.getLcu().setStopAddress(this.numberLCUs);
        if (this.numberIOUs == 0) {
            this.config.setFlags((Slot)BAndoverPointDiscoveryConfig.iou, this.config.getFlags((Slot)BAndoverPointDiscoveryConfig.iou) | 1);
        }
        if (this.numberLCUs == 0) {
            this.config.setFlags((Slot)BAndoverPointDiscoveryConfig.lcu, this.config.getFlags((Slot)BAndoverPointDiscoveryConfig.lcu) | 1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.domain = 0;
    }

    public BAndoverDiscoverPointsJob() {
        this.this();
    }

    public BAndoverDiscoverPointsJob(BAndoverDevice bAndoverDevice, BAndoverPointDiscoveryConfig bAndoverPointDiscoveryConfig) {
        this.this();
        this.device = bAndoverDevice;
        this.config = bAndoverPointDiscoveryConfig;
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$job$BAndoverDiscoverPointsJob;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$job$BAndoverDiscoverPointsJob = BAndoverDiscoverPointsJob.class("[Lcom.tridium.andoverAC256.job.BAndoverDiscoverPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

