/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverBackupControllerJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Type TYPE;
    private BAndoverDevice device;
    private String fileName;
    private int domain;
    static /* synthetic */ Class class$com$tridium$andoverAC256$job$BAndoverBackupControllerJob;

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void run() {
        try {
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            boolean bl = true;
            this.log().message("Dump -> Start dedicated process...");
            int n = this.setDomain(this.domain);
            if (n != this.domain) {
                this.setDomain(0);
                this.failed(new Throwable("ERROR: LCU NOT FOUND, ABORTING..."));
                return;
            }
            BFileSystem bFileSystem = BFileSystem.INSTANCE;
            BIFile bIFile = bFileSystem.makeFile(new FilePath("^backups/" + this.fileName), null);
            OutputStream outputStream = bIFile.getOutputStream();
            this.log().message("Dump -> Sending dump command...");
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DUMP ALL\n", 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)this.getDumpTimeout()), 0);
            if (andoverStringResponse == null) {
                bl = false;
                this.setDomain(0);
                this.failed(new Throwable("ERROR: -> no response to dump command"));
                return;
            }
            String string = null;
            try {
                string = andoverStringResponse.message.substring(andoverStringResponse.message.indexOf("@"), andoverStringResponse.message.indexOf("&") + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                bl = false;
                this.setDomain(0);
                this.log().message("ERROR: -> dump response is missing start/stop delimiters");
                return;
            }
            this.log().message("Dump -> Checking integrity of response");
            bl = this.checkDumpIntegrity(string);
            if (bl) {
                this.log().message("Dump -> Integrity checking OK, saving results...");
                outputStream.write(string.getBytes());
                outputStream.write(13);
                outputStream.write(10);
            }
            outputStream.close();
            this.device.getBackupFileList();
            this.setDomain(0);
            this.success();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.failed(exception);
        }
    }

    private final int setDomain(int n) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DOM " + n + '\n', 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
            if (andoverStringResponse == null) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            if (andoverStringResponse.isError()) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            this.device.setCurrentDomain(andoverStringResponse.getDomain());
            return andoverStringResponse.getDomain();
        }
        catch (Exception exception) {
            this.log().message("ERROR setting domain to " + n + ": " + exception);
            return -1;
        }
    }

    private final int getDumpTimeout() {
        int n;
        switch (this.device.andoverNetwork().getSerialPortConfig().getBaudRate().getOrdinal()) {
            case 110: {
                n = 30000;
                break;
            }
            case 300: {
                n = 11000;
                break;
            }
            case 600: {
                n = 5200;
                break;
            }
            case 1200: {
                n = 2600;
                break;
            }
            case 2400: {
                n = 1300;
                break;
            }
            case 4800: {
                n = 650;
                break;
            }
            case 9600: {
                n = 360;
                break;
            }
            case 19200: {
                n = 180;
                break;
            }
            default: {
                n = 360;
            }
        }
        return n;
    }

    private final boolean checkDumpIntegrity(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char[] cArray = new char[2];
        while (stringTokenizer.hasMoreTokens()) {
            ++n4;
            n2 = 0;
            n = 0;
            n3 = 0;
            String string2 = stringTokenizer.nextToken();
            n3 = string2.indexOf("$");
            if (n3 == -1) continue;
            StringReader stringReader = new StringReader(string2.substring(1, n3));
            String string3 = string2.substring(n3 + 1, n3 + 3);
            try {
                while (stringReader.read(cArray, 0, 2) != -1) {
                    n = n + Integer.parseInt(new String(cArray), 16) & 0xFF;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            n2 = Integer.parseInt(string3, 16);
            if (n2 == n) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAndoverBackupControllerJob() {
    }

    public BAndoverBackupControllerJob(BAndoverDevice bAndoverDevice, BAndoverBackupConfig bAndoverBackupConfig) {
        this.device = bAndoverDevice;
        this.fileName = bAndoverBackupConfig.getFileName();
        this.domain = bAndoverBackupConfig.getDomain();
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$job$BAndoverBackupControllerJob;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$job$BAndoverBackupControllerJob = BAndoverBackupControllerJob.class("[Lcom.tridium.andoverAC256.job.BAndoverBackupControllerJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

