/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256;

import com.tridium.andoverAC256.BAndoverBackupFolder;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.datatypes.BAndoverBackupRecord;
import com.tridium.andoverAC256.datatypes.BAndoverPointDiscoveryConfig;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.datatypes.BPrintStatusReadings;
import com.tridium.andoverAC256.datatypes.BProgramReloadSettings;
import com.tridium.andoverAC256.enums.BAndoverDeviceTypeEnum;
import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.job.BAndoverBackupControllerJob;
import com.tridium.andoverAC256.job.BAndoverDiscoverPointsJob;
import com.tridium.andoverAC256.job.BAndoverRestoreControllerJob;
import com.tridium.andoverAC256.job.BAndoverSetOptionsJob;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.andoverAC256.point.BAndoverPointDeviceExt;
import com.tridium.basicdriver.BBasicDevice;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverDevice
extends BBasicDevice
implements AndoverMessageConst {
    public static final Property deviceType = BAndoverDevice.newProperty((int)4, (BValue)BAndoverDeviceTypeEnum.ac256, null);
    public static final Property devicePassword = BAndoverDevice.newProperty((int)0, (String)"&ne222", null);
    public static final Property builtInUserPassword = BAndoverDevice.newProperty((int)0, (String)"santa", null);
    public static final Property configuredUserPassword = BAndoverDevice.newProperty((int)4, (String)"none", null);
    public static final Property commInitialized = BAndoverDevice.newProperty((int)3, (boolean)false, null);
    public static final Property promptStatus = BAndoverDevice.newProperty((int)67, (BValue)BAndoverPromptEnum.UnknownPrompt, null);
    public static final Property currentDomain = BAndoverDevice.newProperty((int)67, (int)0, null);
    public static final Property printStatusReadings = BAndoverDevice.newProperty((int)67, (BValue)new BPrintStatusReadings(), null);
    public static final Property jaceDateTime = BAndoverDevice.newProperty((int)67, (String)"-", null);
    public static final Property automaticallySetTime = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    public static final Property syncTimeFrequency = BAndoverDevice.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property automaticallyReloadProgram = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    public static final Property programReloadSettings = BAndoverDevice.newProperty((int)0, (BValue)new BProgramReloadSettings(), null);
    public static final Property automaticallySetOptions = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    public static final Property optionCommandSettings = BAndoverDevice.newProperty((int)0, (BValue)new BAndoverSetOptionsConfig(), null);
    public static final Property monitorPoint = BAndoverDevice.newProperty((int)0, (String)"F1", null);
    public static final Property useSPort = BAndoverDevice.newProperty((int)0, (boolean)false, null);
    public static final Property points = BAndoverDevice.newProperty((int)0, (BValue)new BAndoverPointDeviceExt(), null);
    public static final Property backupList = BAndoverDevice.newProperty((int)4, (BValue)new BAndoverBackupFolder(), null);
    public static final Property supportsDomainKeyword = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    public static final Action submitDiscoverPointsJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverPointDiscoveryConfig(), null);
    public static final Action submitBackupControllerJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverBackupConfig(), null);
    public static final Action submitRestoreControllerJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverRestoreConfig(), null);
    public static final Action deleteBackupFile = BAndoverDevice.newAction((int)132, (BValue)BOrd.make((String)""), null);
    public static final Action submitSetOptionsJob = BAndoverDevice.newAction((int)132, (BValue)new BAndoverSetOptionsConfig(), null);
    public static final Action statusCommand = BAndoverDevice.newAction((int)0, null);
    public static final Action syncTime = BAndoverDevice.newAction((int)0, null);
    public static final Topic logonSuccessful = BAndoverDevice.newTopic((int)0, null);
    public static final Type TYPE;
    boolean isFirstPing;
    int lastTimeSyncDay;
    int lastStatusUpdateHour;
    Object monitorObject;
    private boolean reloadRequired;
    private Clock.Ticket timeSyncTicket;
    static /* synthetic */ Class class$com$tridium$andoverAC256$BAndoverDevice;
    static /* synthetic */ Class class$com$tridium$andoverAC256$datatypes$BAndoverBackupRecord;

    public BAndoverDeviceTypeEnum getDeviceType() {
        return (BAndoverDeviceTypeEnum)this.get(deviceType);
    }

    public void setDeviceType(BAndoverDeviceTypeEnum bAndoverDeviceTypeEnum) {
        this.set(deviceType, (BValue)bAndoverDeviceTypeEnum, null);
    }

    public String getDevicePassword() {
        return this.getString(devicePassword);
    }

    public void setDevicePassword(String string) {
        this.setString(devicePassword, string, null);
    }

    public String getBuiltInUserPassword() {
        return this.getString(builtInUserPassword);
    }

    public void setBuiltInUserPassword(String string) {
        this.setString(builtInUserPassword, string, null);
    }

    public String getConfiguredUserPassword() {
        return this.getString(configuredUserPassword);
    }

    public void setConfiguredUserPassword(String string) {
        this.setString(configuredUserPassword, string, null);
    }

    public boolean getCommInitialized() {
        return this.getBoolean(commInitialized);
    }

    public void setCommInitialized(boolean bl) {
        this.setBoolean(commInitialized, bl, null);
    }

    public BEnum getPromptStatus() {
        return (BEnum)this.get(promptStatus);
    }

    public void setPromptStatus(BEnum bEnum) {
        this.set(promptStatus, (BValue)bEnum, null);
    }

    public int getCurrentDomain() {
        return this.getInt(currentDomain);
    }

    public void setCurrentDomain(int n) {
        this.setInt(currentDomain, n, null);
    }

    public BPrintStatusReadings getPrintStatusReadings() {
        return (BPrintStatusReadings)this.get(printStatusReadings);
    }

    public void setPrintStatusReadings(BPrintStatusReadings bPrintStatusReadings) {
        this.set(printStatusReadings, (BValue)bPrintStatusReadings, null);
    }

    public String getJaceDateTime() {
        return this.getString(jaceDateTime);
    }

    public void setJaceDateTime(String string) {
        this.setString(jaceDateTime, string, null);
    }

    public boolean getAutomaticallySetTime() {
        return this.getBoolean(automaticallySetTime);
    }

    public void setAutomaticallySetTime(boolean bl) {
        this.setBoolean(automaticallySetTime, bl, null);
    }

    public BRelTime getSyncTimeFrequency() {
        return (BRelTime)this.get(syncTimeFrequency);
    }

    public void setSyncTimeFrequency(BRelTime bRelTime) {
        this.set(syncTimeFrequency, (BValue)bRelTime, null);
    }

    public boolean getAutomaticallyReloadProgram() {
        return this.getBoolean(automaticallyReloadProgram);
    }

    public void setAutomaticallyReloadProgram(boolean bl) {
        this.setBoolean(automaticallyReloadProgram, bl, null);
    }

    public BProgramReloadSettings getProgramReloadSettings() {
        return (BProgramReloadSettings)this.get(programReloadSettings);
    }

    public void setProgramReloadSettings(BProgramReloadSettings bProgramReloadSettings) {
        this.set(programReloadSettings, (BValue)bProgramReloadSettings, null);
    }

    public boolean getAutomaticallySetOptions() {
        return this.getBoolean(automaticallySetOptions);
    }

    public void setAutomaticallySetOptions(boolean bl) {
        this.setBoolean(automaticallySetOptions, bl, null);
    }

    public BAndoverSetOptionsConfig getOptionCommandSettings() {
        return (BAndoverSetOptionsConfig)this.get(optionCommandSettings);
    }

    public void setOptionCommandSettings(BAndoverSetOptionsConfig bAndoverSetOptionsConfig) {
        this.set(optionCommandSettings, (BValue)bAndoverSetOptionsConfig, null);
    }

    public String getMonitorPoint() {
        return this.getString(monitorPoint);
    }

    public void setMonitorPoint(String string) {
        this.setString(monitorPoint, string, null);
    }

    public boolean getUseSPort() {
        return this.getBoolean(useSPort);
    }

    public void setUseSPort(boolean bl) {
        this.setBoolean(useSPort, bl, null);
    }

    public BAndoverPointDeviceExt getPoints() {
        return (BAndoverPointDeviceExt)this.get(points);
    }

    public void setPoints(BAndoverPointDeviceExt bAndoverPointDeviceExt) {
        this.set(points, (BValue)bAndoverPointDeviceExt, null);
    }

    public BAndoverBackupFolder getBackupList() {
        return (BAndoverBackupFolder)this.get(backupList);
    }

    public void setBackupList(BAndoverBackupFolder bAndoverBackupFolder) {
        this.set(backupList, (BValue)bAndoverBackupFolder, null);
    }

    public boolean getSupportsDomainKeyword() {
        return this.getBoolean(supportsDomainKeyword);
    }

    public void setSupportsDomainKeyword(boolean bl) {
        this.setBoolean(supportsDomainKeyword, bl, null);
    }

    public BOrd submitDiscoverPointsJob(BAndoverPointDiscoveryConfig bAndoverPointDiscoveryConfig) {
        return (BOrd)this.invoke(submitDiscoverPointsJob, (BValue)bAndoverPointDiscoveryConfig, null);
    }

    public BOrd submitBackupControllerJob(BAndoverBackupConfig bAndoverBackupConfig) {
        return (BOrd)this.invoke(submitBackupControllerJob, (BValue)bAndoverBackupConfig, null);
    }

    public BOrd submitRestoreControllerJob(BAndoverRestoreConfig bAndoverRestoreConfig) {
        return (BOrd)this.invoke(submitRestoreControllerJob, (BValue)bAndoverRestoreConfig, null);
    }

    public void deleteBackupFile(BOrd bOrd) {
        this.invoke(deleteBackupFile, (BValue)bOrd, null);
    }

    public BOrd submitSetOptionsJob(BAndoverSetOptionsConfig bAndoverSetOptionsConfig) {
        return (BOrd)this.invoke(submitSetOptionsJob, (BValue)bAndoverSetOptionsConfig, null);
    }

    public void statusCommand() {
        this.invoke(statusCommand, null, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void fireLogonSuccessful(BValue bValue) {
        this.fire(logonSuccessful, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        if (!this.getSupportsDomainKeyword()) {
            this.setCurrentDomain(0);
        }
        super.started();
        this.getBackupFileList();
        if (this.getAutomaticallySetTime()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == syncTimeFrequency || property == automaticallySetTime) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAutomaticallySetTime()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
    }

    public Type getNetworkType() {
        return BAndoverNetwork.TYPE;
    }

    public BAndoverNetwork andoverNetwork() {
        return (BAndoverNetwork)this.getNetwork();
    }

    public Log getAcLog() {
        return this.andoverNetwork().getAcLog();
    }

    public void getBackupFileList() {
        BDirectory bDirectory;
        BIFile[] bIFileArray;
        try {
            bIFileArray = (BIFile[])BOrd.make((String)"file:").get();
            bDirectory = bIFileArray.makeDir(new FilePath("^backups"), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.getBackupList().removeAll();
        bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            BAndoverBackupRecord bAndoverBackupRecord = new BAndoverBackupRecord();
            bAndoverBackupRecord.setTimestamp(bIFileArray[n].getLastModified());
            bAndoverBackupRecord.setPath(bIFileArray[n].getFileName());
            bAndoverBackupRecord.setOrd(bIFileArray[n].getOrdInSpace());
            this.getBackupList().add(null, (BValue)bAndoverBackupRecord, 3);
            ++n;
        }
        this.getBackupList().fireTableUpdated((BValue)BString.make((String)""));
    }

    public BOrd doSubmitDiscoverPointsJob(BAndoverPointDiscoveryConfig bAndoverPointDiscoveryConfig, Context context) {
        return new BAndoverDiscoverPointsJob(this, bAndoverPointDiscoveryConfig).submit(context);
    }

    public BOrd doSubmitBackupControllerJob(BAndoverBackupConfig bAndoverBackupConfig, Context context) {
        return new BAndoverBackupControllerJob(this, bAndoverBackupConfig).submit(context);
    }

    public BOrd doSubmitRestoreControllerJob(BAndoverRestoreConfig bAndoverRestoreConfig, Context context) {
        return new BAndoverRestoreControllerJob(this, bAndoverRestoreConfig).submit(context);
    }

    public void doDeleteBackupFile(BOrd bOrd) {
        BIFile bIFile = (BIFile)bOrd.get();
        try {
            bIFile.delete();
        }
        catch (Exception exception) {}
        this.getBackupFileList();
    }

    public BOrd doSubmitSetOptionsJob(BAndoverSetOptionsConfig bAndoverSetOptionsConfig, Context context) {
        return new BAndoverSetOptionsJob(this, bAndoverSetOptionsConfig).submit(context);
    }

    public void doStatusCommand() {
        if (this.getStatus().isDisabled()) {
            return;
        }
        this.andoverNetwork().postAsync(new Runnable(){

            public final void run() {
                AndoverStatusResponse andoverStatusResponse = null;
                AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P STATUS\n", 1);
                if (BAndoverDevice.this.getAcLog().isTraceOn()) {
                    BAndoverDevice.this.getAcLog().trace(andoverGenericRequest.toString());
                }
                if ((andoverStatusResponse = (AndoverStatusResponse)BAndoverDevice.this.andoverNetwork().sendSync(andoverGenericRequest, BAndoverDevice.this.getStatusTimeout(), 1)) == null) {
                    return;
                }
                if (BAndoverDevice.this.getAcLog().isTraceOn()) {
                    BAndoverDevice.this.getAcLog().trace(andoverStatusResponse.toString());
                }
                if (andoverStatusResponse.exceptionCode != 0) {
                    return;
                }
                BAndoverDevice.this.setStatusData(andoverStatusResponse);
                BAndoverDevice.this.lastStatusUpdateHour = BAbsTime.now().getHour();
                if (andoverStatusResponse.message.indexOf("Enter System Time") != -1) {
                    BAndoverDevice.this.sendSyncTime();
                }
                if (andoverStatusResponse.message.indexOf("Set System Options") != -1) {
                    BAndoverDevice.this.submitSetOptionsJob(BAndoverDevice.this.getOptionCommandSettings());
                }
            }
        });
    }

    private final BRelTime getStatusTimeout() {
        int n = 20;
        int n2 = this.andoverNetwork().getSerialPortConfig().getBaudRate().getOrdinal();
        switch (n2) {
            case 110: {
                n = 320;
                break;
            }
            case 300: {
                n = 160;
                break;
            }
            case 600: {
                n = 80;
                break;
            }
            case 1200: {
                n = 40;
                break;
            }
            case 2400: {
                n = 20;
                break;
            }
            case 4800: {
                n = 10;
                break;
            }
            case 9600: {
                n = 5;
                break;
            }
            case 19200: {
                n = 5;
                break;
            }
            default: {
                n = 20;
            }
        }
        return BRelTime.makeSeconds((int)n);
    }

    private final String getJaceDateTimeString() {
        BAbsTime bAbsTime = BAbsTime.now();
        int n = bAbsTime.getDay();
        int n2 = bAbsTime.getHour();
        int n3 = bAbsTime.getMinute();
        int n4 = bAbsTime.getSecond();
        String string = String.valueOf(bAbsTime.getYear());
        String string2 = bAbsTime.getMonth().getTag().toUpperCase().substring(0, 3);
        String string3 = String.valueOf(bAbsTime.getDay());
        String string4 = bAbsTime.getWeekday().getTag().toUpperCase().substring(0, 3);
        String string5 = String.valueOf(bAbsTime.getHour());
        String string6 = String.valueOf(bAbsTime.getMinute());
        String string7 = String.valueOf(bAbsTime.getSecond());
        if (n < 10) {
            string3 = " " + string3;
        }
        if (n2 < 10) {
            string5 = " " + string5;
        }
        if (n3 < 10) {
            string6 = " " + string6;
        }
        if (n4 < 10) {
            string7 = " " + string7;
        }
        return string + ' ' + string2 + ' ' + string3 + ' ' + string4 + "  " + string5 + ' ' + string6 + ' ' + string7;
    }

    public void doSyncTime() {
        this.andoverNetwork().postAsync(new Runnable(){

            public final void run() {
                BAndoverDevice.this.sendSyncTime();
            }
        });
    }

    private final boolean sendSyncTime() {
        String string = this.getJaceDateTimeString();
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("set time " + string + '\n', 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest);
        if (andoverStringResponse == null) {
            return false;
        }
        this.lastTimeSyncDay = BAbsTime.now().getDayOfYear();
        return true;
    }

    public void doPing() {
        this.getAcLog().trace("ping at " + BAbsTime.now());
        if (!this.andoverNetwork().getSerialPortConfig().getStatus().equals((Object)BStatus.ok)) {
            this.pingFail("can't ping because serial port not initialized");
            return;
        }
        if (this.reloadRequired) {
            this.initCommunications();
            this.pingFail("waiting for panel to re-load");
            return;
        }
        AndoverDataResponse andoverDataResponse = null;
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("P " + this.getMonitorPoint() + '\n', 4);
        andoverDataResponse = (AndoverDataResponse)this.andoverNetwork().sendSync(andoverGenericRequest);
        if (andoverDataResponse == null) {
            if (this.initCommunications()) {
                this.pingOk();
            } else {
                this.pingFail("no response");
            }
            return;
        }
        this.pingOk();
    }

    public void setStatusData(AndoverStatusResponse andoverStatusResponse) {
        if (andoverStatusResponse.getDomain() != 0) {
            return;
        }
        this.setPromptStatus((BEnum)andoverStatusResponse.getPrompt());
        String string = this.getJaceDateTimeString();
        this.setJaceDateTime(string);
        String string2 = andoverStatusResponse.getAndoverDateTime();
        if (andoverStatusResponse.exceptionCode != 0) {
            return;
        }
        this.getPrintStatusReadings().setAndoverDateTime(string2);
        if (this.getSupportsDomainKeyword()) {
            this.setCurrentDomain(andoverStatusResponse.getDomain());
        } else {
            this.setCurrentDomain(0);
        }
        this.getPrintStatusReadings().setUnitNumber(andoverStatusResponse.getUnitNumber());
        this.getPrintStatusReadings().setNumberAttachedIOUs(andoverStatusResponse.getNumberIOUs());
        this.getPrintStatusReadings().setIouCommFaults(andoverStatusResponse.getIOUCommFaults());
        this.getPrintStatusReadings().setIouOverrides(andoverStatusResponse.getIOUOverrides());
        this.getPrintStatusReadings().setNumberLCUs(andoverStatusResponse.getNumberLCUs());
        this.getPrintStatusReadings().setLCUCommFaults(andoverStatusResponse.getLCUCommFaults());
        this.getPrintStatusReadings().setDisabledVarClasses(andoverStatusResponse.getDisabledVars());
        this.getPrintStatusReadings().setNumberFailures(andoverStatusResponse.getNumberFailures());
    }

    public boolean initCommunications() {
        this.getAcLog().trace("initCommunications");
        AndoverStringResponse andoverStringResponse = null;
        this.getAcLog().trace("sending devicePassword:" + this.getDevicePassword());
        String string = this.getUseSPort() ? this.getDevicePassword() + '\n' : "\n" + this.getDevicePassword();
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest(string, 12);
        this.setDriverState(1);
        andoverStringResponse = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest, this.andoverNetwork().getResponseTimeout(), 2);
        if (andoverStringResponse == null) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("no response to logon step 1");
            }
            return false;
        }
        if (andoverStringResponse.getPrompt() != BAndoverPromptEnum.PPrompt) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("error, expecting a P Prompt but received a " + (Object)((Object)andoverStringResponse.getPrompt()));
            }
            return false;
        }
        this.setDriverState(2);
        AndoverGenericRequest andoverGenericRequest2 = new AndoverGenericRequest(this.getBuiltInUserPassword() + '\n', 1);
        AndoverStatusResponse andoverStatusResponse = (AndoverStatusResponse)this.andoverNetwork().sendSync(andoverGenericRequest2, this.getStatusTimeout(), 0);
        if (andoverStatusResponse == null) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("null step 2 logon");
            }
            this.setDriverState(1);
            return false;
        }
        if (andoverStatusResponse.message.endsWith("?")) {
            AndoverStringResponse andoverStringResponse2;
            AndoverGenericRequest andoverGenericRequest3;
            this.setReloadRequired(true);
            this.getAcLog().warning("Andover panel program lost!");
            int n = this.getProgramReloadSettings().getLBusIousAtStartup();
            int n2 = this.getProgramReloadSettings().getAcnetLCUsAtStartup();
            if (andoverStatusResponse.message.indexOf("Number of IOU") != -1) {
                this.getAcLog().trace("setting L-Bus Number of IOUs:" + n);
                andoverGenericRequest3 = new AndoverGenericRequest("" + n + '\n', 12);
                andoverStringResponse2 = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest3, BRelTime.makeSeconds((int)5), 0);
                if (andoverStringResponse2 == null) {
                    this.getAcLog().trace("error, expected additional prompts to set number LCUs");
                } else if (andoverStringResponse2.message.indexOf("Number of LCU") != -1) {
                    this.getAcLog().trace("setting ACNET Number of LCUs:" + n2);
                    andoverGenericRequest3 = new AndoverGenericRequest("" + n2 + '\n', 12);
                    andoverStringResponse2 = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest3, BRelTime.makeSeconds((int)5), 0);
                }
            }
            if (andoverStatusResponse.message.indexOf("Number of LCU") != -1) {
                this.getAcLog().trace("setting ACNET Number of LCUs:" + n2);
                andoverGenericRequest3 = new AndoverGenericRequest("" + n2 + '\n', 12);
                andoverStringResponse2 = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest3, BRelTime.makeSeconds((int)6), 0);
            }
            this.setDriverState(1);
            return false;
        }
        this.setStatusData(andoverStatusResponse);
        if (andoverStatusResponse.message.indexOf("Set System Options") != -1) {
            this.doSubmitSetOptionsJob(this.getOptionCommandSettings(), null);
        }
        if (andoverStatusResponse.message.indexOf("Enter System Time") != -1) {
            this.doSyncTime();
        }
        if (this.reloadRequired) {
            if (this.getAutomaticallyReloadProgram()) {
                this.getAcLog().trace("STARTING RELOAD PROCESS...");
                this.getBackupFileList();
                BAndoverBackupFolder bAndoverBackupFolder = this.getBackupList();
                Class clazz = class$com$tridium$andoverAC256$datatypes$BAndoverBackupRecord;
                if (clazz == null) {
                    clazz = class$com$tridium$andoverAC256$datatypes$BAndoverBackupRecord = BAndoverDevice.class("[Lcom.tridium.andoverAC256.datatypes.BAndoverBackupRecord;", false);
                }
                BAndoverBackupRecord[] bAndoverBackupRecordArray = (BAndoverBackupRecord[])bAndoverBackupFolder.getChildren(clazz);
                BAndoverBackupRecord bAndoverBackupRecord = null;
                BAbsTime bAbsTime = BAbsTime.NULL;
                int n = 0;
                while (n < bAndoverBackupRecordArray.length) {
                    String string2 = bAndoverBackupRecordArray[n].getPath();
                    if (string2.indexOf("_dom0_") != -1 && bAndoverBackupRecordArray[n].getTimestamp().isAfter(bAbsTime)) {
                        bAbsTime = bAndoverBackupRecordArray[n].getTimestamp();
                        bAndoverBackupRecord = bAndoverBackupRecordArray[n];
                    }
                    ++n;
                }
                if (bAndoverBackupRecord != null) {
                    BAndoverRestoreConfig bAndoverRestoreConfig = new BAndoverRestoreConfig();
                    bAndoverRestoreConfig.setRestoreDialog("Restoring Domain 0");
                    bAndoverRestoreConfig.setFileName(bAndoverBackupRecord.getPath());
                    bAndoverRestoreConfig.setTimestamp(bAndoverBackupRecord.getTimestamp());
                    bAndoverRestoreConfig.setDomain(0);
                    bAndoverRestoreConfig.setOrd(bAndoverBackupRecord.getOrd());
                    this.doSubmitRestoreControllerJob(bAndoverRestoreConfig, null);
                    this.getAcLog().trace("auto reload is enabled, reloading controller program from " + bAndoverBackupRecord.getPath());
                } else {
                    this.getAcLog().warning("ERROR: no backups available, cannot reload controller!");
                }
            } else {
                this.getAcLog().warning("auto reload is not enabled, a backup configuration will not be downloaded to the controller");
            }
            this.setPromptStatus((BEnum)BAndoverPromptEnum.UnknownPrompt);
            this.setDriverState(1);
            return false;
        }
        if (andoverStatusResponse.isError()) {
            this.getAcLog().trace("error sending personal password to panel");
            this.setPromptStatus((BEnum)BAndoverPromptEnum.UnknownPrompt);
            this.setDriverState(1);
            return false;
        }
        this.getAcLog().trace("sucessfully initialized communications to Andover panel");
        this.setStatusData(andoverStatusResponse);
        this.setDriverState(1);
        this.setCommInitialized(true);
        this.fireLogonSuccessful((BValue)BString.make((String)""));
        return true;
    }

    public void setDriverState(int n) {
        this.andoverNetwork().setDriverState(n);
    }

    public int setDomain(int n) {
        if (!this.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DOM " + n + '\n', 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.andoverNetwork().sendSync(andoverGenericRequest);
            if (andoverStringResponse == null) {
                if (this.getAcLog().isTraceOn()) {
                    this.getAcLog().trace("    ERROR: could not set to domain " + n);
                }
                return -1;
            }
            if (andoverStringResponse.isError()) {
                if (this.getAcLog().isTraceOn()) {
                    this.getAcLog().trace("    ERROR: could not set to domain " + n);
                }
                return -1;
            }
            this.setCurrentDomain(andoverStringResponse.getDomain());
            return andoverStringResponse.getDomain();
        }
        catch (Exception exception) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().warning("ERROR setting domain to " + n + ": " + exception);
            }
            return -1;
        }
    }

    public void setReloadRequired(boolean bl) {
        this.reloadRequired = bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isFirstPing = false;
        this.lastTimeSyncDay = -1;
        this.lastStatusUpdateHour = -1;
        this.monitorObject = new Object();
        this.reloadRequired = false;
    }

    public BAndoverDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$BAndoverDevice;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$BAndoverDevice = BAndoverDevice.class("[Lcom.tridium.andoverAC256.BAndoverDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

