/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.util;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.BPanoptixPointSamples;
import com.jci.jciPanoptix.BPanoptixService;
import com.jci.jciPanoptix.comm.BPanoptixComm;
import com.jci.jciPanoptix.point.BIPanoptixWritable;
import com.jci.jciPanoptix.point.BPanoptixBooleanWritable;
import com.jci.jciPanoptix.point.BPanoptixEnumWritable;
import com.jci.jciPanoptix.point.BPanoptixNumericWritable;
import java.io.IOException;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.ui.list.BList;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BServiceContainer;

public class PanoptixUtil {
    static final UiLexicon lex = new UiLexicon(class$com$jci$jciPanoptix$util$PanoptixUtil == null ? (class$com$jci$jciPanoptix$util$PanoptixUtil = PanoptixUtil.class$("com.jci.jciPanoptix.util.PanoptixUtil")) : class$com$jci$jciPanoptix$util$PanoptixUtil);
    private static String[] boilerPrefixes = new String[]{"BLR", "HX"};
    private static String[] chillerPrefixes = new String[]{"CH"};
    private static BPanoptixNetwork panNet = null;
    static final int MAX_EQUIPMENT_NUM = 8;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixService;
    static /* synthetic */ Class class$javax$baja$history$ext$BHistoryExt;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$com$jci$jciPanoptix$point$BIPanoptixWritable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixPointSamples;
    static /* synthetic */ Class class$com$jci$jciPanoptix$util$PanoptixUtil;

    public static String getPanoptixTimestamp(BAbsTime bAbsTime) {
        BAbsTime bAbsTime2 = bAbsTime.toUtcTime();
        String string = Integer.toString(bAbsTime2.getYear());
        String string2 = PanoptixUtil.formatTimestampVal(bAbsTime2.getMonth().getMonthOfYear());
        String string3 = PanoptixUtil.formatTimestampVal(bAbsTime2.getDay());
        String string4 = PanoptixUtil.formatTimestampVal(bAbsTime2.getHour());
        String string5 = PanoptixUtil.formatTimestampVal(bAbsTime2.getMinute());
        String string6 = PanoptixUtil.formatTimestampVal(bAbsTime2.getSecond());
        return string + "-" + string2 + "-" + string3 + "T" + string4 + ":" + string5 + ":" + string6 + "Z";
    }

    private static String formatTimestampVal(int n) {
        String string = "";
        if (n < 10) {
            string = "0";
        }
        string = string + Integer.toString(n);
        return string;
    }

    public static BPanoptixNetwork getPanoptixNetwork(BObject bObject) {
        if (panNet == null) {
            BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers/PanoptixNetwork");
            panNet = (BPanoptixNetwork)bOrd.get(bObject);
        }
        return panNet;
    }

    public static BPanoptixComm getComm(BObject bObject) {
        if (PanoptixUtil.getPanoptixNetwork(bObject).getStatus() == BStatus.fault) {
            return null;
        }
        BOrd bOrd = BOrd.make((String)"station:|slot:/Services");
        BServiceContainer bServiceContainer = (BServiceContainer)bOrd.get(bObject);
        BPanoptixService bPanoptixService = (BPanoptixService)((Object)bServiceContainer.getChildren(class$com$jci$jciPanoptix$BPanoptixService == null ? (class$com$jci$jciPanoptix$BPanoptixService = PanoptixUtil.class$("com.jci.jciPanoptix.BPanoptixService")) : class$com$jci$jciPanoptix$BPanoptixService)[0]);
        bPanoptixService.lease(1);
        return bPanoptixService.getPanoptixComm();
    }

    public static boolean doLink(BComponent bComponent, String string, BComponent bComponent2, String string2) {
        try {
            LinkCheck linkCheck;
            Slot slot = null;
            Slot slot2 = null;
            if (string.length() > 0) {
                slot = bComponent.getSlot(string);
            }
            if (string2.length() > 0) {
                slot2 = bComponent2.getSlot(string2);
            }
            if ((linkCheck = bComponent2.checkLink(bComponent, slot, slot2, null)).isValid()) {
                BLink bLink = bComponent2.makeLink(bComponent, slot, slot2, null);
                bComponent2.add(null, (BValue)bLink);
                bComponent2.loadSlots();
                return true;
            }
            System.out.println("Link is not valid");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static BOrd getRealDevice(BPanoptixDevice bPanoptixDevice) {
        BLink[] bLinkArray = bPanoptixDevice.getLinks();
        if (bLinkArray.length == 1) {
            return ((BComponent)bLinkArray[0].getSourceOrd().get((BObject)bPanoptixDevice)).getSlotPathOrd();
        }
        return BOrd.make((String)"");
    }

    public static String[] getCommonPointRoles(BObject bObject, String string) {
        FilePath filePath = new FilePath("panoptix/" + string + "CommonPointRoles.txt");
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get(bObject);
        BIFile bIFile = bFileSpace.findFile(filePath);
        if (bIFile != null) {
            try {
                return FileUtil.readLines((BIFile)bIFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    public static BHistoryExt getPtTrend(BControlPoint bControlPoint, BControlPoint bControlPoint2) {
        BHistoryExt[] bHistoryExtArray;
        try {
            bHistoryExtArray = (BHistoryExt[])bControlPoint.getChildren(class$javax$baja$history$ext$BHistoryExt == null ? (class$javax$baja$history$ext$BHistoryExt = PanoptixUtil.class$("javax.baja.history.ext.BHistoryExt")) : class$javax$baja$history$ext$BHistoryExt);
            if (bHistoryExtArray.length == 1) {
                return bHistoryExtArray[0];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            bHistoryExtArray = (BHistoryExt[])bControlPoint2.getChildren(class$javax$baja$history$ext$BHistoryExt == null ? (class$javax$baja$history$ext$BHistoryExt = PanoptixUtil.class$("javax.baja.history.ext.BHistoryExt")) : class$javax$baja$history$ext$BHistoryExt);
            if (bHistoryExtArray.length == 1) {
                return bHistoryExtArray[0];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static BPanoptixPointSamples getSamples(BControlPoint bControlPoint, BIHistory bIHistory, BAbsTime bAbsTime) {
        BList bList = new BList();
        BList bList2 = new BList();
        Cursor cursor = bIHistory.scan();
        while (cursor.next()) {
            BTrendRecord bTrendRecord = (BTrendRecord)cursor.get();
            if (bAbsTime != null && !bTrendRecord.getTimestamp().isAfter(bAbsTime)) continue;
            if (bControlPoint instanceof BPanoptixBooleanWritable) {
                bList2.addItem((Object)((BBooleanTrendRecord)bTrendRecord).getValue());
            } else if (bControlPoint instanceof BPanoptixNumericWritable) {
                bList2.addItem((Object)((BNumericTrendRecord)bTrendRecord).getValue());
            } else if (bControlPoint instanceof BPanoptixEnumWritable) {
                bList2.addItem((Object)(((BEnumTrendRecord)bTrendRecord).getValue().getOrdinal() - 1));
            }
            bList.addItem((Object)PanoptixUtil.getPanoptixTimestamp(bTrendRecord.getTimestamp()));
        }
        return new BPanoptixPointSamples(bList2, bList);
    }

    public static BPanoptixPointSamples getSamples(BControlPoint bControlPoint, BControlPoint bControlPoint2, BAbsTime bAbsTime) {
        BHistoryExt bHistoryExt = PanoptixUtil.getPtTrend(bControlPoint, bControlPoint2);
        if (bHistoryExt != null) {
            bHistoryExt.lease(1);
            BHistoryId bHistoryId = bHistoryExt.getHistoryConfig().getId();
            try {
                BOrd bOrd = BOrd.make((String)"history:");
                BHistorySpace bHistorySpace = (BHistorySpace)bOrd.get((BObject)bControlPoint);
                return PanoptixUtil.getSamples(bControlPoint, bHistorySpace.getHistory(bHistoryId), bAbsTime);
            }
            catch (Exception exception) {
                System.out.println("Error in Live History Get - Could Not Get HistoryService");
                exception.printStackTrace();
            }
        }
        return new BPanoptixPointSamples();
    }

    public static BControlPoint[] getPoints(BDevice bDevice) {
        bDevice.lease(2);
        BPointDeviceExt bPointDeviceExt = (BPointDeviceExt)bDevice.get("points");
        return (BControlPoint[])bPointDeviceExt.getChildren(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = PanoptixUtil.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint);
    }

    public static int getDeviceCount(BDevice bDevice) {
        BControlPoint[] bControlPointArray = PanoptixUtil.getPoints(bDevice);
        int n = 1;
        for (int i = 0; i < bControlPointArray.length; ++i) {
            String string = SlotPath.unescape((String)bControlPointArray[i].getName());
            for (int j = 8; j > n; --j) {
                int n2;
                for (n2 = 0; n2 < boilerPrefixes.length; ++n2) {
                    if (string.indexOf(boilerPrefixes[n2] + Integer.toString(j)) < 0) continue;
                    n = j;
                }
                for (n2 = 0; n2 < chillerPrefixes.length; ++n2) {
                    if (string.indexOf(chillerPrefixes[n2] + Integer.toString(j)) < 0) continue;
                    n = j;
                }
            }
        }
        return n;
    }

    public static boolean boilerFound(BDevice bDevice) {
        if (bDevice instanceof BPanoptixDevice) {
            BPanoptixDevice bPanoptixDevice = (BPanoptixDevice)bDevice;
            BDevice bDevice2 = (BDevice)PanoptixUtil.getRealDevice(bPanoptixDevice).get((BObject)bPanoptixDevice);
            BDeviceNetwork bDeviceNetwork = bDevice2.getNetwork();
            return bPanoptixDevice.getName().equals(bDeviceNetwork.getName() + "_" + bDevice2.getName() + "_BOILER");
        }
        return PanoptixUtil.prefixFound(bDevice, boilerPrefixes);
    }

    public static boolean panBoilerFound(BDevice bDevice, BDeviceNetwork bDeviceNetwork, BPanoptixNetwork bPanoptixNetwork) {
        BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            if (!bDeviceArray[i].getName().equals(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_BOILER")) continue;
            return true;
        }
        return false;
    }

    public static boolean chillerFound(BDevice bDevice) {
        if (bDevice instanceof BPanoptixDevice) {
            BPanoptixDevice bPanoptixDevice = (BPanoptixDevice)bDevice;
            BDevice bDevice2 = (BDevice)PanoptixUtil.getRealDevice(bPanoptixDevice).get((BObject)bPanoptixDevice);
            BDeviceNetwork bDeviceNetwork = bDevice2.getNetwork();
            return bDevice.getName().equals(bDeviceNetwork.getName() + "_" + bDevice2.getName() + "_CHILLER");
        }
        return PanoptixUtil.prefixFound(bDevice, chillerPrefixes);
    }

    public static boolean panChillerFound(BDevice bDevice, BDeviceNetwork bDeviceNetwork, BPanoptixNetwork bPanoptixNetwork) {
        BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            if (!bDeviceArray[i].getName().equals(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_CHILLER")) continue;
            return true;
        }
        return false;
    }

    public static boolean multiBoilerChillerFound(BDevice bDevice, BDeviceNetwork bDeviceNetwork, BPanoptixNetwork bPanoptixNetwork, int n) {
        BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            if (!bDeviceArray[i].getName().equals(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_" + n)) continue;
            return true;
        }
        return false;
    }

    public static boolean pointNameValid(String string, String string2, int n) {
        int n2;
        int n3;
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (string2.equals("Boiler")) {
            stringArray = boilerPrefixes;
            stringArray2 = chillerPrefixes;
        } else if (string2.equals("Chiller")) {
            stringArray = chillerPrefixes;
            stringArray2 = boilerPrefixes;
        } else {
            return true;
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (string.indexOf(stringArray[n3] + n) >= 0) {
                return true;
            }
            for (n2 = 1; n2 <= 8; ++n2) {
                if (string.indexOf(stringArray[n3] + n2) < 0) continue;
                return false;
            }
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            for (n2 = 1; n2 <= 8; ++n2) {
                if (string.indexOf(stringArray2[n3] + n2) < 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String getEquipmentType(BDevice bDevice) {
        String string = "";
        BOrd bOrd = BOrd.make((String)("station:|slot:/Drivers/" + PanoptixUtil.getNetwork((BComponent)bDevice).getName() + "/" + bDevice.getName() + "/jciFxDriver_JciDeviceMixIn/systemTypeOverride"));
        BString bString = (BString)bOrd.get((BObject)bDevice);
        if (bString.toString().equals("")) {
            return "NO EQUIPMENT TYPE FOUND";
        }
        string = PanoptixUtil.convertToEquipmentType(TextUtil.replace((String)bString.toString(), (String)" ", (String)""));
        if (string == null) {
            return "NO EQUIPMENT TYPE FOUND";
        }
        return string;
    }

    private static String convertToEquipmentType(String string) {
        if (lex.getText("equipment." + string).equals("equipment." + string)) {
            return null;
        }
        return lex.getText("equipment." + string);
    }

    public static int getEquipmentNum(BPanoptixDevice bPanoptixDevice) {
        BDevice bDevice = (BDevice)PanoptixUtil.getRealDevice(bPanoptixDevice).get((BObject)bPanoptixDevice);
        BDeviceNetwork bDeviceNetwork = bDevice.getNetwork();
        String string = bDeviceNetwork.getName() + "_" + bDevice.getName();
        for (int i = 1; i <= 8; ++i) {
            if (!SlotPath.unescape((String)bPanoptixDevice.getName()).equals(string + "_" + i)) continue;
            return i;
        }
        return 0;
    }

    private static boolean prefixFound(BDevice bDevice, String[] stringArray) {
        BControlPoint[] bControlPointArray = PanoptixUtil.getPoints(bDevice);
        for (int i = 0; i < bControlPointArray.length; ++i) {
            String string = SlotPath.unescape((String)bControlPointArray[i].getName());
            for (int j = 0; j < stringArray.length; ++j) {
                if (string.indexOf(stringArray[j]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static BDeviceNetwork getNetwork(BComponent bComponent) {
        try {
            BComplex bComplex = bComponent.getParent();
            while (!(bComplex instanceof BDeviceNetwork)) {
                bComplex = bComplex.getParent();
            }
            return (BDeviceNetwork)bComplex;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Array getPoints(BComponent bComponent) {
        Array array = new Array(class$com$jci$jciPanoptix$point$BIPanoptixWritable == null ? (class$com$jci$jciPanoptix$point$BIPanoptixWritable = PanoptixUtil.class$("com.jci.jciPanoptix.point.BIPanoptixWritable")) : class$com$jci$jciPanoptix$point$BIPanoptixWritable, 0);
        if (bComponent instanceof BIPanoptixWritable) {
            array.push((Object)bComponent);
        } else {
            BComponent[] bComponentArray = (BComponent[])bComponent.getChildren(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = PanoptixUtil.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
            for (int i = 0; i < bComponentArray.length; ++i) {
                array.addAll(PanoptixUtil.getPoints(bComponentArray[i]));
            }
        }
        return array;
    }

    public static void uploadHistory(BComponent bComponent) {
        block13: {
            BIPanoptixWritable bIPanoptixWritable;
            int n;
            Array array = PanoptixUtil.getPoints(bComponent);
            BAbsTime bAbsTime = BAbsTime.now();
            Array array2 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = PanoptixUtil.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
            Array array3 = new Array(class$com$jci$jciPanoptix$BPanoptixPointSamples == null ? (class$com$jci$jciPanoptix$BPanoptixPointSamples = PanoptixUtil.class$("com.jci.jciPanoptix.BPanoptixPointSamples")) : class$com$jci$jciPanoptix$BPanoptixPointSamples, 0);
            for (n = 0; n < array.size(); ++n) {
                System.out.println("pts[" + n + "] = " + ((BIPanoptixWritable)array.get(n)).getName());
                bIPanoptixWritable = (BIPanoptixWritable)array.get(n);
                if (bIPanoptixWritable.getPanoptixPointId().equals("")) {
                    bIPanoptixWritable.setPanoptixInfo("Upload History Error: Blank Panoptix Point ID.  Please Upload Point.");
                    continue;
                }
                bIPanoptixWritable.setPanoptixInfo("");
                BControlPoint bControlPoint = (BControlPoint)bIPanoptixWritable.getRealPoint().get((BObject)((BControlPoint)bIPanoptixWritable));
                BAbsTime bAbsTime2 = bIPanoptixWritable.getLastUpdateSent();
                BPanoptixPointSamples bPanoptixPointSamples = PanoptixUtil.getSamples((BControlPoint)bIPanoptixWritable, bControlPoint, bAbsTime2);
                if (bPanoptixPointSamples.getSampleVals().getItemCount() <= 0) continue;
                System.out.println("adding " + bPanoptixPointSamples.getSampleVals().getItemCount() + " samples from " + SlotPath.unescape((String)bIPanoptixWritable.getName()));
                array3.push((Object)bPanoptixPointSamples);
                array2.push((Object)bIPanoptixWritable);
            }
            try {
                if (bComponent instanceof BPanoptixNetwork) {
                    ((BPanoptixNetwork)bComponent).setPanoptixInfo("");
                } else if (bComponent instanceof BPanoptixDevice) {
                    ((BPanoptixDevice)bComponent).setPanoptixInfo("");
                } else if (bComponent instanceof BIPanoptixWritable) {
                    ((BIPanoptixWritable)bComponent).setPanoptixInfo("");
                }
                if (PanoptixUtil.getComm((BObject)bComponent).addMultiPointSamples(array2, array3, true)) {
                    for (n = 0; n < array2.size(); ++n) {
                        bIPanoptixWritable = (BIPanoptixWritable)array2.get(n);
                        bIPanoptixWritable.setLastUpdateSent(bAbsTime);
                        System.out.println("setting last update time " + bAbsTime + " for " + SlotPath.unescape((String)bIPanoptixWritable.getName()));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (bComponent instanceof BPanoptixNetwork) {
                    ((BPanoptixNetwork)bComponent).setPanoptixInfo("Failed to upload samples.");
                }
                if (bComponent instanceof BPanoptixDevice) {
                    ((BPanoptixDevice)bComponent).setPanoptixInfo("Failed to upload samples.");
                }
                if (!(bComponent instanceof BIPanoptixWritable)) break block13;
                ((BIPanoptixWritable)bComponent).setPanoptixInfo("Failed to upload samples.");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

