/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.ui.point;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.BPanoptixPointSamples;
import com.jci.jciPanoptix.comm.BPanoptixComm;
import com.jci.jciPanoptix.job.BPanoptixDiscoveryPoint;
import com.jci.jciPanoptix.point.BIPanoptixWritable;
import com.jci.jciPanoptix.point.BPanoptixBooleanWritable;
import com.jci.jciPanoptix.point.BPanoptixEnumWritable;
import com.jci.jciPanoptix.point.BPanoptixNumericWritable;
import com.jci.jciPanoptix.point.BPanoptixPointDeviceExt;
import com.jci.jciPanoptix.point.BPanoptixPointFolder;
import com.jci.jciPanoptix.ui.BPanoptixProgressDialog;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BPanoptixPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager == null ? (class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager = BPanoptixPointManager.class$("com.jci.jciPanoptix.ui.point.BPanoptixPointManager")) : class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager));
    static final UiLexicon lexicon = new UiLexicon(class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager == null ? (class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager = BPanoptixPointManager.class$("com.jci.jciPanoptix.ui.point.BPanoptixPointManager")) : class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    static Lexicon wbLex = Lexicon.make((String)"workbench");
    private BPanoptixPointDeviceExt devExt;
    private Array rows = new Array(class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager$Row == null ? (class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager$Row = BPanoptixPointManager.class$("com.jci.jciPanoptix.ui.point.BPanoptixPointManager$Row")) : class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager$Row);
    static /* synthetic */ Class class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager;
    static /* synthetic */ Class class$com$jci$jciPanoptix$point$BIPanoptixWritable;
    static /* synthetic */ Class class$com$jci$jciPanoptix$job$BPanoptixDiscoveryPoint;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixPointSamples;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager$Row;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject bObject, Context context) {
        try {
            if (bObject.getType().is(BPanoptixDevice.TYPE)) {
                this.devExt = (BPanoptixPointDeviceExt)((BPanoptixDevice)bObject).getDeviceExts()[0];
                this.devExt.lease();
                super.doLoadValue((BObject)this.devExt, context);
            } else {
                this.devExt = (BPanoptixPointDeviceExt)((BIPointFolder)bObject).getDeviceExt();
                super.doLoadValue(bObject, context);
            }
            BIPanoptixWritable[] bIPanoptixWritableArray = (BIPanoptixWritable[])this.getDevice().getPoints().getChildren(class$com$jci$jciPanoptix$point$BIPanoptixWritable == null ? (class$com$jci$jciPanoptix$point$BIPanoptixWritable = BPanoptixPointManager.class$("com.jci.jciPanoptix.point.BIPanoptixWritable")) : class$com$jci$jciPanoptix$point$BIPanoptixWritable);
            for (int i = 0; i < bIPanoptixWritableArray.length; ++i) {
                this.rows.add((Object)new Row(bIPanoptixWritableArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BPanoptixPointDeviceExt getDeviceExt() {
        if (this.devExt == null) {
            this.devExt = (BPanoptixPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.devExt;
    }

    public BPanoptixDevice getDevice() {
        return (BPanoptixDevice)this.getDeviceExt().getDevice();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Row {
        BIPanoptixWritable pt;

        Row(BIPanoptixWritable bIPanoptixWritable) {
            this.pt = bIPanoptixWritable;
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBrush bBrush = super.getBackground(cell);
            try {
                BColor bColor = null;
                BIPanoptixWritable bIPanoptixWritable = ((Row)((BPanoptixPointManager)BPanoptixPointManager.this).rows.get((int)cell.row)).pt;
                if (bIPanoptixWritable.getPanoptixPointId().equals("")) {
                    bColor = BColor.yellow;
                }
                if (bColor != null) {
                    return bColor.toBrush();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return bBrush;
        }
    }

    public class MgrTypeInfoImpl
    extends MgrTypeInfo {
        TypeInfo ti;
        String displayName;

        MgrTypeInfoImpl(String string) {
            String string2 = TextUtil.split((String)string, (char)':')[1];
            if (string2.equals("BooleanWritable")) {
                this.ti = BPanoptixBooleanWritable.TYPE.getTypeInfo();
            } else if (string2.equals("BooleanPoint")) {
                this.ti = BPanoptixBooleanWritable.TYPE.getTypeInfo();
            } else if (string2.equals("NumericWritable")) {
                this.ti = BPanoptixNumericWritable.TYPE.getTypeInfo();
            } else if (string2.equals("NumericPoint")) {
                this.ti = BPanoptixNumericWritable.TYPE.getTypeInfo();
            } else if (string2.equals("EnumWritable")) {
                this.ti = BPanoptixEnumWritable.TYPE.getTypeInfo();
            } else if (string2.equals("EnumPoint")) {
                this.ti = BPanoptixEnumWritable.TYPE.getTypeInfo();
            }
            this.displayName = lexicon.getText("panDevMgr.types.Panoptix");
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.ti.is(BControlPoint.TYPE)) {
                return lexicon.getText("mgrTypeInfo.panoptix");
            }
            return this.ti.getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.ti);
        }
    }

    class Controller
    extends PointController {
        BPanoptixPointManager ptManager;

        public Controller(BPanoptixPointManager bPanoptixPointManager2) {
            super((BPointManager)bPanoptixPointManager2);
            this.ptManager = bPanoptixPointManager2;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            BPanoptixNetwork bPanoptixNetwork = (BPanoptixNetwork)BPanoptixPointManager.this.getDevice().getParent();
            if (bPanoptixNetwork.getStatus() == BStatus.fault) {
                return new MgrController.IMgrCommand[0];
            }
            return new MgrController.IMgrCommand[]{this.discover, this.add};
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            this.getManager().getLearn().setJob(BPanoptixPointManager.this.getDevice().submitPointDiscoveryJob());
            return null;
        }

        public CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
            CommandArtifact commandArtifact = super.doAdd(objectArray, context);
            ((Learn)this.getManager().getLearn()).addComplete(objectArray);
            return commandArtifact;
        }

        public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            BComponent bComponent = bMgrTable.getComponentAt(n);
            BWbShell bWbShell = BPanoptixPointManager.this.getWbShell();
            if (bComponent instanceof BIPanoptixWritable) {
                bWbShell.hyperlink(new HyperlinkInfo(bComponent.getNavOrd(), (BInputEvent)bMouseEvent));
            }
        }
    }

    class Learn
    extends MgrLearn {
        BPanoptixDiscoveryPoint[] lastLearn;

        public Learn(BPanoptixPointManager bPanoptixPointManager2) {
            super((BAbstractManager)bPanoptixPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BPanoptixDiscoveryPoint.pointDisplayName, 5), new MgrColumn.Prop(BPanoptixDiscoveryPoint.pointType, 5), new PtRoleColumn()};
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            BPanoptixDiscoveryPoint bPanoptixDiscoveryPoint = (BPanoptixDiscoveryPoint)((Object)object);
            if (bComponent instanceof BPanoptixPointFolder) {
                return false;
            }
            BControlPoint bControlPoint = (BControlPoint)bComponent;
            return bPanoptixDiscoveryPoint.getPointName() == bControlPoint.getName() && bPanoptixDiscoveryPoint.getPointType() == bControlPoint.getType().toString();
        }

        public void jobComplete(BJob bJob) {
            bJob.lease(1);
            this.lastLearn = (BPanoptixDiscoveryPoint[])bJob.getChildren(class$com$jci$jciPanoptix$job$BPanoptixDiscoveryPoint == null ? (class$com$jci$jciPanoptix$job$BPanoptixDiscoveryPoint = BPanoptixPointManager.class$("com.jci.jciPanoptix.job.BPanoptixDiscoveryPoint")) : class$com$jci$jciPanoptix$job$BPanoptixDiscoveryPoint);
            this.updateRoots((Object[])this.lastLearn);
        }

        private Array getPoints(Object[] objectArray, BDevice bDevice) {
            Array array = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
            for (int i = 0; i < objectArray.length; ++i) {
                array.push((Object)this.findPoint(((BPanoptixDiscoveryPoint)((Object)objectArray[i])).getPointName(), (BComponent)bDevice));
            }
            return array;
        }

        public void addComplete(Object[] objectArray) {
            BPanoptixProgressDialog bPanoptixProgressDialog = new BPanoptixProgressDialog("Adding Points");
            bPanoptixProgressDialog.setRunnable(new AddPointsRunnable(bPanoptixProgressDialog, objectArray));
            bPanoptixProgressDialog.openDialog();
            this.updateRoots((Object[])this.lastLearn);
        }

        private boolean uploadTrends(Array array, Array array2, BPanoptixComm bPanoptixComm, boolean bl) {
            Object object;
            int n;
            Array array3 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
            Array array4 = new Array(class$com$jci$jciPanoptix$BPanoptixPointSamples == null ? (class$com$jci$jciPanoptix$BPanoptixPointSamples = BPanoptixPointManager.class$("com.jci.jciPanoptix.BPanoptixPointSamples")) : class$com$jci$jciPanoptix$BPanoptixPointSamples, 0);
            BAbsTime bAbsTime = BAbsTime.now();
            for (n = 0; n < array2.size(); ++n) {
                BControlPoint bControlPoint;
                object = (BControlPoint)array2.get(n);
                BPanoptixPointSamples bPanoptixPointSamples = PanoptixUtil.getSamples((BControlPoint)object, bControlPoint = (BControlPoint)array.get(n), null);
                if (bPanoptixPointSamples.getSampleVals().getItemCount() <= 0) continue;
                array4.push((Object)bPanoptixPointSamples);
                array3.push(object);
            }
            try {
                if (bPanoptixComm.addMultiPointSamples(array3, array4, bl)) {
                    for (n = 0; n < array3.size(); ++n) {
                        object = (BIPanoptixWritable)array3.get(n);
                        object.setLastUpdateSent(bAbsTime);
                    }
                    return true;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BDialog.error(null, (String)"Panoptix Error", (Object)"Failed to add trend samples to Panoptix database.  Please retry.");
                return false;
            }
        }

        private BControlPoint findPoint(String string, BComponent bComponent) {
            BControlPoint[] bControlPointArray = this.getPoints(bComponent);
            for (int i = 0; i < bControlPointArray.length; ++i) {
                if (!string.equals(bControlPointArray[i].getName())) continue;
                return bControlPointArray[i];
            }
            return null;
        }

        private BControlPoint[] getPoints(BComponent bComponent) {
            ArrayList arrayList = new ArrayList();
            this.getPoints(bComponent, arrayList);
            BControlPoint[] bControlPointArray = arrayList.toArray(new BControlPoint[arrayList.size()]);
            return bControlPointArray;
        }

        private void getPoints(BComponent bComponent, ArrayList arrayList) {
            bComponent.lease(1);
            SlotCursor slotCursor = bComponent.loadSlots().getProperties();
            while (slotCursor.nextComponent()) {
                BComponent bComponent2 = slotCursor.get().asComponent();
                if (bComponent2 instanceof BControlPoint) {
                    arrayList.add(bComponent2);
                    continue;
                }
                this.getPoints(bComponent2, arrayList);
            }
        }

        private BDeviceNetwork getRealDeviceNetwork(BPanoptixDevice bPanoptixDevice, String string) {
            BDriverContainer bDriverContainer = (BDriverContainer)bPanoptixDevice.getParent().getParent();
            BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixPointManager.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
            for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
                if (!bDeviceNetworkArray[i].getName().equals(string)) continue;
                return bDeviceNetworkArray[i];
            }
            return null;
        }

        private BDevice getRealDevice(BDeviceNetwork bDeviceNetwork, String string) {
            BDevice[] bDeviceArray = bDeviceNetwork.getDevices();
            for (int i = 0; i < bDeviceArray.length; ++i) {
                if (!string.equals(bDeviceArray[i].getName())) continue;
                return bDeviceArray[i];
            }
            return null;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            BPanoptixDiscoveryPoint bPanoptixDiscoveryPoint = (BPanoptixDiscoveryPoint)((Object)object);
            return new MgrTypeInfo[]{new MgrTypeInfoImpl(bPanoptixDiscoveryPoint.getPointType())};
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BPanoptixDiscoveryPoint bPanoptixDiscoveryPoint = (BPanoptixDiscoveryPoint)((Object)object);
            MgrColumn mgrColumn = BPanoptixPointManager.this.getModel().getColumns()[1];
            mgrEditRow.setCell(mgrColumn, (BValue)BString.make((String)bPanoptixDiscoveryPoint.getPointName()));
        }

        class AddPointsRunnable
        implements Runnable {
            BPanoptixProgressDialog dialog;
            Object[] discovery;

            public AddPointsRunnable(BPanoptixProgressDialog bPanoptixProgressDialog, Object[] objectArray) {
                this.dialog = bPanoptixProgressDialog;
                this.discovery = objectArray;
            }

            public void run() {
                try {
                    Object object;
                    Object object2;
                    Array array;
                    int n;
                    boolean bl = true;
                    BPanoptixComm bPanoptixComm = PanoptixUtil.getComm(BPanoptixPointManager.this.getCurrentValue());
                    BPanoptixDevice bPanoptixDevice = BPanoptixPointManager.this.getDevice();
                    String[] stringArray = TextUtil.split((String)bPanoptixDevice.getName(), (char)'_');
                    BDeviceNetwork bDeviceNetwork = Learn.this.getRealDeviceNetwork(bPanoptixDevice, stringArray[0]);
                    BDevice bDevice = Learn.this.getRealDevice(bDeviceNetwork, stringArray[1]);
                    Array array2 = Learn.this.getPoints(this.discovery, (BDevice)bPanoptixDevice);
                    Array array3 = Learn.this.getPoints(this.discovery, bDevice);
                    Array array4 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixPointManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array5 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixPointManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array6 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixPointManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array7 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
                    Array array8 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
                    Array array9 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
                    Array array10 = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixPointManager.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
                    Array array11 = new Array(class$java$lang$Object == null ? (class$java$lang$Object = BPanoptixPointManager.class$("java.lang.Object")) : class$java$lang$Object, 0);
                    for (n = 0; n < array2.size(); ++n) {
                        Object object3;
                        if (array2.get(n) == null) continue;
                        if (array3.get(n) == null) {
                            BDialog.error(null, (String)"Error", (Object)(((BPanoptixDiscoveryPoint)((Object)this.discovery[n])).getPointName() + " can't be found.  Re-discover points and try again."));
                            BPanoptixPointManager.this.getDeviceExt().remove((BComplex)((BControlPoint)array2.get(n)));
                            array2.set(n, null);
                            continue;
                        }
                        if (!(array2.get(n) instanceof BIPanoptixWritable)) continue;
                        BIPanoptixWritable bIPanoptixWritable = (BIPanoptixWritable)array2.get(n);
                        array = (BControlPoint)array3.get(n);
                        String string = "";
                        if (bIPanoptixWritable instanceof BPanoptixEnumWritable) {
                            string = lexicon.getText("enum." + SlotPath.unescape((String)array.getName()));
                            if (string.equals("enum." + SlotPath.unescape((String)array.getName()))) {
                                string = "";
                            }
                            ((BPanoptixEnumWritable)bIPanoptixWritable).setEnumType(string);
                        } else if (bIPanoptixWritable instanceof BPanoptixBooleanWritable) {
                            string = "EnumSetTrueFalse";
                        }
                        object2 = lexicon.getText("point." + SlotPath.unescape((String)array.getName()));
                        if (!((String)object2).equals("point." + SlotPath.unescape((String)array.getName()))) {
                            bIPanoptixWritable.setPointType((String)object2);
                            array4.push((Object)SlotPath.unescape((String)array.getName()));
                            array6.push((Object)string);
                            array7.push((Object)bIPanoptixWritable);
                            array8.push((Object)array);
                            array11.push(this.discovery[n]);
                            try {
                                object = ((BUnit)array.getFacets().get("units")).getUnitName();
                                object = TextUtil.replace((String)object, (String)" ", (String)"");
                                object3 = lexicon.getText("units." + (String)object);
                                if (((String)object3).equals("units." + (String)object)) {
                                    array5.push((Object)lexicon.getText("units.null"));
                                    continue;
                                }
                                array5.push(object3);
                            }
                            catch (NullPointerException nullPointerException) {
                                array5.push((Object)lexicon.getText("units.null"));
                            }
                            continue;
                        }
                        object = bPanoptixComm.getSupportedPointRoles(bPanoptixDevice.getEquipmentType(), bl);
                        if (object.size() == 0) {
                            bl = false;
                        }
                        object3 = new BListDropDown();
                        for (int i = 0; i < object.size(); ++i) {
                            object3.getList().addItem(object.get(i));
                        }
                        object3.setSelectedIndex(0);
                        BSplitPane bSplitPane = new BSplitPane();
                        bSplitPane.setWidget1((BWidget)new BLabel(array.getDisplayName(BPanoptixPointManager.this.getCurrentContext())));
                        bSplitPane.setWidget2((BWidget)object3);
                        bSplitPane.setOrientation(BOrientation.vertical);
                        bSplitPane.setMoveableDivider(false);
                        int n2 = BDialog.open(null, (String)"Choose Point Role Type", (Object)bSplitPane, (int)3);
                        if (n2 == 1) {
                            bIPanoptixWritable.setPointType(object3.getList().getSelectedItem().toString());
                            array4.push((Object)SlotPath.unescape((String)array.getName()));
                            array6.push((Object)string);
                            array7.push((Object)bIPanoptixWritable);
                            array8.push((Object)array);
                            array11.push(this.discovery[n]);
                            try {
                                String string2 = ((BUnit)array.getFacets().get("units")).getUnitName();
                                string2 = TextUtil.replace((String)string2, (String)" ", (String)"");
                                String string3 = lexicon.getText("units." + string2);
                                if (string3.equals("units." + string2)) {
                                    array5.push((Object)lexicon.getText("units.null"));
                                    continue;
                                }
                                array5.push((Object)string3);
                            }
                            catch (NullPointerException nullPointerException) {
                                array5.push((Object)lexicon.getText("units.null"));
                            }
                            continue;
                        }
                        BPanoptixPointManager.this.getDeviceExt().remove((BComplex)((BControlPoint)array2.get(n)));
                        array2.set(n, null);
                    }
                    n = array4.size() + 6;
                    int n3 = 0;
                    array = bPanoptixComm.addPoints(array4, array5, array6, bl);
                    this.dialog.updateProgress(100 * (n3 += 3) / n);
                    for (int i = 0; i < array.size(); ++i) {
                        object2 = (BIPanoptixWritable)array7.get(i);
                        object = (BControlPoint)array8.get(i);
                        try {
                            object2.setPanoptixPointId(array.get(i).toString());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            object2.setPanoptixPointId("");
                        }
                        if (!object2.getPanoptixPointId().equals("")) {
                            object2.setPanoptixPointRoleId(bPanoptixComm.addPointRole(object2.getPointType(), object2.getPanoptixPointId(), bPanoptixDevice.getPanoptixEquipmentId(), bl));
                            this.dialog.updateProgress(100 * ++n3 / n);
                        }
                        if (object2.getPanoptixPointId().equals("")) {
                            BPanoptixPointManager.this.getDeviceExt().remove((BComplex)((BControlPoint)array7.get(i)));
                            BDialog.error(null, (String)"Error", (Object)(object.getDisplayName(BPanoptixPointManager.this.getCurrentContext()) + " add to Panoptix failed.  Try again."));
                            bl = false;
                            continue;
                        }
                        if (object2.getPanoptixPointRoleId().equals("")) {
                            BPanoptixPointManager.this.getDeviceExt().remove((BComplex)((BControlPoint)array7.get(i)));
                            BDialog.error(null, (String)"Error", (Object)(object.getDisplayName(BPanoptixPointManager.this.getCurrentContext()) + " add to Panoptix failed, because " + bDevice.getDisplayName(BPanoptixPointManager.this.getCurrentContext()) + " does not support the " + object2.getPointType() + " Point Role."));
                            continue;
                        }
                        object2.setRealPoint(object.getSlotPathOrd());
                        PanoptixUtil.doLink((BComponent)object, "out", (BComponent)((BControlPoint)array7.get(i)), "fallback");
                        object2.setupTrendHistory();
                        array9.push(object2);
                        array10.push(object);
                        Learn.this.lastLearn = (BPanoptixDiscoveryPoint[])ArrayUtil.removeOne((Object[])Learn.this.lastLearn, (Object)array11.get(i));
                    }
                    Learn.this.uploadTrends(array10, array9, bPanoptixComm, bl);
                    this.dialog.updateProgress(100 * (n3 += 3) / n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.dialog.close();
                }
                try {
                    this.dialog.close();
                }
                catch (Exception exception) {
                    System.out.println("exception caught");
                }
                Learn.this.updateRoots((Object[])Learn.this.lastLearn);
            }
        }
    }

    class Model
    extends PointModel {
        Model(BPanoptixPointManager bPanoptixPointManager2) {
            super((BPointManager)bPanoptixPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(5), new MgrColumn.Type(5), new PtRoleColumn(), new MgrColumn.ToString(lexOut, 0)};
        }

        protected BMgrTable makeTable() {
            BMgrTable bMgrTable = super.makeTable();
            bMgrTable.setCellRenderer((TableCellRenderer)new CellRenderer());
            return bMgrTable;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BControlPoint bControlPoint = (BControlPoint)mgrTypeInfo.newInstance();
            BNullProxyExt bNullProxyExt = new BNullProxyExt();
            if (bNullProxyExt instanceof BProxyExt) {
                BFacets bFacets = (BFacets)bControlPoint.getFacets().newCopy();
                ((BProxyExt)bNullProxyExt).setDeviceFacets(bFacets);
            }
            bControlPoint.setProxyExt((BAbstractProxyExt)bNullProxyExt);
            return bControlPoint;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList arrayList = new ArrayList();
            PointModel.addBooleanPointTypes(arrayList, (boolean)true);
            PointModel.addNumericPointTypes(arrayList, (boolean)true);
            PointModel.addEnumPointTypes(arrayList, (boolean)true);
            PointModel.addStringPointTypes(arrayList, (boolean)true);
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public boolean accept(BComponent bComponent) {
            return true;
        }
    }

    class PtRoleColumn
    extends MgrColumn {
        public PtRoleColumn() {
            super("Point Role", 4);
        }

        public Object get(Object object) {
            if (object instanceof BIPanoptixWritable) {
                return ((BIPanoptixWritable)object).getPointType();
            }
            if (object instanceof BPanoptixDiscoveryPoint) {
                String string = SlotPath.unescape((String)((BPanoptixDiscoveryPoint)((Object)object)).getPointName());
                String string2 = lexicon.getText("point." + string);
                if (string2.equals("point." + string)) {
                    return "";
                }
                return string2;
            }
            return "???";
        }
    }
}

