/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.ui.device;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixDeviceFolder;
import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.job.BPanoptixDiscoveryDevice;
import com.jci.jciPanoptix.ui.BPanoptixProgressDialog;
import com.jci.jciPanoptix.util.BPanoptixEquipmentTypes;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.util.ArrayUtil;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BPanoptixDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager == null ? (class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager = BPanoptixDeviceManager.class$("com.jci.jciPanoptix.ui.device.BPanoptixDeviceManager")) : class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager));
    static final UiLexicon lex = new UiLexicon(class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager == null ? (class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager = BPanoptixDeviceManager.class$("com.jci.jciPanoptix.ui.device.BPanoptixDeviceManager")) : class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager);
    MgrColumn colDisplayName = new MgrColumn.Name(5);
    MgrColumn colCType = new MgrColumn.Prop(BPanoptixDevice.controllerType, 5);
    MgrColumn colEquipType = new EquipTypeColumn();
    MgrColumn[] cols = new MgrColumn[]{this.colDisplayName, this.colCType, this.colEquipType};
    private BPanoptixNetwork panNet;
    String makeEditLabel;
    int makeEditId;
    String devType;
    String devName;
    int devAddr;
    static /* synthetic */ Class class$com$jci$jciPanoptix$ui$device$BPanoptixDeviceManager;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$driver$BDevice;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public String toString(Context context) {
        return "Panoptix Device Manager";
    }

    public void doLoadValue(BObject bObject, Context context) {
        try {
            this.panNet = (BPanoptixNetwork)((BIDeviceFolder)bObject).getNetwork();
            super.doLoadValue(bObject, context);
            this.registerForComponentEvents((BComponent)this.panNet, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BPanoptixNetwork getNetwork() {
        if (this.panNet == null) {
            this.panNet = (BPanoptixNetwork)((BIDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return this.panNet;
    }

    private BDeviceNetwork getRealDeviceNetwork(String string) {
        BDriverContainer bDriverContainer = (BDriverContainer)this.getNetwork().getParent();
        BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixDeviceManager.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
        for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
            if (!bDeviceNetworkArray[i].getName().equals(string)) continue;
            return bDeviceNetworkArray[i];
        }
        return null;
    }

    private BDevice findPanDevice(String string, String string2, BPanoptixNetwork bPanoptixNetwork) {
        return this.findDevice(string2 + "_" + string, (BDeviceNetwork)bPanoptixNetwork);
    }

    private BDevice findDevice(String string, BDeviceNetwork bDeviceNetwork) {
        BDevice[] bDeviceArray = bDeviceNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            if (!string.equals(bDeviceArray[i].getName())) continue;
            return bDeviceArray[i];
        }
        return null;
    }

    private String getEquipmentType(BDeviceNetwork bDeviceNetwork, BDevice bDevice, boolean bl) {
        String string = "";
        try {
            BOrd bOrd = BOrd.make((String)("station:|slot:/Drivers/" + bDeviceNetwork.getName() + "/" + bDevice.getName() + "/jciFxDriver_JciDeviceMixIn/systemTypeOverride"));
            BString bString = (BString)bOrd.get(this.getCurrentValue(), this.getCurrentContext());
            if (bString.toString().equals("")) {
                throw new Exception();
            }
            string = this.convertToEquipmentType(TextUtil.replace((String)bString.toString(), (String)" ", (String)""));
            if (string == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            if (bl) {
                BListDropDown bListDropDown = new BListDropDown();
                Array array = BPanoptixEquipmentTypes.getEquipmentTypes(false);
                for (int i = 0; i < array.size(); ++i) {
                    bListDropDown.getList().addItem(array.get(i));
                }
                bListDropDown.setSelectedIndex(0);
                BSplitPane bSplitPane = new BSplitPane();
                bSplitPane.setWidget1((BWidget)new BLabel(bDevice.getDisplayName(this.getCurrentContext())));
                bSplitPane.setWidget2((BWidget)bListDropDown);
                bSplitPane.setOrientation(BOrientation.vertical);
                bSplitPane.setMoveableDivider(false);
                int n = BDialog.open(null, (String)"Choose Device Type", (Object)bSplitPane, (int)3);
                string = n == 1 ? TextUtil.replace((String)bListDropDown.getList().getSelectedItem().toString(), (String)" ", (String)"") : "";
            }
            string = "";
        }
        return string;
    }

    private String convertToEquipmentType(String string) {
        if (lex.getText("equipment." + string).equals("equipment." + string)) {
            return null;
        }
        return lex.getText("equipment." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MgrTypeInfoImpl
    extends MgrTypeInfo {
        TypeInfo ti;
        String displayName;

        MgrTypeInfoImpl() {
            this.ti = BPanoptixDevice.TYPE.getTypeInfo();
            this.displayName = lex.getText("panDevMgr.types.Panoptix");
        }

        MgrTypeInfoImpl(TypeInfo typeInfo, String string) {
            this.ti = typeInfo;
            this.displayName = string;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.ti.is(BPanoptixDevice.TYPE)) {
                return lex.getText("mgrTypeInfo.panoptix");
            }
            return this.ti.getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.ti);
        }
    }

    class Controller
    extends DeviceController {
        BPanoptixDeviceManager devManager;

        public Controller(BPanoptixDeviceManager bPanoptixDeviceManager2) {
            super((BDeviceManager)bPanoptixDeviceManager2);
            this.devManager = bPanoptixDeviceManager2;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            if (BPanoptixDeviceManager.this.getNetwork().getStatus() == BStatus.fault) {
                return new MgrController.IMgrCommand[0];
            }
            return new MgrController.IMgrCommand[]{this.discover, this.add};
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            BPanoptixDeviceManager.this.makeEditLabel = "add";
            super.doDiscover(context);
            this.getManager().getLearn().setJob(BPanoptixDeviceManager.this.getNetwork().submitDeviceDiscoveryJob());
            return null;
        }

        protected CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
            BPanoptixDeviceManager.this.makeEditLabel = "add";
            MgrEdit mgrEdit = this.makeEdit(this.add.getLabel());
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                MgrTypeInfo[] mgrTypeInfoArray = this.getManager().getLearn().toTypes(object);
                MgrEditRow mgrEditRow = mgrEdit.addRow(object, mgrTypeInfoArray);
                this.getManager().getLearn().toRow(object, mgrEditRow);
            }
            CommandArtifact commandArtifact = mgrEdit.invoke(context);
            ((Learn)this.getManager().getLearn()).addComplete(objectArray);
            return commandArtifact;
        }

        public MgrEdit makeEdit(String string) {
            if (BPanoptixDeviceManager.this.makeEditLabel.equalsIgnoreCase("add")) {
                BPanoptixDeviceManager.this.makeEditId = 5;
            }
            return new MgrEdit(this.getManager(), string){

                public CommandArtifact commit() throws Exception {
                    Object object;
                    int n;
                    MgrEditRow[] mgrEditRowArray = this.getRows();
                    if (mgrEditRowArray.length == 0) {
                        System.out.println("rows.length == 0");
                        return null;
                    }
                    BComponent bComponent = this.getAddContainer();
                    Context context = Transaction.start((BComponent)bComponent, null);
                    BPanoptixNetwork bPanoptixNetwork = BPanoptixDeviceManager.this.getNetwork();
                    if (bPanoptixNetwork == null) {
                        System.out.println("Panoptix Network Not Found");
                        return null;
                    }
                    BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
                    int[] nArray = new int[bDeviceArray.length + mgrEditRowArray.length];
                    String[] stringArray = new String[bDeviceArray.length + mgrEditRowArray.length];
                    int n2 = 0;
                    for (n = 0; n < bDeviceArray.length; ++n) {
                        object = (BPanoptixDevice)bDeviceArray[n];
                        if (object == null) continue;
                        int n3 = object.getAddress();
                        String string = object.getDisplayName(BPanoptixDeviceManager.this.getCurrentContext());
                        nArray[n] = n3;
                        stringArray[n] = string;
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                    for (n = 0; n < mgrEditRowArray.length; ++n) {
                        if (((Controller)Controller.this).BPanoptixDeviceManager.this.makeEditId != 5) continue;
                        object = mgrEditRowArray[n].getCell(((Controller)Controller.this).BPanoptixDeviceManager.this.colDisplayName).toString();
                        ((Controller)Controller.this).BPanoptixDeviceManager.this.devName = object;
                        boolean bl = true;
                        if (bl) {
                            for (int i = 0; i < bDeviceArray.length + n; ++i) {
                                String string = stringArray[i];
                                if (!((Controller)Controller.this).BPanoptixDeviceManager.this.devName.equals(string)) continue;
                                stringArray[bDeviceArray.length + n] = string = ((Controller)Controller.this).BPanoptixDeviceManager.this.devName + "1";
                                mgrEditRowArray[n].setCell(((Controller)Controller.this).BPanoptixDeviceManager.this.colDisplayName, (BValue)BString.make((String)string));
                                ((Controller)Controller.this).BPanoptixDeviceManager.this.devName = string;
                                object = string;
                                System.out.println("PanoptixDriverManager.commit, Duplicate name for device: " + ((Controller)Controller.this).BPanoptixDeviceManager.this.devName);
                                break;
                            }
                        }
                        mgrEditRowArray[n].commit(context);
                    }
                    Transaction.end((BComponent)bComponent, (Context)context);
                    mgrEditRowArray = this.getRows();
                    n = mgrEditRowArray.length > 0 ? (!mgrEditRowArray[0].getTarget().isMounted() ? 1 : 0) : 0;
                    ((Controller)Controller.this).BPanoptixDeviceManager.this.makeEditLabel = "";
                    ((Controller)Controller.this).BPanoptixDeviceManager.this.makeEditId = -1;
                    if (n != 0) {
                        return this.getManager().getModel().addInstances(mgrEditRowArray, null);
                    }
                    System.out.println("needAdd = false");
                    return null;
                }
            };
        }

        public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            BComponent bComponent = bMgrTable.getComponentAt(n);
            BWbShell bWbShell = BPanoptixDeviceManager.this.getWbShell();
            BPanoptixDevice bPanoptixDevice = null;
            System.out.println("PanoptixDriverDeviceManager.cellDoubleClick = " + bComponent.getNavOrd());
            if (bComponent instanceof BPanoptixDeviceFolder) {
                bWbShell.hyperlink(new HyperlinkInfo(bComponent.getNavOrd(), (BInputEvent)bMouseEvent));
            } else {
                String string = bComponent.getName();
                BPanoptixNetwork bPanoptixNetwork = BPanoptixDeviceManager.this.getNetwork();
                if (bPanoptixNetwork != null && (bPanoptixDevice = (BPanoptixDevice)bPanoptixNetwork.get(string)) == null) {
                    BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
                    for (int i = 0; i < bDeviceArray.length; ++i) {
                        BDevice bDevice = bDeviceArray[i];
                        if (!bDevice.getDisplayName(BPanoptixDeviceManager.this.getCurrentContext()).equalsIgnoreCase(string)) continue;
                        bPanoptixDevice = (BPanoptixDevice)bDevice;
                        break;
                    }
                }
            }
            if (bPanoptixDevice != null && bWbShell != null) {
                bWbShell.hyperlink(new HyperlinkInfo(bPanoptixDevice.getNavOrd(), (BInputEvent)bMouseEvent));
            }
        }
    }

    class Learn
    extends MgrLearn {
        BPanoptixDiscoveryDevice[] lastLearn;

        public Learn(BPanoptixDeviceManager bPanoptixDeviceManager2) {
            super((BAbstractManager)bPanoptixDeviceManager2);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BPanoptixDiscoveryDevice.deviceDisplayName, 0), new MgrColumn.Prop(BPanoptixDiscoveryDevice.controllerType, 0), new EquipTypeColumn()};
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            BPanoptixDiscoveryDevice bPanoptixDiscoveryDevice = (BPanoptixDiscoveryDevice)((Object)object);
            if (bComponent instanceof BPanoptixDeviceFolder) {
                return false;
            }
            BPanoptixDevice bPanoptixDevice = (BPanoptixDevice)bComponent;
            return bPanoptixDiscoveryDevice.getDeviceName() == bPanoptixDevice.getName() && bPanoptixDiscoveryDevice.getControllerType() == bPanoptixDevice.getType().toString();
        }

        public void jobComplete(BJob bJob) {
            bJob.lease(1);
            this.lastLearn = (BPanoptixDiscoveryDevice[])bJob.getChildren(class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice == null ? (class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice = BPanoptixDeviceManager.class$("com.jci.jciPanoptix.job.BPanoptixDiscoveryDevice")) : class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice);
            this.updateRoots((Object[])this.lastLearn);
        }

        public void addComplete(Object[] objectArray) {
            BPanoptixProgressDialog bPanoptixProgressDialog = new BPanoptixProgressDialog("Adding Devices");
            bPanoptixProgressDialog.setRunnable(new AddDevicesRunnable(bPanoptixProgressDialog, objectArray));
            bPanoptixProgressDialog.openDialog();
            this.updateRoots((Object[])this.lastLearn);
        }

        public MgrTypeInfo[] toTypes(Object object) {
            return new MgrTypeInfo[]{new MgrTypeInfoImpl()};
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BPanoptixDiscoveryDevice bPanoptixDiscoveryDevice = (BPanoptixDiscoveryDevice)((Object)object);
            mgrEditRow.setCell(BPanoptixDeviceManager.this.colDisplayName, (BValue)BString.make((String)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName())));
            mgrEditRow.setCell(BPanoptixDeviceManager.this.colCType, (BValue)BString.make((String)bPanoptixDiscoveryDevice.getControllerType()));
        }

        class AddDevicesRunnable
        implements Runnable {
            BPanoptixProgressDialog dialog;
            Object[] discovery;

            public AddDevicesRunnable(BPanoptixProgressDialog bPanoptixProgressDialog, Object[] objectArray) {
                this.dialog = bPanoptixProgressDialog;
                this.discovery = objectArray;
            }

            public void run() {
                try {
                    boolean bl = true;
                    Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixDeviceManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array2 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixDeviceManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array3 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixDeviceManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array4 = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixDeviceManager.class$("java.lang.String")) : class$java$lang$String, 0);
                    Array array5 = new Array(class$javax$baja$driver$BDevice == null ? (class$javax$baja$driver$BDevice = BPanoptixDeviceManager.class$("javax.baja.driver.BDevice")) : class$javax$baja$driver$BDevice, 0);
                    Array array6 = new Array(class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice == null ? (class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice = BPanoptixDeviceManager.class$("com.jci.jciPanoptix.job.BPanoptixDiscoveryDevice")) : class$com$jci$jciPanoptix$job$BPanoptixDiscoveryDevice, 0);
                    for (int i = 0; i < this.discovery.length; ++i) {
                        BPanoptixDiscoveryDevice bPanoptixDiscoveryDevice = (BPanoptixDiscoveryDevice)((Object)this.discovery[i]);
                        BPanoptixDevice bPanoptixDevice = (BPanoptixDevice)BPanoptixDeviceManager.this.findPanDevice(bPanoptixDiscoveryDevice.getDeviceName(), bPanoptixDiscoveryDevice.getNetworkName(), BPanoptixDeviceManager.this.getNetwork());
                        BDeviceNetwork bDeviceNetwork = BPanoptixDeviceManager.this.getRealDeviceNetwork(bPanoptixDiscoveryDevice.getNetworkName());
                        BDevice bDevice = BPanoptixDeviceManager.this.findDevice(bPanoptixDiscoveryDevice.getDeviceName(), bDeviceNetwork);
                        try {
                            BPanoptixDeviceManager.this.getNetwork().remove((BComplex)bPanoptixDevice);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bDevice == null && bPanoptixDevice != null) {
                            BDialog.error(null, (String)"Error", (Object)(bPanoptixDiscoveryDevice.getDeviceDisplayName() + " can't be found.  Re-discover devices and try again."));
                        }
                        if (bPanoptixDevice == null) continue;
                        String string = BPanoptixDeviceManager.this.getEquipmentType(bDeviceNetwork, bDevice, true);
                        String string2 = SlotPath.unescape((String)bDevice.getName());
                        if (string.equals("SimplePlant")) {
                            if (PanoptixUtil.boilerFound(bDevice) && !PanoptixUtil.panBoilerFound(bDevice, bDeviceNetwork, BPanoptixDeviceManager.this.getNetwork())) {
                                array.push((Object)(string2 + " (Boiler)"));
                                array2.push((Object)"Boiler");
                                array3.push((Object)"");
                                array5.push((Object)bDevice);
                                array4.push((Object)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName() + "_BOILER"));
                            }
                            if (bl && PanoptixUtil.chillerFound(bDevice) && !PanoptixUtil.panChillerFound(bDevice, bDeviceNetwork, BPanoptixDeviceManager.this.getNetwork())) {
                                array.push((Object)(string2 + " (Chiller)"));
                                array2.push((Object)"Chiller");
                                array3.push((Object)"");
                                array5.push((Object)bDevice);
                                array4.push((Object)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName() + "_CHILLER"));
                            }
                            array6.push((Object)bPanoptixDiscoveryDevice);
                            continue;
                        }
                        if (string.equals("Boiler") || string.equals("Chiller")) {
                            int n = PanoptixUtil.getDeviceCount(bDevice);
                            if (n == 1) {
                                array.push((Object)string2);
                                array2.push((Object)string);
                                array3.push((Object)"");
                                array5.push((Object)bDevice);
                                array4.push((Object)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName()));
                            } else {
                                for (int j = 1; j <= n; ++j) {
                                    if (PanoptixUtil.multiBoilerChillerFound(bDevice, bDeviceNetwork, BPanoptixDeviceManager.this.getNetwork(), j)) continue;
                                    array.push((Object)(string2 + "_" + j));
                                    array2.push((Object)string);
                                    array3.push((Object)"");
                                    array5.push((Object)bDevice);
                                    array4.push((Object)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName() + "_" + j));
                                }
                            }
                            array6.push((Object)bPanoptixDiscoveryDevice);
                            continue;
                        }
                        if (string.equals("")) continue;
                        array.push((Object)string2);
                        array2.push((Object)string);
                        array3.push((Object)"");
                        array5.push((Object)bDevice);
                        array4.push((Object)(bPanoptixDiscoveryDevice.getNetworkName() + "_" + bPanoptixDiscoveryDevice.getDeviceName()));
                        array6.push((Object)bPanoptixDiscoveryDevice);
                    }
                    bl &= this.uploadDevices(array4, array5, array, array2, array3, array6, bl);
                    this.dialog.updateProgress(100.0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.dialog.close();
                }
                try {
                    this.dialog.close();
                }
                catch (Exception exception) {
                    System.out.println("exception caught");
                }
            }

            private boolean uploadDevices(Array array, Array array2, Array array3, Array array4, Array array5, Array array6, boolean bl) {
                int n;
                Array array7 = PanoptixUtil.getComm(BPanoptixDeviceManager.this.getCurrentValue()).addEquipment(array3, array4, null, array5, bl);
                BPanoptixDevice[] bPanoptixDeviceArray = new BPanoptixDevice[array7.size()];
                for (n = 0; n < array7.size(); ++n) {
                    bPanoptixDeviceArray[n] = new BPanoptixDevice();
                    bPanoptixDeviceArray[n].setPanoptixEquipmentId(array7.get(n).toString());
                    BDevice bDevice = (BDevice)array2.get(n);
                    if (bPanoptixDeviceArray[n].getPanoptixEquipmentId().equals("")) {
                        BDialog.error(null, (String)"Error", (Object)(bDevice.getDisplayName(null) + " add to Panoptix failed.  Try again."));
                        return false;
                    }
                    bPanoptixDeviceArray[n].setRealDevice(bDevice.getSlotPathOrd());
                    bPanoptixDeviceArray[n].setEquipmentType(array4.get(n).toString());
                    bPanoptixDeviceArray[n].setControllerType(bDevice.getType().toString());
                    PanoptixUtil.doLink((BComponent)bDevice, "enabled", (BComponent)bPanoptixDeviceArray[n], "enabled");
                    BPanoptixDeviceManager.this.getNetwork().add(array.get(n).toString(), (BValue)bPanoptixDeviceArray[n]);
                }
                for (n = 0; n < array6.size(); ++n) {
                    Learn.this.lastLearn = (BPanoptixDiscoveryDevice[])ArrayUtil.removeOne((Object[])Learn.this.lastLearn, (Object)array6.get(n));
                }
                return true;
            }
        }
    }

    class Model
    extends DeviceModel {
        Model(BPanoptixDeviceManager bPanoptixDeviceManager2) {
            super((BDeviceManager)bPanoptixDeviceManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BPanoptixDeviceManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BComponent bComponent = mgrTypeInfo.newInstance();
            return bComponent;
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[]{new MgrTypeInfoImpl(BPanoptixDevice.TYPE.getTypeInfo(), lex.getText("panDevMgr.types.Panoptix"))};
            return mgrTypeInfoArray;
        }

        public CommandArtifact addInstances(MgrEditRow[] mgrEditRowArray, Context context) throws Exception {
            CommandArtifact commandArtifact = super.addInstances(mgrEditRowArray, context);
            return commandArtifact;
        }
    }

    class EquipTypeColumn
    extends MgrColumn {
        public EquipTypeColumn() {
            super("Equipment Type", 4);
        }

        public Object get(Object object) {
            if (object instanceof BPanoptixDevice) {
                return ((BPanoptixDevice)((Object)object)).getEquipmentType();
            }
            if (object instanceof BPanoptixDiscoveryDevice) {
                BPanoptixDiscoveryDevice bPanoptixDiscoveryDevice = (BPanoptixDiscoveryDevice)((Object)object);
                BDeviceNetwork bDeviceNetwork = BPanoptixDeviceManager.this.getRealDeviceNetwork(bPanoptixDiscoveryDevice.getNetworkName());
                BDevice bDevice = BPanoptixDeviceManager.this.findDevice(bPanoptixDiscoveryDevice.getDeviceName(), bDeviceNetwork);
                return BPanoptixDeviceManager.this.getEquipmentType(bDeviceNetwork, bDevice, false);
            }
            return "???";
        }
    }
}

