/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.ui;

import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.BPanoptixWizard;
import com.jci.jciPanoptix.util.PanoptixUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BPanoptixToolsView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$ui$BPanoptixToolsView == null ? (class$com$jci$jciPanoptix$ui$BPanoptixToolsView = BPanoptixToolsView.class$("com.jci.jciPanoptix.ui.BPanoptixToolsView")) : class$com$jci$jciPanoptix$ui$BPanoptixToolsView));
    BComponent selectedComp = null;
    BComponent selectedParentComp = null;
    private Command launchWizardCmd;
    private Command uploadSpacesCmd;
    private Command uploadServerHistoriesCmd;
    private static UiLexicon lex = new UiLexicon(class$com$jci$jciPanoptix$ui$BPanoptixToolsView == null ? (class$com$jci$jciPanoptix$ui$BPanoptixToolsView = BPanoptixToolsView.class$("com.jci.jciPanoptix.ui.BPanoptixToolsView")) : class$com$jci$jciPanoptix$ui$BPanoptixToolsView);
    static /* synthetic */ Class class$com$jci$jciPanoptix$ui$BPanoptixToolsView;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;

    public Type getType() {
        return TYPE;
    }

    public BPanoptixToolsView() {
        this.autoRegisterForComponentEvents = true;
        BGridPane bGridPane = this.makeButtonPane();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 5.0, 5.0, 5.0));
        this.setContent((BWidget)bEdgePane);
        this.setCategoryMask(BCategoryMask.make((String)"1"), Context.commit);
    }

    public String toString(Context context) {
        return lex.getText("jciPanoptix.toolsTitle");
    }

    private BGridPane makeButtonPane() {
        BInsets bInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
        BGridPane bGridPane = new BGridPane();
        this.launchWizardCmd = new LaunchWizard((BWidget)this);
        this.uploadSpacesCmd = new UploadSpaces((BWidget)this);
        this.uploadServerHistoriesCmd = new UploadServerHistories((BWidget)this);
        BAbstractButton bAbstractButton = BAbstractButton.make((Command)this.launchWizardCmd);
        BAbstractButton bAbstractButton2 = BAbstractButton.make((Command)this.uploadSpacesCmd);
        BAbstractButton bAbstractButton3 = BAbstractButton.make((Command)this.uploadServerHistoriesCmd);
        bAbstractButton.setPadding(bInsets);
        bGridPane.add("bLaunchWizard", (BValue)bAbstractButton);
        bGridPane.add("bUploadSpaces", (BValue)bAbstractButton2);
        bGridPane.add("bUploadServerHistories", (BValue)bAbstractButton3);
        bGridPane.setColumnCount(1);
        bGridPane.setColumnAlign(BHalign.center);
        return bGridPane;
    }

    public void doPreLoadPoints(BObject bObject, Context context) {
        String string = "station:|slot:/Drivers|bql:select slotPath from control:ControlPoint";
        BOrd bOrd = BOrd.make((String)string);
        BITable bITable = (BITable)bOrd.resolve(bObject).get();
        TableCursor tableCursor = (TableCursor)bITable.cursor();
        int n = 0;
        Column column = bITable.getColumns().get(0);
        while (tableCursor.next()) {
            String string2 = bITable.getString(n, column);
            ++n;
            BOrd.make((String)string2).resolve(bObject).get();
        }
    }

    public CommandArtifact doUploadServerHistories() throws Exception {
        BComponent bComponent = (BComponent)this.getWbShell().getActiveOrdTarget().get();
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.resolve((BObject)bComponent).get();
        bDriverContainer.lease();
        this.doPreLoadPoints((BObject)bDriverContainer, null);
        BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixToolsView.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
        BPanoptixWizard bPanoptixWizard = new BPanoptixWizard(bDeviceNetworkArray, PanoptixUtil.getComm(this.getCurrentValue()));
        for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
            BPanoptixNetwork bPanoptixNetwork;
            if (!(bDeviceNetworkArray[i] instanceof BPanoptixNetwork) || (bPanoptixNetwork = (BPanoptixNetwork)bDeviceNetworkArray[i]).getStatus() == BStatus.fault) continue;
            bPanoptixWizard.uploadServerHistories(this.getWbShell());
        }
        return null;
    }

    public CommandArtifact doUploadSpaces() throws Exception {
        BComponent bComponent = (BComponent)this.getWbShell().getActiveOrdTarget().get();
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.resolve((BObject)bComponent).get();
        bDriverContainer.lease();
        this.doPreLoadPoints((BObject)bDriverContainer, null);
        BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixToolsView.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
        BPanoptixWizard bPanoptixWizard = new BPanoptixWizard(bDeviceNetworkArray, PanoptixUtil.getComm(this.getCurrentValue()));
        for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
            BPanoptixNetwork bPanoptixNetwork;
            if (!(bDeviceNetworkArray[i] instanceof BPanoptixNetwork) || (bPanoptixNetwork = (BPanoptixNetwork)bDeviceNetworkArray[i]).getStatus() == BStatus.fault) continue;
            bPanoptixWizard.syncSpacesAndEquipment();
        }
        return null;
    }

    public CommandArtifact doLaunchWizard() throws Exception {
        BComponent bComponent = (BComponent)this.getWbShell().getActiveOrdTarget().get();
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.resolve((BObject)bComponent).get();
        bDriverContainer.lease();
        this.doPreLoadPoints((BObject)bDriverContainer, null);
        BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixToolsView.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
        try {
            BPanoptixWizard bPanoptixWizard = new BPanoptixWizard(bDeviceNetworkArray, PanoptixUtil.getComm(this.getCurrentValue()));
            for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
                if (!(bDeviceNetworkArray[i] instanceof BPanoptixNetwork)) continue;
                BPanoptixNetwork bPanoptixNetwork = (BPanoptixNetwork)bDeviceNetworkArray[i];
                if (bPanoptixNetwork.getStatus() != BStatus.fault) {
                    bPanoptixWizard.launchWizard();
                    continue;
                }
                throw new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            BDialog.error(null, (String)"Panoptix Error", (Object)"Error: Feature not Licensed");
        }
        return null;
    }

    public void setScheduleComponentObjects(BOrd bOrd) {
        this.selectedComp = null;
        this.selectedParentComp = null;
        if (bOrd.toString().length() > 0) {
            BObject bObject = null;
            try {
                if (this.getWbShell() != null) {
                    BObject bObject2 = this.getWbShell().getActiveOrdTarget().get();
                    bObject = bOrd.resolve(bObject2).get();
                    this.selectedComp = (BComponent)bObject;
                    bObject = bOrd.getParent().resolve(bObject2).get();
                    this.selectedParentComp = (BComponent)bObject;
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BBrush bBrush = super.getForeground(cell);
            return bBrush;
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBrush bBrush = super.getBackground(cell);
            return bBrush;
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            BColor bColor = BColor.white;
            if (bColor != null) {
                return bColor.toBrush();
            }
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            BColor bColor = BColor.darkSlateBlue;
            if (bColor != null) {
                return bColor.toBrush();
            }
            return this.getBackground(cell);
        }
    }

    class LaunchWizard
    extends Command {
        LaunchWizard(BWidget bWidget) {
            super(bWidget, lex.getText("jciPanoptix.buttonLaunchWizard"));
        }

        public CommandArtifact doInvoke() throws Exception {
            return BPanoptixToolsView.this.doLaunchWizard();
        }
    }

    class UploadSpaces
    extends Command {
        UploadSpaces(BWidget bWidget) {
            super(bWidget, lex.getText("jciPanoptix.buttonUploadSpaces"));
        }

        public CommandArtifact doInvoke() throws Exception {
            return BPanoptixToolsView.this.doUploadSpaces();
        }
    }

    class UploadServerHistories
    extends Command {
        UploadServerHistories(BWidget bWidget) {
            super(bWidget, lex.getText("jciPanoptix.buttonUploadServerHistories"));
        }

        public CommandArtifact doInvoke() throws Exception {
            return BPanoptixToolsView.this.doUploadServerHistories();
        }
    }
}

