/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.point;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.enums.BPanoptixObjectType;
import com.jci.jciPanoptix.point.BPanoptixPointDeviceExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BPanoptixProxyExt
extends BProxyExt
implements BIBasicPollable {
    public static final Property networkPointType = BPanoptixProxyExt.newProperty((int)0, (BValue)BPanoptixObjectType.unconfigured, null);
    public static final Property networkPointAddress = BPanoptixProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)256));
    public static final Property shortName = BPanoptixProxyExt.newProperty((int)0, (String)"", null);
    public static final Property longName = BPanoptixProxyExt.newProperty((int)0, (String)"", null);
    public static final Property profileName = BPanoptixProxyExt.newProperty((int)0, (String)"", null);
    public static final Property pollFrequency = BPanoptixProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property traceThisPoint = BPanoptixProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property currentTime = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property lastTime = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property pointTime = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTime = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTimeAverage = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTimeSum = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elapsedDeviceTime = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elapsedDeviceTimeAverage = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elapsedDeviceTimeSum = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Property traceCount = BPanoptixProxyExt.newProperty((int)4, (int)0, null);
    public static final Action forceRead = BPanoptixProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BPanoptixProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$point$BPanoptixProxyExt == null ? (class$com$jci$jciPanoptix$point$BPanoptixProxyExt = BPanoptixProxyExt.class$("com.jci.jciPanoptix.point.BPanoptixProxyExt")) : class$com$jci$jciPanoptix$point$BPanoptixProxyExt));
    private boolean cov = false;
    boolean overridden = false;
    static final Context rewriteCx = new BasicContext(){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "jciPanoptix:rewrite";
        }
    };
    static /* synthetic */ Class class$com$jci$jciPanoptix$point$BPanoptixProxyExt;

    public BPanoptixObjectType getNetworkPointType() {
        return (BPanoptixObjectType)this.get(networkPointType);
    }

    public void setNetworkPointType(BPanoptixObjectType bPanoptixObjectType) {
        this.set(networkPointType, (BValue)bPanoptixObjectType, null);
    }

    public int getNetworkPointAddress() {
        return this.getInt(networkPointAddress);
    }

    public void setNetworkPointAddress(int n) {
        this.setInt(networkPointAddress, n, null);
    }

    public String getShortName() {
        return this.getString(shortName);
    }

    public void setShortName(String string) {
        this.setString(shortName, string, null);
    }

    public String getLongName() {
        return this.getString(longName);
    }

    public void setLongName(String string) {
        this.setString(longName, string, null);
    }

    public String getProfileName() {
        return this.getString(profileName);
    }

    public void setProfileName(String string) {
        this.setString(profileName, string, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public boolean getTraceThisPoint() {
        return this.getBoolean(traceThisPoint);
    }

    public void setTraceThisPoint(boolean bl) {
        this.setBoolean(traceThisPoint, bl, null);
    }

    public long getCurrentTime() {
        return this.getLong(currentTime);
    }

    public void setCurrentTime(long l) {
        this.setLong(currentTime, l, null);
    }

    public long getLastTime() {
        return this.getLong(lastTime);
    }

    public void setLastTime(long l) {
        this.setLong(lastTime, l, null);
    }

    public long getPointTime() {
        return this.getLong(pointTime);
    }

    public void setPointTime(long l) {
        this.setLong(pointTime, l, null);
    }

    public long getRoundTripTime() {
        return this.getLong(roundTripTime);
    }

    public void setRoundTripTime(long l) {
        this.setLong(roundTripTime, l, null);
    }

    public long getRoundTripTimeAverage() {
        return this.getLong(roundTripTimeAverage);
    }

    public void setRoundTripTimeAverage(long l) {
        this.setLong(roundTripTimeAverage, l, null);
    }

    public long getRoundTripTimeSum() {
        return this.getLong(roundTripTimeSum);
    }

    public void setRoundTripTimeSum(long l) {
        this.setLong(roundTripTimeSum, l, null);
    }

    public long getElapsedDeviceTime() {
        return this.getLong(elapsedDeviceTime);
    }

    public void setElapsedDeviceTime(long l) {
        this.setLong(elapsedDeviceTime, l, null);
    }

    public long getElapsedDeviceTimeAverage() {
        return this.getLong(elapsedDeviceTimeAverage);
    }

    public void setElapsedDeviceTimeAverage(long l) {
        this.setLong(elapsedDeviceTimeAverage, l, null);
    }

    public long getElapsedDeviceTimeSum() {
        return this.getLong(elapsedDeviceTimeSum);
    }

    public void setElapsedDeviceTimeSum(long l) {
        this.setLong(elapsedDeviceTimeSum, l, null);
    }

    public long getTraceCount() {
        return this.getLong(traceCount);
    }

    public void setTraceCount(long l) {
        this.setLong(traceCount, l, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BPanoptixPointDeviceExt.TYPE;
    }

    public void started() {
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals(networkPointType)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
        if (property.equals(networkPointAddress)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
        if (property.equals(status)) {
            // empty if block
        }
        if (property.equals(traceThisPoint)) {
            if (this.getTraceThisPoint()) {
                this.setFlags(this.getSlot("lastTime"), 0);
                this.setFlags(this.getSlot("currentTime"), 0);
                this.setFlags(this.getSlot("pointTime"), 0);
                this.setFlags(this.getSlot("roundTripTime"), 0);
                this.setFlags(this.getSlot("roundTripTimeAverage"), 0);
                this.setFlags(this.getSlot("elapsedDeviceTime"), 0);
                this.setFlags(this.getSlot("elapsedDeviceTimeAverage"), 0);
                this.setFlags(this.getSlot("traceCount"), 0);
                this.setLastTime(0L);
                this.setCurrentTime(0L);
                this.setPointTime(0L);
                this.setRoundTripTime(0L);
                this.setRoundTripTimeAverage(0L);
                this.setRoundTripTimeSum(0L);
                this.setElapsedDeviceTime(0L);
                this.setElapsedDeviceTimeAverage(0L);
                this.setElapsedDeviceTimeSum(0L);
                this.setTraceCount(0L);
            } else {
                this.setFlags(this.getSlot("lastTime"), 4);
                this.setFlags(this.getSlot("currentTime"), 4);
                this.setFlags(this.getSlot("pointTime"), 4);
                this.setFlags(this.getSlot("roundTripTime"), 4);
                this.setFlags(this.getSlot("roundTripTimeAverage"), 4);
                this.setFlags(this.getSlot("elapsedDeviceTime"), 4);
                this.setFlags(this.getSlot("elapsedDeviceTimeAverage"), 4);
                this.setFlags(this.getSlot("traceCount"), 4);
            }
        }
    }

    public void doForceRead() {
        this.getPanoptixNetwork().postAsync(new Runnable(){

            public void run() {
                BPanoptixProxyExt.this.poll();
            }
        });
    }

    public void doForceWrite() {
        try {
            this.write((Context)null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    abstract void write(BStatusValue var1);

    abstract void setpoint(BValue var1);

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (this.getPanoptixDevice() != null) {
            string = this.getPanoptixDevice().getDisplayName(context);
        }
        try {
            string = SlotPath.unescape((String)this.getParent().getParent().getParent().getDisplayName(context));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        stringBuffer.append("PanoptixPx:").append(string).append(":").append(this.getShortName()).append(" [").append((Object)this.getNetworkPointType()).append(':').append(this.getNetworkPointAddress()).append("] ");
        return stringBuffer.toString();
    }

    public BPanoptixNetwork getPanoptixNetwork() {
        return (BPanoptixNetwork)this.getNetwork();
    }

    public BPanoptixDevice getPanoptixDevice() {
        BPanoptixDevice bPanoptixDevice = null;
        try {
            bPanoptixDevice = (BPanoptixDevice)this.getDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bPanoptixDevice;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"PanoptixProxyExt", 2);
        spyWriter.prop((Object)"overridden", this.overridden);
        spyWriter.prop((Object)"isValid", this.isValid());
        this.panoptixspy(spyWriter);
        spyWriter.endProps();
    }

    public void panoptixspy(SpyWriter spyWriter) throws Exception {
    }

    boolean isValid() {
        return this.getNetworkPointType() != BPanoptixObjectType.unconfigured && this.getNetworkPointAddress() > 0;
    }

    public void pointTrace(BPanoptixProxyExt bPanoptixProxyExt, boolean bl) {
        if (bPanoptixProxyExt.getTraceThisPoint()) {
            long l = System.currentTimeMillis();
            if (bl) {
                bPanoptixProxyExt.setLastTime(bPanoptixProxyExt.getCurrentTime());
                bPanoptixProxyExt.setCurrentTime(l);
                if (bPanoptixProxyExt.getLastTime() > 0L) {
                    bPanoptixProxyExt.setRoundTripTime(bPanoptixProxyExt.getCurrentTime() - bPanoptixProxyExt.getLastTime());
                    bPanoptixProxyExt.setTraceCount(bPanoptixProxyExt.getTraceCount() + 1L);
                    bPanoptixProxyExt.setRoundTripTimeSum(bPanoptixProxyExt.getRoundTripTimeSum() + bPanoptixProxyExt.getRoundTripTime());
                    if (bPanoptixProxyExt.getTraceCount() > 0L) {
                        bPanoptixProxyExt.setRoundTripTimeAverage(bPanoptixProxyExt.getRoundTripTimeSum() / bPanoptixProxyExt.getTraceCount());
                    }
                }
            } else {
                bPanoptixProxyExt.setPointTime(l - bPanoptixProxyExt.getCurrentTime());
                BPanoptixProxyExt bPanoptixProxyExt2 = null;
                BPanoptixProxyExt bPanoptixProxyExt3 = null;
                BControlPoint[] bControlPointArray = null;
                bControlPointArray = this.getPanoptixDevice().getPoints().getPoints();
                bPanoptixProxyExt2 = (BPanoptixProxyExt)bControlPointArray[0].getProxyExt();
                bPanoptixProxyExt3 = (BPanoptixProxyExt)bControlPointArray[bControlPointArray.length - 1].getProxyExt();
                if (bPanoptixProxyExt == bPanoptixProxyExt2) {
                    // empty if block
                }
                if (bPanoptixProxyExt == bPanoptixProxyExt3) {
                    long l2 = 0L;
                    l2 = l - bPanoptixProxyExt2.getCurrentTime();
                    bPanoptixProxyExt.setElapsedDeviceTime(l2);
                    bPanoptixProxyExt.setElapsedDeviceTimeSum(bPanoptixProxyExt.getElapsedDeviceTimeSum() + l2);
                    if (bPanoptixProxyExt.getTraceCount() > 0L) {
                        bPanoptixProxyExt.setElapsedDeviceTimeAverage(bPanoptixProxyExt.getElapsedDeviceTimeSum() / bPanoptixProxyExt.getTraceCount());
                    }
                }
            }
        }
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public void setOverridden(boolean bl) {
        this.overridden = bl;
    }

    public final boolean write(Context context) throws Exception {
        this.getPanoptixLog().trace("...write on " + this.getPanoptixDevice().getDisplayName(context) + ": " + (Object)((Object)this) + ", val: " + this.getWriteValue() + ", ovr: " + this.overridden);
        if (!this.isValid()) {
            return false;
        }
        BStatusValue bStatusValue = this.getWriteValue();
        return bStatusValue != null && !bStatusValue.getStatus().isNull() || this.overridden;
    }

    public void readSubscribed(Context context) throws Exception {
        this.getPanoptixLog().trace("readSubscribed on " + (Object)((Object)this));
    }

    public void readUnsubscribed(Context context) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        if (this.cov && !this.getPanoptixDevice().getStatus().isDown()) {
            this.getPanoptixNetwork().postAsync(new Runnable(){

                public void run() {
                }
            });
        }
        this.cov = false;
    }

    Log getPanoptixLog() {
        try {
            if (this.getPanoptixDevice().getTraceThisDevice()) {
                return this.getPanoptixNetwork().getPanoptixLog();
            }
            return Log.getLog((String)"panoptix.x");
        }
        catch (Exception exception) {
            return Log.getLog((String)"panoptix.x");
        }
    }

    static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

