/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.job;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.job.BPanoptixDiscoveryPoint;
import com.jci.jciPanoptix.util.PanoptixUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;

public class BPanoptixDiscoverPointsJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$job$BPanoptixDiscoverPointsJob == null ? (class$com$jci$jciPanoptix$job$BPanoptixDiscoverPointsJob = BPanoptixDiscoverPointsJob.class$("com.jci.jciPanoptix.job.BPanoptixDiscoverPointsJob")) : class$com$jci$jciPanoptix$job$BPanoptixDiscoverPointsJob));
    static final UiLexicon lexicon = new UiLexicon(class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager == null ? (class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager = BPanoptixDiscoverPointsJob.class$("com.jci.jciPanoptix.ui.point.BPanoptixPointManager")) : class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager);
    private BPanoptixDevice panDev;
    private BDevice realDev;
    private BDeviceNetwork realNet;
    private BControlPoint[] panoptixReadyPts;
    static /* synthetic */ Class class$com$jci$jciPanoptix$job$BPanoptixDiscoverPointsJob;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$com$jci$jciPanoptix$ui$point$BPanoptixPointManager;

    public Type getType() {
        return TYPE;
    }

    public BPanoptixDiscoverPointsJob() {
    }

    public BPanoptixDiscoverPointsJob(BPanoptixDevice bPanoptixDevice) {
        this.panDev = bPanoptixDevice;
        this.panoptixReadyPts = PanoptixUtil.getPoints((BDevice)bPanoptixDevice);
        String[] stringArray = TextUtil.split((String)bPanoptixDevice.getName(), (char)'_');
        this.realNet = this.getRealDeviceNetwork(stringArray[0]);
        this.realDev = this.getRealDevice(this.realNet, stringArray[1]);
    }

    private BDeviceNetwork getRealDeviceNetwork(String string) {
        BDriverContainer bDriverContainer = (BDriverContainer)this.panDev.getParent().getParent();
        BDeviceNetwork[] bDeviceNetworkArray = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixDiscoverPointsJob.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
        for (int i = 0; i < bDeviceNetworkArray.length; ++i) {
            if (!bDeviceNetworkArray[i].getName().equals(string)) continue;
            return bDeviceNetworkArray[i];
        }
        return null;
    }

    private BDevice getRealDevice(BDeviceNetwork bDeviceNetwork, String string) {
        BDevice[] bDeviceArray = bDeviceNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            if (!string.equals(bDeviceArray[i].getName())) continue;
            return bDeviceArray[i];
        }
        return null;
    }

    private boolean pointAlreadyAdded(String string) {
        for (int i = 0; i < this.panoptixReadyPts.length; ++i) {
            String string2 = this.panoptixReadyPts[i].getName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isEligiblePoint(BControlPoint bControlPoint) {
        Type type = bControlPoint.getType();
        return (type == BNumericPoint.TYPE || type == BBooleanPoint.TYPE || type == BStringPoint.TYPE || type == BEnumPoint.TYPE || type == BNumericWritable.TYPE || type == BBooleanWritable.TYPE || type == BStringWritable.TYPE || type == BEnumWritable.TYPE) && PanoptixUtil.pointNameValid(SlotPath.unescape((String)bControlPoint.getName()), this.panDev.getEquipmentType(), PanoptixUtil.getEquipmentNum(this.panDev));
    }

    public void run(Context context) throws Exception {
        if (this.panDev == null) {
            throw new IllegalStateException("Must submit thru PanoptixDevice.submitPointDiscoveryJob()");
        }
        BPointDeviceExt bPointDeviceExt = (BPointDeviceExt)this.realDev.get("points");
        BControlPoint[] bControlPointArray = (BControlPoint[])bPointDeviceExt.getChildren(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixDiscoverPointsJob.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint);
        for (int i = 0; i < bControlPointArray.length; ++i) {
            if (this.pointAlreadyAdded(bControlPointArray[i].getName()) || !this.isEligiblePoint(bControlPointArray[i])) continue;
            this.add(null, (BValue)new BPanoptixDiscoveryPoint(bControlPointArray[i].getName(), bControlPointArray[i].getDisplayName(context), bControlPointArray[i].getType().toString()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

