/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.job;

import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.job.BPanoptixDiscoveryDevice;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.nd.BNiagaraNetwork;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPanoptixDiscoverDevicesJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$job$BPanoptixDiscoverDevicesJob == null ? (class$com$jci$jciPanoptix$job$BPanoptixDiscoverDevicesJob = BPanoptixDiscoverDevicesJob.class$("com.jci.jciPanoptix.job.BPanoptixDiscoverDevicesJob")) : class$com$jci$jciPanoptix$job$BPanoptixDiscoverDevicesJob));
    private BPanoptixNetwork panNet;
    private BDeviceNetwork[] nets;
    private final String[] simplePlantSystemTypes = new String[]{"PCTSimpleCentralPlant"};
    private final String[] boilerChillerPlantSystemTypes = new String[]{"PCTCentralCooling", "PCTCentralCoolingOpt", "FXHeatingSystem", "FXHotWaterSystem", "PCTCentralHeating"};
    static /* synthetic */ Class class$com$jci$jciPanoptix$job$BPanoptixDiscoverDevicesJob;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$javax$baja$driver$BDevice;

    public Type getType() {
        return TYPE;
    }

    public BPanoptixDiscoverDevicesJob() {
    }

    public BPanoptixDiscoverDevicesJob(BPanoptixNetwork bPanoptixNetwork) {
        this.panNet = bPanoptixNetwork;
        BDriverContainer bDriverContainer = (BDriverContainer)bPanoptixNetwork.getParent();
        this.nets = (BDeviceNetwork[])bDriverContainer.getChildren(class$javax$baja$driver$BDeviceNetwork == null ? (class$javax$baja$driver$BDeviceNetwork = BPanoptixDiscoverDevicesJob.class$("javax.baja.driver.BDeviceNetwork")) : class$javax$baja$driver$BDeviceNetwork);
    }

    private boolean deviceAlreadyAdded(String string) {
        BDevice[] bDeviceArray = this.panNet.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            String string2 = bDeviceArray[i].getName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimplePlant(String string) {
        for (int i = 0; i < this.simplePlantSystemTypes.length; ++i) {
            if (!string.equals(this.simplePlantSystemTypes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBoilerChillerPlant(String string) {
        for (int i = 0; i < this.boilerChillerPlantSystemTypes.length; ++i) {
            if (!string.equals(this.boilerChillerPlantSystemTypes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean deviceCompletelyAdded(String string, BDeviceNetwork bDeviceNetwork, BDevice bDevice) {
        boolean bl = true;
        if (this.isSimplePlant(string)) {
            boolean bl2 = PanoptixUtil.boilerFound(bDevice);
            boolean bl3 = PanoptixUtil.chillerFound(bDevice);
            if (bl2) {
                bl &= this.deviceAlreadyAdded(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_BOILER");
            }
            if (bl3) {
                bl &= this.deviceAlreadyAdded(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_CHILLER");
            }
            return bl;
        }
        if (this.isBoilerChillerPlant(string)) {
            if (PanoptixUtil.getDeviceCount(bDevice) == 1) {
                bl &= this.deviceAlreadyAdded(bDeviceNetwork.getName() + "_" + bDevice.getName());
            } else {
                for (int i = 1; i <= PanoptixUtil.getDeviceCount(bDevice); ++i) {
                    bl &= this.deviceAlreadyAdded(bDeviceNetwork.getName() + "_" + bDevice.getName() + "_" + i);
                }
            }
            return bl;
        }
        return true;
    }

    public void run(Context context) throws Exception {
        if (this.panNet == null) {
            throw new IllegalStateException("Must submit thru PanoptixNetwork.submitDeviceDiscoveryJob()");
        }
        for (int i = 0; i < this.nets.length; ++i) {
            if (this.nets[i] instanceof BPanoptixNetwork || this.nets[i] instanceof BNiagaraNetwork) continue;
            BDevice[] bDeviceArray = (BDevice[])this.nets[i].getChildren(class$javax$baja$driver$BDevice == null ? BPanoptixDiscoverDevicesJob.class$("javax.baja.driver.BDevice") : class$javax$baja$driver$BDevice);
            for (int j = 0; j < bDeviceArray.length; ++j) {
                String string = "";
                boolean bl = false;
                try {
                    BOrd bOrd = BOrd.make((String)("station:|slot:/Drivers/" + this.nets[i].getName() + "/" + bDeviceArray[j].getName() + "/jciFxDriver_JciDeviceMixIn/systemTypeOverride"));
                    string = TextUtil.replace((String)((BString)bOrd.get((BObject)bDeviceArray[j])).toString(), (String)" ", (String)"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isSimplePlant(string) || this.isBoilerChillerPlant(string)) {
                    if (!this.deviceCompletelyAdded(string, this.nets[i], bDeviceArray[j])) {
                        bl = true;
                    }
                } else if (!this.deviceAlreadyAdded(this.nets[i].getName() + "_" + bDeviceArray[j].getName())) {
                    bl = true;
                }
                if (!bl) continue;
                this.add(null, (BValue)new BPanoptixDiscoveryDevice(bDeviceArray[j], this.nets[i].getName(), bDeviceArray[j].getName(), bDeviceArray[j].getDisplayName(context), bDeviceArray[j].getType().toString()));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

