/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix.comm;

import com.jci.jciPanoptix.comm.BProxyInfo;
import com.jci.jciPanoptix.enums.BConnectionMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.LoginException;

public final class HttpClient {
    private static String sendStringResponse(URL uRL, String string, BConnectionMethod bConnectionMethod, String string2, BProxyInfo bProxyInfo) throws LoginException {
        int n = 2;
        while (n-- > 0) {
            try {
                return HttpClient.run(uRL, string, bConnectionMethod, string2, bProxyInfo);
            }
            catch (IOException iOException) {
            }
            catch (LoginException loginException) {
                throw new LoginException();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    private static boolean sendBoolResponse(URL uRL, String string, BConnectionMethod bConnectionMethod, String string2, BProxyInfo bProxyInfo) throws LoginException {
        int n = 2;
        while (n-- > 0) {
            try {
                HttpClient.run(uRL, string, bConnectionMethod, string2, bProxyInfo);
                return true;
            }
            catch (LoginException loginException) {
                throw new LoginException();
            }
            catch (Exception exception) {
                if (n != 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String login(URL uRL, String string, String string2, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendStringResponse(uRL, string, BConnectionMethod.login, string2, bProxyInfo);
    }

    public static String postStringResponse(URL uRL, String string, String string2, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendStringResponse(uRL, string, BConnectionMethod.post, string2, bProxyInfo);
    }

    public static boolean postBoolResponse(URL uRL, String string, String string2, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendBoolResponse(uRL, string, BConnectionMethod.post, string2, bProxyInfo);
    }

    public static boolean put(URL uRL, String string, String string2, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendBoolResponse(uRL, string, BConnectionMethod.put, string2, bProxyInfo);
    }

    public static String get(URL uRL, String string, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendStringResponse(uRL, "", BConnectionMethod.get, string, bProxyInfo);
    }

    public static boolean delete(URL uRL, String string, String string2, BProxyInfo bProxyInfo) throws LoginException {
        return HttpClient.sendBoolResponse(uRL, string, BConnectionMethod.delete, string2, bProxyInfo);
    }

    public static String run(URL uRL, String string, BConnectionMethod bConnectionMethod, String string2, BProxyInfo bProxyInfo) throws IOException, LoginException {
        HttpURLConnection httpURLConnection;
        Object object;
        System.out.println("Attempting request");
        System.out.println("Msg Type = " + bConnectionMethod.getTag());
        System.out.println("URL = " + uRL);
        if (bProxyInfo.getEnabled()) {
            object = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(bProxyInfo.getServer(), bProxyInfo.getPort()));
            httpURLConnection = (HttpURLConnection)uRL.openConnection((Proxy)object);
        } else {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        if (bConnectionMethod.equals((Object)BConnectionMethod.login)) {
            httpURLConnection.setRequestMethod(BConnectionMethod.post.getTag().toUpperCase());
        } else {
            httpURLConnection.setRequestMethod(bConnectionMethod.getTag().toUpperCase());
        }
        if (bConnectionMethod.equals((Object)BConnectionMethod.login)) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        } else if (string2 != null) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + string2);
        }
        httpURLConnection.setDoOutput(true);
        if (string.equals("") && !bConnectionMethod.equals((Object)BConnectionMethod.login)) {
            try {
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                throw new IOException();
            }
        }
        if (bConnectionMethod.equals((Object)BConnectionMethod.login)) {
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        } else {
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
        }
        httpURLConnection.connect();
        object = httpURLConnection.getOutputStream();
        ((OutputStream)object).write(string.getBytes(), 0, string.getBytes().length);
        ((OutputStream)object).flush();
        try {
            ((OutputStream)object).close();
            int n = string.length() > 1000 ? 1000 : string.length();
            System.out.println("Sent: " + string.substring(0, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new StringWriter();
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            int n = inputStream.read();
            while (n > 0) {
                ((StringWriter)object).write(n);
                n = inputStream.read();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            if (httpURLConnection.getResponseCode() == 400 && bConnectionMethod.equals((Object)BConnectionMethod.delete)) {
                InputStream inputStream = httpURLConnection.getErrorStream();
                int n = inputStream.read();
                while (n > 0) {
                    ((StringWriter)object).write(n);
                    n = inputStream.read();
                }
                inputStream.close();
                if (!((StringWriter)object).toString().contains("Only points not mapped to a piece of equipment can be deleted.") && !((StringWriter)object).toString().contains("An invalid Id was given")) {
                    throw new IOException();
                }
            } else {
                if (httpURLConnection.getResponseCode() == 401) {
                    throw new LoginException();
                }
                if (httpURLConnection.getResponseCode() == 404 && !bConnectionMethod.equals((Object)BConnectionMethod.delete) || httpURLConnection.getResponseCode() / 100 != 2 && httpURLConnection.getResponseCode() != 404) {
                    System.out.println("responseCode=" + httpURLConnection.getResponseCode());
                    System.out.println("responseMsg=" + httpURLConnection.getResponseMessage());
                    throw new IOException();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((StringWriter)object).toString();
    }

    static {
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
        }
        catch (Exception exception) {
            System.out.println("Error creating dummy trust manager...");
            exception.printStackTrace();
        }
    }
}

