/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.BPanoptixPointSamples;
import com.jci.jciPanoptix.PanoptixNetworkSubscriber;
import com.jci.jciPanoptix.comm.BPanoptixComm;
import com.jci.jciPanoptix.point.BIPanoptixWritable;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.net.URL;
import javax.baja.control.BControlPoint;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BPanoptixService
extends BAbstractService {
    public static final Property pointUpdateFrequency = BPanoptixService.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeHours((int)6))), null);
    public static final Property meterUpdateFrequency = BPanoptixService.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    public static final Property loginExpiration = BPanoptixService.newProperty((int)1, (BValue)BAbsTime.make((long)0L), null);
    public static final Property panoptixComm = BPanoptixService.newProperty((int)0, (BValue)new BPanoptixComm(), null);
    public static final Property panoptixInfo = BPanoptixService.newProperty((int)1, (String)"", null);
    public static final Action uploadPointHistory = BPanoptixService.newAction((int)0, null);
    public static final Action uploadMeterHistory = BPanoptixService.newAction((int)0, null);
    public static final Action clearDatabase = BPanoptixService.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$BPanoptixService == null ? (class$com$jci$jciPanoptix$BPanoptixService = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixService")) : class$com$jci$jciPanoptix$BPanoptixService));
    private Type[] serviceTypes = new Type[]{this.getType()};
    static String vendorTridium = "tridium";
    static String featureBrand = "brand";
    static String facilityExplorerBrandId = "FacExp";
    static final BOrd JciFxLogo = BOrd.make((String)"module://jciFxDriver/com/jci/jciFxDriver/hx/jcifxlogo.jpg");
    static final Lexicon lex = Lexicon.make((Class)(class$com$jci$jciPanoptix$BPanoptixService == null ? (class$com$jci$jciPanoptix$BPanoptixService = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixService")) : class$com$jci$jciPanoptix$BPanoptixService));
    static String httpProxyServer;
    static URL proxyUrl;
    private PanoptixNetworkSubscriber netSubscriber;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixService;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixNetwork;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixPointSamples;
    static /* synthetic */ Class class$com$jci$jciPanoptix$point$BIPanoptixWritable;

    public BTimeTrigger getPointUpdateFrequency() {
        return (BTimeTrigger)this.get(pointUpdateFrequency);
    }

    public void setPointUpdateFrequency(BTimeTrigger bTimeTrigger) {
        this.set(pointUpdateFrequency, (BValue)bTimeTrigger, null);
    }

    public BTimeTrigger getMeterUpdateFrequency() {
        return (BTimeTrigger)this.get(meterUpdateFrequency);
    }

    public void setMeterUpdateFrequency(BTimeTrigger bTimeTrigger) {
        this.set(meterUpdateFrequency, (BValue)bTimeTrigger, null);
    }

    public BAbsTime getLoginExpiration() {
        return (BAbsTime)this.get(loginExpiration);
    }

    public void setLoginExpiration(BAbsTime bAbsTime) {
        this.set(loginExpiration, (BValue)bAbsTime, null);
    }

    public BPanoptixComm getPanoptixComm() {
        return (BPanoptixComm)this.get(panoptixComm);
    }

    public void setPanoptixComm(BPanoptixComm bPanoptixComm) {
        this.set(panoptixComm, (BValue)bPanoptixComm, null);
    }

    public String getPanoptixInfo() {
        return this.getString(panoptixInfo);
    }

    public void setPanoptixInfo(String string) {
        this.setString(panoptixInfo, string, null);
    }

    public void uploadPointHistory() {
        this.invoke(uploadPointHistory, null, null);
    }

    public void uploadMeterHistory() {
        this.invoke(uploadMeterHistory, null, null);
    }

    public void clearDatabase() {
        this.invoke(clearDatabase, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BPanoptixService getService() {
        return (BPanoptixService)Sys.getService((Type)TYPE);
    }

    public Type[] getServiceTypes() {
        return this.serviceTypes;
    }

    public boolean loginExpired() {
        return BAbsTime.now().isAfter(this.getLoginExpiration());
    }

    public void serviceStarted() {
        if (!BPanoptixService.isFacilityExplorerBrand()) {
            System.out.println("BPanoptixService::serviceStarted DID NOT find FacExp Brand!");
            this.setStatus(BStatus.fault);
            this.configFail("PanoptixService NOT LICENSED");
            this.configFatal("NOT Licensed to run Facility Explorer");
            return;
        }
        this.linkTo((BComponent)this.getPointUpdateFrequency(), (Slot)BTimeTrigger.fireTrigger, (Slot)uploadPointHistory);
        this.linkTo((BComponent)this.getMeterUpdateFrequency(), (Slot)BTimeTrigger.fireTrigger, (Slot)uploadMeterHistory);
        this.setPanoptixInfo("");
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.get((BObject)this);
        this.netSubscriber = new PanoptixNetworkSubscriber(bDriverContainer);
        this.netSubscriber.subscribe((BComponent)bDriverContainer);
    }

    public static boolean isFacExpBrand(BOrd bOrd) {
        boolean bl = false;
        try {
            BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:jciPanoptix:PanoptixService ");
            BPanoptixService bPanoptixService = (BPanoptixService)bOrd2.get();
            if (bPanoptixService.getStatus().isOk()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println(" isFacExpBrand ERROR ");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static boolean isFacilityExplorerBrand() {
        boolean bl = false;
        try {
            Feature feature = Sys.getLicenseManager().getFeature(vendorTridium, featureBrand);
            if (feature == null) {
                return false;
            }
            feature.check();
            if (feature.isExpired()) {
                return false;
            }
            String string = feature.get("brandId");
            if (string.equalsIgnoreCase(facilityExplorerBrandId)) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("License Exception: " + exception);
        }
        return bl;
    }

    public void doClearDatabase() {
        this.getPanoptixComm().clearDatabase(true);
    }

    public void doUploadPointHistory() {
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.get();
        bDriverContainer.loadSlots();
        try {
            Object object;
            int n;
            this.setPanoptixInfo("");
            BPanoptixNetwork bPanoptixNetwork = (BPanoptixNetwork)((Object)bDriverContainer.getChildren(class$com$jci$jciPanoptix$BPanoptixNetwork == null ? (class$com$jci$jciPanoptix$BPanoptixNetwork = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixNetwork")) : class$com$jci$jciPanoptix$BPanoptixNetwork)[0]);
            BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
            BAbsTime bAbsTime = BAbsTime.now();
            Array array = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixService.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
            Array array2 = new Array(class$com$jci$jciPanoptix$BPanoptixPointSamples == null ? (class$com$jci$jciPanoptix$BPanoptixPointSamples = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixPointSamples")) : class$com$jci$jciPanoptix$BPanoptixPointSamples, 0);
            for (n = 0; n < bDeviceArray.length; ++n) {
                object = (BPanoptixDevice)bDeviceArray[n];
                if (object.getEquipmentType().indexOf("Meter") != -1) continue;
                BIPanoptixWritable[] bIPanoptixWritableArray = (BIPanoptixWritable[])object.getPoints().getChildren(class$com$jci$jciPanoptix$point$BIPanoptixWritable == null ? BPanoptixService.class$("com.jci.jciPanoptix.point.BIPanoptixWritable") : class$com$jci$jciPanoptix$point$BIPanoptixWritable);
                for (int i = 0; i < bIPanoptixWritableArray.length; ++i) {
                    if (bIPanoptixWritableArray[i].getPanoptixPointId().equals("")) {
                        bIPanoptixWritableArray[i].setPanoptixInfo("Upload History Error: Blank Panoptix Point ID.  Please Upload Point.");
                        continue;
                    }
                    bIPanoptixWritableArray[i].setPanoptixInfo("");
                    BControlPoint bControlPoint = (BControlPoint)bIPanoptixWritableArray[i].getRealPoint().get((BObject)this);
                    BAbsTime bAbsTime2 = bIPanoptixWritableArray[i].getLastUpdateSent();
                    BPanoptixPointSamples bPanoptixPointSamples = PanoptixUtil.getSamples((BControlPoint)bIPanoptixWritableArray[i], bControlPoint, bAbsTime2);
                    if (bPanoptixPointSamples.getSampleVals().getItemCount() <= 0) continue;
                    array2.push((Object)bPanoptixPointSamples);
                    array.push((Object)bIPanoptixWritableArray[i]);
                }
            }
            try {
                if (this.getPanoptixComm().addMultiPointSamples(array, array2, true)) {
                    for (n = 0; n < array.size(); ++n) {
                        object = (BIPanoptixWritable)array.get(n);
                        object.setLastUpdateSent(bAbsTime);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setPanoptixInfo("Failed to upload samples.  Please retry.");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setPanoptixInfo("No Panoptix Network found");
        }
    }

    public void doUploadMeterHistory() {
        BOrd bOrd = BOrd.make((String)"station:|slot:/Drivers");
        BDriverContainer bDriverContainer = (BDriverContainer)bOrd.get();
        bDriverContainer.loadSlots();
        try {
            Object object;
            int n;
            this.setPanoptixInfo("");
            BPanoptixNetwork bPanoptixNetwork = (BPanoptixNetwork)((Object)bDriverContainer.getChildren(class$com$jci$jciPanoptix$BPanoptixNetwork == null ? (class$com$jci$jciPanoptix$BPanoptixNetwork = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixNetwork")) : class$com$jci$jciPanoptix$BPanoptixNetwork)[0]);
            BDevice[] bDeviceArray = bPanoptixNetwork.getDevices();
            BAbsTime bAbsTime = BAbsTime.now();
            Array array = new Array(class$javax$baja$control$BControlPoint == null ? (class$javax$baja$control$BControlPoint = BPanoptixService.class$("javax.baja.control.BControlPoint")) : class$javax$baja$control$BControlPoint, 0);
            Array array2 = new Array(class$com$jci$jciPanoptix$BPanoptixPointSamples == null ? (class$com$jci$jciPanoptix$BPanoptixPointSamples = BPanoptixService.class$("com.jci.jciPanoptix.BPanoptixPointSamples")) : class$com$jci$jciPanoptix$BPanoptixPointSamples, 0);
            for (n = 0; n < bDeviceArray.length; ++n) {
                object = (BPanoptixDevice)bDeviceArray[n];
                if (object.getEquipmentType().indexOf("Meter") <= -1) continue;
                BIPanoptixWritable[] bIPanoptixWritableArray = (BIPanoptixWritable[])object.getPoints().getChildren(class$com$jci$jciPanoptix$point$BIPanoptixWritable == null ? BPanoptixService.class$("com.jci.jciPanoptix.point.BIPanoptixWritable") : class$com$jci$jciPanoptix$point$BIPanoptixWritable);
                for (int i = 0; i < bIPanoptixWritableArray.length; ++i) {
                    if (bIPanoptixWritableArray[i].getPanoptixPointId().equals("")) {
                        bIPanoptixWritableArray[i].setPanoptixInfo("Upload History Error: Blank Panoptix Point ID.  Please Upload Point.");
                        continue;
                    }
                    bIPanoptixWritableArray[i].setPanoptixInfo("");
                    BControlPoint bControlPoint = (BControlPoint)bIPanoptixWritableArray[i].getRealPoint().get((BObject)this);
                    BAbsTime bAbsTime2 = bIPanoptixWritableArray[i].getLastUpdateSent();
                    BPanoptixPointSamples bPanoptixPointSamples = PanoptixUtil.getSamples((BControlPoint)bIPanoptixWritableArray[i], bControlPoint, bAbsTime2);
                    if (bPanoptixPointSamples.getSampleVals().getItemCount() <= 0) continue;
                    array2.push((Object)bPanoptixPointSamples);
                    array.push((Object)bIPanoptixWritableArray[i]);
                }
            }
            try {
                if (this.getPanoptixComm().addMultiPointSamples(array, array2, true)) {
                    for (n = 0; n < array.size(); ++n) {
                        object = (BIPanoptixWritable)array.get(n);
                        object.setLastUpdateSent(bAbsTime);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setPanoptixInfo("Failed to upload samples.  Please retry.");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setPanoptixInfo("No Panoptix Network found");
        }
    }

    public boolean isModuleLoaded(String string) {
        try {
            NModule nModule = Nre.moduleManager.loadModule(string);
            if (nModule != null) {
                System.out.println("...PanoptixService get Module Manager, module: " + string + " EXISTS!  " + nModule);
                return true;
            }
            System.out.println("...PanoptixService get Module Manager, module: " + string + " Does not EXIST!");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

