/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix;

import com.jci.jciPanoptix.BPanoptixDevice;
import com.jci.jciPanoptix.BPanoptixDeviceFolder;
import com.jci.jciPanoptix.job.BPanoptixDiscoverDevicesJob;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.ddfHttp.BDdfHttpNetwork;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDriverContainer;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;

public class BPanoptixNetwork
extends BDdfHttpNetwork {
    public static final Property panoptixInfo = BPanoptixNetwork.newProperty((int)1, (String)"", null);
    public static final Property deviceRenamePermission = BPanoptixNetwork.newProperty((int)5, (boolean)false, null);
    public static final Action uploadHistory = BPanoptixNetwork.newAction((int)0, null);
    public static final Action submitDeviceDiscoveryJob = BPanoptixNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$BPanoptixNetwork == null ? (class$com$jci$jciPanoptix$BPanoptixNetwork = BPanoptixNetwork.class$("com.jci.jciPanoptix.BPanoptixNetwork")) : class$com$jci$jciPanoptix$BPanoptixNetwork));
    static final UiLexicon lex = new UiLexicon(class$com$jci$jciPanoptix$BPanoptixNetwork == null ? (class$com$jci$jciPanoptix$BPanoptixNetwork = BPanoptixNetwork.class$("com.jci.jciPanoptix.BPanoptixNetwork")) : class$com$jci$jciPanoptix$BPanoptixNetwork);
    static String vendorTridium = "tridium";
    static String featureBrand = "brand";
    static String facilityExplorerBrandId = "FacExp";
    private Log panlog;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixNetwork;
    static /* synthetic */ Class class$java$lang$String;

    public String getPanoptixInfo() {
        return this.getString(panoptixInfo);
    }

    public void setPanoptixInfo(String string) {
        this.setString(panoptixInfo, string, null);
    }

    public boolean getDeviceRenamePermission() {
        return this.getBoolean(deviceRenamePermission);
    }

    public void setDeviceRenamePermission(boolean bl) {
        this.setBoolean(deviceRenamePermission, bl, null);
    }

    public void uploadHistory() {
        this.invoke(uploadHistory, null, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("jciPanoptix:PanoptixDeviceManager");
        agentList.remove(agentList.get("devDriver:DdfDeviceManager"));
        return agentList;
    }

    public void started() throws Exception {
        super.started();
        if (!BPanoptixNetwork.isFacilityExplorerBrand()) {
            System.out.println("BPanoptixNetwork::started DID NOT find FacExp Brand!");
            this.setStatus(BStatus.fault);
            this.configFail("PanoptixNetwork NOT LICENSED");
            this.configFatal("NOT Licensed to run Facility Explorer");
            return;
        }
        BDriverContainer bDriverContainer = (BDriverContainer)this.getParent();
        BPanoptixNetwork[] bPanoptixNetworkArray = (BPanoptixNetwork[])bDriverContainer.getChildren(class$com$jci$jciPanoptix$BPanoptixNetwork == null ? (class$com$jci$jciPanoptix$BPanoptixNetwork = BPanoptixNetwork.class$("com.jci.jciPanoptix.BPanoptixNetwork")) : class$com$jci$jciPanoptix$BPanoptixNetwork);
        if (bPanoptixNetworkArray.length == 2 && !bPanoptixNetworkArray[0].getName().equals(bPanoptixNetworkArray[1].getName() + "_BACKUP") && !bPanoptixNetworkArray[1].getName().equals(bPanoptixNetworkArray[0].getName() + "_BACKUP")) {
            System.out.println("Can't create more than one Panoptix Network per station.");
            bDriverContainer.remove((BComplex)this);
            return;
        }
    }

    public Type getDeviceType() {
        return BPanoptixDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BPanoptixDeviceFolder.TYPE;
    }

    public BOrd doSubmitDeviceDiscoveryJob(Context context) {
        return new BPanoptixDiscoverDevicesJob(this).submit(context);
    }

    public Log getPanoptixLog() {
        String string = "pan." + this.getDisplayName(null);
        if (this.panlog != null && string.equals(this.panlog.getLogName())) {
            return this.panlog;
        }
        this.panlog = Log.getLog((String)string);
        return this.panlog;
    }

    public static boolean isFacilityExplorerBrand() {
        boolean bl = false;
        try {
            Feature feature = Sys.getLicenseManager().getFeature(vendorTridium, featureBrand);
            if (feature == null) {
                return false;
            }
            feature.check();
            if (feature.isExpired()) {
                return false;
            }
            String string = feature.get("brandId");
            if (string.equalsIgnoreCase(facilityExplorerBrandId)) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("License Exception: " + exception);
        }
        return bl;
    }

    public void doUploadHistory() {
        PanoptixUtil.uploadHistory((BComponent)this);
    }

    public void checkRemove(Property property, Context context) {
        BValue bValue = this.get(property);
        if (context != null && bValue instanceof BPanoptixDevice && context.getUser() != null) {
            BPanoptixDevice bPanoptixDevice = (BPanoptixDevice)bValue;
            this.setPanoptixInfo("");
            if (!bPanoptixDevice.getPanoptixEquipmentId().equals("")) {
                Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BPanoptixNetwork.class$("java.lang.String")) : class$java$lang$String, 0);
                array.push((Object)bPanoptixDevice.getPanoptixEquipmentId());
                if (!PanoptixUtil.getComm((BObject)this).deleteEquipment(array, true)) {
                    throw new LocalizableRuntimeException("panoptix", "Failed to delete equipment from Panoptix, please try again.");
                }
            }
        }
    }

    public void checkRename(Property property, String string, Context context) {
        BValue bValue;
        if (!this.getDeviceRenamePermission() && (bValue = this.get(property)) instanceof BPanoptixDevice && context.getUser() != null) {
            throw new IllegalNameException("panoptix", "Cannot rename Panoptix device.", null);
        }
    }

    public void stopped() {
        BDriverContainer bDriverContainer = (BDriverContainer)this.getParent();
        if (bDriverContainer.isRunning() && this.getName().indexOf("_BACKUP") <= 0) {
            try {
                if (!PanoptixUtil.getComm((BObject)this).deleteNetwork(this, true)) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                this.setPanoptixInfo("Error: Network not deleted in Panoptix properly.  Please try again.");
                bDriverContainer.add(this.getName() + "_BACKUP", this.newCopy());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

