/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciPanoptix;

import com.jci.jciPanoptix.BPanoptixNetwork;
import com.jci.jciPanoptix.job.BPanoptixDiscoverPointsJob;
import com.jci.jciPanoptix.point.BPanoptixPointDeviceExt;
import com.jci.jciPanoptix.util.PanoptixUtil;
import com.tridium.basicdriver.BBasicDevice;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BPanoptixDevice
extends BBasicDevice {
    public static final Property realDevice = BPanoptixDevice.newProperty((int)1, (BValue)BOrd.make((String)""), null);
    public static final Property equipmentNode = BPanoptixDevice.newProperty((int)1, (BValue)BOrd.make((String)""), null);
    public static final Property locatedInSpace = BPanoptixDevice.newProperty((int)1, (BValue)BOrd.make((String)""), null);
    public static final Property servesSpaces = BPanoptixDevice.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property servesEquipment = BPanoptixDevice.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property panoptixEquipmentId = BPanoptixDevice.newProperty((int)1, (String)"", null);
    public static final Property equipmentType = BPanoptixDevice.newProperty((int)1, (String)"", null);
    public static final Property panoptixInfo = BPanoptixDevice.newProperty((int)1, (String)"", null);
    public static final Property points = BPanoptixDevice.newProperty((int)0, (BValue)new BPanoptixPointDeviceExt(), null);
    public static final Property deviceCode = BPanoptixDevice.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)BUnit.NULL, (int)0, (int)255, (int)16));
    public static final Property address = BPanoptixDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)255));
    public static final Property controllerType = BPanoptixDevice.newProperty((int)4, (String)"", null);
    public static final Property traceThisDevice = BPanoptixDevice.newProperty((int)0, (boolean)false, null);
    public static final Action uploadHistory = BPanoptixDevice.newAction((int)0, null);
    public static final Action submitPointDiscoveryJob = BPanoptixDevice.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$jci$jciPanoptix$BPanoptixDevice == null ? (class$com$jci$jciPanoptix$BPanoptixDevice = BPanoptixDevice.class$("com.jci.jciPanoptix.BPanoptixDevice")) : class$com$jci$jciPanoptix$BPanoptixDevice));
    private static final IntHashMap devMap = new IntHashMap();
    private boolean needsId = true;
    protected BAbsTime lastTimeSync = null;
    static /* synthetic */ Class class$com$jci$jciPanoptix$BPanoptixDevice;

    public BOrd getRealDevice() {
        return (BOrd)this.get(realDevice);
    }

    public void setRealDevice(BOrd bOrd) {
        this.set(realDevice, (BValue)bOrd, null);
    }

    public BOrd getEquipmentNode() {
        return (BOrd)this.get(equipmentNode);
    }

    public void setEquipmentNode(BOrd bOrd) {
        this.set(equipmentNode, (BValue)bOrd, null);
    }

    public BOrd getLocatedInSpace() {
        return (BOrd)this.get(locatedInSpace);
    }

    public void setLocatedInSpace(BOrd bOrd) {
        this.set(locatedInSpace, (BValue)bOrd, null);
    }

    public BFolder getServesSpaces() {
        return (BFolder)this.get(servesSpaces);
    }

    public void setServesSpaces(BFolder bFolder) {
        this.set(servesSpaces, (BValue)bFolder, null);
    }

    public BFolder getServesEquipment() {
        return (BFolder)this.get(servesEquipment);
    }

    public void setServesEquipment(BFolder bFolder) {
        this.set(servesEquipment, (BValue)bFolder, null);
    }

    public String getPanoptixEquipmentId() {
        return this.getString(panoptixEquipmentId);
    }

    public void setPanoptixEquipmentId(String string) {
        this.setString(panoptixEquipmentId, string, null);
    }

    public String getEquipmentType() {
        return this.getString(equipmentType);
    }

    public void setEquipmentType(String string) {
        this.setString(equipmentType, string, null);
    }

    public String getPanoptixInfo() {
        return this.getString(panoptixInfo);
    }

    public void setPanoptixInfo(String string) {
        this.setString(panoptixInfo, string, null);
    }

    public BPanoptixPointDeviceExt getPoints() {
        return (BPanoptixPointDeviceExt)this.get(points);
    }

    public void setPoints(BPanoptixPointDeviceExt bPanoptixPointDeviceExt) {
        this.set(points, (BValue)bPanoptixPointDeviceExt, null);
    }

    public int getDeviceCode() {
        return this.getInt(deviceCode);
    }

    public void setDeviceCode(int n) {
        this.setInt(deviceCode, n, null);
    }

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int n) {
        this.setInt(address, n, null);
    }

    public String getControllerType() {
        return this.getString(controllerType);
    }

    public void setControllerType(String string) {
        this.setString(controllerType, string, null);
    }

    public boolean getTraceThisDevice() {
        return this.getBoolean(traceThisDevice);
    }

    public void setTraceThisDevice(boolean bl) {
        this.setBoolean(traceThisDevice, bl, null);
    }

    public void uploadHistory() {
        this.invoke(uploadHistory, null, null);
    }

    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPing() throws Exception {
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public void clockChanged(BRelTime bRelTime) throws Exception {
        if (bRelTime.getMinutes() > 2) {
            this.lastTimeSync = null;
        }
    }

    public Type getNetworkType() {
        return BPanoptixNetwork.TYPE;
    }

    public void pingOk() {
        if (this.isDown()) {
            this.transitionToOnline();
        }
        super.pingOk();
    }

    protected void transitionToOnline() {
    }

    protected void timeSync() {
    }

    public BPanoptixNetwork getPanoptixNetwork() {
        return (BPanoptixNetwork)this.getNetwork();
    }

    public void setNeedsId(boolean bl) {
        this.needsId = bl;
    }

    public boolean needsId() {
        return this.needsId;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"PanoptixDevice", 2);
        spyWriter.prop((Object)"needsId", this.needsId);
        spyWriter.prop((Object)"lastTimeSync", (Object)this.lastTimeSync);
        this.panoptixspy(spyWriter);
        spyWriter.endProps();
    }

    public void panoptixspy(SpyWriter spyWriter) throws Exception {
    }

    public static String getControllerType(int n, boolean bl) {
        DeviceType deviceType = (DeviceType)devMap.get(n);
        if (deviceType == null) {
            return "Unknown code:" + n;
        }
        return deviceType.getCType();
    }

    public static String getDisplayType(int n, boolean bl) {
        DeviceType deviceType = (DeviceType)devMap.get(n);
        if (deviceType == null) {
            return "?" + n + "?";
        }
        return deviceType.getDType();
    }

    public static TypeInfo getTypeInfo(int n, boolean bl) {
        DeviceType deviceType = (DeviceType)devMap.get(n);
        if (deviceType == null) {
            return null;
        }
        return deviceType.getTInfo();
    }

    Log getPanoptixLog() {
        try {
            if (this.getTraceThisDevice()) {
                return this.getPanoptixNetwork().getPanoptixLog();
            }
            return Log.getLog((String)"panoptix.x");
        }
        catch (Exception exception) {
            return Log.getLog((String)"panoptix.x");
        }
    }

    public BOrd doSubmitPointDiscoveryJob(Context context) {
        return new BPanoptixDiscoverPointsJob(this).submit(context);
    }

    public void doUploadHistory() {
        PanoptixUtil.uploadHistory((BComponent)this);
    }

    static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            BOrd bOrd = BOrd.make((String)"module://jciPanoptix/com/jci/jciPanoptix/deviceTypes.xml");
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("device");
            for (int i = 0; i < xElemArray.length; ++i) {
                int n = xElemArray[i].geti("code", 0);
                DeviceType deviceType = new DeviceType(xElemArray[i].get("n", "??"), xElemArray[i].get("controllerType", "??"), xElemArray[i].get("t", null));
                devMap.put(n, (Object)deviceType);
            }
        }
        catch (Exception exception) {
            System.out.println("Error Loading Panoptix Device Types!");
            exception.printStackTrace();
        }
    }

    static class DeviceType {
        private String cType;
        private String dType;
        private TypeInfo ti;

        public DeviceType(String string, String string2, String string3) {
            this.cType = string;
            this.dType = string2;
            this.ti = BTypeSpec.make((String)("jciPanoptix:" + string3)).getTypeInfo();
        }

        public String getCType() {
            return this.cType;
        }

        public String getDType() {
            return this.dType;
        }

        public TypeInfo getTInfo() {
            return this.ti;
        }

        public String toString() {
            return this.cType + " (" + this.dType + ")";
        }
    }
}

