/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BPicture;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.raster.viewer.PxUtil;
import com.tridium.sys.Nre;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;

public class Thumb {
    static Log log = Log.getLog((String)"thumbs");
    static final double imagew = 96.0;
    static final double imageh = BPicture.imageh;
    static final HashMap cache = new HashMap();
    static final BImage errorImage = BImage.make((String)"module://icons/x32/error.png");
    static final Thread thread;
    static final Object dibsLock;
    static Thumb dibs;
    BIFile file;
    boolean loaded;
    BImage image;
    double origw;
    double origh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thumb make(BIFile file) {
        if (!file.getType().is(ImageUtil.imageFileType) && !file.getType().is(ImageUtil.pxFileType)) {
            return new Thumb(BImage.make((BIcon)((BObject)file).getIcon()));
        }
        Thumb thumb = null;
        HashMap hashMap = cache;
        synchronized (hashMap) {
            BOrd ord = file.getNavOrd();
            thumb = (Thumb)cache.get(ord);
            if (thumb != null) {
                return thumb;
            }
            thumb = new Thumb(file);
            cache.put(ord, thumb);
        }
        return thumb;
    }

    public static void clearCache() {
        cache.clear();
    }

    private Thumb(BImage image) {
        this.image = image;
        this.loaded = true;
    }

    private Thumb(BIFile file) {
        this.file = file;
    }

    public boolean isLoaded() {
        return this.loaded && this.image.isLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dibs() {
        if (this.loaded) {
            return;
        }
        Object object = dibsLock;
        synchronized (object) {
            dibs = this;
            dibsLock.notifyAll();
        }
    }

    public BImage getImage() {
        return this.image;
    }

    public double getOrigWidth() {
        if (this.file == null) {
            return this.image.getWidth();
        }
        return this.origw;
    }

    public double getOrigHeight() {
        if (this.file == null) {
            return this.image.getHeight();
        }
        return this.origh;
    }

    public void unload() {
        if (this.file == null) {
            return;
        }
        this.image = null;
        this.loaded = false;
    }

    void load() throws IOException {
        double ih;
        double iw;
        long t1 = Clock.ticks();
        BufferedImage src = null;
        try {
            src = this.file.getType().is(ImageUtil.pxFileType) ? PxUtil.read(this.file) : ImageUtil.read(this.file);
            iw = this.origw = (double)src.getWidth();
            ih = this.origh = (double)src.getHeight();
        }
        catch (Exception e) {
            System.out.println("ERROR: Cannot load " + this.file);
            this.image = errorImage;
            this.loaded = true;
            return;
        }
        long t2 = Clock.ticks();
        if (iw <= 96.0 && ih <= imageh) {
            this.image = ImageUtil.toBImage(src);
            this.loaded = true;
            return;
        }
        double rx = 96.0 / iw;
        double ry = imageh / ih;
        double r = Math.min(rx, ry);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(r, r), null);
        BufferedImage dest = op.filter(src, null);
        this.image = ImageUtil.toBImage(dest);
        src.flush();
        src = null;
        this.loaded = true;
        long t3 = Clock.ticks();
        if (log.isTraceOn()) {
            log.trace(this.file.getFileName() + ": load=" + (t2 - t1) + "ms scale=" + (t3 - t2) + "ms");
        }
    }

    static {
        dibsLock = new Object();
        thread = new ThumbManagerThread();
        thread.start();
        Spy.ROOT.add("thumbManager", (Spy)new ThumbManagerSpy());
    }

    static class ThumbManagerSpy
    extends SpyDir
    implements Comparator {
        ThumbManagerSpy() {
        }

        public void write(SpyWriter out) throws Exception {
            int i;
            Object[] thumbs = cache.values().toArray(new Thumb[cache.size()]);
            SortUtil.sort((Object[])thumbs, (Object[])thumbs, (Comparator)this);
            int loaded = 0;
            for (i = 0; i < thumbs.length; ++i) {
                if (!((Thumb)thumbs[i]).loaded) continue;
                ++loaded;
            }
            out.startTable(true);
            out.trTitle((Object)("Thumb Cache [total=" + thumbs.length + "; loaded=" + loaded + "]"), 3);
            out.w((Object)"<tr>").th((Object)"<b>File</b>").th((Object)"<b>Loaded</b>").th((Object)"<b>Orig Size</b>").w((Object)"</tr>\n");
            for (i = 0; i < thumbs.length; ++i) {
                Object t = thumbs[i];
                String size = ((Thumb)t).loaded ? "" + ((Thumb)t).origw + "," + ((Thumb)t).origh : "-";
                out.tr((Object)((Thumb)t).file.getFilePath(), (Object)("" + ((Thumb)t).loaded), (Object)size);
            }
            out.endTable();
        }

        public int compare(Object a, Object b) {
            return SortUtil.compare((Object)((Thumb)a).file.getFileName(), (Object)((Thumb)b).file.getFileName());
        }
    }

    static class ThumbManagerThread
    extends Thread {
        ThumbManagerThread() {
            super(Nre.mainThreadGroup, "Ui:ThumbManager");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object thumb = null;
                        Object object = dibsLock;
                        synchronized (object) {
                            if (dibs == null) {
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 7, 8] lbl8 : MonitorExitStatement: MONITOREXIT : var2_3
                                thumb = dibsLock;
                                synchronized (thumb) {
                                    dibsLock.wait(10000L);
                                    continue;
                                }
                            }
                            thumb = dibs;
                            dibs = null;
                        }
                        ((Thumb)thumb).load();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

