/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BDirectoryThumbnails;
import com.tridium.raster.viewer.BPicture;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.raster.viewer.Thumb;
import com.tridium.workbench.file.BDirTable;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BPictureGrid
extends BTransferWidget
implements NavListener {
    public static final Property content = BPictureGrid.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$raster$viewer$BPictureGrid == null ? (class$com$tridium$raster$viewer$BPictureGrid = BPictureGrid.class$("com.tridium.raster.viewer.BPictureGrid")) : class$com$tridium$raster$viewer$BPictureGrid));
    static Lexicon lex = Lexicon.make((String)"raster");
    BTitlePane titlePane;
    BGridPane gridPane;
    BScrollPane scroll;
    BIDirectory dir;
    BOrd dirOrd;
    BIFile[] files;
    BPicture[] pictures = new BPicture[0];
    boolean enableEdits = false;
    Selection sel = new Selection();
    boolean checkSelectionOnRelease;
    Command clearCache = new ClearThumbCache((BWidget)this);
    Command refresh = new Refresh((BWidget)this);
    Command rotateLeft = new RotateLeft((BWidget)this);
    Command rotateRight = new RotateRight((BWidget)this);
    Command resize = new Resize((BWidget)this);
    static /* synthetic */ Class class$com$tridium$raster$viewer$BPictureGrid;
    static /* synthetic */ Class class$com$tridium$raster$viewer$BPicture;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPictureGrid() {
        this.gridPane = new BGridPane(5);
        this.gridPane.setValign(BValign.top);
        this.gridPane.setHalign(BHalign.left);
        this.gridPane.setRowGap(10.0);
        this.gridPane.setColumnGap(10.0);
        new WidgetSubscriber(){

            public void mousePressed(BMouseEvent e) {
                BPictureGrid.this.backgroundPressed(e);
            }

            public void mouseReleased(BMouseEvent e) {
                BPictureGrid.this.backgroundReleased(e);
            }
        }.subscribe((BComponent)this.gridPane);
        BBorderPane border = new BBorderPane((BWidget)this.gridPane, BBorder.inset, BInsets.DEFAULT);
        border.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        this.scroll = new BScrollPane((BWidget)border);
        this.titlePane = new BTitlePane("", (BWidget)this.scroll);
        this.titlePane.setTypeName("files");
        this.setContent((BWidget)this.titlePane);
    }

    public void computePreferredSize() {
        BWidget c = this.getContent();
        c.computePreferredSize();
        this.setPreferredSize(c.getPreferredWidth(), c.getPreferredHeight());
    }

    public void doLayout(BWidget[] kids) {
        if (this.gridPane != null) {
            int col = (int)((this.getWidth() - 20.0) / 100.0) - 1;
            if (col < 5) {
                col = 5;
            }
            this.gridPane.setColumnCount(col);
        }
        BWidget c = this.getContent();
        c.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void load(BIDirectory dir) {
        this.dir = dir;
        this.dirOrd = dir.getNavOrd();
        this.files = dir.listFiles();
        this.titlePane.setTitle(dir.getNavName());
        this.titlePane.setCount(this.files.length);
        this.enableEdits = false;
        if (dir instanceof BDirectory) {
            this.enableEdits = !((BDirectory)dir).isReadonly();
        }
        for (int i = 0; i < this.pictures.length; ++i) {
            this.pictures[i].grid = null;
        }
        BPicture[] p = new BPicture[this.files.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new BPicture(this, this.files[i]);
        }
        this.rebuildGrid(p);
        this.updateTransferCommands();
    }

    public void refresh() {
        BIFile[] files = this.dir.listFiles();
        BPicture[] newPics = new BPicture[files.length];
        BPicture[] oldPics = this.pictures;
        int n = 0;
        this.titlePane.setCount(files.length);
        block0: for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getFileName();
            for (int j = 0; j < oldPics.length; ++j) {
                if (!filename.equals(oldPics[j].file.getFileName())) continue;
                files[i] = null;
                newPics[n++] = oldPics[j];
                continue block0;
            }
        }
        int selectStart = n;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            newPics[n++] = new BPicture(this, files[i]);
        }
        this.rebuildGrid(newPics);
        this.sel.deselectAll();
        if (selectStart < newPics.length) {
            this.sel.select(selectStart, this.pictures.length - 1);
        }
    }

    void rebuildGrid(BPicture[] p) {
        int i;
        for (i = 0; i < p.length; ++i) {
            p[i].index = i;
        }
        this.pictures = p;
        this.gridPane.removeAll();
        for (i = 0; i < p.length; ++i) {
            this.gridPane.add("p" + i, (BValue)p[i]);
        }
        this.relayout();
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent event) {
        if (this.dirOrd != null && this.dirOrd.equals((Object)event.getParentOrd())) {
            this.refresh();
        }
    }

    public void backgroundPressed(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup(null, event);
        } else if (!event.isButton3Down()) {
            this.sel.deselectAll();
        }
    }

    public void backgroundReleased(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup(null, event);
        }
    }

    public void mouseEntered(BPicture picture, BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(picture.toStatusString());
        }
    }

    public void mouseExited(BPicture picture, BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus("");
        }
    }

    public void mousePressed(BPicture picture, BMouseEvent event) {
        if (event.isButton2Down()) {
            return;
        }
        if (picture.selected) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(picture, event);
        }
        if (event.isPopupTrigger()) {
            this.popup(picture, event);
        }
        if (event.isButton1Down() && event.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.doubleClicked(picture, event);
        }
    }

    public void mouseReleased(BPicture picture, BMouseEvent event) {
        if (event.isButton2Down()) {
            return;
        }
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!event.isPopupTrigger()) {
                this.checkSelection(picture, event);
            }
        }
        if (event.isPopupTrigger()) {
            this.popup(picture, event);
        }
    }

    void checkSelection(BPicture picture, BMouseEvent event) {
        int index = picture.index;
        if (event.isShiftDown() && event.isButton1Down()) {
            if (this.sel.getAnchor() == -1) {
                this.sel.select(0);
            }
            this.sel.select(this.sel.getAnchor(), index, !event.isControlDown());
        } else if (event.isControlDown()) {
            if (this.sel.isSelected(index)) {
                this.sel.deselect(index);
            } else {
                this.sel.select(index);
            }
        } else {
            this.sel.select(index, true);
        }
    }

    void popup(BPicture picture, BMouseEvent event) {
        Subject subject = this.getSubject(picture != null ? picture.file : null);
        BMenu menu = BDirTable.makeDirPopup((BTransferWidget)this, (BIDirectory)this.dir, (Subject)subject, (boolean)this.enableEdits);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, this.refresh);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, this.rotateLeft);
        menu.add(null, this.rotateRight);
        menu.add(null, this.resize);
        menu.removeConsecutiveSeparators();
        menu.open(event);
    }

    void doubleClicked(BPicture picture, BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell instanceof BWbShell) {
            BIFile node = picture.file;
            BOrd ord = node.getNavOrd();
            if (node instanceof BIDirectory) {
                ord = BOrd.make((BOrd)ord, (String)("view:" + BDirectoryThumbnails.TYPE.toString()));
            }
            ((BWbShell)shell).hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    public void updateTransferCommands() {
        BIFile[] files = this.getSelectedFiles();
        int count = files.length;
        boolean filesEditable = true;
        for (int i = 0; i < count; ++i) {
            if (!files[i].isReadonly()) continue;
            filesEditable = false;
            break;
        }
        this.setCutEnabled(count > 0 && filesEditable && this.enableEdits);
        this.setCopyEnabled(count > 0);
        this.setPasteEnabled(this.enableEdits);
        this.setDuplicateEnabled(count > 0 && this.enableEdits);
        this.setDeleteEnabled(count > 0 && filesEditable && this.enableEdits);
        this.setRenameEnabled(count > 0 && filesEditable && this.enableEdits);
        this.rotateLeft.setEnabled(count > 0 && filesEditable && this.enableEdits);
        this.rotateRight.setEnabled(count > 0 && filesEditable && this.enableEdits);
        this.resize.setEnabled(count > 0 && filesEditable && this.enableEdits);
        this.refresh.setEnabled(count > 0);
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return TransferUtil.insert((BWidget)this, (TransferContext)cx, (BObject)((BObject)this.dir), null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.delete((BWidget)this, (Mark)mark);
    }

    public CommandArtifact doRename() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.rename((BWidget)this, (Mark)mark);
    }

    void refreshSelection() {
        BPicture[] pictures = this.getSelectedPictures();
        for (int i = 0; i < pictures.length; ++i) {
            pictures[i].refresh();
        }
        this.repaint();
    }

    void rotateSelection(int angle) {
        BIFile[] files = this.getSelectedFiles();
        if (files.length == 0) {
            return;
        }
        ImageUtil.process((BWidget)this, files, new ImageUtil.Rotate(angle));
        this.refreshSelection();
    }

    void resizeSelection() {
        BIFile[] files = this.getSelectedFiles();
        BPicture[] pictures = this.getSelectedPictures();
        if (files.length == 0) {
            return;
        }
        for (int i = 0; i < pictures.length; ++i) {
            Thumb t = pictures[i].thumb;
            if (t.isLoaded()) continue;
            BDialog.error((BWidget)this, (Object)"Not all selected images have been loaded yet");
            return;
        }
        double curw = pictures[0].thumb.getOrigWidth();
        double curh = pictures[0].thumb.getOrigHeight();
        for (int i = 0; i < pictures.length; ++i) {
            Thumb t = pictures[i].thumb;
            if (t.getOrigWidth() == curw && t.getOrigHeight() == curh) continue;
            BDialog.error((BWidget)this, (Object)("All images must be same size as first (" + t.file.getFileName() + ")"));
            return;
        }
        ImageUtil.ResizeInput in = new ImageUtil.ResizeInput((int)curw, (int)curh);
        int r = BDialog.open((BWidget)this, (String)"Resize", (Object)in.getContent(), (int)3);
        if (r != 1) {
            return;
        }
        int w = in.getWidth();
        int h = in.getHeight();
        ImageUtil.process((BWidget)this, files, new ImageUtil.Resize(w, h));
        this.refreshSelection();
    }

    public BPicture[] getSelectedPictures() {
        Array a = new Array(class$com$tridium$raster$viewer$BPicture == null ? (class$com$tridium$raster$viewer$BPicture = BPictureGrid.class$("com.tridium.raster.viewer.BPicture")) : class$com$tridium$raster$viewer$BPicture);
        for (int i = 0; i < this.pictures.length; ++i) {
            if (!this.pictures[i].selected) continue;
            a.add((Object)this.pictures[i]);
        }
        return (BPicture[])a.trim();
    }

    public BIFile[] getSelectedFiles() {
        Array a = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = BPictureGrid.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
        for (int i = 0; i < this.pictures.length; ++i) {
            if (!this.pictures[i].selected) continue;
            a.add((Object)this.pictures[i].file);
        }
        return (BIFile[])a.trim();
    }

    public Mark getSelectedFilesAsMark() {
        if (this.dir == null) {
            return null;
        }
        BIFile[] f = this.getSelectedFiles();
        if (f.length == 0) {
            return null;
        }
        String[] names = new String[f.length];
        BObject[] objects = new BObject[f.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = f[i].getFileName();
            objects[i] = (BObject)f[i];
        }
        return new Mark(objects, names);
    }

    public Subject getSubject(BIFile active) {
        return new Subject((Object[])this.getSelectedFiles(), (Object)active);
    }

    public BMenu getViewMenu() {
        BMenu menu = new BMenu(BDirectoryThumbnails.TYPE.getDisplayName(null));
        menu.add(null, this.clearCache);
        menu.add(null, this.refresh);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, this.rotateLeft);
        menu.add(null, this.rotateRight);
        menu.add(null, this.resize);
        return menu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Resize
    extends Command {
        public Resize(BWidget owner) {
            super(owner, lex, "resize");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.resizeSelection();
            return null;
        }
    }

    class RotateRight
    extends Command {
        public RotateRight(BWidget owner) {
            super(owner, lex, "rotateRight");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.rotateSelection(90);
            return null;
        }
    }

    class RotateLeft
    extends Command {
        public RotateLeft(BWidget owner) {
            super(owner, lex, "rotateLeft");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.rotateSelection(270);
            return null;
        }
    }

    class Refresh
    extends Command {
        public Refresh(BWidget owner) {
            super(owner, lex, "refresh");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.refreshSelection();
            return null;
        }
    }

    class ClearThumbCache
    extends Command {
        public ClearThumbCache(BWidget owner) {
            super(owner, lex, "clearThumbCache");
        }

        public CommandArtifact doInvoke() {
            int s = BDialog.confirm((BWidget)this.getOwner(), (String)this.getLabel(), (Object)"Clear thumbnail cache?");
            if (s != 4) {
                return null;
            }
            Thumb.clearCache();
            BPictureGrid.this.repaint();
            return null;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            for (int i = 0; i < BPictureGrid.this.pictures.length; ++i) {
                BPictureGrid.this.pictures[i].selected = this.isSelected(i);
            }
            BPictureGrid.this.updateTransferCommands();
            BPictureGrid.this.repaint();
        }
    }
}

