/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.codec.png;

import com.tridium.raster.codec.png.Chunk;
import com.tridium.raster.codec.png.FilterType0;
import com.tridium.raster.codec.png.FilterType1;
import com.tridium.raster.codec.png.FilterType2;
import com.tridium.raster.codec.png.FilterType3;
import com.tridium.raster.codec.png.FilterType4;
import com.tridium.raster.codec.png.ImageFormatException;
import com.tridium.raster.codec.png.Util;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;

public class PNGImageEncoder {
    private OutputStream output;
    private Header header = new Header();
    private int currentY = 0;

    public PNGImageEncoder(OutputStream out) {
        this.output = out;
    }

    public void encode(BufferedImage image) throws ImageFormatException, IOException {
        this.header.width = image.getWidth();
        this.header.height = image.getHeight();
        this.header.bitDepth = (byte)8;
        this.header.colorType = (byte)(image.getType() == 13 ? 3 : 2);
        this.header.compressMethod = 0;
        this.header.filterMethod = 0;
        this.header.interlaceMethod = 0;
        this.writeSignature();
        this.writeChunk(this.createHeaderChunk(image));
        if (this.header.colorType == 3) {
            this.writeChunk(this.createPaletteChunk(image));
            if (image.getColorModel().hasAlpha()) {
                this.writeChunk(this.createTransChunk(image));
            }
        }
        this.writeChunk(this.createDataChunk(image));
        this.writeChunk(this.createEndChunk());
    }

    private void writeSignature() throws IOException {
        byte[] sig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.output.write(sig);
    }

    private void writeChunk(Chunk chunk) throws IOException {
        int crcByteSize = chunk.getData() == null ? 4 : 4 + chunk.getData().length;
        byte[] crcBytes = new byte[crcByteSize];
        byte[] temp = new byte[4];
        Util.IntToByte(temp, chunk.getLength(), 0);
        this.output.write(temp);
        Util.IntToByte(temp, chunk.getType(), 0);
        this.output.write(temp);
        for (int i = 0; i < 4; ++i) {
            crcBytes[i] = temp[i];
        }
        if (chunk.getData() != null) {
            byte[] data = chunk.getData();
            this.output.write(data);
            for (int i = 0; i < data.length; ++i) {
                crcBytes[4 + i] = data[i];
            }
        }
        CRC32 crc = new CRC32();
        crc.update(crcBytes);
        Util.IntToByte(temp, (int)crc.getValue(), 0);
        this.output.write(temp);
    }

    private Chunk createHeaderChunk(BufferedImage image) {
        byte[] data = new byte[13];
        Util.IntToByte(data, this.header.width, 0);
        Util.IntToByte(data, this.header.height, 4);
        data[8] = this.header.bitDepth;
        data[9] = this.header.colorType;
        data[10] = this.header.compressMethod;
        data[11] = this.header.filterMethod;
        data[12] = this.header.interlaceMethod;
        return new Chunk(data.length, 1229472850, data, 0);
    }

    public Chunk createPaletteChunk(BufferedImage image) {
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        int size = icm.getMapSize();
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        icm.getReds(red);
        icm.getGreens(green);
        icm.getBlues(blue);
        byte[] data = new byte[size * 3];
        for (int i = 0; i < size; ++i) {
            data[i * 3] = red[i];
            data[i * 3 + 1] = green[i];
            data[i * 3 + 2] = blue[i];
        }
        return new Chunk(data.length, 1347179589, data, 0);
    }

    public Chunk createTransChunk(BufferedImage image) {
        byte[] data;
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        byte[] alpha = new byte[icm.getMapSize()];
        icm.getAlphas(alpha);
        int transIndex = icm.getTransparentPixel();
        if (transIndex != -1) {
            data = new byte[transIndex + 1];
            int i = 0;
            while (i != transIndex) {
                data[i++] = -1;
            }
            data[i] = 0;
        } else {
            data = alpha;
        }
        System.out.println(transIndex);
        System.out.println(Integer.toHexString(icm.getRGB(0)));
        if (transIndex >= 0) {
            System.out.println(Integer.toHexString(icm.getRGB(transIndex)));
        }
        for (int x = 0; x < data.length; ++x) {
            System.out.print(Integer.toHexString(data[x]) + " ");
        }
        return new Chunk(data.length, 1951551059, data, 0);
    }

    private Chunk createEndChunk() {
        return new Chunk(0, 1229278788, null, 0);
    }

    public Chunk createDataChunk(BufferedImage image) throws IOException {
        int sampleSize = image.getSampleModel().getNumBands();
        int[] sum = new int[5];
        byte[] scanLine = new byte[this.header.width * sampleSize];
        byte[] prevScanLine = new byte[scanLine.length];
        byte[] filteredScanLine = new byte[this.header.width * sampleSize + 1];
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(byteArray);
        WritableRaster raster = image.getRaster();
        Arrays.fill(prevScanLine, (byte)0);
        for (int j = 0; j < image.getHeight(); ++j) {
            int i;
            int i2;
            int[] sample = new int[sampleSize];
            for (int x = 0; x <= scanLine.length - sampleSize; x += sampleSize) {
                raster.getPixel(x / sampleSize, this.currentY, sample);
                for (int z = 0; z < sampleSize; ++z) {
                    scanLine[x + z] = (byte)(0xFF & sample[z]);
                }
            }
            filteredScanLine = FilterType0.filter(scanLine, prevScanLine);
            for (i2 = 1; i2 < filteredScanLine.length; ++i2) {
                sum[0] = sum[0] + Math.abs(filteredScanLine[i2]);
            }
            filteredScanLine = FilterType1.filter(scanLine, prevScanLine);
            for (i2 = 1; i2 < filteredScanLine.length; ++i2) {
                sum[1] = sum[1] + Math.abs(filteredScanLine[i2]);
            }
            filteredScanLine = FilterType2.filter(scanLine, prevScanLine);
            for (i2 = 1; i2 < filteredScanLine.length; ++i2) {
                sum[2] = sum[2] + Math.abs(filteredScanLine[i2]);
            }
            filteredScanLine = FilterType3.filter(scanLine, prevScanLine);
            for (i2 = 1; i2 < filteredScanLine.length; ++i2) {
                sum[3] = sum[3] + Math.abs(filteredScanLine[i2]);
            }
            filteredScanLine = FilterType4.filter(scanLine, prevScanLine);
            for (i2 = 1; i2 < filteredScanLine.length; ++i2) {
                sum[4] = sum[4] + Math.abs(filteredScanLine[i2]);
            }
            int optimalFilter = 0;
            int minValue = sum[0];
            for (i = 1; i < 5; ++i) {
                if (sum[i] >= minValue) continue;
                minValue = sum[i];
                optimalFilter = i;
            }
            if (this.header.colorType == 3) {
                optimalFilter = 0;
            }
            switch (optimalFilter) {
                case 0: {
                    filteredScanLine = FilterType0.filter(scanLine, prevScanLine);
                    break;
                }
                case 1: {
                    filteredScanLine = FilterType1.filter(scanLine, prevScanLine);
                    break;
                }
                case 2: {
                    filteredScanLine = FilterType2.filter(scanLine, prevScanLine);
                    break;
                }
                case 3: {
                    filteredScanLine = FilterType3.filter(scanLine, prevScanLine);
                    break;
                }
                case 4: {
                    filteredScanLine = FilterType4.filter(scanLine, prevScanLine);
                }
            }
            for (i = 0; i < scanLine.length; ++i) {
                prevScanLine[i] = scanLine[i];
            }
            deflater.write(filteredScanLine, 0, filteredScanLine.length);
            ++this.currentY;
        }
        deflater.close();
        byte[] data = byteArray.toByteArray();
        return new Chunk(data.length, 1229209940, data, 0);
    }

    private class Header {
        public int width = 0;
        public int height = 0;
        public byte bitDepth = 0;
        public byte colorType = 0;
        public byte compressMethod = 0;
        public byte filterMethod = 0;
        public byte interlaceMethod = 0;

        private Header() {
        }
    }
}

