/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.codec.png;

import com.tridium.raster.codec.png.Chunk;
import com.tridium.raster.codec.png.FilterType0;
import com.tridium.raster.codec.png.FilterType1;
import com.tridium.raster.codec.png.FilterType2;
import com.tridium.raster.codec.png.FilterType3;
import com.tridium.raster.codec.png.FilterType4;
import com.tridium.raster.codec.png.ImageFormatException;
import com.tridium.raster.codec.png.Util;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGImageDecoder {
    private static final int COLOR_TYPE_PALETTED = 3;
    private InputStream source;
    private Header header = new Header();
    private int currentY = 0;

    public PNGImageDecoder(InputStream src) {
        this.source = src;
    }

    public BufferedImage decode() throws ImageFormatException, IOException {
        BufferedImage image = null;
        Chunk palChunk = null;
        Chunk transChunk = null;
        if (!this.isSignatureValid()) {
            throw new ImageFormatException("Invalid signature");
        }
        Chunk chunk = this.readChunk();
        if (chunk.getType() != 1229472850) {
            throw new ImageFormatException("No IHDR chunk");
        }
        this.getHeaderParams(chunk.getData());
        chunk = this.readChunk();
        while (chunk.getType() != 1229278788) {
            if (chunk.getType() == 1347179589) {
                palChunk = chunk;
            } else if (chunk.getType() == 1951551059) {
                transChunk = chunk;
            } else if (chunk.getType() == 1229209940) {
                if (this.header.colorType == 3) {
                    IndexColorModel cm = this.loadPalette(palChunk, transChunk);
                    image = new BufferedImage(this.header.width, this.header.height, 13, cm);
                } else {
                    image = new BufferedImage(this.header.width, this.header.height, 1);
                }
                this.appendDataToImage(image, chunk.getData());
            } else if (chunk.isCritical()) {
                throw new ImageFormatException("Unknown critical chunk");
            }
            chunk = this.readChunk();
        }
        return image;
    }

    private boolean isSignatureValid() throws IOException {
        int[] ref = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        byte[] sig = new byte[ref.length];
        this.source.read(sig, 0, ref.length);
        for (int i = 0; i < ref.length; ++i) {
            if ((0xFF & sig[i]) == ref[i]) continue;
            return false;
        }
        return true;
    }

    private Chunk readChunk() throws IOException {
        byte[] buf = new byte[4];
        this.source.read(buf, 0, 4);
        int length = Util.BytesToInt(0, buf);
        this.source.read(buf, 0, 4);
        int type = Util.BytesToInt(0, buf);
        byte[] data = new byte[length];
        this.source.read(data, 0, length);
        this.source.read(buf, 0, 4);
        int crc = Util.BytesToInt(0, buf);
        byte[] crcBytes = new byte[4 + length];
        Util.IntToByte(crcBytes, type, 0);
        for (int i = 0; i < length; ++i) {
            crcBytes[4 + i] = data[i];
        }
        CRC32 crc32 = new CRC32();
        crc32.update(crcBytes);
        if ((int)crc32.getValue() != crc) {
            throw new ImageFormatException("CRC corruption in: ChunkType: " + type);
        }
        return new Chunk(length, type, data, crc);
    }

    private void getHeaderParams(byte[] data) {
        this.header.width = Util.BytesToInt(0, data);
        this.header.height = Util.BytesToInt(4, data);
        this.header.bitDepth = 0xFF & data[8];
        this.header.colorType = 0xFF & data[9];
        this.header.compressMethod = 0xFF & data[10];
        this.header.filterMethod = 0xFF & data[11];
        this.header.interlaceMethod = 0xFF & data[12];
    }

    public IndexColorModel loadPalette(Chunk palChunk, Chunk transChunk) {
        int i;
        if (palChunk.getLength() % 3 != 0) {
            throw new ImageFormatException("Invalid PLTE length (not divisible by 3):" + palChunk.getLength());
        }
        byte[] palData = palChunk.getData();
        int palSize = palChunk.getLength() / 3;
        byte[] transData = transChunk == null ? null : transChunk.getData();
        int transSize = transChunk == null ? 0 : transChunk.getLength();
        int transIndex = -1;
        byte[] alpha = new byte[palSize];
        byte[] red = new byte[palSize];
        byte[] green = new byte[palSize];
        byte[] blue = new byte[palSize];
        Arrays.fill(alpha, (byte)-1);
        for (i = 0; i < palSize; ++i) {
            if (transData != null && i < transSize) {
                alpha[i] = transData[i];
            }
            red[i] = palData[i * 3];
            green[i] = palData[i * 3 + 1];
            blue[i] = palData[i * 3 + 2];
        }
        for (i = 0; i < transSize; ++i) {
            if (transData[i] == 255 || transIndex != -1) continue;
            if (transData[i] == 0) {
                transIndex = i;
                continue;
            }
            transIndex = -1;
            break;
        }
        if (transData == null) {
            return new IndexColorModel(8, palSize, red, green, blue);
        }
        if (transIndex != -1) {
            return new IndexColorModel(8, palSize, red, green, blue, transIndex);
        }
        return new IndexColorModel(8, palSize, red, green, blue, alpha);
    }

    public void appendDataToImage(BufferedImage image, byte[] data) {
        int sampleSize = this.header.colorType == 3 ? 1 : 3;
        byte[] scanLine = new byte[this.header.width * sampleSize + 1];
        byte[] prevScanLine = new byte[this.header.width * sampleSize];
        byte[] newData = new byte[(this.header.width * sampleSize + 1) * this.header.height];
        try {
            Inflater inflate = new Inflater();
            inflate.setInput(data);
            inflate.inflate(newData);
        }
        catch (DataFormatException e) {
            throw new ImageFormatException("Corrupt image data; " + e);
        }
        WritableRaster raster = image.getRaster();
        Arrays.fill(prevScanLine, (byte)0);
        for (int j = 0; j < newData.length; j += this.header.width * sampleSize + 1) {
            for (int i = 0; i < scanLine.length; ++i) {
                scanLine[i] = newData[j + i];
            }
            if (scanLine[0] == 0) {
                prevScanLine = FilterType0.reverseFilter(scanLine, prevScanLine);
            } else if (scanLine[0] == 1) {
                prevScanLine = FilterType1.reverseFilter(scanLine, prevScanLine);
            } else if (scanLine[0] == 2) {
                prevScanLine = FilterType2.reverseFilter(scanLine, prevScanLine);
            } else if (scanLine[0] == 3) {
                prevScanLine = FilterType3.reverseFilter(scanLine, prevScanLine);
            } else if (scanLine[0] == 4) {
                prevScanLine = FilterType4.reverseFilter(scanLine, prevScanLine);
            } else {
                throw new ImageFormatException("Unknown filter type: " + scanLine[0]);
            }
            for (int x = 0; x < scanLine.length - sampleSize; x += sampleSize) {
                int[] sample;
                if (this.header.colorType == 3) {
                    sample = new int[]{prevScanLine[x]};
                    raster.setPixel(x, this.currentY, sample);
                    continue;
                }
                sample = new int[]{prevScanLine[x], prevScanLine[x + 1], prevScanLine[x + 2]};
                raster.setPixel(x / 3, this.currentY, sample);
            }
            ++this.currentY;
        }
    }

    private class Header {
        public int width = 0;
        public int height = 0;
        public int bitDepth = 0;
        public int colorType = 0;
        public int compressMethod = 0;
        public int filterMethod = 0;
        public int interlaceMethod = 0;

        private Header() {
        }
    }
}

