/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.user;

import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.user.BUserPasswordConfiguration;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BUserChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$fox$sys$user$BUserChannel == null ? (class$com$tridium$fox$sys$user$BUserChannel = BUserChannel.class$("com.tridium.fox.sys.user.BUserChannel")) : class$com$tridium$fox$sys$user$BUserChannel));
    private BOrd homePage;
    private BOrd navFile;
    private BPasswordStrength passwordStrength;
    static /* synthetic */ Class class$com$tridium$fox$sys$user$BUserChannel;

    public Type getType() {
        return TYPE;
    }

    public BUserChannel() {
        super("user");
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "fetchPrefs") {
            return this.fetchPrefs(foxRequest);
        }
        if (string == "setPassword") {
            return this.setPassword(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public BOrd getHomePage() {
        return this.homePage;
    }

    public BOrd getNavFile() {
        return this.navFile;
    }

    public BPasswordStrength getPasswordStrength() {
        return this.passwordStrength;
    }

    public void fetchPrefs() throws Exception {
        FoxResponse foxResponse = this.sendSync(this.makeRequest("fetchPrefs"));
        this.homePage = BOrd.make((String)foxResponse.getString("homePage"));
        this.navFile = BOrd.make((String)foxResponse.getString("navFile"));
        this.passwordStrength = new BPasswordStrength(foxResponse.getInt("minLength", 8), foxResponse.getInt("minLowerCase", 0), foxResponse.getInt("minUpperCase", 0), foxResponse.getInt("minDigits", 1), foxResponse.getInt("minSpecial", 0));
    }

    private FoxResponse fetchPrefs(FoxRequest foxRequest) throws Exception {
        BUser bUser = this.getServerConnection().getUser();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("homePage", bUser.getHomePage().toString());
        foxResponse.add("navFile", bUser.getNavFile().toString());
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BPasswordStrength bPasswordStrength = bUserService.getPasswordStrength();
        foxResponse.add("minLength", bPasswordStrength.getMinimumLength());
        foxResponse.add("minDigits", bPasswordStrength.getMinimumDigits());
        foxResponse.add("minUpperCase", bPasswordStrength.getMinimumUpperCase());
        foxResponse.add("minLowerCase", bPasswordStrength.getMinimumLowerCase());
        foxResponse.add("minSpecial", bPasswordStrength.getMinimumSpecial());
        return foxResponse;
    }

    public void setPassword(BPassword bPassword) throws Exception {
        this.setPassword(bPassword, false);
    }

    public void setPassword(BPassword bPassword, boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest("setPassword");
        foxRequest.add("password", bPassword.encodeToString());
        foxRequest.add("forceChange", bl);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("err", null);
        if (string != null) {
            throw new BajaRuntimeException(string);
        }
    }

    private FoxResponse setPassword(FoxRequest foxRequest) throws Exception {
        try {
            BUserPasswordConfiguration bUserPasswordConfiguration;
            BUser bUser = this.getServerConnection().getUser();
            BPassword bPassword = (BPassword)BPassword.DEFAULT.decodeFromString(foxRequest.getString("password"));
            if (bUser.getPassword().validate(bPassword.getValue()) && foxRequest.getBoolean("forceChange", false)) {
                throw new LocalizableException(Lexicon.make((String)"baja"), "user.strongPassword.alreadyUsed");
            }
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            bUserService.checkPassword(bPassword.getValue());
            if (bUserService.canUsePasswordFeatures(bUser) && (bUserPasswordConfiguration = bUserService.getUserPasswordConfig(bUser)) != null) {
                if (bUserService.isDuplicatePassword(bPassword.getValue(), bUser)) {
                    throw new LocalizableException(Lexicon.make((String)"baja"), "user.strongPassword.alreadyUsed");
                }
                bUserPasswordConfiguration.setForceResetAtNextLogin(false);
            }
            bUser.setPassword(bPassword);
            return new FoxResponse(foxRequest);
        }
        catch (Exception exception) {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            foxResponse.add("err", exception.getMessage());
            return foxResponse;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

