/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.spy;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.util.ThrowableUtil;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.log.Log;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class FoxLog {
    static int nextWhoId = 0;
    static final int SERVER = 1;
    static final int ERROR = 3;
    static final int WARNING = 2;
    static final int MESSAGE = 1;
    static final int TRACE = 0;
    static final int OPENED = 10;
    static final int CLOSED = 11;
    static final int REJECTED = 12;
    static DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    static Object lock = new Object();
    static final int max;
    static int size;
    static Rec head;
    static Rec tail;
    static HashMap whoHistory;
    Log log;
    String logName;
    FoxSession session;

    public static FoxLog make(String string) {
        return new FoxLog(Log.getLog((String)string));
    }

    public Log log() {
        return this.log;
    }

    public String getLogName() {
        return this.logName;
    }

    public boolean isTraceOn() {
        return this.log.isTraceOn();
    }

    public void error(String string) {
        this.log(3, string, null);
    }

    public void error(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    public void warning(String string) {
        this.log(2, string, null);
    }

    public void warning(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }

    public void message(String string) {
        this.log(1, string, null);
    }

    public void message(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    public void trace(String string) {
        this.log(0, string, null);
    }

    public void trace(String string, Throwable throwable) {
        this.log(0, string, throwable);
    }

    public void log(int n, String string, Throwable throwable) {
        if (this.log.isLoggable(n)) {
            this.log.log(n, string, throwable);
            FoxLog.add(new Rec(n, this.session, this.logName, string, throwable));
        }
    }

    public void logRecOnly(int n, String string) {
        if (this.log.isLoggable(n)) {
            FoxLog.add(new Rec(n, this.session, this.logName, string, null));
        }
    }

    public FoxSession session() {
        return this.session;
    }

    public void setSession(FoxSession foxSession) {
        this.session = foxSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void opened(FoxSession foxSession) {
        this.session = foxSession;
        String string = "Opened: " + FoxLog.toString(foxSession);
        if (!FoxLog.stationToStationConnection(foxSession)) {
            this.log.message(string);
        } else if (this.log.isTraceOn()) {
            this.log.trace(string);
        }
        FoxLog.add(new Rec(10, foxSession, this.logName, string, null));
        String string2 = FoxLog.toWho(foxSession);
        Object object = lock;
        synchronized (object) {
            Who who = (Who)whoHistory.get(string2);
            if (who == null) {
                who = new Who(string2);
                whoHistory.put(string2, who);
            }
            who.opened(foxSession);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closed(FoxSession foxSession, Throwable throwable) {
        block10: {
            String string;
            int n;
            if (this.session == foxSession) {
                n = 11;
                string = "Closed: " + FoxLog.toString(foxSession);
            } else {
                n = 12;
                string = "Rejected: " + FoxLog.toString(foxSession);
            }
            if (!FoxLog.stationToStationConnection(foxSession)) {
                this.log.message(string);
            } else if (this.log.isTraceOn()) {
                this.log.trace(string);
            }
            FoxLog.add(new Rec(n, foxSession, this.logName, string, throwable));
            String string2 = FoxLog.toWho(foxSession);
            Object object = lock;
            synchronized (object) {
                Who who;
                block9: {
                    who = (Who)whoHistory.get(string2);
                    if (who == null) {
                        who = new Who(string2);
                        whoHistory.put(string2, who);
                    }
                    if (n != 11) break block9;
                    who.closed(foxSession);
                    break block10;
                }
                who.rejected(foxSession);
            }
        }
        this.session = null;
    }

    public static String toWho(FoxSession foxSession) {
        if (foxSession == null) {
            return "null";
        }
        try {
            String string;
            FoxMessage foxMessage = foxSession.getRemoteHello();
            if (foxMessage == null) {
                foxMessage = new FoxMessage();
                try {
                    string = foxSession.getSocket().getInetAddress().toString();
                }
                catch (NullPointerException nullPointerException) {
                    string = "unknown";
                }
            } else {
                string = foxMessage.getString("hostName", "unknown");
            }
            String string2 = foxMessage.getString("app.name", "unknown");
            String string3 = foxMessage.getString("station.name", null);
            String string4 = foxMessage.getString("user", null);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            if (string3 != null) {
                stringBuffer.append(" [").append(string3).append("]");
            } else if (string4 != null) {
                stringBuffer.append(" [").append(string4).append("]");
            }
            stringBuffer.append(" @ ").append(string);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "err";
        }
    }

    public static String toString(FoxSession foxSession) {
        if (foxSession == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(foxSession.getId());
        stringBuffer.append(foxSession.isServer() ? " <- " : " -> ");
        stringBuffer.append(foxSession.getRemoteId());
        stringBuffer.append(" :: ");
        stringBuffer.append(FoxLog.toWho(foxSession));
        return stringBuffer.toString();
    }

    static String toTime(long l) {
        if (l <= 0L) {
            return "null";
        }
        return format.format(new Date(Clock.millis() - Clock.ticks() + l));
    }

    static String toAge(long l) {
        return BRelTime.toString((long)(Clock.ticks() - l));
    }

    static String toDuration(long l) {
        return BRelTime.toString((long)l);
    }

    static boolean stationToStationConnection(FoxSession foxSession) {
        try {
            String string = foxSession.getRemoteHello().getString("app.name", "");
            boolean bl = false;
            if (string.equals("Station") && string.equals(Fox.appName)) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static void header(SpyWriter spyWriter) {
        spyWriter.w((Object)"\n");
        spyWriter.w((Object)Fox.appName).w((Object)" ").w((Object)Fox.appVersion);
        if (Sys.getStation() != null) {
            spyWriter.w((Object)(" [" + Sys.getStation().getStationName() + ']'));
        }
        spyWriter.w((Object)(" | " + FoxLog.toTime(Clock.ticks())));
        spyWriter.w((Object)" | <a href='/fox/log'>Log Index</a>");
        spyWriter.w((Object)(" | <a href='/fox/log/all'>All Records [" + size + "]</a>"));
        spyWriter.w((Object)"<hr>\n");
    }

    static Who findWho(int n) {
        Iterator iterator = whoHistory.values().iterator();
        while (iterator.hasNext()) {
            Who who = (Who)iterator.next();
            if (who.id != n) continue;
            return who;
        }
        return null;
    }

    static Rec findRec(int n) {
        Rec rec = head;
        while (rec != null) {
            if (rec.id == n) {
                return rec;
            }
            rec = rec.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void add(Rec rec) {
        Object object = lock;
        synchronized (object) {
            block5: {
                while (true) {
                    if (size < max) {
                        if (head != null) break;
                        head = tail = rec;
                        break block5;
                    }
                    head = FoxLog.head.next;
                    --size;
                }
                rec.id = FoxLog.tail.id + 1;
                FoxLog.tail.next = rec;
                tail = rec;
            }
            ++size;
            return;
        }
    }

    static String typeToString(int n) {
        switch (n) {
            case 3: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Message";
            }
            case 0: {
                return "Trace";
            }
            case 10: {
                return "Opened";
            }
            case 11: {
                return "Closed";
            }
            case 12: {
                return "Rejected";
            }
        }
        return "?" + n + '?';
    }

    private FoxLog(Log log) {
        this.log = log;
        this.logName = log.getLogName();
    }

    static {
        int n = 1000;
        try {
            n = Integer.parseInt(System.getProperty("niagara.fox.logMax", "" + n));
        }
        catch (Exception exception) {}
        max = n;
        whoHistory = new HashMap();
        FoxLog.add(new Rec(1, null, "fox", "Booted", null));
    }

    static class Rec
    extends Spy {
        Rec next;
        int id;
        long ticks = Clock.ticks();
        int sessionId;
        int type;
        String logName;
        String msg;
        Throwable ex;

        public void write(SpyWriter spyWriter) throws Exception {
            FoxLog.header(spyWriter);
            spyWriter.startProps("Fox Log Record");
            spyWriter.prop((Object)"Id", (Object)("" + this.id));
            spyWriter.prop((Object)"Time", (Object)FoxLog.toTime(this.ticks));
            spyWriter.prop((Object)"Age", (Object)FoxLog.toAge(this.ticks));
            spyWriter.prop((Object)"Session", this.sessionId);
            spyWriter.prop((Object)"Type", (Object)FoxLog.typeToString(this.type));
            spyWriter.prop((Object)"LogName", (Object)this.logName);
            spyWriter.prop((Object)"Message", (Object)this.msg);
            spyWriter.endProps();
            if (this.ex != null) {
                spyWriter.w((Object)"<pre>");
                ThrowableUtil.dump((Writer)spyWriter, (Throwable)this.ex);
                spyWriter.w((Object)"</pre>");
            }
        }

        Rec(int n, FoxSession foxSession, String string, String string2, Throwable throwable) {
            this.type = n;
            this.sessionId = foxSession == null ? -1 : foxSession.getId();
            this.logName = string;
            this.msg = string2;
            this.ex = throwable;
        }
    }

    static class Who {
        int id = nextWhoId++;
        String key;
        int[] sessionIds;
        int[] remoteIds;
        long[] openTicks;
        long[] closeTicks;
        byte[] flags;

        void opened(FoxSession foxSession) {
            System.arraycopy(this.sessionIds, 0, this.sessionIds, 1, this.sessionIds.length - 1);
            System.arraycopy(this.remoteIds, 0, this.remoteIds, 1, this.remoteIds.length - 1);
            System.arraycopy(this.openTicks, 0, this.openTicks, 1, this.openTicks.length - 1);
            System.arraycopy(this.closeTicks, 0, this.closeTicks, 1, this.closeTicks.length - 1);
            System.arraycopy(this.flags, 0, this.flags, 1, this.flags.length - 1);
            this.sessionIds[0] = foxSession.getId();
            this.remoteIds[0] = foxSession.getRemoteId();
            this.openTicks[0] = Clock.ticks();
            this.closeTicks[0] = -1;
            this.flags[0] = (byte)(foxSession.isServer() ? 1 : 0);
        }

        void closed(FoxSession foxSession) {
            int n = foxSession.getId();
            int n2 = 0;
            while (n2 < this.sessionIds.length) {
                if (this.sessionIds[n2] == n) {
                    this.closeTicks[n2] = Clock.ticks();
                    break;
                }
                ++n2;
            }
        }

        void rejected(FoxSession foxSession) {
            this.opened(foxSession);
            this.closeTicks[0] = Long.MAX_VALUE;
        }

        IntHashMap sessionsToIntHashMap() {
            IntHashMap intHashMap = new IntHashMap();
            int n = 0;
            while (n < this.sessionIds.length) {
                int n2 = this.sessionIds[n];
                if (n2 >= 0) {
                    intHashMap.put(n2, (Object)this);
                }
                ++n;
            }
            return intHashMap;
        }

        public String toString() {
            return this.key;
        }

        Who(String string) {
            this.key = string;
            this.sessionIds = new int[20];
            this.remoteIds = new int[20];
            this.openTicks = new long[20];
            this.closeTicks = new long[20];
            this.flags = new byte[20];
            int n = 0;
            while (n < 20) {
                this.sessionIds[n] = -1;
                ++n;
            }
        }
    }

    static class SpyRecs
    extends SpyDir {
        String title;
        IntHashMap sessions;

        public Spy find(String string) {
            return FoxLog.findRec(Integer.parseInt(string));
        }

        public void write(SpyWriter spyWriter) throws Exception {
            FoxLog.header(spyWriter);
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)this.title, 6);
            spyWriter.w((Object)"<tr><th>Time</th><th>Age</th><th>Sid</th><th>Log</th><th>Message</th><th>Exception</th></tr>\n");
            Rec rec = head;
            while (rec != null) {
                if (this.include(rec)) {
                    spyWriter.w((Object)"<tr");
                    switch (rec.type) {
                        case 3: {
                            spyWriter.w((Object)" bgcolor='#FFAA26'");
                            break;
                        }
                        case 2: {
                            spyWriter.w((Object)" bgcolor='#FFFF00'");
                            break;
                        }
                    }
                    spyWriter.w((Object)">").td((Object)("<a href='" + rec.id + "'>" + FoxLog.toTime(rec.ticks) + "</a>")).td((Object)FoxLog.toAge(rec.ticks)).td((Object)("" + rec.sessionId)).td((Object)rec.logName).w((Object)"<td align='left' nowrap='true'>").safe(rec.msg).w((Object)"</td>").td((Object)(rec.ex == null ? "" : rec.ex.toString()));
                    spyWriter.w((Object)"</tr>\n");
                }
                rec = rec.next;
            }
            spyWriter.endTable();
        }

        boolean include(Rec rec) {
            if (this.sessions == null) {
                return true;
            }
            boolean bl = false;
            if (this.sessions.get(rec.sessionId) != null) {
                bl = true;
            }
            return bl;
        }

        SpyRecs(String string, IntHashMap intHashMap) {
            this.title = string;
            this.sessions = intHashMap;
        }
    }

    static class Index
    extends SpyDir {
        public Spy find(String string) {
            IntHashMap intHashMap;
            String string2;
            if (string.equals("all")) {
                string2 = "All Records";
                intHashMap = null;
            } else if (string.startsWith("byWho-")) {
                Who who = FoxLog.findWho(Integer.parseInt(string.substring(6)));
                string2 = "Records for " + who.key;
                intHashMap = who.sessionsToIntHashMap();
            } else if (string.startsWith("bySession-")) {
                int n = Integer.parseInt(string.substring(10));
                string2 = "Records for FoxSession " + n;
                intHashMap = new IntHashMap();
                intHashMap.put(n, (Object)this);
            } else {
                throw new IllegalStateException();
            }
            return new SpyRecs(string2, intHashMap);
        }

        public void write(SpyWriter spyWriter) throws Exception {
            FoxLog.header(spyWriter);
            Object[] objectArray = whoHistory.values().toArray(new Who[whoHistory.size()]);
            SortUtil.sort((Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Log of who has made fox connections [" + objectArray.length + ']'), 4);
            spyWriter.w((Object)"<tr><th>Session</th><th>Opened</th><th>Closed</th><th>Duration</th></tr>\n");
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                spyWriter.trTitle((Object)("<a href='byWho-" + ((Who)object).id + "'>" + object), 4);
                int n2 = ((Who)object).sessionIds.length - 1;
                while (n2 >= 0) {
                    int n3 = ((Who)object).sessionIds[n2];
                    if (n3 >= 0) {
                        String string;
                        String string2;
                        int n4 = ((Who)object).remoteIds[n2];
                        long l = ((Who)object).openTicks[n2];
                        long l2 = ((Who)object).closeTicks[n2];
                        boolean bl = false;
                        if ((((Who)object).flags[n2] & 1) != 0) {
                            bl = true;
                        }
                        boolean bl2 = bl;
                        String string3 = n3 + (bl2 ? " &lt;- " : " -&gt; ") + n4;
                        boolean bl3 = false;
                        if (l2 <= 0L) {
                            string2 = "Open";
                            string = FoxLog.toDuration(Clock.ticks() - l);
                            bl3 = true;
                        } else if (l2 == Long.MAX_VALUE) {
                            string2 = "Rejected";
                            string = "-";
                        } else {
                            string2 = FoxLog.toTime(l2);
                            string = FoxLog.toDuration(l2 - l);
                        }
                        spyWriter.w((Object)"<tr").w((Object)(bl3 ? " bgcolor='#00ff00'" : "")).w((Object)">").td((Object)("<a href='bySession-" + n3 + "'>" + string3 + "</a>")).td((Object)FoxLog.toTime(l)).td((Object)string2).td((Object)string).w((Object)"</tr>\n");
                    }
                    --n2;
                }
                ++n;
            }
            spyWriter.endTable();
        }

        Index() {
        }
    }
}

