/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.spy;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.fox.sys.spy.FoxSessionSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;

public class FoxIndexSpy
extends SpyDir {
    public Spy find(String string) {
        if (string.equals("log")) {
            return new FoxLog.Index();
        }
        int n = Integer.parseInt(string.substring("session-".length()));
        FoxSession foxSession = Fox.getSession(n);
        return new FoxSessionSpy(foxSession);
    }

    public void write(SpyWriter spyWriter) {
        FoxSession[] foxSessionArray = Fox.getSessions();
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Fox", 2);
        spyWriter.prop((Object)"requestTimeout", Fox.requestTimeout);
        spyWriter.prop((Object)"keepAliveInterval", Fox.keepAliveInterval);
        spyWriter.prop((Object)"soTimeout", Fox.soTimeout);
        spyWriter.prop((Object)"tcpNoDelay", Fox.tcpNoDelay);
        spyWriter.prop((Object)"failsafeTimeouts", Fox.failsafeTimeouts);
        spyWriter.prop((Object)"foxDeadlocks", Fox.deadlocks);
        spyWriter.prop((Object)"maxServerSessions", Fox.maxServerSessions);
        spyWriter.prop((Object)"maxQueueSize", Fox.maxQueueSize);
        spyWriter.prop((Object)"circuitChunkSize", Fox.circuitChunkSize);
        spyWriter.prop((Object)"circuitMaxReceiveBuffer", Fox.circuitMaxReceiveBuffer);
        spyWriter.prop((Object)"hostName", (Object)Fox.hostName);
        spyWriter.prop((Object)"hostAddress", (Object)Fox.hostAddress);
        spyWriter.prop((Object)"app", (Object)(Fox.appName + ' ' + Fox.appVersion));
        spyWriter.prop((Object)"vm", (Object)(Fox.vmName + ' ' + Fox.vmVersion));
        spyWriter.prop((Object)"os", (Object)(Fox.osName + ' ' + Fox.osVersion));
        spyWriter.prop((Object)"exceptionTranslator", (Object)Fox.exceptionTranslator.getClass().getName());
        spyWriter.prop((Object)"engageLinger", (Object)("" + BFoxClientConnection.engageLinger));
        spyWriter.prop((Object)"license.tunneling.fox", Acceptor.foxTunnelingLicensed());
        spyWriter.trTitle((Object)"Fox Log", 2);
        spyWriter.prop((Object)"<a href='log'>Fox Log Index</a>", (Object)("size=" + FoxLog.size));
        spyWriter.trTitle((Object)"Client Sessions", 2);
        int n = 0;
        while (n < foxSessionArray.length) {
            if (!foxSessionArray[n].isServer()) {
                this.prop(spyWriter, foxSessionArray[n]);
            }
            ++n;
        }
        spyWriter.trTitle((Object)("Server Sessions [cached count=" + Fox.getServerSessionCount() + ']'), 2);
        n = 0;
        while (n < foxSessionArray.length) {
            if (foxSessionArray[n].isServer()) {
                this.prop(spyWriter, foxSessionArray[n]);
            }
            ++n;
        }
        spyWriter.trTitle((Object)"Fox Thread Pool Worker", 2);
        spyWriter.endProps();
        BFoxClientConnection.spyThreadPoolWorker(spyWriter);
    }

    private final void prop(SpyWriter spyWriter, FoxSession foxSession) {
        Object object;
        String string = "session-" + foxSession.getId();
        FoxConnection foxConnection = foxSession.conn();
        int n = -1;
        if (foxConnection instanceof BObject && (object = ((BObject)foxConnection).fw(803, null, null, null, null)) instanceof Integer) {
            n = (Integer)object;
        }
        object = n != -1 ? string + "-fw" : string;
        spyWriter.prop((Object)("<a href='" + spyWriter.href(string) + "'>" + (String)object + "</a>"), (Object)foxSession);
    }
}

