/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.file;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.fox.sys.file.FoxFileException;
import com.tridium.sys.transfer.RemoteTransferSpace;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BFoxFileSpace
extends BFileSpace
implements BIDirectory,
BIFoxProxySpace,
RemoteTransferSpace {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$fox$sys$file$BFoxFileSpace == null ? (class$com$tridium$fox$sys$file$BFoxFileSpace = BFoxFileSpace.class$("com.tridium.fox.sys.file.BFoxFileSpace")) : class$com$tridium$fox$sys$file$BFoxFileSpace));
    private BOrd ordInSession = BOrd.make((String)"file:");
    private BIFile[] roots;
    private BIFile stationHome;
    private BFileChannel channel;
    static /* synthetic */ Class class$com$tridium$fox$sys$file$BFoxFileSpace;

    public Type getType() {
        return TYPE;
    }

    public BFoxFileSpace() {
        super("file", LexiconText.make((String)"fox", (String)"nav.fileSystem"));
    }

    public BFoxFileSpace(BFileChannel bFileChannel) {
        this();
        this.channel = bFileChannel;
    }

    public void init(BFoxSession bFoxSession) {
    }

    public void cleanup(BFoxSession bFoxSession) {
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        try {
            BFoxFileStore bFoxFileStore = this.channel().makeDir(this, filePath);
            return new BDirectory((BIFileStore)bFoxFileStore);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FoxFileException(filePath.toString(), exception);
        }
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        try {
            BFoxFileStore bFoxFileStore = this.channel().makeFile(this, filePath);
            return this.makeFile((BIFileStore)bFoxFileStore);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FoxFileException(filePath.toString(), exception);
        }
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        try {
            this.channel().move(this, filePath, filePath2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FoxFileException("" + filePath + "->" + filePath2, exception);
        }
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        try {
            this.channel().delete(this, filePath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FoxFileException(filePath.toString(), exception);
        }
    }

    public BIFile[] listFiles() {
        if (this.roots == null) {
            BFoxFileStore bFoxFileStore = new BFoxFileStore(this, new FilePath("!"));
            BDirectory bDirectory = new BDirectory((BIFileStore)bFoxFileStore, LexiconText.make((String)"baja", (String)"nav.sysHome"));
            bDirectory.setIcon(BIcon.std((String)"home.png"));
            BFoxFileStore bFoxFileStore2 = new BFoxFileStore(this, new FilePath("^"));
            BDirectory bDirectory2 = new BDirectory((BIFileStore)bFoxFileStore2, LexiconText.make((String)"baja", (String)"nav.stationHome"));
            bDirectory2.setIcon(BIcon.std((String)"database.png"));
            ArrayList arrayList = new ArrayList();
            this.addRoot(arrayList, "!", "nav.sysHome", "home.png");
            this.addRoot(arrayList, "^", "nav.stationHome", "database.png");
            return arrayList.toArray(new BIFile[arrayList.size()]);
        }
        return this.roots;
    }

    private void addRoot(ArrayList arrayList, String string, String string2, String string3) {
        try {
            FilePath filePath = new FilePath(string);
            BFoxFileStore bFoxFileStore = this.channel().head(this, filePath);
            BDirectory bDirectory = new BDirectory((BIFileStore)bFoxFileStore, LexiconText.make((String)"baja", (String)string2));
            bDirectory.setIcon(BIcon.std((String)string3));
            arrayList.add(bDirectory);
        }
        catch (Exception exception) {
            System.out.println("FoxFileSpace \"" + string + "\" unsupported");
        }
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    public BIFileStore findStore(FilePath filePath) {
        try {
            return this.channel().head(this, filePath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FoxFileException(filePath.toString(), exception);
        }
    }

    public BIFile getChild(BIFile bIFile, String string) {
        return this.findFile(bIFile.getFilePath().merge(string));
    }

    public BIFile[] getChildren(BIFile bIFile) {
        return this.list(bIFile.getFilePath());
    }

    private BIFile[] list(FilePath filePath) {
        try {
            BFoxFileStore[] bFoxFileStoreArray = this.channel().list(this, filePath);
            BIFile[] bIFileArray = new BIFile[bFoxFileStoreArray.length];
            for (int i = 0; i < bIFileArray.length; ++i) {
                bIFileArray[i] = this.makeFile((BIFileStore)bFoxFileStoreArray[i]);
            }
            return bIFileArray;
        }
        catch (Exception exception) {
            throw new FoxFileException(filePath.toString(), exception);
        }
    }

    public TransferResult transfer(TransferStrategy transferStrategy) throws Exception {
        return this.channel().transfer(transferStrategy);
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)(super.getNavOrd().toString() + "^"));
    }

    public BINavNode getNavChild(String string) {
        return this.getStationHome().getNavChild(string);
    }

    public BINavNode[] getNavChildren() {
        return this.getStationHome().getNavChildren();
    }

    public BIFile getStationHome() {
        if (this.stationHome == null) {
            this.stationHome = this.findFile(new FilePath("^"));
        }
        return this.stationHome;
    }

    public BFoxSession getFoxSession() {
        if (this.channel != null) {
            return null;
        }
        return (BFoxSession)this.getNavParent();
    }

    public BFileChannel channel() {
        if (this.channel != null) {
            return this.channel;
        }
        return (BFileChannel)this.getFoxSession().getConnection().getChannels().get("file");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

