/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.fox.sys.broker.BFoxComponentSpace;
import com.tridium.space.BIGatewaySpace;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.net.NotConnectedException;
import javax.baja.security.BIProtected;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponentSpace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSysChannel
extends BFoxChannel
implements NavListener,
Station.RemoteListener {
    public static final Type TYPE;
    static byte[] noPayload;
    private Type[] stationMixIns;
    static /* synthetic */ Class class$com$tridium$fox$sys$BSysChannel;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "navEvent") {
            return this.navEvent(foxRequest);
        }
        if (string == "summary") {
            return this.summary(foxRequest);
        }
        if (string == "stationCall") {
            return this.stationCall(foxRequest);
        }
        if (string == "stationEvent") {
            return this.stationEvent(foxRequest);
        }
        if (string == "listLocalSpaces") {
            return this.listLocalSpaces(foxRequest);
        }
        if (string == "makeBrokerChannel") {
            return this.makeBrokerChannel(foxRequest);
        }
        if (string == "subNavEvents") {
            return this.subscribeNavEvents(foxRequest);
        }
        if (string == "unsubNavEvents") {
            return this.unsubscribeNavEvents(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void sessionClosed(Throwable throwable) throws Exception {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        Station.removeRemoteListener((Station.RemoteListener)this);
    }

    public String[][] summary() throws Exception {
        FoxRequest foxRequest = this.makeRequest("summary");
        if (this.isTraceOn()) {
            this.trace("c:summary");
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[][] stringArray = new String[foxResponse.count][];
        int n = 0;
        while (n < foxResponse.count) {
            FoxString foxString = (FoxString)foxResponse.tuples[n];
            stringArray[n] = new String[]{foxString.name, foxString.value};
            ++n;
        }
        return stringArray;
    }

    public FoxResponse summary(FoxRequest foxRequest) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listLocalSpaces");
        }
        Context context = this.getSessionContext();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("stationName", Sys.getStation().getStationName());
        foxResponse.add("host", "" + Sys.getLocalHost());
        foxResponse.add("hostModel", Nre.getHostModel());
        foxResponse.add("hostId", Nre.getHostId());
        foxResponse.add("niagaraVersion", "" + Sys.getBajaModule().getVendorVersion());
        foxResponse.add("javaVersion", System.getProperty("java.vm.name") + ' ' + System.getProperty("java.vm.version"));
        foxResponse.add("osVersion", System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
        foxResponse.add("locale", "" + Locale.getDefault());
        foxResponse.add("currentTime", BAbsTime.make().toString(context));
        return foxResponse;
    }

    public byte[] stationCall(String string, byte[] byArray) throws Exception {
        if (byArray == null) {
            byArray = noPayload;
        }
        FoxRequest foxRequest = this.makeRequest("stationCall");
        foxRequest.add("id", string);
        foxRequest.add("payload", byArray);
        if (this.isTraceOn()) {
            this.trace("c:stationCall " + string);
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBlob("payload");
    }

    public FoxResponse stationCall(FoxRequest foxRequest) throws Exception {
        Station.Message message;
        String string = foxRequest.getString("id");
        byte[] byArray = foxRequest.getBlob("payload");
        if (this.isTraceOn()) {
            this.trace("s:stationCall " + string);
        }
        if ((message = Station.remoteCall((Station.Message)new Station.Message(string, byArray))) != null) {
            byArray = message.payload;
        }
        if (byArray == null) {
            byArray = noPayload;
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("payload", byArray);
        return foxResponse;
    }

    public void stationEvent(Station.Message message) throws Exception {
        FoxRequest foxRequest = this.makeRequest("stationEvent");
        foxRequest.add("id", message.id);
        foxRequest.add("payload", message.payload);
        if (this.isTraceOn()) {
            this.trace("c:stationEvent " + message.id);
        }
        this.sendAsync(foxRequest);
    }

    public FoxResponse stationEvent(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("id");
        byte[] byArray = foxRequest.getBlob("payload");
        if (this.isTraceOn()) {
            this.trace("s:stationEvent " + string);
        }
        if (string.equals("stationFault")) {
            String string2 = null;
            if (byArray.length > 0) {
                string2 = Lexicon.make((String)"baja").getText(new String(byArray));
            }
            this.getFoxSession().stationFault = string2;
        } else if (string.equals("mixIns")) {
            this.stationMixIns = Station.decodeMixIns((byte[])byArray);
        }
        return null;
    }

    public Type[] getStationMixIns() {
        return (Type[])this.stationMixIns.clone();
    }

    public HashMap listLocalSpaces() throws Exception {
        FoxRequest foxRequest = this.makeRequest("listLocalSpaces");
        if (this.isTraceOn()) {
            this.trace("c:listLocalSpaces");
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple[] foxTupleArray = foxResponse.list("space");
        String[] stringArray = new String[foxTupleArray.length];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            String string = foxMessage.getString("schemeId");
            hashMap.put(string, string);
            ++n;
        }
        return hashMap;
    }

    public FoxResponse listLocalSpaces(FoxRequest foxRequest) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listLocalSpaces");
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BINavNode[] bINavNodeArray = BLocalHost.INSTANCE.getNavChildren();
        int n = 0;
        while (n < bINavNodeArray.length) {
            BINavNode bINavNode = bINavNodeArray[n];
            if (bINavNode instanceof BSpace) {
                Object[] objectArray;
                BSpace bSpace = (BSpace)bINavNode;
                if (bSpace instanceof BIProtected && !this.getPermissionsFor(bSpace).hasOperatorRead()) {
                    if (bSpace.getNavName().equals("station")) {
                        objectArray = new String[]{this.getConnection() instanceof BFoxServerConnection ? this.getServerConnection().getUser().getUsername() : this.getClientConnection().getUsername()};
                        throw new LocalizableRuntimeException("fox", "error.NoPermissionForStation", objectArray);
                    }
                } else {
                    objectArray = new FoxMessage("space");
                    objectArray.add("schemeId", bSpace.getNavName());
                    objectArray.add("type", bSpace.getType().toString());
                    foxResponse.add((FoxTuple)objectArray);
                }
            }
            ++n;
        }
        return foxResponse;
    }

    public BBrokerChannel makeBrokerChannel(BFoxComponentSpace bFoxComponentSpace) throws Exception {
        FoxRequest foxRequest = this.makeRequest("makeBrokerChannel");
        foxRequest.add("ord", "" + bFoxComponentSpace.getOrdInSession());
        if (this.isTraceOn()) {
            this.trace("c:makebrokerChannel");
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("channelName");
        BFoxChannelRegistry bFoxChannelRegistry = this.getConnection().getChannels();
        BBrokerChannel bBrokerChannel = (BBrokerChannel)bFoxChannelRegistry.get(string, BBrokerChannel.TYPE);
        bBrokerChannel.initClient(bFoxComponentSpace);
        return bBrokerChannel;
    }

    public FoxResponse makeBrokerChannel(FoxRequest foxRequest) throws Exception {
        String string;
        Object object;
        BOrd bOrd = BOrd.make((String)foxRequest.getString("ord"));
        BComponentSpace bComponentSpace = (BComponentSpace)bOrd.get();
        if (bComponentSpace instanceof BVirtualComponentSpace) {
            object = ((BVirtualComponentSpace)bComponentSpace).getVirtualGateway();
            string = "virt_" + object.getHandle();
        } else {
            string = bComponentSpace instanceof BIGatewaySpace ? "gw_" + ((BIGatewaySpace)bComponentSpace).getGateway().getHandle() : bComponentSpace.getNavName();
        }
        object = this.getConnection().getChannels();
        BBrokerChannel bBrokerChannel = (BBrokerChannel)((BFoxChannelRegistry)((Object)object)).get(string, BBrokerChannel.TYPE);
        bBrokerChannel.initServer(bComponentSpace);
        if (this.isTraceOn()) {
            this.trace("s:makebrokerChannel " + bOrd + " -> " + string);
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("channelName", string);
        return foxResponse;
    }

    public void subscribeNavEvents() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:subNavEvents");
        }
        this.sendAsync(this.makeRequest("subNavEvents"));
    }

    private final FoxResponse subscribeNavEvents(FoxRequest foxRequest) {
        if (this.isTraceOn()) {
            this.trace("s:subNavEvents");
        }
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        Station.addRemoteListener((Station.RemoteListener)this);
        Station.broadcastStationFault();
        Station.broadcastStationMixIns();
        return null;
    }

    public void unsubscribeNavEvents() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:unsubNavEvents");
        }
        try {
            this.sendAsync(this.makeRequest("unsubNavEvents"));
        }
        catch (NotConnectedException notConnectedException) {}
    }

    private final FoxResponse unsubscribeNavEvents(FoxRequest foxRequest) {
        if (this.isTraceOn()) {
            this.trace("s:unsubNavEvents");
        }
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        Station.removeRemoteListener((Station.RemoteListener)this);
        return null;
    }

    public void navEvent(NavEvent navEvent) {
        block16: {
            try {
                String string;
                if (this.isTraceOn()) {
                    this.trace("c:navEvent " + navEvent);
                }
                if (!(string = navEvent.getParentOrd().toString()).startsWith("local:")) {
                    return;
                }
                if (string.startsWith("local:|fox:") || string.startsWith("local:|foxs:")) {
                    return;
                }
                if (navEvent.getParent() instanceof BComponent) {
                    return;
                }
                int n = string.indexOf(124);
                if (n < 0) {
                    return;
                }
                String string2 = string.substring(n + 1);
                FoxRequest foxRequest = this.makeRequest("navEvent");
                foxRequest.add("ord", string2);
                switch (navEvent.getId()) {
                    case 1: {
                        foxRequest.add("id", "a");
                        foxRequest.add("n", navEvent.getNewChildName());
                        break;
                    }
                    case 2: {
                        foxRequest.add("id", "v");
                        foxRequest.add("o", navEvent.getOldChildName());
                        break;
                    }
                    case 3: {
                        foxRequest.add("id", "r");
                        foxRequest.add("o", navEvent.getOldChildName());
                        foxRequest.add("n", navEvent.getNewChildName());
                        break;
                    }
                    case 4: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = navEvent.getNewOrder();
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            stringBuffer.append(stringArray[n2]).append('|');
                            ++n2;
                        }
                        foxRequest.add("id", "o");
                        foxRequest.add("o", stringBuffer.toString());
                        break;
                    }
                    case 5: {
                        foxRequest.add("id", "p");
                        foxRequest.add("o", navEvent.getOldChildName());
                        break;
                    }
                    case 6: {
                        foxRequest.add("id", "c");
                        foxRequest.add("o", navEvent.getOldChildName());
                        foxRequest.add("n", navEvent.getNewChildName());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(navEvent.toString());
                    }
                }
                this.sendAsync(foxRequest);
            }
            catch (Exception exception) {
                if (!this.getConnection().isConnected()) break block16;
                exception.printStackTrace();
            }
        }
    }

    private final FoxResponse navEvent(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("ord");
        BOrd bOrd = BOrd.make((BOrd)this.getFoxSession().getAbsoluteOrd(), (String)string);
        String string2 = foxRequest.getString("id");
        if (this.isTraceOn()) {
            this.trace("s:navEvent " + string2 + ' ' + bOrd);
        }
        NavEvent navEvent = null;
        if (string2.equals("a")) {
            String string3 = foxRequest.getString("n");
            navEvent = NavEvent.makeAdded((BOrd)bOrd, (String)string3, null);
        } else if (string2.equals("v")) {
            String string4 = foxRequest.getString("o");
            navEvent = NavEvent.makeRemoved((BOrd)bOrd, (String)string4, null);
        } else if (string2.equals("r")) {
            String string5 = foxRequest.getString("o");
            String string6 = foxRequest.getString("n");
            navEvent = NavEvent.makeRenamed((BOrd)bOrd, (String)string5, (String)string6, null);
        } else if (string2.equals("o")) {
            String string7 = foxRequest.getString("o");
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string7, "|");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            navEvent = NavEvent.makeReordered((BOrd)bOrd, (String[])stringArray, null);
        } else if (string2.equals("p")) {
            String string8 = foxRequest.getString("o");
            navEvent = NavEvent.makeReplaced((BOrd)bOrd, (String)string8, null);
        } else if (string2.equals("c")) {
            String string9 = foxRequest.getString("o");
            String string10 = foxRequest.getString("n");
            navEvent = NavEvent.makeRecategorized((BOrd)bOrd, (String)string9, (String)string10, null);
        } else {
            System.out.println("ERROR: Unknown event type: " + string2);
            Thread.dumpStack();
        }
        if (navEvent != null) {
            BNavRoot.INSTANCE.fireNavEvent(navEvent);
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stationMixIns = new Type[0];
    }

    public BSysChannel() {
        super("sys");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BSysChannel;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BSysChannel = BSysChannel.class("[Lcom.tridium.fox.sys.BSysChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        noPayload = new byte[0];
    }
}

