/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.Tuner;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxAuthenticationPolicy;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxTunnelServerConnection;
import com.tridium.fox.sys.BServerConnections;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.license.Brand;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.io.net.IServerSocketFactory;
import javax.baja.log.Log;
import javax.baja.security.AuthenticationException;
import javax.baja.security.DigestFactory;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxService
extends BComponent
implements BIService {
    public static final Property port = BFoxService.newProperty((int)0, (int)1911, null);
    public static final Property foxEnabled = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property foxsPort = BFoxService.newProperty((int)0, (int)4911, null);
    public static final Property foxsEnabled = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property foxsOnly = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property foxsMinProtocol = BFoxService.newProperty((int)0, (BValue)BSslTlsEnum.sslv3andtlsv1, null);
    public static final Property foxsCert = BFoxService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")));
    public static final Property authenticationPolicy = BFoxService.newProperty((int)0, (BValue)BFoxAuthenticationPolicy.digest, null);
    public static final Property legacyAuthentication = BFoxService.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:RelaxedFE"));
    public static final Property requestTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.requestTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property socketOptionTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.soTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property socketTcpNoDelay = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property keepAliveInterval = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.keepAliveInterval), null);
    public static final Property maxServerSessions = BFoxService.newProperty((int)0, (int)Fox.maxServerSessions, null);
    public static final Property multicastEnabled = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property enableAnnouncement = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property multicastTimeToLive = BFoxService.newProperty((int)0, (int)Fox.multicastTimeToLive, null);
    public static final Property serverConnections = BFoxService.newProperty((int)0, (BValue)new BServerConnections(), null);
    public static final Property traceSessionStates = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceReadFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceWriteFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceMulticast = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelingEnabled = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property onlyTunnelKnownStations = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Action delayStationStarted = BFoxService.newAction((int)4, null);
    public static final Action checkLegacyAuth = BFoxService.newAction((int)4, null);
    public static final Type TYPE;
    private static final Type[] serviceTypes;
    private static final BIcon icon;
    public static final Log log;
    private Daemon daemon;
    private Clock.Ticket restartTicket;
    private Clock.Ticket legacyAuthCheckTicket;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxService;

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public boolean getFoxEnabled() {
        return this.getBoolean(foxEnabled);
    }

    public void setFoxEnabled(boolean bl) {
        this.setBoolean(foxEnabled, bl, null);
    }

    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    public void setFoxsPort(int n) {
        this.setInt(foxsPort, n, null);
    }

    public boolean getFoxsEnabled() {
        return this.getBoolean(foxsEnabled);
    }

    public void setFoxsEnabled(boolean bl) {
        this.setBoolean(foxsEnabled, bl, null);
    }

    public boolean getFoxsOnly() {
        return this.getBoolean(foxsOnly);
    }

    public void setFoxsOnly(boolean bl) {
        this.setBoolean(foxsOnly, bl, null);
    }

    public BSslTlsEnum getFoxsMinProtocol() {
        return (BSslTlsEnum)this.get(foxsMinProtocol);
    }

    public void setFoxsMinProtocol(BSslTlsEnum bSslTlsEnum) {
        this.set(foxsMinProtocol, (BValue)bSslTlsEnum, null);
    }

    public String getFoxsCert() {
        return this.getString(foxsCert);
    }

    public void setFoxsCert(String string) {
        this.setString(foxsCert, string, null);
    }

    public BFoxAuthenticationPolicy getAuthenticationPolicy() {
        return (BFoxAuthenticationPolicy)this.get(authenticationPolicy);
    }

    public void setAuthenticationPolicy(BFoxAuthenticationPolicy bFoxAuthenticationPolicy) {
        this.set(authenticationPolicy, (BValue)bFoxAuthenticationPolicy, null);
    }

    public BAbsTime getLegacyAuthentication() {
        return (BAbsTime)this.get(legacyAuthentication);
    }

    public void setLegacyAuthentication(BAbsTime bAbsTime) {
        this.set(legacyAuthentication, (BValue)bAbsTime, null);
    }

    public BRelTime getRequestTimeout() {
        return (BRelTime)this.get(requestTimeout);
    }

    public void setRequestTimeout(BRelTime bRelTime) {
        this.set(requestTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getSocketOptionTimeout() {
        return (BRelTime)this.get(socketOptionTimeout);
    }

    public void setSocketOptionTimeout(BRelTime bRelTime) {
        this.set(socketOptionTimeout, (BValue)bRelTime, null);
    }

    public boolean getSocketTcpNoDelay() {
        return this.getBoolean(socketTcpNoDelay);
    }

    public void setSocketTcpNoDelay(boolean bl) {
        this.setBoolean(socketTcpNoDelay, bl, null);
    }

    public BRelTime getKeepAliveInterval() {
        return (BRelTime)this.get(keepAliveInterval);
    }

    public void setKeepAliveInterval(BRelTime bRelTime) {
        this.set(keepAliveInterval, (BValue)bRelTime, null);
    }

    public int getMaxServerSessions() {
        return this.getInt(maxServerSessions);
    }

    public void setMaxServerSessions(int n) {
        this.setInt(maxServerSessions, n, null);
    }

    public boolean getMulticastEnabled() {
        return this.getBoolean(multicastEnabled);
    }

    public void setMulticastEnabled(boolean bl) {
        this.setBoolean(multicastEnabled, bl, null);
    }

    public boolean getEnableAnnouncement() {
        return this.getBoolean(enableAnnouncement);
    }

    public void setEnableAnnouncement(boolean bl) {
        this.setBoolean(enableAnnouncement, bl, null);
    }

    public int getMulticastTimeToLive() {
        return this.getInt(multicastTimeToLive);
    }

    public void setMulticastTimeToLive(int n) {
        this.setInt(multicastTimeToLive, n, null);
    }

    public BServerConnections getServerConnections() {
        return (BServerConnections)this.get(serverConnections);
    }

    public void setServerConnections(BServerConnections bServerConnections) {
        this.set(serverConnections, (BValue)bServerConnections, null);
    }

    public boolean getTraceSessionStates() {
        return this.getBoolean(traceSessionStates);
    }

    public void setTraceSessionStates(boolean bl) {
        this.setBoolean(traceSessionStates, bl, null);
    }

    public boolean getTraceReadFrame() {
        return this.getBoolean(traceReadFrame);
    }

    public void setTraceReadFrame(boolean bl) {
        this.setBoolean(traceReadFrame, bl, null);
    }

    public boolean getTraceWriteFrame() {
        return this.getBoolean(traceWriteFrame);
    }

    public void setTraceWriteFrame(boolean bl) {
        this.setBoolean(traceWriteFrame, bl, null);
    }

    public boolean getTraceMulticast() {
        return this.getBoolean(traceMulticast);
    }

    public void setTraceMulticast(boolean bl) {
        this.setBoolean(traceMulticast, bl, null);
    }

    public boolean getTunnelingEnabled() {
        return this.getBoolean(tunnelingEnabled);
    }

    public void setTunnelingEnabled(boolean bl) {
        this.setBoolean(tunnelingEnabled, bl, null);
    }

    public boolean getOnlyTunnelKnownStations() {
        return this.getBoolean(onlyTunnelKnownStations);
    }

    public void setOnlyTunnelKnownStations(boolean bl) {
        this.setBoolean(onlyTunnelKnownStations, bl, null);
    }

    public void delayStationStarted() {
        this.invoke(delayStationStarted, null, null);
    }

    public void checkLegacyAuth() {
        this.invoke(checkLegacyAuth, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public boolean isServing() {
        Daemon daemon = this.daemon;
        boolean bl = false;
        if (daemon != null && daemon.isServing()) {
            bl = true;
        }
        return bl;
    }

    public void stationStarted() {
        int n = -1;
        int n2 = -1;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            this.serviceStopped();
            this.initOptions();
            if (this.getFoxEnabled()) {
                n = this.getFoxPort();
            }
            if (this.getFoxsEnabled()) {
                n2 = this.getFoxsPort();
            }
            this.daemon = new Daemon(this, n, n2);
            this.daemon.run();
            arrayList.add("foxport");
            arrayList2.add(String.valueOf(n));
            arrayList.add("foxsport");
            arrayList2.add(String.valueOf(n2));
            Nre.getPlatform().reportSummaryFields(arrayList.toArray(new String[0]), arrayList2.toArray(new String[0]));
            this.doCheckLegacyAuth();
        }
        catch (Exception exception) {
            log.error("Cannot start", (Throwable)exception);
        }
    }

    public void serviceStarted() {
        try {
            Nre.serviceManager.getService("platCrypto:CertManagerService");
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsCert, this.getFlags((Slot)foxsCert) & 0xFFFFFFFA);
            if (SecurityInitializer.isFips()) {
                this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) | 1);
                if (this.getFoxsMinProtocol() != BSslTlsEnum.tlsv1) {
                    log.message("Changing foxs min protocol to tlsv1 to support fips mode");
                    this.setFoxsMinProtocol(BSslTlsEnum.tlsv1);
                }
            }
        }
        catch (Exception exception) {
            if (this.getFoxsEnabled()) {
                log.warning("Foxs is unsupported on this device. Using fox instead.");
                this.setFoxsOnly(false);
                this.setFoxsEnabled(false);
                this.setFoxEnabled(true);
            }
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) | 1 | 4);
            this.setFoxsEnabled(false);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) | 1 | 4);
            this.setFoxsOnly(false);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) | 1 | 4);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) | 1 | 4);
            this.setFlags((Slot)foxsCert, this.getFlags((Slot)foxsCert) | 1 | 4);
        }
    }

    public void serviceStopped() {
        if (this.daemon != null) {
            log.message("Service stopped");
            this.daemon.stop();
        }
        this.daemon = null;
    }

    private final void initOptions() {
        Fox.appName = "Station";
        Fox.appVersion = "" + Sys.getBajaModule().getVendorVersion();
        Fox.hostName = Sys.getLocalHost().getHostName();
        Fox.hostAddress = Sys.getLocalHost().getHostAddress();
        Fox.ipv4Enabled = NreLib.getLocalHost((boolean)false).isLoopbackAddress() ^ true;
        boolean bl = false;
        if (Fox.ipv6Enabled && !NreLib.getLocalHost((boolean)true).isLoopbackAddress()) {
            bl = true;
        }
        Fox.ipv6Enabled = bl;
        Fox.requestTimeout = (int)this.getRequestTimeout().getMillis();
        Fox.keepAliveInterval = (int)this.getKeepAliveInterval().getMillis();
        Fox.soTimeout = (int)this.getSocketOptionTimeout().getMillis();
        Fox.tcpNoDelay = this.getSocketTcpNoDelay();
        Fox.multicastEnabled = this.getMulticastEnabled();
        Fox.multicastTimeToLive = this.getMulticastTimeToLive();
        Fox.maxServerSessions = this.getMaxServerSessions();
        Fox.traceSessionStates = this.getTraceSessionStates();
        Fox.traceReadFrame = this.getTraceReadFrame();
        Fox.traceWriteFrame = this.getTraceWriteFrame();
        Fox.traceMulticast = this.getTraceMulticast();
        Fox.tunnelingEnabled = this.getTunnelingEnabled();
        Fox.onlyTunnelKnownStations = this.getOnlyTunnelKnownStations();
        Acceptor.foxTunnelingLicensed();
    }

    public static BFoxService waitUntilPortOpen(long l) {
        try {
            BFoxService bFoxService = (BFoxService)Sys.getService((Type)TYPE);
            long l2 = Clock.ticks();
            while (!bFoxService.isServing()) {
                if (Clock.ticks() - l2 > l) {
                    throw new BajaRuntimeException("BFoxService.waitUntilPortOpen timed out");
                }
                Thread.sleep(100L);
            }
            return bFoxService;
        }
        catch (BajaRuntimeException bajaRuntimeException) {
            throw bajaRuntimeException;
        }
        catch (Exception exception) {
            System.out.println("ERROR: BFoxService.waitUntilPortOpen failed");
            exception.printStackTrace();
            throw new BajaRuntimeException("FoxService.waitUntilPortOpen", (Throwable)exception);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == port || property == foxsPort) {
            this.triggerDelayedStationStarted();
        } else if (property == foxsCert || property == foxsMinProtocol || property == foxsOnly) {
            if (this.getFoxsEnabled()) {
                this.triggerDelayedStationStarted();
            }
        } else if (property == foxEnabled || property == foxsEnabled || property == multicastEnabled) {
            this.triggerDelayedStationStarted();
        } else {
            this.initOptions();
        }
    }

    private final synchronized void triggerDelayedStationStarted() {
        this.triggerDelayedStationStarted(500L);
    }

    private final synchronized void triggerDelayedStationStarted(long l) {
        if (this.restartTicket == null) {
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)l), (Action)delayStationStarted, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDelayStationStarted() {
        BFoxService bFoxService = this;
        synchronized (bFoxService) {
            this.restartTicket = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            this.stationStarted();
            return;
        }
    }

    public void doCheckLegacyAuth() {
        BAbsTime bAbsTime;
        Class clazz = class$com$tridium$fox$sys$BFoxService;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxService = BFoxService.class("[Lcom.tridium.fox.sys.BFoxService;", false);
        }
        Lexicon lexicon = Lexicon.make((Class)clazz);
        if (this.legacyAuthCheckTicket != null) {
            this.legacyAuthCheckTicket.cancel();
        }
        if (!(bAbsTime = this.getLegacyAuthentication()).isNull()) {
            if (bAbsTime.isBefore(BAbsTime.now())) {
                log.warning(lexicon.getText("fox.legacy.relaxed.expired"));
            } else {
                log.warning(lexicon.getText("fox.legacy.relaxed"));
                if (BAbsTime.now().delta(bAbsTime).getDays() < 7) {
                    log.warning(lexicon.getText("fox.legacy.relaxed.expiring", new Object[]{bAbsTime}));
                }
            }
        }
        BAbsTime bAbsTime2 = Clock.time().timeOfDay(1, 0, 0, 0).nextDay();
        this.legacyAuthCheckTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime2, (Action)checkLegacyAuth, null);
    }

    public BFoxServerConnection makeServerConnection(FoxSession foxSession, FoxMessage foxMessage) throws Exception {
        BFoxServerConnection bFoxServerConnection = new BFoxServerConnection();
        this.getServerConnections().add("Session" + foxSession.getId(), (BValue)bFoxServerConnection, 3);
        return bFoxServerConnection;
    }

    public FoxServer getFoxServer() {
        return this.daemon;
    }

    public int getFoxPort() {
        return this.getPort();
    }

    public static NiagaraNetwork getNiagaraNetwork() {
        BFoxService bFoxService = (BFoxService)Sys.getService((Type)TYPE);
        BComplex bComplex = bFoxService.getParent();
        while (bComplex != null) {
            if (bComplex instanceof NiagaraNetwork) {
                return (NiagaraNetwork)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public static void httpSessionClosed(String string) {
        if (string == null) {
            return;
        }
        BFoxService bFoxService = (BFoxService)Sys.getService((Type)TYPE);
        BComponent[] bComponentArray = bFoxService.getServerConnections().getChildComponents();
        if (bComponentArray == null) {
            return;
        }
        int n = 0;
        while (n < bComponentArray.length) {
            String string2;
            BFoxServerConnection bFoxServerConnection = (BFoxServerConnection)bComponentArray[n];
            if (bFoxServerConnection != null && string.equals(string2 = bFoxServerConnection.session().getRemoteHello().getString("httpSession", null))) {
                bFoxServerConnection.close();
            }
            ++n;
        }
    }

    public static int getHttpPort() {
        try {
            Type type = Sys.getType((String)"web:WebService");
            BComponent bComponent = Sys.getService((Type)type);
            BInteger bInteger = (BInteger)bComponent.get("httpPort");
            return bInteger.getInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean auditConnection(FoxSession foxSession) {
        String string = foxSession.getRemoteHello().getString("app.name", "Station");
        return string.equals("Station") ^ true;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.restartTicket = null;
        this.legacyAuthCheckTicket = null;
    }

    public BFoxService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxService;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxService = BFoxService.class("[Lcom.tridium.fox.sys.BFoxService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std((String)"fox.png");
        log = Log.getLog((String)"fox");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Daemon
    extends FoxServer {
        private BFoxService service;

        public void run() {
            try {
                super.run();
            }
            catch (Exception exception) {}
        }

        public ServerSocket getFoxsServerSocket() throws IOException {
            ICryptoManager iCryptoManager;
            try {
                iCryptoManager = CertManagerFactory.getInstance();
            }
            catch (Exception exception) {
                throw new IOException("Unable to get crypto service instance");
            }
            try {
                IServerSocketFactory iServerSocketFactory = iCryptoManager.getServerSocketFactory(this.service.getFoxsMinProtocol(), false, this.service.getFoxsCert());
                return iServerSocketFactory.createServerSocket(BFoxService.this.getFoxsPort(), 10);
            }
            catch (BindException bindException) {
                throw bindException;
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    exception.printStackTrace();
                }
                if (!BFoxService.this.getFoxEnabled() || BFoxService.this.getFoxsOnly()) {
                    log.warning("Unable to start foxs, enabling fox connectivity!");
                    BFoxService.this.setFoxEnabled(true);
                    BFoxService.this.setFoxsOnly(false);
                }
                throw new IOException("Unable to create socket: " + exception.getLocalizedMessage());
            }
        }

        public FoxConnection makeConnection(FoxSession foxSession, FoxMessage foxMessage) throws Exception {
            if (foxSession == null) {
                return new BFoxTunnelServerConnection();
            }
            return BFoxService.this.makeServerConnection(foxSession, foxMessage);
        }

        public FoxMessage getAnnouncement() {
            InetAddress inetAddress;
            if (!BFoxService.this.getEnableAnnouncement()) {
                return null;
            }
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("station", Sys.getStation().getStationName());
            if (Fox.ipv4Enabled && !(inetAddress = NreLib.getLocalHost((boolean)false)).isLoopbackAddress()) {
                foxMessage.add("hostName", inetAddress.getHostName());
                foxMessage.add("hostAddress", inetAddress.getHostAddress());
            }
            if (Fox.ipv6Enabled && !(inetAddress = NreLib.getLocalHost((boolean)true)).isLoopbackAddress()) {
                foxMessage.add("hostNameIPv6", inetAddress.getHostName());
                foxMessage.add("hostAddressIPv6", inetAddress.getHostAddress());
            }
            if (BFoxService.this.getFoxEnabled()) {
                foxMessage.add("foxPort", BFoxService.this.getFoxPort());
            }
            if (BFoxService.this.getFoxsEnabled()) {
                foxMessage.add("foxsPort", BFoxService.this.getFoxsPort());
            }
            foxMessage.add("httpPort", BFoxService.getHttpPort());
            foxMessage.add("version", Sys.getBajaModule().getVendorVersion().toString());
            foxMessage.add("hostId", Nre.getHostId());
            foxMessage.add("hostModel", Nre.getHostModel());
            foxMessage.add("brandId", Brand.getBrandId());
            foxMessage.add("vmName", Fox.vmName);
            foxMessage.add("vmVersion", Fox.vmVersion);
            foxMessage.add("osName", Fox.osName);
            foxMessage.add("osVersion", Fox.osVersion);
            return foxMessage;
        }

        public int getAuthenticationPolicy() {
            return BFoxService.this.getAuthenticationPolicy().getOrdinal();
        }

        public boolean authenticateBasic(FoxSession foxSession, String string, String string2) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateBasic in BFoxService. This call should be handled by an Authentication Agent.");
        }

        public boolean authenticateDigest(FoxSession foxSession, String string, byte[] byArray, byte[] byArray2) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateDigest in BFoxService. This call should be handled by an Authentication Agent.");
        }

        public Daemon(BFoxService bFoxService2, int n, int n2) {
            super(n, n2);
            this.service = bFoxService2;
        }
    }

    static class FoxDigestFactory
    implements DigestFactory {
        byte[] nonce;

        public byte[] makeDigest(String string, String string2) {
            try {
                return Tuner.generateDigest(string, string2, this.nonce);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public byte[] getNonce() {
            return this.nonce;
        }

        FoxDigestFactory(byte[] byArray) {
            this.nonce = byArray;
        }
    }
}

