/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.InvalidChannelException;
import com.tridium.fox.sys.BFoxAuthAgent;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.fox.sys.spy.FoxIndexSpy;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import java.net.Socket;
import javax.baja.net.NotConnectedException;
import javax.baja.spy.Spy;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.user.BUserService;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BFoxConnection
extends BComponent
implements FoxConnection {
    public static final Property state = BFoxConnection.newProperty((int)3, (String)"Not connected", null);
    public static final Property lastConnectTime = BFoxConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastDisconnectTime = BFoxConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastDisconnectCause = BFoxConnection.newProperty((int)1, (String)"", null);
    public static final Property channels = BFoxConnection.newProperty((int)7, (BValue)new BFoxChannelRegistry(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected final FoxLog log;
    private FoxSession session;
    private Version remoteVersion;
    Integer fwConnectionType;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxConnection;

    public String getState() {
        return this.getString(state);
    }

    public void setState(String string) {
        this.setString(state, string, null);
    }

    public BAbsTime getLastConnectTime() {
        return (BAbsTime)this.get(lastConnectTime);
    }

    public void setLastConnectTime(BAbsTime bAbsTime) {
        this.set(lastConnectTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastDisconnectTime() {
        return (BAbsTime)this.get(lastDisconnectTime);
    }

    public void setLastDisconnectTime(BAbsTime bAbsTime) {
        this.set(lastDisconnectTime, (BValue)bAbsTime, null);
    }

    public String getLastDisconnectCause() {
        return this.getString(lastDisconnectCause);
    }

    public void setLastDisconnectCause(String string) {
        this.setString(lastDisconnectCause, string, null);
    }

    public BFoxChannelRegistry getChannels() {
        return (BFoxChannelRegistry)this.get(channels);
    }

    public void setChannels(BFoxChannelRegistry bFoxChannelRegistry) {
        this.set(channels, (BValue)bFoxChannelRegistry, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isConnected() {
        boolean bl = false;
        if (this.session != null && !this.session.isClosed()) {
            bl = true;
        }
        return bl;
    }

    public void assertConnected() throws NotConnectedException {
        if (this.session == null || this.session.isClosed()) {
            throw new NotConnectedException();
        }
    }

    public FoxSession session() {
        return this.session;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public void close() {
        this.setState("Not connected");
        if (this.session != null) {
            this.session.close(null);
        }
    }

    public NiagaraStation getParentStation() {
        if (this.getParent() instanceof NiagaraStation) {
            return (NiagaraStation)this.getParent();
        }
        return null;
    }

    public void initHello(FoxMessage foxMessage) throws Exception {
        NiagaraStation niagaraStation;
        BStation bStation;
        BFoxSession bFoxSession = null;
        if (this instanceof BFoxClientConnection) {
            bFoxSession = ((BFoxClientConnection)this).getFoxSession();
            bStation = this.get("httpSession");
            if (bStation instanceof BString) {
                foxMessage.add("httpSession", ((BString)bStation).getString());
            }
        }
        if ((bStation = Sys.getStation()) != null && bFoxSession == null) {
            foxMessage.add("station.name", bStation.getStationName());
        }
        if ((niagaraStation = this.getParentStation()) != null) {
            niagaraStation.initHello(foxMessage);
        }
        foxMessage.add("lang", Sys.getLanguage());
        foxMessage.add("timeZone", BTimeZone.getLocal().encodeToString());
        foxMessage.add("hostId", Nre.getHostId());
        foxMessage.add("vmUuid", Nre.vmUuid);
        try {
            foxMessage.add("brandId", Brand.getBrandId());
        }
        catch (Exception exception) {}
        if (bStation != null) {
            BFoxAuthAgent bFoxAuthAgent;
            BUserService bUserService;
            BFacets bFacets = bStation.getSysInfo();
            BogCodec.add(foxMessage, "sysInfo", (BValue)bFacets, null);
            String string = bFacets.gets("realms", null);
            if (string != null) {
                foxMessage.add("realms", string);
            }
            if ((bUserService = BUserService.getService()) != null && (bFoxAuthAgent = (BFoxAuthAgent)bUserService.getAuthAgent(BFoxAuthAgent.TYPE)) != null) {
                foxMessage.add("authAgentTypeSpecs", bFoxAuthAgent.getType().getTypeSpec().encodeToString());
            }
        }
    }

    public void sessionOpened(FoxSession foxSession) {
        this.session = foxSession;
        this.log.opened(foxSession);
        this.setState("Connected [" + foxSession.getId() + ']');
        this.setLastConnectTime(Clock.time());
        this.getChannels().sessionOpened();
        try {
            this.remoteVersion = new Version(foxSession.getRemoteHello().getString("app.version"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sessionClosed(FoxSession foxSession, Throwable throwable) {
        this.log.closed(foxSession, throwable);
        this.session = null;
        this.setState("Not connected");
        this.setLastDisconnectTime(Clock.time());
        this.setLastDisconnectCause(throwable == null ? "" : throwable.toString());
        this.getChannels().sessionClosed(throwable);
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        return this.getChannel(foxRequest.channel).process(foxRequest);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Throwable {
        this.getChannel(foxCircuit.channel).circuitOpened(foxCircuit);
    }

    private final BFoxChannel getChannel(String string) {
        BFoxChannel bFoxChannel = (BFoxChannel)this.getChannels().get(string);
        if (bFoxChannel != null) {
            return bFoxChannel;
        }
        BFoxChannel bFoxChannel2 = (BFoxChannel)BFoxChannelRegistry.getPrototype().get(string);
        if (bFoxChannel2 != null) {
            bFoxChannel = (BFoxChannel)bFoxChannel2.newCopy();
            this.getChannels().add(string, (BValue)bFoxChannel);
            return bFoxChannel;
        }
        throw new InvalidChannelException(string);
    }

    public Thread makeThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        return new Thread(threadGroup, runnable, string);
    }

    public void error(String string, Throwable throwable) {
        this.log.error(string, throwable);
    }

    public boolean isTunnelClientConnection() {
        return false;
    }

    public boolean isTunnelServerConnection() {
        return false;
    }

    public String[] getTunnelAuthorities() {
        return null;
    }

    public Socket createTunnelSocket(String string, boolean bl) throws Exception {
        return null;
    }

    public FoxResponse sendSync(FoxRequest foxRequest) throws Exception {
        FoxSession foxSession = this.session;
        if (foxSession == null) {
            throw new NotConnectedException();
        }
        return foxSession.sendSync(foxRequest);
    }

    public void sendAsync(FoxRequest foxRequest) throws Exception {
        this.sendAsync(foxRequest, null);
    }

    public void sendAsync(FoxRequest foxRequest, FoxAsyncCallbacks foxAsyncCallbacks) throws Exception {
        FoxSession foxSession = this.session;
        if (foxSession == null) {
            throw new NotConnectedException();
        }
        foxSession.sendAsync(foxRequest, foxAsyncCallbacks);
    }

    public BIcon getIcon() {
        return icon;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 803) {
            if (object instanceof Integer) {
                this.fwConnectionType = (Integer)object;
            }
            return this.fwConnectionType;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = FoxLog.make("fox");
        this.fwConnectionType = FoxSession.NON_FW_FOX_SESSION;
    }

    public BFoxConnection() {
        this.this();
        this.set(channels, BFoxChannelRegistry.getPrototype().newCopy());
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxConnection;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxConnection = BFoxConnection.class("[Lcom.tridium.fox.sys.BFoxConnection;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        Spy.ROOT.add("fox", (Spy)new FoxIndexSpy());
    }
}

