/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.naming.BHost;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxClientConnection
extends BFoxConnection {
    public static final Property port = BFoxClientConnection.newProperty((int)0, (int)1911, null);
    public static final Property useFoxs = BFoxClientConnection.newProperty((int)5, (boolean)false, null);
    public static final Property username = BFoxClientConnection.newProperty((int)0, (String)"", null);
    public static final Property password = BFoxClientConnection.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property lastFailureTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailureCause = BFoxClientConnection.newProperty((int)1, (String)"", null);
    public static final Property retryPeriod = BFoxClientConnection.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property nextAttemptTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Action manualConnect = BFoxClientConnection.newAction((int)0, null);
    public static final Action manualDisconnect = BFoxClientConnection.newAction((int)0, null);
    public static final Action lingerTimeout = BFoxClientConnection.newAction((int)20, null);
    public static final Type TYPE;
    public static long engageLinger;
    private static CoalesceQueue queue;
    private static ThreadPoolWorker threadPool;
    private BFoxSession foxSession;
    private BICredentials credentials;
    private BHost remoteHost;
    private Object connectLock;
    private long lastFailureTicks;
    private Exception lastFailureException;
    private Object retryLock;
    private HashMap interests;
    private ArrayList interestLog;
    private Clock.Ticket lingerTicket;
    private boolean checkBrandCompatibility;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxClientConnection;

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public boolean getUseFoxs() {
        return this.getBoolean(useFoxs);
    }

    public void setUseFoxs(boolean bl) {
        this.setBoolean(useFoxs, bl, null);
    }

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String string) {
        this.setString(username, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    public void setLastFailureTime(BAbsTime bAbsTime) {
        this.set(lastFailureTime, (BValue)bAbsTime, null);
    }

    public String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    public void setLastFailureCause(String string) {
        this.setString(lastFailureCause, string, null);
    }

    public BRelTime getRetryPeriod() {
        return (BRelTime)this.get(retryPeriod);
    }

    public void setRetryPeriod(BRelTime bRelTime) {
        this.set(retryPeriod, (BValue)bRelTime, null);
    }

    public BAbsTime getNextAttemptTime() {
        return (BAbsTime)this.get(nextAttemptTime);
    }

    public void setNextAttemptTime(BAbsTime bAbsTime) {
        this.set(nextAttemptTime, (BValue)bAbsTime, null);
    }

    public void manualConnect() {
        this.invoke(manualConnect, null, null);
    }

    public void manualDisconnect() {
        this.invoke(manualDisconnect, null, null);
    }

    public void lingerTimeout() {
        this.invoke(lingerTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final void init() {
        if (System.getProperty("java.vm.name").equalsIgnoreCase("J9")) {
            this.setUseFoxs(false);
            this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) | 1 | 4);
        } else if (Sys.getStation() != null) {
            try {
                Nre.serviceManager.getService("platCrypto:CertManagerService");
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
            }
            catch (Exception exception) {
                this.setUseFoxs(false);
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) | 1 | 4);
            }
        } else {
            this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
        }
        this.set(channels, BFoxChannelRegistry.getPrototype().newCopy());
    }

    public final BFoxSession getFoxSession() {
        return this.foxSession;
    }

    public final NiagaraStation getParentStation() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof NiagaraStation) {
            return (NiagaraStation)bComplex;
        }
        return null;
    }

    public final BHost getRemoteHost() {
        if (this.getParent() instanceof NiagaraStation) {
            return ((NiagaraStation)this.getParent()).getRemoteHost();
        }
        return this.remoteHost;
    }

    public void setRemoteHost(BHost bHost) {
        this.remoteHost = bHost;
    }

    public void setRemoteHost(BHost bHost, int n) {
        this.setRemoteHost(bHost);
        this.setPort(n);
    }

    public void setCredentials(BICredentials bICredentials) {
        this.credentials = bICredentials;
    }

    public BICredentials getCredentials() {
        if (this.credentials != null) {
            return this.credentials;
        }
        return new BUsernameAndPassword(this.getUsername(), this.getPassword());
    }

    public void sessionOpened(FoxSession foxSession) {
        NiagaraStation niagaraStation;
        if (this.checkBrandCompatibility) {
            Acceptor.accept(foxSession);
        }
        super.sessionOpened(foxSession);
        if (this.foxSession != null) {
            this.foxSession.sessionOpened();
        }
        if ((niagaraStation = this.getParentStation()) != null) {
            niagaraStation.clientOpened();
        }
    }

    public void sessionClosed(FoxSession foxSession, Throwable throwable) {
        NiagaraStation niagaraStation;
        super.sessionClosed(foxSession, throwable);
        if (this.foxSession != null) {
            this.foxSession.sessionClosed();
        }
        if ((niagaraStation = this.getParentStation()) != null) {
            niagaraStation.clientClosed();
        }
    }

    public boolean isTunnelClientConnection() {
        boolean bl = false;
        if (this.foxSession != null && this.foxSession.tunnelAuthorities != null) {
            bl = true;
        }
        return bl;
    }

    public String[] getTunnelAuthorities() {
        return this.foxSession.tunnelAuthorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws Exception {
        var1_1 = this.getParentStation();
        var2_2 = Clock.ticks();
        var4_3 = this.connectLock;
        synchronized (var4_3) {
            block22: {
                if (this.isConnected()) {
                    return;
                }
                if (this.lastFailureTicks > var2_2) {
                    throw this.lastFailureException;
                }
                var6_4 = this.getState();
                var7_5 = FoxSession.createListeners(this);
                try {
                    if (var1_1 != null && var1_1.isFatalFault()) {
                        throw new Exception(var1_1.getFaultCause());
                    }
                    this.transition("Connecting...");
                    this.setNextAttemptTime(BAbsTime.NULL);
                    var8_6 = this.getRemoteHost();
                    if (var8_6 == null) {
                        throw new IllegalStateException("Remote host not set");
                    }
                    var9_8 = this.getCredentials();
                    var10_10 = null;
                    var11_14 = false;
                    var12_15 = 4911;
                    if (!this.getUseFoxs()) {
                        try {
                            var10_10 = var8_6.openSocket(this.getPort());
                            Fox.open((FoxConnection)this, var10_10, var9_8, var7_5);
                        }
                        catch (FoxsRedirectException var13_16) {
                            var10_10.close();
                            var11_14 = true;
                            var12_15 = var13_16.getPort();
                            this.setPort(var13_16.getPort());
                            this.setUseFoxs(true);
                            this.log.message("received foxs redirect to port " + var12_15);
                        }
                    }
                    if (this.getUseFoxs() || var11_14) {
                        try {
                            var13_17 = CertManagerFactory.getInstance();
                            var14_19 = var13_17.getClientSocketFactory(BSslTlsEnum.sslv3andtlsv1);
                            var10_10 = var8_6.openSocket(this.getPort(), var14_19);
                            if (this.foxSession != null) {
                                this.foxSession.setUseFoxs(true);
                                this.foxSession.setPort(this.getPort());
                            }
                            Fox.open((FoxConnection)this, var10_10, var9_8, var7_5);
                        }
                        catch (ServiceNotFoundException var13_18) {
                            throw new IOException("CryptoFactory not found.");
                        }
                    }
                    this.lastFailureTicks = 0L;
                    this.lastFailureException = null;
                    this.setLastFailureTime(BAbsTime.NULL);
                    this.setLastFailureCause("");
                    this.pingOk();
                    if (this.foxSession != null) {
                        this.foxSession.postConnect();
                    }
                }
                catch (Exception var8_7) {
                    var9_9 = var8_7.toString();
                    if (var8_7 instanceof FoxAuthenticationException) {
                        var10_11 = (FoxAuthenticationException)var8_7;
                        var9_9 = "Authentication Failed";
                        if (var10_11.fatal != null) {
                            var9_9 = var9_9 + ": " + var10_11.fatal;
                        }
                    }
                    this.transition(var6_4);
                    this.lastFailureTicks = Clock.ticks();
                    this.lastFailureException = var8_7;
                    this.setLastFailureTime(Clock.time());
                    this.setLastFailureCause(var9_9);
                    this.pingFail(var9_9);
                    if (var7_5 == FoxSession.nullListeners) break block22;
                    var10_12 = 0;
                    if (true) ** GOTO lbl81
                }
                return;
                do {
                    var7_5[var10_12].connectionAborted(var9_9, var8_7);
                    ++var10_12;
lbl81:
                    // 2 sources

                } while (var10_12 < var7_5.length);
            }
            if (var7_5 != FoxSession.nullListeners) {
                var10_13 = 0;
                while (var10_13 < var7_5.length) {
                    var7_5[var10_13].connectionAborted(var9_9, var8_7);
                    ++var10_13;
                }
            }
            throw var8_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Interest[] getInterests() {
        HashMap hashMap = this.interests;
        synchronized (hashMap) {
            return this.interests.keySet().toArray(new Interest[this.interests.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasInterests() {
        HashMap hashMap = this.interests;
        synchronized (hashMap) {
            return this.interests.isEmpty() ^ true;
        }
    }

    public InterestLogItem[] getInterestLog() {
        InterestLogItem[] interestLogItemArray = this.interests.values().toArray(new InterestLogItem[this.interests.size()]);
        InterestLogItem[] interestLogItemArray2 = this.interestLog.toArray(new InterestLogItem[this.interestLog.size()]);
        InterestLogItem[] interestLogItemArray3 = new InterestLogItem[interestLogItemArray.length + interestLogItemArray2.length];
        System.arraycopy(interestLogItemArray, 0, interestLogItemArray3, 0, interestLogItemArray.length);
        System.arraycopy(interestLogItemArray2, 0, interestLogItemArray3, interestLogItemArray.length, interestLogItemArray2.length);
        return interestLogItemArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEngaged(Interest interest) {
        Interest interest2 = interest;
        synchronized (interest2) {
            boolean bl = false;
            if (this.interests.get(interest) == null) return bl;
            return true;
        }
    }

    public void engageNoRetry(Interest interest) throws Exception {
        this.engageNoRetry(interest, 5000L);
    }

    public void engageNoRetry(Interest interest, long l) throws Exception {
        this.engageNoRetry(interest, l, false);
    }

    public void engageNoRetry(Interest interest, long l, boolean bl) throws Exception {
        Exception exception = this.lastFailureException;
        if (exception != null && Clock.ticks() - this.lastFailureTicks < l) {
            throw exception;
        }
        try {
            this.engage(interest, false);
        }
        catch (Exception exception2) {
            if (bl) {
                this.transition("Waiting for retry...");
                long l2 = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + l2)));
            }
            throw exception2;
        }
    }

    public void engageRetry(Interest interest) throws Exception {
        this.engage(interest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void engage(Interest interest, boolean bl) throws Exception {
        HashMap hashMap = this.interests;
        synchronized (hashMap) {
            if (this.interests.get(interest) == null) {
                InterestLogItem interestLogItem = this.logEngaged(interest);
                this.interests.put(interest, interestLogItem);
            }
            if (this.lingerTicket != null) {
                this.lingerTicket.cancel();
            }
        }
        while (true) {
            try {
                this.connect();
                this.interruptRetries();
                return;
            }
            catch (Exception exception) {
                if (!bl) {
                    throw exception;
                }
                this.transition("Waiting for retry...");
                long l = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + l)));
                Object object = this.retryLock;
                synchronized (object) {
                    this.retryLock.wait(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disengage(Interest interest) {
        HashMap hashMap = this.interests;
        synchronized (hashMap) {
            block5: {
                block6: {
                    int n = this.interests.size();
                    if (interest != null) {
                        InterestLogItem interestLogItem = (InterestLogItem)this.interests.get(interest);
                        if (interestLogItem != null) {
                            this.logDisengaged(interestLogItem);
                        }
                        this.interests.remove(interest);
                    }
                    if (n <= 0 || this.interests.size() != 0) break block5;
                    if (!this.isRunning()) break block6;
                    this.lingerTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)engageLinger), (Action)lingerTimeout, null);
                    break block5;
                }
                this.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interruptRetries() {
        if (this.retryLock == null) {
            return;
        }
        Object object = this.retryLock;
        synchronized (object) {
            this.retryLock.notifyAll();
            return;
        }
    }

    private final void transition(String string) {
        if (this.log.isTraceOn()) {
            this.log.trace(this.getState() + " -> " + string);
        }
        this.setState(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doLingerTimeout() {
        HashMap hashMap = this.interests;
        synchronized (hashMap) {
            this.lingerTicket = null;
            if (this.interests.size() == 0) {
                this.close();
            }
            return;
        }
    }

    public boolean getCheckBrandCompatibility() {
        return this.checkBrandCompatibility;
    }

    public void setCheckBrandCompatibility(boolean bl) {
        this.checkBrandCompatibility = bl;
    }

    public void pingOk() {
        if (this.getParent() instanceof NiagaraStation) {
            ((NiagaraStation)this.getParent()).pingOk();
        }
    }

    public void pingFail(String string) {
        if (this.getParent() instanceof NiagaraStation) {
            ((NiagaraStation)this.getParent()).pingFail(string);
        }
    }

    public void doManualConnect() throws Exception {
        this.connect();
    }

    public void doManualDisconnect() throws Exception {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFuture post(Action action, BValue bValue, Context context) {
        if (!action.equals((Object)lingerTimeout)) return super.post(action, bValue, context);
        try {
            if (!threadPool.isRunning()) {
                ThreadPoolWorker threadPoolWorker = threadPool;
                synchronized (threadPoolWorker) {
                    if (!threadPool.isRunning()) {
                        threadPool.start("foxLingerTimeout");
                    }
                }
            }
            queue.enqueue((Object)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        catch (Exception exception) {
            this.log.error("Could not invoke lingerTimeout action on fox client connection " + this.toDebugString(), exception);
        }
        return null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.isFrozen() && (property.getDefaultFlags() & 1) == 0) {
            this.interruptRetries();
        }
    }

    private final InterestLogItem logEngaged(Interest interest) {
        InterestLogItem interestLogItem = new InterestLogItem();
        interestLogItem.interest = interest.toString();
        interestLogItem.startTicks = Clock.ticks();
        return interestLogItem;
    }

    private final void logDisengaged(InterestLogItem interestLogItem) {
        interestLogItem.endTicks = Clock.ticks();
        while (this.interestLog.size() >= 20) {
            this.interestLog.remove(0);
        }
        this.interestLog.add(interestLogItem);
    }

    public static void spyThreadPoolWorker(SpyWriter spyWriter) {
        try {
            threadPool.spy(spyWriter);
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.connectLock = new Object();
        this.retryLock = new Object();
        this.interests = new HashMap(5);
        this.interestLog = new ArrayList(20);
        this.checkBrandCompatibility = true;
    }

    public BFoxClientConnection(BFoxSession bFoxSession) {
        this.this();
        this.foxSession = bFoxSession;
        this.setRemoteHost(bFoxSession.getHost());
        this.setPort(bFoxSession.getPort());
        this.setUseFoxs(bFoxSession.getUseFoxs());
        this.init();
    }

    public BFoxClientConnection() {
        this.this();
        this.init();
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxClientConnection;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxClientConnection = BFoxClientConnection.class("[Lcom.tridium.fox.sys.BFoxClientConnection;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        engageLinger = 5000L;
        try {
            engageLinger = Long.parseLong(System.getProperty("niagara.fox.engageLinger", "" + engageLinger).trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        queue = new CoalesceQueue(1000);
        threadPool = new ThreadPoolWorker((Worker.ITodo)queue);
        threadPool.setMaxThreads(1000);
    }

    public static interface Interest {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    public static class InterestLogItem {
        public String interest;
        public long startTicks;
        public long endTicks;
    }

    public static class StringInterest
    implements Interest {
        private String string;

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof StringInterest) {
                return ((StringInterest)object).string.equals(this.string);
            }
            return false;
        }

        public String toString() {
            return this.string;
        }

        public StringInterest(String string) {
            if (string == null) {
                throw new IllegalArgumentException("interest string is null");
            }
            this.string = string;
        }
    }
}

