/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.kerberos.KerberosAuthenticator;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.sys.BFoxDefaultAuthAgent;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BIFoxAuthAgent;
import com.tridium.nre.auth.ScramSha256Client;
import com.tridium.user.BRetrievePasswordCredential;
import com.tridium.util.ValueByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.MessageDigest;
import javax.baja.log.Log;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;

public class Tuner
extends Thread {
    private FoxServer server;
    private FoxSession session;
    private String scheme;

    static FoxSession openClient(FoxConnection foxConnection, Socket socket, String string, String string2, FoxSession.IFoxSessionListener[] iFoxSessionListenerArray) throws Exception {
        BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(string, string2);
        return Tuner.openClient(foxConnection, socket, (BICredentials)bUsernameAndPassword, iFoxSessionListenerArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FoxSession openClient(FoxConnection foxConnection, Socket socket, BICredentials bICredentials, FoxSession.IFoxSessionListener[] iFoxSessionListenerArray) throws Exception {
        byte[] byArray = ValueByteBuffer.marshal((BObject)((BObject)bICredentials));
        FoxSession foxSession = new FoxSession(socket, foxConnection, iFoxSessionListenerArray);
        foxSession.setState("client.tune open credentials.len=" + byArray.length);
        Fox.register(foxSession);
        try {
            foxSession.setState("client.tune sendHello");
            foxSession.sendHello(null);
            foxSession.setState("client.tune receiveHello");
            foxSession.receiveHello();
            foxSession.setState("client.tune receiveChallenge");
            FoxMessage foxMessage = foxSession.receiveTuning("challenge");
            String string = foxMessage.getString("method");
            foxSession.setState("client.tune receivedChallenge method=" + string);
            if (string.equals("basic")) {
                FoxMessage foxMessage2 = new FoxMessage();
                if (bICredentials instanceof BUsernameAndPassword) {
                    BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
                    foxMessage2.add("username", bUsernameAndPassword.getUsername());
                    foxMessage2.add("password", bUsernameAndPassword.getPassword().getValue());
                } else if (bICredentials instanceof BRetrievePasswordCredential) {
                    BRetrievePasswordCredential bRetrievePasswordCredential = (BRetrievePasswordCredential)bICredentials;
                    foxMessage2.add("username", bRetrievePasswordCredential.getUsername());
                    foxMessage2.add("email", bRetrievePasswordCredential.getEmail());
                } else {
                    if (!(bICredentials instanceof BHttpFoxCredentials)) throw new IllegalStateException();
                    BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)bICredentials;
                    byte[] byArray2 = byArray;
                    foxMessage2.add("username", bHttpFoxCredentials.getUsername());
                    foxMessage2.add("credentials", byArray2);
                }
                foxSession.setState("client.tune sendLogin");
                foxSession.sendTuning("login", foxMessage2);
                Tuner.receiveWelcome(foxSession, string);
            } else if (string.equals("digest-md5")) {
                if (foxSession.getRemoteHello().getString("fox.version", "1.0").compareTo("1.0.1") < 0) {
                    FoxMessage foxMessage3 = new FoxMessage();
                    BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
                    byte[] byArray3 = foxMessage.getBlob("nonce");
                    String string2 = bUsernameAndPassword.getUsername();
                    byte[] byArray4 = Tuner.generateDigest(string2, bUsernameAndPassword.getPassword().getValue(), byArray3);
                    foxMessage3.add("username", string2);
                    foxMessage3.add("digest", byArray4);
                    foxSession.setState("client.tune sendLogin");
                    foxSession.sendTuning("login", foxMessage3);
                    Tuner.receiveWelcome(foxSession, string);
                }
            } else if (string.equals("digest")) {
                if (bICredentials instanceof BUsernameAndPassword) {
                    try {
                        FoxMessage foxMessage4 = new FoxMessage();
                        foxMessage4.add("authInput", "authInputScram");
                        BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
                        ScramSha256Client scramSha256Client = new ScramSha256Client(bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getValue());
                        foxMessage4.add("authHandshake1", scramSha256Client.createClientFirstMessage());
                        foxSession.setState("client.tune send scramsha1-clientFirstMessage");
                        foxSession.sendTuning("authMessage1", foxMessage4);
                        FoxMessage foxMessage5 = foxSession.receiveTuning("authMessage1");
                        foxMessage4 = new FoxMessage();
                        String string3 = foxMessage5.getString("authHandshake1");
                        foxMessage4.add("authHandshake2", scramSha256Client.createClientFinalMessage(string3));
                        foxSession.setState("client.tune send scramsha1-clientFinalMessage");
                        foxSession.sendTuning("authMessage2", foxMessage4);
                        foxMessage5 = foxSession.receiveTuning("authMessage2");
                        String string4 = foxMessage5.getString("authHandshake2");
                        foxSession.setState("client.tune process scramsha1-serverFinalMessage");
                        scramSha256Client.processServerFinalMessage(string4);
                    }
                    catch (Exception exception) {
                        throw new FoxAuthenticationException("Rejected", string, null, foxSession);
                    }
                    Tuner.receiveWelcome(foxSession, string);
                } else if (bICredentials instanceof BRetrievePasswordCredential) {
                    FoxMessage foxMessage6 = new FoxMessage();
                    foxMessage6.add("authInput", "authInputRetrieve");
                    BRetrievePasswordCredential bRetrievePasswordCredential = (BRetrievePasswordCredential)bICredentials;
                    foxMessage6.add("username", bRetrievePasswordCredential.getUsername());
                    foxMessage6.add("email", bRetrievePasswordCredential.getEmail());
                    foxSession.setState("client.tune sendFirstMessage");
                    foxSession.sendTuning("authMessage1", foxMessage6);
                    Tuner.receiveWelcome(foxSession, string);
                } else {
                    if (!(bICredentials instanceof BHttpFoxCredentials)) throw new IllegalStateException();
                    FoxMessage foxMessage7 = new FoxMessage();
                    foxMessage7.add("authInput", "authInputHttp");
                    BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)bICredentials;
                    byte[] byArray5 = byArray;
                    foxMessage7.add("username", bHttpFoxCredentials.getUsername());
                    foxMessage7.add("credentials", byArray5);
                    foxSession.setState("client.tune sendFirstMessage");
                    foxSession.sendTuning("authMessage1", foxMessage7);
                    Tuner.receiveWelcome(foxSession, string);
                }
            } else {
                if (!string.equals("kerberos")) throw new FoxAuthenticationException("Unknown challenge method ", string, foxSession);
                if (System.getProperty("java.vm.name").equalsIgnoreCase("J9")) {
                    throw new FoxAuthenticationException("Unsupported challenge method: ", string, foxSession);
                }
                if (bICredentials instanceof BHttpFoxCredentials) {
                    FoxMessage foxMessage8 = new FoxMessage();
                    foxMessage8.add("authInput", "authInputHttp");
                    BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)bICredentials;
                    byte[] byArray6 = byArray;
                    foxMessage8.add("username", bHttpFoxCredentials.getUsername());
                    foxMessage8.add("credentials", byArray6);
                    foxSession.setState("client.tune sendFirstMessage");
                    foxSession.sendTuning("authMessage1", foxMessage8);
                    Tuner.receiveWelcome(foxSession, string);
                } else {
                    KerberosAuthenticator.authenticate(foxSession, foxMessage, bICredentials);
                    Tuner.receiveWelcome(foxSession, string);
                }
            }
            foxSession.setState("client.tune starting");
            foxSession.start();
            return foxSession;
        }
        catch (Error error) {
            foxSession.close(error);
            throw error;
        }
        catch (Exception exception) {
            foxSession.close(exception);
            throw exception;
        }
    }

    private static void receiveWelcome(FoxSession foxSession, String string) throws IOException, FoxAuthenticationException {
        foxSession.setState("client.tune receiveWelcome");
        FoxFrame foxFrame = foxSession.readFrame();
        if (foxFrame.command != "welcome") {
            foxSession.setState("client.tune receivedRejected");
            String string2 = foxFrame.message.getString("fatal", null);
            String string3 = foxFrame.message.getString("msg", null);
            FoxAuthenticationException foxAuthenticationException = null != string3 ? new FoxAuthenticationException(string3, string, string2, foxSession) : new FoxAuthenticationException("Rejected", string, string2, foxSession);
            try {
                foxAuthenticationException.data = foxFrame.message.getMessage("data");
            }
            catch (IOException iOException) {
                foxAuthenticationException.data = null;
            }
            throw foxAuthenticationException;
        }
        foxSession.remoteWelcome = foxFrame.message;
        foxSession.setState("client.tune receivedWelcome");
    }

    static void openServer(FoxServer foxServer, Socket socket, String string) throws Exception {
        FoxSession foxSession = new FoxSession(socket, foxServer.makeConnection(null, null));
        int n = Math.max(1, Fox.maxServerSessions);
        if (Fox.getServerSessionCount() >= n) {
            Log.getLog((String)"fox").warning("past fox.maxServerSessions limit: " + n);
            foxSession.sendBusy();
        }
        Fox.register(foxSession);
        foxSession.setState("server.tune spawning");
        new Tuner(foxServer, foxSession, string).start();
    }

    private Tuner(FoxServer foxServer, FoxSession foxSession, String string) {
        super("Fox:Tuner:" + foxSession.getId());
        this.server = foxServer;
        this.session = foxSession;
        this.scheme = string;
    }

    public void run() {
        try {
            this.session.setState("server.tune receiveHello");
            if (!this.session.receiveHello()) {
                this.session.start();
                return;
            }
            this.session.setState("server.tune makeConnection");
            this.session.conn = this.server.makeConnection(this.session, this.session.getRemoteHello());
            BFoxService bFoxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            if (this.scheme.equalsIgnoreCase("fox") && bFoxService.getFoxsOnly() && bFoxService.getFoxsEnabled()) {
                this.session.setState("server.tune sendRedirect");
                this.session.sendRedirect(bFoxService.getFoxsPort());
                throw new FoxsRedirectException(bFoxService.getFoxsPort());
            }
            this.session.setState("server.tune sendHello");
            this.session.sendHello(null);
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BIFoxAuthAgent bIFoxAuthAgent = (BIFoxAuthAgent)bUserService.getAuthAgent(BIFoxAuthAgent.TYPE);
            if (null != bIFoxAuthAgent) {
                bIFoxAuthAgent.authenticate(this.session, this.server);
            } else {
                BFoxDefaultAuthAgent.INSTANCE.authenticate(this.session, this.server);
            }
        }
        catch (Throwable throwable) {
            this.session.close(throwable);
        }
    }

    public static byte[] generateDigest(String string, String string2, byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeUTF(string2);
        dataOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray2);
        return messageDigest.digest();
    }
}

