/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FrameQueue;
import java.io.IOException;

public class SessionSender
implements Runnable {
    private static FoxFrame keepAlive = new FoxFrame(107, -1, -1, "fox", "keepalive", new FoxMessage());
    private FoxSession session;
    private String name;
    private volatile boolean isAlive;
    private Thread thread;
    private FrameQueue queue;
    private volatile boolean running = false;

    public SessionSender(FoxSession foxSession) {
        this.name = "Fox:Sender:" + foxSession.getId();
        this.session = foxSession;
        this.queue = new FrameQueue();
        this.isAlive = true;
    }

    public void enqueue(FoxFrame foxFrame) throws InterruptedException {
        this.queue.enqueue(foxFrame);
    }

    public void start() {
        this.thread = this.session.conn.makeThread(Fox.threadGroup, this, this.name);
        this.thread.start();
    }

    public void kill() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.kill();
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        try {
            this.running = true;
            while (this.isAlive && !this.session.isClosed()) {
                try {
                    object = this.queue.dequeue(Fox.keepAliveInterval);
                    if (this.session.isClosed()) {
                        break;
                    }
                    if (object == null) {
                        object = keepAlive;
                    }
                    this.session.writeFrame((FoxFrame)object);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    this.session.close(iOException);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        finally {
            this.running = false;
            Object object2 = object = this.session.getSessionStateLock();
            synchronized (object2) {
                object.notifyAll();
            }
            if (this.session.getState().equals("closed")) {
                try {
                    if (this.session.getSocket() != null) {
                        this.session.getSocket().close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public String toString() {
        return this.name + " {" + this.queue + "}";
    }
}

