/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FrameQueue;

public class SessionDispatcher
implements Runnable {
    private FoxSession session;
    private String name;
    private boolean isAlive;
    private Thread thread;
    private FrameQueue queue;

    public SessionDispatcher(FoxSession foxSession) {
        this.name = "Fox:Dispatcher:" + foxSession.getId();
        this.session = foxSession;
        this.queue = new FrameQueue();
        this.isAlive = true;
    }

    public void enqueue(FoxFrame foxFrame) throws InterruptedException {
        if (this.session.isClosed()) {
            throw new InterruptedException("FoxSession is closed");
        }
        this.queue.enqueue(foxFrame);
    }

    public void start() {
        this.thread = this.session.conn.makeThread(Fox.threadGroup, this, this.name);
        this.thread.start();
    }

    public void kill() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.kill();
    }

    public void run() {
        while (this.isAlive && !this.session.isClosed()) {
            try {
                FoxFrame foxFrame = this.queue.dequeue(-1);
                this.dispatch(foxFrame);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void dispatch(FoxFrame foxFrame) throws InterruptedException {
        block2: {
            try {
                FoxResponse foxResponse = foxFrame.channel == "fox" ? this.session.processFoxChannelRequest((FoxRequest)foxFrame.message) : this.session.conn().process((FoxRequest)foxFrame.message);
                this.session.sendReply(foxFrame, foxResponse);
            }
            catch (Throwable throwable) {
                if (!this.isAlive) break block2;
                throwable.printStackTrace();
                this.session.sendError(foxFrame, throwable);
            }
        }
    }

    public String toString() {
        return this.name + " {" + this.queue + "}";
    }
}

