/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.IntMap;
import com.tridium.fox.session.InvalidCommandException;

public class SessionCircuits {
    static final int THREAD_POOL_SIZE = 2;
    private FoxSession session;
    private IntMap circuits = new IntMap();
    private int nextId;
    private ServiceThread[] threadPool = new ServiceThread[2];
    private int nonPoolServiceCount;

    SessionCircuits(FoxSession foxSession) {
        this.session = foxSession;
        this.nextId = foxSession.isServer() ? 0 : 1;
    }

    synchronized FoxCircuit alloc(String string, String string2) {
        int n = this.nextId;
        this.nextId += 2;
        FoxCircuit foxCircuit = new FoxCircuit(n, this.session, string, string2);
        this.circuits.put(n, foxCircuit);
        return foxCircuit;
    }

    synchronized void free(FoxCircuit foxCircuit) {
        this.circuits.remove(foxCircuit.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        FoxCircuit[] foxCircuitArray = (FoxCircuit[])this.circuits.toArray(new FoxCircuit[this.circuits.size()]);
        for (int i = 0; i < foxCircuitArray.length; ++i) {
            try {
                foxCircuitArray[i].close();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        ServiceThread[] serviceThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            for (int i = 0; i < this.threadPool.length; ++i) {
                if (this.threadPool[i] == null) continue;
                try {
                    this.threadPool[i].kill();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.threadPool[i] = null;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    void circuitRequestReceived(FoxFrame foxFrame) throws Exception {
        String string = foxFrame.command;
        if (string == "open") {
            this.processOpen(foxFrame.message);
            return;
        }
        if (string == "stream") {
            this.processStream(foxFrame.message);
            return;
        }
        if (string == "close") {
            this.processClose(foxFrame.message);
            return;
        }
        throw new InvalidCommandException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOpen(FoxMessage foxMessage) throws Exception {
        int n = foxMessage.getInt("id");
        String string = foxMessage.getString("channel").intern();
        String string2 = foxMessage.getString("command").intern();
        FoxCircuit foxCircuit = new FoxCircuit(n, this.session, string, string2);
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            if (this.circuits.get(n) != null) {
                throw new IllegalStateException("Circuit already allocated: " + n);
            }
            this.circuits.put(n, foxCircuit);
        }
        this.runCircuit(foxCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStream(FoxMessage foxMessage) throws Exception {
        int n = foxMessage.getInt("id");
        byte[] byArray = foxMessage.getBlob("data");
        FoxCircuit foxCircuit = null;
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            foxCircuit = (FoxCircuit)this.circuits.get(n);
        }
        if (foxCircuit != null) {
            foxCircuit.pushIn(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processClose(FoxMessage foxMessage) throws Exception {
        int n = foxMessage.getInt("id");
        FoxCircuit foxCircuit = null;
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            foxCircuit = (FoxCircuit)this.circuits.get(n);
        }
        if (foxCircuit != null) {
            foxCircuit.close();
        }
    }

    public synchronized String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ThreadPool\n");
        for (n = 0; n < this.threadPool.length; ++n) {
            stringBuffer.append("  pool[").append(n).append("] = ");
            if (this.threadPool[n] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.threadPool[n].serviceCount);
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("  nonPoolServiceCount = " + this.nonPoolServiceCount).append('\n');
        stringBuffer.append("Circuits\n");
        if (this.circuits.size() == 0) {
            stringBuffer.append("  none\n");
        } else {
            for (n = 0; n < this.circuits.size(); ++n) {
                FoxCircuit foxCircuit = (FoxCircuit)this.circuits.get(n);
                if (foxCircuit == null) continue;
                stringBuffer.append("  ").append(foxCircuit).append('\n');
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCircuit(FoxCircuit foxCircuit) {
        ServiceThread[] serviceThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            for (int i = 0; i < this.threadPool.length; ++i) {
                if (this.threadPool[i] == null) {
                    this.threadPool[i] = new ServiceThread(this.session, "Fox:Circuit:" + this.session.getId() + " (Pooled:" + i + ")", true);
                    this.threadPool[i].start();
                }
                if (!this.threadPool[i].isAvailable()) continue;
                this.threadPool[i].runCircuit(foxCircuit);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ++this.nonPoolServiceCount;
            ServiceThread serviceThread = new ServiceThread(this.session, "Fox:Circuit:" + this.session.getId() + " (Non-pooled)", false);
            serviceThread.start();
            serviceThread.runCircuit(foxCircuit);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static class ServiceThread
    implements Runnable {
        Thread thread;
        boolean isAlive = true;
        boolean pooled;
        FoxCircuit circuit;
        int serviceCount;

        ServiceThread(FoxSession foxSession, String string, boolean bl) {
            this.thread = foxSession.conn.makeThread(Fox.threadGroup, this, string);
            this.pooled = bl;
        }

        public void start() {
            this.thread.start();
        }

        public synchronized void kill() {
            this.isAlive = false;
            this.notify();
        }

        public synchronized boolean isAvailable() {
            return this.circuit == null;
        }

        public synchronized void runCircuit(FoxCircuit foxCircuit) {
            if (this.circuit != null) {
                throw new IllegalStateException();
            }
            this.circuit = foxCircuit;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isAlive) {
                ServiceThread serviceThread = this;
                synchronized (serviceThread) {
                    while (this.circuit == null) {
                        if (!this.isAlive) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                ++this.serviceCount;
                try {
                    this.circuit.session().conn().circuitOpened(this.circuit);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                finally {
                    this.circuit.close();
                }
                serviceThread = this;
                synchronized (serviceThread) {
                    this.circuit = null;
                    if (!this.pooled) {
                        return;
                    }
                }
            }
        }
    }
}

