/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import java.io.InterruptedIOException;

public class SessionBedroom {
    private Bed[] bedTable = new Bed[4];

    synchronized Bed getBed(Thread thread) {
        Bed[] bedArray;
        int n;
        for (n = 0; n < this.bedTable.length && this.bedTable[n] != null; ++n) {
        }
        if (n == this.bedTable.length) {
            bedArray = new Bed[this.bedTable.length * 2];
            System.arraycopy(this.bedTable, 0, bedArray, 0, this.bedTable.length);
            this.bedTable = bedArray;
        }
        bedArray = new Bed();
        bedArray.replyNumber = n;
        bedArray.thread = thread;
        this.bedTable[n] = bedArray;
        return bedArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleep(Bed bed) throws InterruptedIOException {
        try {
            Bed bed2 = bed;
            synchronized (bed2) {
                long l = Fox.clock.ticks();
                while (!bed.haveReply && Fox.clock.ticks() - l < (long)Fox.requestTimeout) {
                    long l2 = (long)Fox.requestTimeout - (Fox.clock.ticks() - l);
                    if (l2 < 50L) {
                        l2 = 50L;
                    }
                    bed.wait(l2);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            SessionBedroom sessionBedroom = this;
            synchronized (sessionBedroom) {
                bed.thread = null;
                this.bedTable[bed.replyNumber] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wake(FoxFrame foxFrame) throws Exception {
        Bed bed = null;
        Object object = this;
        synchronized (object) {
            bed = this.bedTable[foxFrame.replyNumber];
        }
        if (bed == null) {
            return;
        }
        object = bed;
        synchronized (object) {
            bed.haveReply = true;
            bed.reply = foxFrame;
            bed.notify();
            return;
        }
    }

    synchronized void wakeAll() {
        for (int i = 0; i < this.bedTable.length; ++i) {
            Bed bed = this.bedTable[i];
            if (bed == null) continue;
            bed.thread.interrupt();
            bed.thread = null;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bedTable.length; ++i) {
            Bed bed = this.bedTable[i];
            if (bed == null) continue;
            stringBuffer.append(bed.replyNumber).append(": ").append(bed.thread).append('\n');
        }
        if (stringBuffer.length() == 0) {
            return "empty";
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static class Bed {
        int replyNumber;
        FoxFrame reply;
        boolean haveReply = false;
        Thread thread;

        Bed() {
        }
    }
}

