/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MulticastUtil {
    public static FoxFrame makeFrame(String string, FoxMessage foxMessage) {
        return new FoxFrame(109, -1, -1, "fox", string, foxMessage);
    }

    public static void send(String string, FoxMessage foxMessage, int n) throws Exception {
        MulticastUtil.send(MulticastUtil.makeFrame(string, foxMessage), n);
    }

    public static void send(FoxFrame foxFrame, int n) throws Exception {
        int n2;
        if (!Fox.ipv4Enabled && !Fox.ipv6Enabled || !Fox.multicastEnabled) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        MessageWriter messageWriter = new MessageWriter(byteArrayOutputStream);
        foxFrame.write(messageWriter);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = Fox.ipv4Enabled ? new DatagramPacket(byArray, byArray.length, InetAddress.getByName(Fox.MULTICAST_ADDRESS), 1911) : null;
        DatagramPacket datagramPacket2 = Fox.ipv6Enabled ? new DatagramPacket(byArray, byArray.length, InetAddress.getByName(Fox.IPV6_MULTICAST_ADDRESS), 1911) : null;
        MulticastSocket multicastSocket = new MulticastSocket();
        multicastSocket.setTimeToLive(Fox.multicastTimeToLive);
        IOException iOException = null;
        IOException iOException2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (datagramPacket != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    Thread.sleep(100L);
                    multicastSocket.send(datagramPacket);
                }
                bl = true;
            }
        }
        catch (IOException iOException3) {
            System.err.println("WARNING: Could not send IPv4 multicast packet: " + iOException3);
            bl = false;
            iOException = iOException3;
        }
        try {
            if (datagramPacket2 != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    Thread.sleep(100L);
                    multicastSocket.send(datagramPacket2);
                }
                bl2 = true;
            }
        }
        catch (IOException iOException4) {
            System.err.println("WARNING: Could not send IPv6 multicast packet: " + iOException4);
            bl2 = false;
            iOException2 = iOException4;
        }
        if (!bl2 && !bl) {
            String string = Fox.ipv4Enabled && iOException != null ? iOException.getMessage() : null;
            String string2 = Fox.ipv6Enabled && iOException2 != null ? iOException2.getMessage() : null;
            String string3 = "OK";
            if (string != null) {
                string3 = string;
            }
            if (string2 != null) {
                string3 = string == null ? string2 : string3 + ", " + string2;
            }
            throw new IOException("ERROR: Could not send Fox multicast packet(s): (" + string3 + ")");
        }
    }

    public static FoxFrame receive(DatagramSocket datagramSocket) throws Exception {
        byte[] byArray = new byte[1024];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        datagramSocket.receive(datagramPacket);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData(), 0, datagramPacket.getLength());
        MessageReader messageReader = new MessageReader(byteArrayInputStream);
        FoxFrame foxFrame = FoxFrame.read(messageReader);
        if (datagramPacket.getAddress() instanceof Inet6Address) {
            foxFrame.message.add("IPv6FoxFrameMulticastReceived", true);
        }
        return foxFrame;
    }

    public static boolean isIpv6Message(FoxMessage foxMessage) {
        FoxTuple[] foxTupleArray = foxMessage.list("IPv6FoxFrameMulticastReceived");
        boolean bl = false;
        if (foxTupleArray != null && foxTupleArray.length != 0) {
            FoxBoolean foxBoolean = (FoxBoolean)foxTupleArray[foxTupleArray.length - 1];
            bl = foxBoolean.value;
        }
        return bl;
    }
}

