/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;

public final class FrameQueue {
    private FoxFrame head;
    private FoxFrame tail;
    private int size;
    private int peak;
    private String blocked;
    private boolean isAlive = true;

    public final int size() {
        return this.size;
    }

    public final int peak() {
        return this.peak;
    }

    public final int max() {
        return Fox.maxQueueSize;
    }

    public final synchronized void kill() {
        this.isAlive = false;
        this.notifyAll();
    }

    public synchronized FoxFrame dequeue(int n) throws InterruptedException {
        FoxFrame foxFrame;
        while (this.isAlive && this.size == 0) {
            if (n == -1) {
                this.wait();
                continue;
            }
            this.wait(n);
            break;
        }
        if ((foxFrame = this.head) == null) {
            return null;
        }
        this.head = foxFrame.next;
        if (this.head == null) {
            this.tail = null;
        }
        foxFrame.next = null;
        --this.size;
        this.notifyAll();
        return foxFrame;
    }

    public synchronized void enqueue(FoxFrame foxFrame) throws InterruptedException {
        while (this.isAlive && this.size >= this.max()) {
            try {
                this.blocked = Thread.currentThread().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wait();
        }
        this.blocked = null;
        if (foxFrame.next != null) {
            throw new IllegalStateException();
        }
        if (this.tail == null) {
            this.head = this.tail = foxFrame;
        } else {
            this.tail.next = foxFrame;
            this.tail = foxFrame;
        }
        ++this.size;
        if (this.size > this.peak) {
            this.peak = this.size;
        }
        this.notifyAll();
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public String toString() {
        String string = "FrameQueue size=" + this.size + " peak=" + this.peak + " max=" + this.max();
        if (this.blocked != null) {
            string = string + " blocked=" + this.blocked;
        }
        return string;
    }
}

