/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.MulticastServer;
import com.tridium.fox.session.Tuner;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.baja.log.Log;

public abstract class FoxServer {
    private static final String FOX = "fox";
    private static final String FOXS = "foxs";
    private static Log log = Log.getLog((String)"fox");
    protected int foxPort = -1;
    protected int foxsPort = -1;
    private boolean alive = true;
    private Thread foxThread;
    private ServerSocket foxServerSocket;
    private boolean foxRunning = false;
    private Thread foxsThread;
    private ServerSocket foxsServerSocket;
    private boolean foxsRunning = false;
    private MulticastServer multicastServer;

    public FoxServer() {
        this.foxPort = 1911;
        this.foxsPort = 4911;
    }

    public FoxServer(int n, int n2) {
        this.foxPort = n;
        this.foxsPort = n2;
    }

    public MulticastServer getMulticastServer() {
        return this.multicastServer;
    }

    public void run() throws Exception {
        if (this.foxThread != null || this.foxsThread != null) {
            throw new IllegalStateException("Server already running");
        }
        this.alive = true;
        if (this.foxPort >= 0) {
            this.foxThread = new Thread((Runnable)new MainLoop(FOX), "Fox:Server");
            this.foxThread.start();
        }
        if (this.foxsPort >= 0) {
            this.foxsThread = new Thread((Runnable)new MainLoop(FOXS), "Foxs:Server");
            this.foxsThread.start();
        }
        try {
            if (Fox.multicastEnabled) {
                this.multicastServer = new MulticastServer(this);
                this.multicastServer.start();
            } else {
                log.message("Multicast disabled (no station discovery supported)");
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot open Fox multicast socket: " + exception);
        }
    }

    private void runFox() {
        this.foxRunning = true;
        this.run(FOX);
        this.foxRunning = false;
    }

    private void runFoxs() {
        this.foxsRunning = true;
        this.run(FOXS);
        this.foxsRunning = false;
    }

    public boolean isServing() {
        return this.foxServerSocket != null || this.foxsServerSocket != null;
    }

    public boolean isRunning() {
        return this.foxRunning || this.foxsRunning;
    }

    public boolean isFoxRunning() {
        return this.foxRunning;
    }

    public boolean isFoxsRunning() {
        return this.foxsRunning;
    }

    public ServerSocket getFoxServerSocket() throws IOException {
        return new ServerSocket(this.foxPort);
    }

    public ServerSocket getFoxsServerSocket() throws IOException {
        throw new UnsupportedOperationException("FOXS not supported.");
    }

    private void run(String string) {
        ServerSocket serverSocket = null;
        int n = 1911;
        block13: while (this.alive) {
            try {
                if (string.equalsIgnoreCase(FOX)) {
                    n = this.foxPort;
                    serverSocket = this.foxServerSocket = this.getFoxServerSocket();
                } else {
                    n = this.foxsPort;
                    serverSocket = this.foxsServerSocket = this.getFoxsServerSocket();
                }
            }
            catch (BindException bindException) {
                log.error(string.toUpperCase() + " server failed to bind to port [" + n + "] " + bindException);
                serverSocket = null;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (log.isTraceOn()) {
                    log.error(string.toUpperCase() + " server failed to start on port [" + n + "]\n ", (Throwable)illegalArgumentException);
                } else {
                    log.error(string.toUpperCase() + " server failed to start on port [" + n + "]\n " + illegalArgumentException.getLocalizedMessage());
                }
                return;
            }
            catch (IOException iOException) {
                if (log.isTraceOn()) {
                    log.error(string.toUpperCase() + " server failed to start on port. [" + n + "]\n ", (Throwable)iOException);
                } else {
                    log.error(string.toUpperCase() + " server failed to start on port. [" + n + "]\n " + iOException.getLocalizedMessage());
                }
                return;
            }
            if (serverSocket == null) continue;
            try {
                log.message(string.toUpperCase() + " server started on port [" + n + "]");
                Socket socket = null;
                while (this.alive) {
                    try {
                        socket = serverSocket.accept();
                        if (!this.alive) continue block13;
                        Tuner.openServer(this, socket, string);
                    }
                    catch (IOException iOException) {
                        if (this.alive && (iOException.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || iOException.getClass().getName().equals("iaik.security.ssl.SSLException"))) {
                            if (log.isTraceOn()) {
                                log.warning("Server accept " + iOException.getClass().getName() + ": " + iOException.getLocalizedMessage(), (Throwable)iOException);
                                continue;
                            }
                            log.warning("Server accept " + iOException.getClass().getName() + ": " + iOException.getLocalizedMessage());
                            continue;
                        }
                        if (!this.alive) continue;
                        log.message("Server accept exception: " + iOException.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                if (!this.alive) continue;
                log.error(string + ": Error in main loop.", throwable);
            }
        }
        log.message(string.toUpperCase() + " server stopped on  port [" + n + "]");
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.foxThread != null) {
            this.alive = false;
            this.foxThread.interrupt();
            this.foxThread = null;
            if (this.foxServerSocket != null) {
                try {
                    this.foxServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.foxServerSocket = null;
            }
        }
        if (this.foxsThread != null) {
            this.alive = false;
            this.foxsThread.interrupt();
            this.foxsThread = null;
            if (this.foxsServerSocket != null) {
                try {
                    this.foxsServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.foxsServerSocket = null;
            }
        }
        if (this.multicastServer != null) {
            this.multicastServer.kill();
            this.multicastServer = null;
        }
    }

    public abstract FoxConnection makeConnection(FoxSession var1, FoxMessage var2) throws Exception;

    public abstract FoxMessage getAnnouncement();

    public abstract int getAuthenticationPolicy();

    public abstract boolean authenticateBasic(FoxSession var1, String var2, String var3) throws Exception;

    public abstract boolean authenticateDigest(FoxSession var1, String var2, byte[] var3, byte[] var4) throws Exception;

    private class MainLoop
    implements Runnable {
        private String scheme;

        public MainLoop(String string) {
            this.scheme = string;
        }

        public void run() {
            if (this.scheme.equals(FoxServer.FOX)) {
                FoxServer.this.runFox();
            } else {
                FoxServer.this.runFoxs();
            }
        }
    }
}

