/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class MessageReader {
    private static final int CM_NAME = 1;
    private static final int CM_DIGIT = 2;
    private static final int CM_HEX = 4;
    private static byte[] charMap;
    private static final int HISTORY_SIZE = 160;
    private InputStream in;
    private int pushBack = -1;
    private byte[] history = new byte[160];
    private int historyIndex = -1;

    public MessageReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public final int read() throws IOException {
        if (this.pushBack != -1) {
            int n = this.pushBack;
            this.pushBack = -1;
            return n;
        }
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException("EOF");
        }
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = (byte)n;
        return n;
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.in.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw this.error("EOF");
        }
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 98;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 108;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 111;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 98;
    }

    public final void pushBack(int n) {
        if (this.pushBack != -1) {
            throw new IllegalStateException("Double push back");
        }
        this.pushBack = n;
    }

    public final String readName() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((charMap[n = this.read()] & 1) == 0) {
                if (stringBuffer.length() == 0) {
                    throw this.error("Expected name");
                }
                this.pushBack(n);
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    public final String readTo(char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.read()) == c) {
                this.pushBack(n);
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    public final int readInt() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = this.read();
        if ((charMap[n2] & 2) != 0) {
            n = n2 - 48;
        } else if (n2 == 45) {
            bl = true;
        } else {
            throw this.error("Expecting int");
        }
        while (true) {
            if ((charMap[n2 = this.read()] & 2) == 0) break;
            n = n * 10 + (n2 - 48);
        }
        this.pushBack(n2);
        if (bl) {
            n = -n;
        }
        return n;
    }

    public final long readLong() throws IOException {
        long l = 0L;
        boolean bl = false;
        int n = this.read();
        if ((charMap[n] & 2) != 0) {
            l = n - 48;
        } else if (n == 45) {
            bl = true;
        } else {
            throw this.error("Expecting int");
        }
        while (true) {
            if ((charMap[n = this.read()] & 2) == 0) break;
            l = l * 10L + (long)(n - 48);
        }
        this.pushBack(n);
        if (bl) {
            l = -l;
        }
        return l;
    }

    public final int readHex() throws IOException {
        int n;
        int n2 = 0;
        while (true) {
            if ((charMap[n = this.read()] & 4) == 0) break;
            if ((charMap[n] & 2) != 0) {
                n2 = (n2 << 4) + (n - 48);
                continue;
            }
            n2 = (n2 << 4) + 10 + (n - 97);
        }
        this.pushBack(n);
        return n2;
    }

    public final long readHexLong() throws IOException {
        int n;
        long l = 0L;
        while (true) {
            if ((charMap[n = this.read()] & 4) == 0) break;
            if ((charMap[n] & 2) != 0) {
                l = (l << 4) + (long)(n - 48);
                continue;
            }
            l = (l << 4) + 10L + (long)(n - 97);
        }
        this.pushBack(n);
        return l;
    }

    public final String readSafe() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((n = this.read()) < 32) break;
            if (n == 35) {
                int n2;
                if (stringBuffer.length() == 0) {
                    n2 = this.read();
                    if (n2 == 110) {
                        this.consume(117);
                        this.consume(108);
                        this.consume(108);
                        this.consume(59);
                        return null;
                    }
                    this.pushBack(n2);
                }
                n2 = this.readHex();
                this.consume(59);
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append((char)n);
        }
        this.pushBack(n);
        return stringBuffer.toString();
    }

    public final void consume(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.consume(string.charAt(i));
        }
    }

    public final void consume(int n) throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != n) {
            throw this.error("Expected '" + this.toString(n) + "', got '" + this.toString(n2) + "'");
        }
    }

    public final void close() throws IOException {
        this.in.close();
    }

    public IOException error(String string) {
        System.out.println("ERROR: MessageReader: " + string);
        Thread.dumpStack();
        byte[] byArray = this.getHistory();
        System.out.println("--- History ---");
        MessageReader.hexDump(byArray);
        byte[] byArray2 = this.getFuture();
        if (byArray2.length > 0) {
            System.out.println("--- Future ---");
            MessageReader.hexDump(byArray2);
        }
        return new IOException(string);
    }

    public static void hexDump(byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 16) {
            StringBuffer stringBuffer = new StringBuffer(64);
            StringBuffer stringBuffer2 = new StringBuffer(64);
            for (int j = 0; j < 16 && i + j < byArray.length; ++j) {
                int n = byArray[i + j] & 0xFF;
                if (j % 4 == 0) {
                    stringBuffer.append(' ');
                }
                if (n < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n));
                if (n < 32 || n > 127) {
                    stringBuffer2.append('.');
                    continue;
                }
                stringBuffer2.append((char)n);
            }
            System.out.print(stringBuffer);
            System.out.print("   ");
            System.out.print(stringBuffer2);
            System.out.println();
        }
    }

    public byte[] getHistory() {
        int n;
        byte[] byArray = new byte[160];
        int n2 = this.historyIndex + 1;
        int n3 = 160 - n2;
        for (n = 0; n < n3; ++n) {
            byArray[n] = this.history[n + n2];
        }
        for (n = 0; n < n2; ++n) {
            byArray[n + n3] = this.history[n];
        }
        return byArray;
    }

    public byte[] getFuture() {
        try {
            int n = this.in.available();
            int n2 = Math.min(n, 160);
            if (n2 > 0) {
                byte[] byArray = new byte[n2];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)this.read();
                }
                return byArray;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    public String toString(int n) {
        if (n == 10) {
            return "\\n";
        }
        if (n < 32 || n > 126) {
            return "0x" + Integer.toHexString(n);
        }
        return String.valueOf((char)n);
    }

    static {
        int n;
        charMap = new byte[256];
        for (n = 97; n <= 122; ++n) {
            MessageReader.charMap[n] = 1;
        }
        for (n = 65; n <= 90; ++n) {
            MessageReader.charMap[n] = 1;
        }
        for (n = 48; n <= 57; ++n) {
            MessageReader.charMap[n] = 7;
        }
        n = 97;
        while (n <= 102) {
            int n2 = n++;
            charMap[n2] = (byte)(charMap[n2] | 4);
        }
        MessageReader.charMap[46] = 1;
        MessageReader.charMap[45] = 1;
        MessageReader.charMap[95] = 1;
        MessageReader.charMap[36] = 1;
    }
}

